/* mips-opc.c -- MIPS opcode list.
   Copyright 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002
   2003, 2004, 2005 Free Software Foundation, Inc.
   Contributed by Ralph Campbell and OSF
   Commented and modified by Ian Lance Taylor, Cygnus Support
   Extended for MIPS32 support by Anders Norlander, and by SiByte, Inc.
   MIPS-3D, MDMX, and MIPS32 Release 2 support added by Broadcom
   Corporation (SiByte).

This file is part of GDB, GAS, and the GNU binutils.

GDB, GAS, and the GNU binutils are free software; you can redistribute
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation; either version
1, or (at your option) any later version.

GDB, GAS, and the GNU binutils are distributed in the hope that they
will be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this file; see the file COPYING.  If not, write to the Free
Software Foundation, 51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.  */

#include <stdio.h>
#include "sysdep.h"
#include "opcode/mips.h"

/* Short hand so the lines aren't too long.  */

#define LDD     INSN_LOAD_MEMORY_DELAY
#define LCD	INSN_LOAD_COPROC_DELAY
#define UBD     INSN_UNCOND_BRANCH_DELAY
#define CBD	INSN_COND_BRANCH_DELAY
#define COD     INSN_COPROC_MOVE_DELAY
#define CLD	INSN_COPROC_MEMORY_DELAY
#define CBL	INSN_COND_BRANCH_LIKELY
#define TRAP	INSN_TRAP
#define SM	INSN_STORE_MEMORY

#define WR_d    INSN_WRITE_GPR_D
#define WR_t    INSN_WRITE_GPR_T
#define WR_31   INSN_WRITE_GPR_31
#define WR_D    INSN_WRITE_FPR_D
#define WR_T	INSN_WRITE_FPR_T
#define WR_S	INSN_WRITE_FPR_S
#define RD_s    INSN_READ_GPR_S
#define RD_b    INSN_READ_GPR_S
#define RD_t    INSN_READ_GPR_T
#define RD_S    INSN_READ_FPR_S
#define RD_T    INSN_READ_FPR_T
#define RD_R	INSN_READ_FPR_R
#define WR_CC	INSN_WRITE_COND_CODE
#define RD_CC	INSN_READ_COND_CODE
#define RD_C0   INSN_COP
#define RD_C1	INSN_COP
#define RD_C2   INSN_COP
#define RD_C3   INSN_COP
#define WR_C0   INSN_COP
#define WR_C1	INSN_COP
#define WR_C2   INSN_COP
#define WR_C3   INSN_COP

#define WR_HI	INSN_WRITE_HI
#define RD_HI	INSN_READ_HI
#define MOD_HI  WR_HI|RD_HI

#define WR_LO	INSN_WRITE_LO
#define RD_LO	INSN_READ_LO
#define MOD_LO  WR_LO|RD_LO

#define WR_HILO WR_HI|WR_LO
#define RD_HILO RD_HI|RD_LO
#define MOD_HILO WR_HILO|RD_HILO

#define IS_M    INSN_MULT

#define WR_MACC INSN2_WRITE_MDMX_ACC
#define RD_MACC INSN2_READ_MDMX_ACC

#define I1	INSN_ISA1
#define I2	INSN_ISA2
#define I3	INSN_ISA3
#define I4	INSN_ISA4
#define I5	INSN_ISA5
#define I32	INSN_ISA32
#define I64     INSN_ISA64
#define I33	INSN_ISA32R2
#define I65	INSN_ISA64R2

/* MIPS64 MIPS-3D ASE support.  */
#define I16     INSN_MIPS16

/* MIPS64 MIPS-3D ASE support.  */
#define M3D     INSN_MIPS3D

/* MIPS64 MDMX ASE support.  */
#define MX      INSN_MDMX

#define P3	INSN_4650
#define L1	INSN_4010
#define V1	(INSN_4100 | INSN_4111 | INSN_4120)
#define T3      INSN_3900
#define M1	INSN_10000
#define SB1     INSN_SB1
#define N411	INSN_4111
#define N412	INSN_4120
#define N5	(INSN_5400 | INSN_5500)
#define N54	INSN_5400
#define N55	INSN_5500

#define G1      (T3             \
                 )

#define G2      (T3             \
                 )

#define G3      (I4             \
                 )

/* MIPS DSP ASE support.
   NOTE:
   1. MIPS DSP ASE includes 4 accumulators ($ac0 - $ac3).  $ac0 is the pair
   of original HI and LO.  $ac1, $ac2 and $ac3 are new registers, and have
   the same structure as $ac0 (HI + LO).  For DSP instructions that write or
   read accumulators (that may be $ac0), we add WR_a (WR_HILO) or RD_a
   (RD_HILO) attritubes, such that HILO dependences are maintained
   conservatively.

   2. For some mul. instructions that use integer registers as destinations
   but destroy HI+LO as side-effect, we add WR_HILO to their attritubes.

   3. MIPS DSP ASE includes a new DSP control register, which has 6 fields
   (ccond, outflag, EFI, c, scount, pos).  Many DSP instructions read or write
   certain fields of the DSP control register.  For simplicity, we decide not
   to track dependences of these fields.
   However, "bposge32" is a branch instruction that depends on the "pos"
   field.  In order to make sure that GAS does not reorder DSP instructions
   that writes the "pos" field and "bposge32", we add DSP_VOLA (INSN_TRAP)
   attritube to those instructions that write the "pos" field.  */

#define WR_a	WR_HILO	/* Write dsp accumulators (reuse WR_HILO)  */
#define RD_a	RD_HILO	/* Read dsp accumulators (reuse RD_HILO)  */
#define MOD_a	WR_a|RD_a
#define DSP_VOLA	INSN_TRAP
#define D32	(INSN_DSP)

/* MIPS MT ASE support.  */
#define MT32	(INSN_MT)

/* The order of overloaded instructions matters.  Label arguments and
   register arguments look the same. Instructions that can have either
   for arguments must apear in the correct order in this table for the
   assembler to pick the right one. In other words, entries with
   immediate operands must apear after the same instruction with
   registers.

   Because of the lookup algorithm used, entries with the same opcode
   name must be contiguous.
 
   Many instructions are short hand for other instructions (i.e., The
   jal <register> instruction is short for jalr <register>).  */

const struct mips_opcode mips_builtin_opcodes[] =
{
/* These instructions appear first so that the disassembler will find
   them first.  The assemblers uses a hash table based on the
   instruction name anyhow.  */
/* name,    args,	match,	    mask,	pinfo,          	membership */

/************************************/ 
/* instructions different from MIPS */
/************************************/

{"daddi",	"t,r,j",	0x60000000, 0xfc000000,	WR_t|RD_s,		0, I1},
{"daddiu",	"t,r,j",	0x64000000, 0xfc000000,	WR_t|RD_s,		0, I1},
{"dadd",	"d,v,t",	0x0000002c, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"daddu",	"d,v,t",	0x0000002d, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"dsub",	"d,v,t",	0x0000002e, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"dsubu",	"d,v,t",	0x0000002f, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"dsllv",   "d,t,s",	0x00000014, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},
{"dsll32",  "d,w,<",	0x0000003c, 0xffe0003f, WR_d|RD_t,		0, I1},
{"dsll",    "d,w,s",	0x00000014, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},/*dsllv*/
{"dsll",    "d,w,>",	0x0000003c, 0xffe0003f, WR_d|RD_t,		0, I1},/*dsll32*/
{"dsll",    "d,w,<",	0x00000038, 0xffe0003f,	WR_d|RD_t,		0, I1},
{"dsrav",   "d,t,s",	0x00000017, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},
{"dsra32",  "d,w,<",	0x0000003f, 0xffe0003f, WR_d|RD_t,		0, I1},
{"dsra",    "d,w,s",	0x00000017, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},/*dsrav*/
{"dsra",    "d,w,>",	0x0000003f, 0xffe0003f, WR_d|RD_t,		0, I1},/*dsra32*/
{"dsra",    "d,w,<",	0x0000003b, 0xffe0003f,	WR_d|RD_t,		0, I1},
{"dsrlv",   "d,t,s",	0x00000016, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},
{"dsrl32",  "d,w,<",	0x0000003e, 0xffe0003f, WR_d|RD_t,		0, I1},
{"dsrl",    "d,w,s",	0x00000016, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},/*dsrlv*/
{"dsrl",    "d,w,>",	0x0000003e, 0xffe0003f, WR_d|RD_t,		0, I1},/*dsrl32*/
{"dsrl",    "d,w,<",	0x0000003a, 0xffe0003f,	WR_d|RD_t,		0, I1},
{"mult",	"d,s,t",    0x00000018, 0xfc0007ff, RD_s|RD_t|WR_d|IS_M,	0, I1},
{"multu",	"d,s,t",    0x00000019, 0xfc0007ff, RD_s|RD_t|WR_d|IS_M, 	0, I1},
{"div",		"d,v,t",	0x0000001a, 0xfc0007ff, RD_s|RD_t|WR_d,			0, I1},
{"divu",	"d,v,t",	0x0000001b, 0xfc0007ff, RD_s|RD_t|WR_d,			0, I1},
{"dmult",	"d,s,t",	0x0000001c,	0xfc0007ff,	RD_s|RD_t|WR_d,			0, I1},
{"dmultu",	"d,s,t",	0x0000001d,	0xfc0007ff,	RD_s|RD_t|WR_d,			0, I1},

/* floating point instructions */
{"c.f.d",   "S,T",	0x46200030, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.f.s",   "S,T",  0x46000030, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.un.d",  "S,T",	0x46200031, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.un.s",  "S,T",  0x46000031, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.eq.d",  "S,T",	0x46200032, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.eq.s",  "S,T",  0x46000032, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.ueq.d", "S,T",	0x46200033, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.ueq.s", "S,T",  0x46000033, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.olt.d", "S,T",  0x46200034, 0xffe007ff, RD_S|RD_T|WR_CC|FP_D,   0, I1},
{"c.olt.s", "S,T",	0x46000034, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_S,	0, I1},
{"c.ult.d", "S,T",	0x46200035, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.ult.s", "S,T",  0x46000035, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.ole.d", "S,T",  0x46200036, 0xffe007ff, RD_S|RD_T|WR_CC|FP_D,   0, I1},
{"c.ole.s", "S,T",  0x46000036, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.ule.d", "S,T",	0x46200037, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.ule.s", "S,T",  0x46000037, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.sf.d",  "S,T",	0x46200038, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.sf.s",  "S,T",  0x46000038, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.ngle.d","S,T",	0x46200039, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.ngle.s","S,T",  0x46000039, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.seq.d", "S,T",	0x4620003a, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.seq.s", "S,T",  0x4600003a, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.ngl.d", "S,T",	0x4620003b, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.ngl.s", "S,T",  0x4600003b, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.lt.d",  "S,T",	0x4620003c, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.lt.s",  "S,T",	0x4600003c, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_S,	0, I1},
{"c.nge.d", "S,T",	0x4620003d, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.nge.s", "S,T",  0x4600003d, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"c.le.d",  "S,T",	0x4620003e, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.le.s",  "S,T",	0x4600003e, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_S,	0, I1},
{"c.ngt.d", "S,T",	0x4620003f, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0, I1},
{"c.ngt.s", "S,T",  0x4600003f, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0, I1},
{"bc1f",    "p",	0x45000000, 0xffff0000,	CBD|FP_S,		0, I1},
{"bc1t",    "p",	0x45010000, 0xffff0000,	CBD|FP_S,		0, I1},
{"bc1fl",   "p",	0x45020000, 0xffff0000,	CBL|FP_S,		0, I1},
{"bc1tl",   "p",	0x45030000, 0xffff0000,	CBL|FP_S,		0, I1},

/* other instructions */
{"sync",    "",		0x0000000f, 0xffffffff,	INSN_SYNC,		0, I1},


/****************************/ 
/* instructions only on RMT */
/****************************/

/* load/store instructions*/
{"iolb",	"t,s",		0x40000030,	0xfc00ffff,	WR_t|RD_s,	0, I1},
{"iolh",	"t,s",		0x40000031,	0xfc00ffff,	WR_t|RD_s,	0, I1},
{"iolw",	"t,s",		0x40000032,	0xfc00ffff,	WR_t|RD_s,	0, I1},

/* logical instructions */
{"dand",	"d,v,t",	0x00000064, 0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"dor",		"d,v,t",	0x00000065,	0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"dxor",	"d,v,t",	0x00000066,	0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"dnor",	"d,v,t",	0x00000067,	0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"dandi",	"t,r,i",	0xb0000000,	0xfc000000,	WR_t|RD_s,			0, I1},
{"dori",	"t,r,i",	0xd0000000,	0xfc000000,	WR_t|RD_s,			0, I1},
{"dxori",	"t,r,i",	0xf0000000,	0xfc000000,	WR_t|RD_s,			0, I1},
{"multh",	"d,s,t",	0x00000058,	0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"multuh",	"d,s,t",	0x00000059,	0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"dmulth",	"d,s,t",	0x0000005c,	0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"dmultuh",	"d,s,t",	0x0000005d,	0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"rem",		"d,s,t",	0x0000005a, 0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"remu",	"d,s,t",	0x0000005b, 0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"dslt",	"d,v,t",	0x0000006a,	0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"dsltu",	"d,v,t",	0x0000006b,	0xfc0007ff,	WR_d|RD_s|RD_t,		0, I1},
{"rtl",		"d,w,<",	0x00200000,	0xffe0003f,	WR_d|RD_t,		0, I1},
{"rtr",		"d,w,<",	0x00200002,	0xffe0003f,	WR_d|RD_t,		0, I1},
{"rtlv",	"d,t,s",	0x00000044,	0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},
{"rtrv",	"d,t,s",	0x00000046,	0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},
{"drtl",	"d,w,<",	0x00200038,	0xffe0003f,	WR_d|RD_t,		0, I1},
{"drtr",	"d,w,<",	0x0020003a,	0xffe0003f,	WR_d|RD_t,		0, I1},
{"drtl32",	"d,w,<",	0x0020003c,	0xffe0003f,	WR_d|RD_t,		0, I1},
{"drtr32",	"d,w,<",	0x0020003e,	0xffe0003f,	WR_d|RD_t,		0, I1},
{"drtlv",	"d,t,s",	0x0000054,	0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},
{"drtrv",	"d,t,s",	0x0000056,	0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},

/* system control instructions */
{"mfc0",    "t,d",		0x40000000, 0xffe007ff,	LCD|WR_t,		0, I1},
{"mtc0",    "t,d",		0x40800000, 0xffe007ff,	COD|RD_t,		0, I1},
{"mfimm",   "t,d",		0x40000002, 0xffe007ff,	LCD|WR_t, 		0, I1},
{"mfimm3",  "d,s,t",	0x40000006, 0xfc0007ff,	LCD|WR_d|RD_s|RD_t,	0, I1},
{"mtimm",   "t,d",		0x40800002, 0xffe007ff,	COD|RD_t,		0, I1},
{"mfdmm",   "t,d",		0x40000003, 0xffe007ff,	LCD|WR_t,		0, I1},
{"mfdmm3",  "d,s,t",	0x40000007, 0xfc0007ff,	LCD|WR_d|RD_s|RD_t,	0, I1},
{"mtdmm",   "t,d",		0x40800003, 0xffe007ff,	COD|RD_t, 		0, I1},
{"eret",	"",			0x40000018, 0xffffffff,	0, 				0, I1},

/* thread control instructions */
{"mkth",	"d,s,t",	0x74000001,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"delth",	"d,s",		0x74000002,	0xfc1f07ff,	WR_d|RD_s,		0, I1},
{"chgpr",	"d,s,t",	0x74000003,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"chgst",	"d,s,t",	0x74000004,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"runth",	"d,s",		0x74000005,	0xfc1f07ff,	WR_d|RD_s,		0, I1},
{"stopth",	"d,s",		0x74000006,	0xfc1f07ff,	WR_d|RD_s,		0, I1},
{"stopslf",	"d",		0x74000007,	0xffff07ff,	WR_d,			0, I1},
{"bkupth",	"d,s",		0x74000008,	0xfc1f07ff,	WR_d|RD_s,		0, I1},
{"bkupslf",	"d",		0x74000009,	0xffff07ff,	WR_d,			0, I1},
{"rstrth",	"d,s",		0x7400000a,	0xfc1f07ff,	WR_d|RD_s,		0, I1},
{"swapth",	"d,s,t",	0x7400000b,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"swapslf",	"d,t",		0x7400000c,	0xffe007ff,	WR_d|RD_t,		0, I1},
{"cpthtoa",	"d,s,t",	0x7400000d,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cpthtom",	"d,s,t",	0x7400000e,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"gettt",	"d,s",		0x7400000f,	0xfc1f07ff,	WR_d|RD_s,		0, I1},
{"gettid",	"d,s",		0x74000010,	0xfc1f07ff,	WR_d|RD_s,		0, I1},
{"getotid",	"d",		0x74000011,	0xffff07ff,	WR_d,			0, I1},
{"getmtid",	"d,s",		0x74000012,	0xfc1f07ff,	WR_d|RD_s,		0, I1},
{"getcnum",	"d,s",		0x74000013,	0xfc1f07ff,	WR_d|RD_s,		0, I1},

/* SIMD logical instructions */
{"sadd.8",		"d,v,t",	0x70000060,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sadd.8.sc",	"d,v,t",	0x70000160,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sadd.16",		"d,v,t",	0x700000a0,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sadd.16.sc",	"d,v,t",	0x700001a0,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sadd.32",		"d,v,t",	0x700000e0,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sadd.32.sc",	"d,v,t",	0x700001e0,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssub.8",		"d,v,t",	0x70000062,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssub.8.sc",	"d,v,t",	0x70000162,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssub.16",		"d,v,t",	0x700000a2,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssub.16.sc",	"d,v,t",	0x700001a2,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssub.32",		"d,v,t",	0x700000e2,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssub.32.sc",	"d,v,t",	0x700001e2,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smult.8",		"d,s,t",	0x70000038,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smult.8.sc",	"d,s,t",	0x70000138,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smult.16",	"d,s,t",	0x70000098,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smult.16.sc",	"d,s,t",	0x70000198,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smult.32",	"d,s,t",	0x700000d8,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smult.32.sc",	"d,s,t",	0x700001d8,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smultu.8",	"d,s,t",	0x70000039,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smultu.8.sc",	"d,s,t",	0x70000139,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smultu.16",	"d,s,t",	0x70000099,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smultu.16.sc","d,s,t",	0x70000199,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smultu.32",	"d,s,t",	0x700000d9,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"smultu.32.sc","d,s,t",	0x700001d9,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sand.8",		"d,v,t",	0x70000064,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sand.8.sc",	"d,v,t",	0x70000164,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sand.16",		"d,v,t",	0x700000a4,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sand.16.sc",	"d,v,t",	0x700001a4,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sand.32",		"d,v,t",	0x700000e4,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sand.32.sc",	"d,v,t",	0x700001e4,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sor.8",		"d,v,t",	0x70000065,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sor.8.sc",	"d,v,t",	0x70000165,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sor.16",		"d,v,t",	0x700000a5,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sor.16.sc",	"d,v,t",	0x700001a5,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sor.32",		"d,v,t",	0x700000e5,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sor.32.sc",	"d,v,t",	0x700001e5,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sxor.8",		"d,v,t",	0x70000066,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sxor.8.sc",	"d,v,t",	0x70000166,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sxor.16",		"d,v,t",	0x700000a6,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sxor.16.sc",	"d,v,t",	0x700001a6,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sxor.32",		"d,v,t",	0x700000e6,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sxor.32.sc",	"d,v,t",	0x700001e6,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"snor.8",		"d,v,t",	0x70000067,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"snor.8.sc",	"d,v,t",	0x70000167,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"snor.16",		"d,v,t",	0x700000a7,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"snor.16.sc",	"d,v,t",	0x700001a7,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"snor.32",		"d,v,t",	0x700000e7,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"snor.32.sc",	"d,v,t",	0x700001e7,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sslt.8",		"d,v,t",	0x70000068,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sslt.8.sc",	"d,v,t",	0x70000168,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sslt.16",		"d,v,t",	0x700000a8,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sslt.16.sc",	"d,v,t",	0x700001a8,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sslt.32",		"d,v,t",	0x700000e8,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sslt.32.sc",	"d,v,t",	0x700001e8,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssltu.8",		"d,v,t",	0x70000069,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssltu.8.sc",	"d,v,t",	0x70000169,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssltu.16",	"d,v,t",	0x700000a9,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssltu.16.sc",	"d,v,t",	0x700001a9,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssltu.32",	"d,v,t",	0x700000e9,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssltu.32.sc",	"d,v,t",	0x700001e9,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssllv.8",		"d,t,s",	0x70000044,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssllv.8.sc",	"d,t,s",	0x70000144,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssllv.16",	"d,t,s",	0x70000084,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssllv.16.sc",	"d,t,s",	0x70000184,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssllv.32",	"d,t,s",	0x700000c4,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssllv.32.sc",	"d,t,s",	0x700001c4,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrlv.8",		"d,t,s",	0x70000046,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrlv.8.sc",	"d,t,s",	0x70000146,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrlv.16",	"d,t,s",	0x70000086,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrlv.16.sc",	"d,t,s",	0x70000186,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrlv.32",	"d,t,s",	0x700000c6,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrlv.32.sc",	"d,t,s",	0x700001c6,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrav.8",		"d,t,s",	0x70000047,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrav.8.sc",	"d,t,s",	0x70000147,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrav.16",	"d,t,s",	0x70000087,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrav.16.sc",	"d,t,s",	0x70000187,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrav.32",	"d,t,s",	0x700000c7,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"ssrav.32.sc",	"d,t,s",	0x700001c7,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtlv.8",		"d,t,s",	0x70000040,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtlv.8.sc",	"d,t,s",	0x70000140,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtlv.16",	"d,t,s",	0x70000080,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtlv.16.sc",	"d,t,s",	0x70000180,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtlv.32",	"d,t,s",	0x700000c0,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtlv.32.sc",	"d,t,s",	0x700001c0,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtrv.8",		"d,t,s",	0x70000042,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtrv.8.sc",	"d,t,s",	0x70000142,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtrv.16",	"d,t,s",	0x70000082,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtrv.16.sc",	"d,t,s",	0x70000182,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtrv.32",	"d,t,s",	0x700000c2,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"srtrv.32.sc",	"d,t,s",	0x700001c2,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"pck.8",		"d,v,t",	0x70000078,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"pck.16",		"d,v,t",	0x700000b8,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"pck.32",		"d,v,t",	0x700000f8,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"pckh.8",		"d,v,t",	0x70000079,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"pckh.16",		"d,v,t",	0x700000b9,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"pckh.32",		"d,v,t",	0x700000f9,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat1.8",		"d,v,t",	0x7000007a,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat1.16",		"d,v,t",	0x700000ba,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat1.32",		"d,v,t",	0x700000fa,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat1h.8",		"d,v,t",	0x7000007b,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat1h.16",	"d,v,t",	0x700000bb,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat1h.32",	"d,v,t",	0x700000fb,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat2.8",		"d,v,t",	0x7000007c,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat2.16",		"d,v,t",	0x700000bc,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat2.32",		"d,v,t",	0x700000fc,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat2h.8",		"d,v,t",	0x7000007d,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat2h.16",	"d,v,t",	0x700000bd,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat2h.32",	"d,v,t",	0x700000fd,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat3.8",		"d,v,t",	0x7000007e,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat3.16",		"d,v,t",	0x700000be,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat3.32",		"d,v,t",	0x700000fe,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat3h.8",		"d,v,t",	0x7000007f,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat3h.16",	"d,v,t",	0x700000bf,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"cat3h.32",	"d,v,t",	0x700000ff,	0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},

/* synchronization instructions*/
{"rgpsh",	"t,~",	0x40000020,	0xffe007ff,	LCD|WR_t|RD_C0,	0, I1},
{"wgpsh",	"t,~",	0x40800020,	0xffe007ff,	COD|RD_t|WR_C0,	0, I1},
{"gplock",  "t,d",	0x40000027, 0xffe007ff,	LCD|WR_t|RD_C0,	0, I1},
{"gprel",   "t,d",	0x40800027, 0xffe007ff,	COD|RD_t|WR_C0,	0, I1},
{"rfpsh",	"t,~",	0x40000024,	0xffe007ff,	LCD|WR_t|RD_C0,	0, I1},
{"wfpsh",	"t,~",	0x40800024,	0xffe007ff,	COD|RD_t|WR_C0,	0, I1},
{"rgpex",	"t,~",	0x40000021,	0xffe007ff,	LCD|WR_t|RD_C0,	0, I1},
{"wgpex",	"t,~",	0x40800021,	0xffe007ff,	COD|RD_t|WR_C0,	0, I1},
{"rfpex",	"t,~",	0x40000025,	0xffe007ff,	LCD|WR_t|RD_C0,	0, I1},
{"wfpex",	"t,~",	0x40800025,	0xffe007ff,	COD|RD_t|WR_C0,	0, I1},
{"gpco",	"t,~,#",0x40000022,	0xffe0003f,	LCD|WR_t|RD_C0,	0, I1},
{"gppr",	"t,~,#",0x40800022,	0xffe0003f,	COD|RD_t|WR_C0,	0, I1},
{"fpco",	"t,~,#",0x40000026,	0xffe0003f,	LCD|WR_t|RD_C0,	0, I1},
{"fppr",	"t,~,#",0x40800026,	0xffe0003f,	COD|RD_t|WR_C0,	0, I1},
{"bar",		"t,~",	0x40800023,	0xffe007ff,	COD|RD_t|WR_C0,	0, I1},
{"pbar",	"~",	0x40000023,	0xffff07ff,	LCD|RD_C0,		0, I1},

/* vector logical instructions */
{"vadd.vv",			"d,s,t",	0x78000020,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vadd.vs",			"d,s,t",	0x780000a0,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vadd.vv.sy",		"d,s,t",	0x78000060,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vadd.vs.sy",		"d,s,t",	0x780000e0,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsub.vv",			"d,s,t",	0x78000022,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsub.vs",			"d,s,t",	0x780000a2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsub.sv",			"d,s,t",	0x78000122,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsub.ss",			"d,s,t",	0x780001a2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsub.vv.sy",		"d,s,t",	0x78000062,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsub.vs.sy",		"d,s,t",	0x780000e2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsub.sv.sy",		"d,s,t",	0x78000162,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsub.ss.sy",		"d,s,t",	0x780001e2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmult.vv",		"d,s,t",	0x78000018,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmult.vs",		"d,s,t",	0x78000098,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmult.vv.sy",		"d,s,t",	0x78000058,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmult.vs.sy",		"d,s,t",	0x780000d8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmultu.vv",		"d,s,t",	0x78000019,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmultu.vs",		"d,s,t",	0x78000099,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmultu.vv.sy",	"d,s,t",	0x78000059,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmultu.vs.sy",	"d,s,t",	0x780000d9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmulth.vv",		"d,s,t",	0x78000010,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmulth.vs",		"d,s,t",	0x78000090,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmulth.vv.sy",	"d,s,t",	0x78000050,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmulth.vs.sy",	"d,s,t",	0x780000d0,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.vv",		"d,s,t",	0x78000011,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.vs",		"d,s,t",	0x78000091,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.vv.sy",	"d,s,t",	0x78000051,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.vs.sy",	"d,s,t",	0x780000d1,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdiv.vv",			"d,s,t",	0x7800001a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdiv.vs",			"d,s,t",	0x7800009a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdiv.sv",			"d,s,t",	0x7800011a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdiv.ss",			"d,s,t",	0x7800019a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdiv.vv.sy",		"d,s,t",	0x7800005a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdiv.vs.sy",		"d,s,t",	0x780000da,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdiv.sv.sy",		"d,s,t",	0x7800015a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdiv.ss.sy",		"d,s,t",	0x780001da,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdivu.vv",		"d,s,t",	0x7800001b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdivu.vs",		"d,s,t",	0x7800009b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdivu.sv",		"d,s,t",	0x7800011b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdivu.ss",		"d,s,t",	0x7800019b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdivu.vv.sy",		"d,s,t",	0x7800005b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdivu.vs.sy",		"d,s,t",	0x780000db,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdivu.sv.sy",		"d,s,t",	0x7800015b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vdivu.ss.sy",		"d,s,t",	0x780001db,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrem.vv",			"d,s,t",	0x78000012,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrem.vs",			"d,s,t",	0x78000092,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrem.sv",			"d,s,t",	0x78000112,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrem.ss",			"d,s,t",	0x78000192,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrem.vv.sy",		"d,s,t",	0x78000052,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrem.vs.sy",		"d,s,t",	0x780000d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrem.sv.sy",		"d,s,t",	0x78000152,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrem.ss.sy",		"d,s,t",	0x780001d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vremu.vv",		"d,s,t",	0x78000013,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vremu.vs",		"d,s,t",	0x78000093,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vremu.sv",		"d,s,t",	0x78000113,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vremu.ss",		"d,s,t",	0x78000193,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vremu.vv.sy",		"d,s,t",	0x78000053,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vremu.vs.sy",		"d,s,t",	0x780000d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vremu.sv.sy",		"d,s,t",	0x78000153,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vremu.ss.sy",		"d,s,t",	0x780001d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd.vv",		"d,s,t",	0x78000021,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd.vs",		"d,s,t",	0x780000a1,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd.vv.sy",		"d,s,t",	0x78000061,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd.vs.sy",		"d,s,t",	0x780000e1,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.vv",		"d,s,t",	0x78000023,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.vs",		"d,s,t",	0x780000a3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.vv.sy",		"d,s,t",	0x78000063,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.vs.sy",		"d,s,t",	0x780000e3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmul8.vv",		"d,s,t",	0x78000008,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmul8.vs",		"d,s,t",	0x78000088,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmul8.vv.sy",		"d,s,t",	0x78000048,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmul8.vs.sy",		"d,s,t",	0x780000c8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd8.vv",		"d,s,t",	0x78000009,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd8.vs",		"d,s,t",	0x78000089,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd8.vv.sy",	"d,s,t",	0x78000049,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd8.vs.sy",	"d,s,t",	0x780000c9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vacc",			"d,s",		0x7800000a,	0xfc1f07ff, RD_s|RD_t|WR_d,	0, I1},
{"vacc.sy",			"d,s",		0x7800004a,	0xfc1f07ff, RD_s|RD_t|WR_d,	0, I1},
{"vmac.vv",			"d,s,t",	0x7800000b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmac.vs",			"d,s,t",	0x7800008b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmac.vv.sy",		"d,s,t",	0x7800004b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmac.vs.sy",		"d,s,t",	0x780000cb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vand.vv"	,		"d,s,t",	0x78000024,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vand.vs",			"d,s,t",	0x780000a4,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vand.vv.sy",		"d,s,t",	0x78000064,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vand.vs.sy",		"d,s,t",	0x780000e4,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vor.vv"	,		"d,s,t",	0x78000025,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vor.vs",			"d,s,t",	0x780000a5,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vor.vv.sy",		"d,s,t",	0x78000065,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vor.vs.sy",		"d,s,t",	0x780000e5,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vxor.vv"	,		"d,s,t",	0x78000026,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vxor.vs",			"d,s,t",	0x780000a6,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vxor.vv.sy",		"d,s,t",	0x78000066,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vxor.vs.sy",		"d,s,t",	0x780000e6,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vnor.vv"	,		"d,s,t",	0x78000027,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vnor.vs",			"d,s,t",	0x780000a7,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vnor.vv.sy",		"d,s,t",	0x78000067,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vnor.vs.sy",		"d,s,t",	0x780000e7,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsllv.vv"	,		"d,s,t",	0x78000004,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsllv.vs",		"d,s,t",	0x78000084,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsllv.vv.sy",		"d,s,t",	0x78000044,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsllv.vs.sy",		"d,s,t",	0x780000c4,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.vv"	,		"d,s,t",	0x78000006,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.vs",		"d,s,t",	0x78000086,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.vv.sy",		"d,s,t",	0x78000046,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.vs.sy",		"d,s,t",	0x780000c6,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsrav.vv"	,		"d,s,t",	0x78000007,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsrav.vs",		"d,s,t",	0x78000087,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsrav.vv.sy",		"d,s,t",	0x78000047,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vsrav.vs.sy",		"d,s,t",	0x780000c7,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.vv"	,		"d,s,t",	0x78000000,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.vs",		"d,s,t",	0x78000080,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.vv.sy",		"d,s,t",	0x78000040,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.vs.sy",		"d,s,t",	0x780000c0,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.vv"	,		"d,s,t",	0x78000002,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.vs",		"d,s,t",	0x78000082,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.vv.sy",		"d,s,t",	0x78000042,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.vs.sy",		"d,s,t",	0x780000c2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.f.vv",		"d,s,t",	0x78000028,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.eq.vv",		"d,s,t",	0x78000128,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ge.vv",		"d,s,t",	0x78000228,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.gt.vv",		"d,s,t",	0x78000328,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.t.vv",		"d,s,t",	0x78000428,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ne.vv",		"d,s,t",	0x78000528,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.lt.vv",		"d,s,t",	0x78000628,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.le.vv",		"d,s,t",	0x78000728,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.f.vs",		"d,s,t",	0x780000a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.eq.vs",		"d,s,t",	0x780001a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ge.vs",		"d,s,t",	0x780002a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.gt.vs",		"d,s,t",	0x780003a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.t.vs",		"d,s,t",	0x780004a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ne.vs",		"d,s,t",	0x780005a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.lt.vs",		"d,s,t",	0x780006a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.le.vs",		"d,s,t",	0x780007a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.f.vv.sy",	"d,s,t",	0x78000068,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.eq.vv.sy",	"d,s,t",	0x78000168,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ge.vv.sy",	"d,s,t",	0x78000268,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.gt.vv.sy",	"d,s,t",	0x78000368,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.t.vv.sy",	"d,s,t",	0x78000468,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ne.vv.sy",	"d,s,t",	0x78000568,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.lt.vv.sy",	"d,s,t",	0x78000668,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.le.vv.sy",	"d,s,t",	0x78000768,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.f.vs.sy",	"d,s,t",	0x780000e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.eq.vs.sy",	"d,s,t",	0x780001e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ge.vs.sy",	"d,s,t",	0x780002e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.gt.vs.sy",	"d,s,t",	0x780003e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.t.vs.sy",	"d,s,t",	0x780004e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ne.vs.sy",	"d,s,t",	0x780005e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.lt.vs.sy",	"d,s,t",	0x780006e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.le.vs.sy",	"d,s,t",	0x780007e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.f.vv",		"d,s,t",	0x78000029,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.eq.vv",		"d,s,t",	0x78000129,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ge.vv",		"d,s,t",	0x78000229,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.gt.vv",		"d,s,t",	0x78000329,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.t.vv",		"d,s,t",	0x78000429,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ne.vv",		"d,s,t",	0x78000529,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.lt.vv",		"d,s,t",	0x78000629,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.le.vv",		"d,s,t",	0x78000729,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.f.vs",		"d,s,t",	0x780000a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.eq.vs",		"d,s,t",	0x780001a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ge.vs",		"d,s,t",	0x780002a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.gt.vs",		"d,s,t",	0x780003a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.t.vs",		"d,s,t",	0x780004a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ne.vs",		"d,s,t",	0x780005a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.lt.vs",		"d,s,t",	0x780006a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.le.vs",		"d,s,t",	0x780007a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.f.vv.sy",	"d,s,t",	0x78000069,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.eq.vv.sy",	"d,s,t",	0x78000169,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ge.vv.sy",	"d,s,t",	0x78000269,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.gt.vv.sy",	"d,s,t",	0x78000369,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.t.vv.sy",	"d,s,t",	0x78000469,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ne.vv.sy",	"d,s,t",	0x78000569,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.lt.vv.sy",	"d,s,t",	0x78000669,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.le.vv.sy",	"d,s,t",	0x78000769,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.f.vs.sy",	"d,s,t",	0x780000e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.eq.vs.sy",	"d,s,t",	0x780001e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ge.vs.sy",	"d,s,t",	0x780002e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.gt.vs.sy",	"d,s,t",	0x780003e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.t.vs.sy",	"d,s,t",	0x780004e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ne.vs.sy",	"d,s,t",	0x780005e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.lt.vs.sy",	"d,s,t",	0x780006e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.le.vs.sy",	"d,s,t",	0x780007e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.f.vv",		"d,s,t",	0x7800002a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.eq.vv",	"d,s,t",	0x7800012a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ge.vv",	"d,s,t",	0x7800022a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.gt.vv",	"d,s,t",	0x7800032a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.t.vv",		"d,s,t",	0x7800042a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ne.vv",	"d,s,t",	0x7800052a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.lt.vv",	"d,s,t",	0x7800062a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.le.vv",	"d,s,t",	0x7800072a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.f.vs",		"d,s,t",	0x780000aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.eq.vs",	"d,s,t",	0x780001aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ge.vs",	"d,s,t",	0x780002aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.gt.vs",	"d,s,t",	0x780003aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.t.vs",		"d,s,t",	0x780004aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ne.vs",	"d,s,t",	0x780005aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.lt.vs",	"d,s,t",	0x780006aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.le.vs",	"d,s,t",	0x780007aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.f.vv.sy",	"d,s,t",	0x7800006a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.eq.vv.sy",	"d,s,t",	0x7800016a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ge.vv.sy",	"d,s,t",	0x7800026a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.gt.vv.sy",	"d,s,t",	0x7800036a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.t.vv.sy",	"d,s,t",	0x7800046a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ne.vv.sy",	"d,s,t",	0x7800056a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.lt.vv.sy",	"d,s,t",	0x7800066a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.le.vv.sy",	"d,s,t",	0x7800076a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.f.vs.sy",	"d,s,t",	0x780000ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.eq.vs.sy",	"d,s,t",	0x780001ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ge.vs.sy",	"d,s,t",	0x780002ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.gt.vs.sy",	"d,s,t",	0x780003ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.t.vs.sy",	"d,s,t",	0x780004ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ne.vs.sy",	"d,s,t",	0x780005ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.lt.vs.sy",	"d,s,t",	0x780006ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.le.vs.sy",	"d,s,t",	0x780007ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.f.vv",	"d,s,t",	0x7800002b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.eq.vv",	"d,s,t",	0x7800012b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ge.vv",	"d,s,t",	0x7800022b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.gt.vv",	"d,s,t",	0x7800032b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.t.vv",	"d,s,t",	0x7800042b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ne.vv",	"d,s,t",	0x7800052b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.lt.vv",	"d,s,t",	0x7800062b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.le.vv",	"d,s,t",	0x7800072b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.f.vs",	"d,s,t",	0x780000ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.eq.vs",	"d,s,t",	0x780001ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ge.vs",	"d,s,t",	0x780002ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.gt.vs",	"d,s,t",	0x780003ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.t.vs",	"d,s,t",	0x780004ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ne.vs",	"d,s,t",	0x780005ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.lt.vs",	"d,s,t",	0x780006ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.le.vs",	"d,s,t",	0x780007ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.f.vv.sy",	"d,s,t",	0x7800006b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.eq.vv.sy","d,s,t",	0x7800016b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ge.vv.sy","d,s,t",	0x7800026b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.gt.vv.sy","d,s,t",	0x7800036b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.t.vv.sy",	"d,s,t",	0x7800046b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ne.vv.sy","d,s,t",	0x7800056b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.lt.vv.sy","d,s,t",	0x7800066b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.le.vv.sy","d,s,t",	0x7800076b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.f.vs.sy",	"d,s,t",	0x780000eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.eq.vs.sy","d,s,t",	0x780001eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ge.vs.sy","d,s,t",	0x780002eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.gt.vs.sy","d,s,t",	0x780003eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.t.vs.sy",	"d,s,t",	0x780004eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ne.vs.sy","d,s,t",	0x780005eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.lt.vs.sy","d,s,t",	0x780006eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.le.vs.sy","d,s,t",	0x780007eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vimfc",			"d,s",		0x78000030,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vimfc.sy",		"d,s",		0x78000070,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vimtc",			"d,s",		0x78000031,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vimtc.sy",		"d,s",		0x78000071,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vimfs",			"d,s",		0x78000032,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vimfs.sy",		"d,s",		0x78000072,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vimts",			"d,s",		0x78000033,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vimts.sy",		"d,s",		0x78000073,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vimfv",			"d,s,t",	0x78000034,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vimfv.sy",		"d,s,t",	0x78000074,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vimtv",			"d,s,t",	0x78000035,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vimtv.sy",		"d,s,t",	0x78000075,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
	/* Dont we deal with mask registers? (vimtm.*) */
{"vimtm.lo",		"s",		0x7800009e, 0xfc1fffff,	RD_s,			0, I1},
{"vimtm.hi",		"s",		0x7800011e, 0xfc1fffff,	RD_s,			0, I1},
{"vimtm.lo.sy",		"s",		0x780000de, 0xfc1fffff,	RD_s,			0, I1},
{"vimtm.hi.sy",		"s",		0x7800015e, 0xfc1fffff,	RD_s,			0, I1},
{"virsv",			"d,s",		0x78000036,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"virsv.sy",		"d,s",		0x78000076,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"virls",			"d",		0x78000037,	0xffff07ff,	WR_d,			0, I1},
{"virls.sy",		"d",		0x78000077,	0xffff07ff,	WR_d,			0, I1},
{"vidci",			"d,s",		0x7800002e,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vidci.sy",		"d,s",		0x7800006e,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vieci",      		"d,s,t,n",	0x7800002f,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
/* Base register(b) is replaced by source register(s)
 * because compile error in gcc vilw - visw.sy
 */
{"vilw",			"t,b",		0x7800003a,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"vilw.sy",			"t,b",		0x7800007a,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"visw",			"t,b",		0x7800003e,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"visw.sy",			"t,b",		0x7800007e,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"vadd.qb.vv",			"d,s,t",	0xf8000020,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.qb.vs",			"d,s,t",	0xf80000a0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.qb.vv.lo8",		"d,s,t",	0xf8000220,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.qb.vs.lo8",		"d,s,t",	0xf80002a0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.qb.vv.sy",		"d,s,t",	0xf8000060,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.qb.vs.sy",		"d,s,t",	0xf80000e0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.qb.vv.lo8.sy",	"d,s,t",	0xf8000260,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.qb.vs.lo8.sy",	"d,s,t",	0xf80002e0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.vv",			"d,s,t",	0xf8000022, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.vs",			"d,s,t",	0xf80000a2, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.sv",			"d,s,t",	0xf8000122, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.vv.lo8",		"d,s,t",	0xf8000222, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.vs.lo8",		"d,s,t",	0xf80002a2, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.sv.lo8",		"d,s,t",	0xf8000322, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.vv.sy",		"d,s,t",	0xf8000062, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.vs.sy",		"d,s,t",	0xf80000e2, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.sv.sy",		"d,s,t",	0xf8000162, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.vv.lo8.sy",	"d,s,t",	0xf8000262, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.vs.lo8.sy",	"d,s,t",	0xf80002e2, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.qb.sv.lo8.sy",	"d,s,t",	0xf8000362, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.qb.vv",			"d,s,t",	0xf8000018,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.qb.vs",			"d,s,t",	0xf8000098,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.qb.vv.lo8",		"d,s,t",	0xf8000218,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.qb.vs.lo8",		"d,s,t",	0xf8000298,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.qb.vv.sy",		"d,s,t",	0xf8000058,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.qb.vs.sy",		"d,s,t",	0xf80000D8,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.qb.vv.lo8.sy",	"d,s,t",	0xf8000258,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.qb.vs.lo8.sy",	"d,s,t",	0xf80002D8,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.qb.vv",		"d,s,t",	0xf8000019,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.qb.vs",		"d,s,t",	0xf8000099,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.qb.vv.lo8",	"d,s,t",	0xf8000219,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.qb.vs.lo8",	"d,s,t",	0xf8000299,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.qb.vv.sy",		"d,s,t",	0xf8000059,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.qb.vs.sy",		"d,s,t",	0xf80000d9,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.qb.vv.lo8.sy",	"d,s,t",	0xf8000259,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.qb.vs.lo8.sy",	"d,s,t",	0xf80002d9,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.qb.vv",		"d,s,t",	0xf8000010,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.qb.vs",		"d,s,t",	0xf8000090,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.qb.vv.lo8",	"d,s,t",	0xf8000210,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.qb.vs.lo8",	"d,s,t",	0xf8000290,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.qb.vv.sy",		"d,s,t",	0xf8000050,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.qb.vs.sy",		"d,s,t",	0xf80000d0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.qb.vv.lo8.sy",	"d,s,t",	0xf8000250,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.qb.vs.lo8.sy",	"d,s,t",	0xf80002d0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.qb.vv",		"d,s,t",	0xf8000011,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.qb.vs",		"d,s,t",	0xf8000091,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.qb.vv.lo8",	"d,s,t",	0xf8000211,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.qb.vs.lo8",	"d,s,t",	0xf8000291,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.qb.vv.sy",	"d,s,t",	0xf8000051,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.qb.vs.sy",	"d,s,t",	0xf80000d1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.qb.vv.lo8.sy","d,s,t",	0xf8000251,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.qb.vs.lo8.sy","d,s,t",	0xf80002d1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.qb.vv",			"d,s,t",	0xf8000021,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.qb.vs",			"d,s,t",	0xf80000a1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.qb.vv.lo8",		"d,s,t",	0xf8000221,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.qb.vs.lo8",		"d,s,t",	0xf80002a1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.qb.vv.sy",		"d,s,t",	0xf8000061,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.qb.vs.sy",		"d,s,t",	0xf80000e1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.qb.vv.lo8.sy",	"d,s,t",	0xf8000261,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.qb.vs.lo8.sy",	"d,s,t",	0xf80002e1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.qb.vv",			"d,s,t",	0xf8000023,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.qb.vs",			"d,s,t",	0xf80000a3,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.qb.vv.lo8",		"d,s,t",	0xf8000223,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.qb.vs.lo8",		"d,s,t",	0xf80002a3,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.qb.vv.sy",		"d,s,t",	0xf8000063,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.qb.vs.sy",		"d,s,t",	0xf80000e3,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.qb.vv.lo8.sy",	"d,s,t",	0xf8000263,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.qb.vs.lo8.sy",	"d,s,t",	0xf80002e3,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vacc.qb",				"d,s",		0xf800000a,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vacc.qb.sy",			"d,s",		0xf800004a,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vmac.qb.vv",			"d,s,t",	0xf800000b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.qb.vs",			"d,s,t",	0xf800008b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.qb.vv.lo8",		"d,s,t",	0xf800020b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.qb.vs.lo8",		"d,s,t",	0xf800028b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.qb.vv.sy",		"d,s,t",	0xf800004b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.qb.vs.sy",		"d,s,t",	0xf80000cb,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.qb.vv.lo8.sy",	"d,s,t",	0xf800024b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.qb.vs.lo8.sy",	"d,s,t",	0xf80002cb,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.qb.vv",			"d,s,t",	0xf8000024,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.qb.vs",			"d,s,t",	0xf80000a4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.qb.vv.lo8",		"d,s,t",	0xf8000224,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.qb.vs.lo8",		"d,s,t",	0xf80002a4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.qb.vv.sy",		"d,s,t",	0xf8000064,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.qb.vs.sy",		"d,s,t",	0xf80000e4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.qb.vv.lo8.sy",	"d,s,t",	0xf8000264,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.qb.vs.lo8.sy",	"d,s,t",	0xf80002e4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.qb.vv",			"d,s,t",	0xf8000025,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.qb.vs",			"d,s,t",	0xf80000a5,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.qb.vv.lo8",		"d,s,t",	0xf8000225,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.qb.vs.lo8",		"d,s,t",	0xf80002a5,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.qb.vv.sy",		"d,s,t",	0xf8000065,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.qb.vs.sy",		"d,s,t",	0xf80000e5,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.qb.vv.lo8.sy",	"d,s,t",	0xf8000265,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.qb.vs.lo8.sy",	"d,s,t",	0xf80002e5,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.qb.vv",			"d,s,t",	0xf8000026,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.qb.vs",			"d,s,t",	0xf80000a6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.qb.vv.lo8",		"d,s,t",	0xf8000226,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.qb.vs.lo8",		"d,s,t",	0xf80002a6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.qb.vv.sy",		"d,s,t",	0xf8000066,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.qb.vs.sy",		"d,s,t",	0xf80000e6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.qb.vv.lo8.sy",	"d,s,t",	0xf8000266,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.qb.vs.lo8.sy",	"d,s,t",	0xf80002e6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.qb.vv",			"d,s,t",	0xf8000027,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.qb.vs",			"d,s,t",	0xf80000a7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.qb.vv.lo8",		"d,s,t",	0xf8000227,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.qb.vs.lo8",		"d,s,t",	0xf80002a7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.qb.vv.sy",		"d,s,t",	0xf8000067,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.qb.vs.sy",		"d,s,t",	0xf80000e7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.qb.vv.lo8.sy",	"d,s,t",	0xf8000267,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.qb.vs.lo8.sy",	"d,s,t",	0xf80002e7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.qb.vv",			"d,s,t",	0xf8000004,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.qb.vs",			"d,s,t",	0xf8000084,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.qb.vv.lo8",		"d,s,t",	0xf8000204,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.qb.vs.lo8",		"d,s,t",	0xf8000284,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.qb.vv.sy",		"d,s,t",	0xf8000044,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.qb.vs.sy",		"d,s,t",	0xf80000c4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.qb.vv.lo8.sy",	"d,s,t",	0xf8000244,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.qb.vs.lo8.sy",	"d,s,t",	0xf80002c4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.qb.vv",			"d,s,t",	0xf8000006,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.qb.vs",			"d,s,t",	0xf8000086,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.qb.vv.lo8",		"d,s,t",	0xf8000206,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.qb.vs.lo8",		"d,s,t",	0xf8000286,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.qb.vv.sy",		"d,s,t",	0xf8000046,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.qb.vs.sy",		"d,s,t",	0xf80000c6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.qb.vv.lo8.sy",	"d,s,t",	0xf8000246,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.qb.vs.lo8.sy",	"d,s,t",	0xf80002c6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.qb.vv",			"d,s,t",	0xf8000007,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.qb.vs",			"d,s,t",	0xf8000087,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.qb.vv.lo8",		"d,s,t",	0xf8000207,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.qb.vs.lo8",		"d,s,t",	0xf8000287,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.qb.vv.sy",		"d,s,t",	0xf8000047,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.qb.vs.sy",		"d,s,t",	0xf80000c7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.qb.vv.lo8.sy",	"d,s,t",	0xf8000247,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.qb.vs.lo8.sy",	"d,s,t",	0xf80002c7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.qb.vv",			"d,s,t",	0xf8000000,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.qb.vs",			"d,s,t",	0xf8000080,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.qb.vv.lo8",		"d,s,t",	0xf8000200,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.qb.vs.lo8",		"d,s,t",	0xf8000280,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.qb.vv.sy",		"d,s,t",	0xf8000040,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.qb.vs.sy",		"d,s,t",	0xf80000c0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.qb.vv.lo8.sy",	"d,s,t",	0xf8000240,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.qb.vs.lo8.sy",	"d,s,t",	0xf80002c0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.qb.vv",			"d,s,t",	0xf8000002,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.qb.vs",			"d,s,t",	0xf8000082,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.qb.vv.lo8",		"d,s,t",	0xf8000202,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.qb.vs.lo8",		"d,s,t",	0xf8000282,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.qb.vv.sy",		"d,s,t",	0xf8000042,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.qb.vs.sy",		"d,s,t",	0xf80000c2,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.qb.vv.lo8.sy",	"d,s,t",	0xf8000242,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.qb.vs.lo8.sy",	"d,s,t",	0xf80002c2,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.f.vv",		"d,s,t",	0xf8000028,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.eq.vv",		"d,s,t",	0xf8000128,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.ge.vv",		"d,s,t",	0xf8000228,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.gt.vv",		"d,s,t",	0xf8000328,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.t.vv",		"d,s,t",	0xf8000428,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.ne.vv",		"d,s,t",	0xf8000528,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.lt.vv",		"d,s,t",	0xf8000628,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.le.vv",		"d,s,t",	0xf8000728,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.f.vs",		"d,s,t",	0xf80000a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.eq.vs",		"d,s,t",	0xf80001a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.ge.vs",		"d,s,t",	0xf80002a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.gt.vs",		"d,s,t",	0xf80003a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.t.vs",		"d,s,t",	0xf80004a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.ne.vs",		"d,s,t",	0xf80005a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.lt.vs",		"d,s,t",	0xf80006a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.le.vs",		"d,s,t",	0xf80007a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.f.vv.sy",		"d,s,t",	0xf8000068,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.eq.vv.sy",	"d,s,t",	0xf8000168,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.ge.vv.sy",	"d,s,t",	0xf8000268,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.gt.vv.sy",	"d,s,t",	0xf8000368,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.t.vv.sy",		"d,s,t",	0xf8000468,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.ne.vv.sy",	"d,s,t",	0xf8000568,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.lt.vv.sy",	"d,s,t",	0xf8000668,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.le.vv.sy",	"d,s,t",	0xf8000768,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.f.vs.sy",		"d,s,t",	0xf80000e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.eq.vs.sy",	"d,s,t",	0xf80001e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.ge.vs.sy",	"d,s,t",	0xf80002e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.gt.vs.sy",	"d,s,t",	0xf80003e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.t.vs.sy",		"d,s,t",	0xf80004e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.ne.vs.sy",	"d,s,t",	0xf80005e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.lt.vs.sy",	"d,s,t",	0xf80006e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.qb.le.vs.sy",	"d,s,t",	0xf80007e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.f.vv",		"d,s,t",	0xf800000c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.eq.vv",		"d,s,t",	0xf800010c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.ge.vv",		"d,s,t",	0xf800020c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.gt.vv",		"d,s,t",	0xf800030c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.t.vv",		"d,s,t",	0xf800040c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.ne.vv",		"d,s,t",	0xf800050c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.lt.vv",		"d,s,t",	0xf800060c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.le.vv",		"d,s,t",	0xf800070c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.f.vs",		"d,s,t",	0xf800008c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.eq.vs",		"d,s,t",	0xf800018c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.ge.vs",		"d,s,t",	0xf800028c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.gt.vs",		"d,s,t",	0xf800038c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.t.vs",		"d,s,t",	0xf800048c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.ne.vs",		"d,s,t",	0xf800058c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.lt.vs",		"d,s,t",	0xf800068c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.le.vs",		"d,s,t",	0xf800078c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.f.vv.sy",	"d,s,t",	0xf800004c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.eq.vv.sy",	"d,s,t",	0xf800014c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.ge.vv.sy",	"d,s,t",	0xf800024c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.gt.vv.sy",	"d,s,t",	0xf800034c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.t.vv.sy",	"d,s,t",	0xf800044c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.ne.vv.sy",	"d,s,t",	0xf800054c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.lt.vv.sy",	"d,s,t",	0xf800064c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.le.vv.sy",	"d,s,t",	0xf800074c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.f.vs.sy",	"d,s,t",	0xf80000cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.eq.vs.sy",	"d,s,t",	0xf80001cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.ge.vs.sy",	"d,s,t",	0xf80002cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.gt.vs.sy",	"d,s,t",	0xf80003cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.t.vs.sy",	"d,s,t",	0xf80004cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.ne.vs.sy",	"d,s,t",	0xf80005cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.lt.vs.sy",	"d,s,t",	0xf80006cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.qb.le.vs.sy",	"d,s,t",	0xf80007cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.f.vv",		"d,s,t",	0xf8000029,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.eq.vv",		"d,s,t",	0xf8000129,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.ge.vv",		"d,s,t",	0xf8000229,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.gt.vv",		"d,s,t",	0xf8000329,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.t.vv",		"d,s,t",	0xf8000429,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.ne.vv",		"d,s,t",	0xf8000529,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.lt.vv",		"d,s,t",	0xf8000629,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.le.vv",		"d,s,t",	0xf8000729,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.f.vs",		"d,s,t",	0xf80000a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.eq.vs",		"d,s,t",	0xf80001a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.ge.vs",		"d,s,t",	0xf80002a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.gt.vs",		"d,s,t",	0xf80003a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.t.vs",		"d,s,t",	0xf80004a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.ne.vs",		"d,s,t",	0xf80005a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.lt.vs",		"d,s,t",	0xf80006a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.le.vs",		"d,s,t",	0xf80007a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.f.vv.sy",	"d,s,t",	0xf8000069,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.eq.vv.sy",	"d,s,t",	0xf8000169,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.ge.vv.sy",	"d,s,t",	0xf8000269,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.gt.vv.sy",	"d,s,t",	0xf8000369,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.t.vv.sy",	"d,s,t",	0xf8000469,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.ne.vv.sy",	"d,s,t",	0xf8000569,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.lt.vv.sy",	"d,s,t",	0xf8000669,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.le.vv.sy",	"d,s,t",	0xf8000769,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.f.vs.sy",	"d,s,t",	0xf80000e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.eq.vs.sy",	"d,s,t",	0xf80001e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.ge.vs.sy",	"d,s,t",	0xf80002e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.gt.vs.sy",	"d,s,t",	0xf80003e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.t.vs.sy",	"d,s,t",	0xf80004e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.ne.vs.sy",	"d,s,t",	0xf80005e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.lt.vs.sy",	"d,s,t",	0xf80006e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.qb.le.vs.sy",	"d,s,t",	0xf80007e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.f.vv",		"d,s,t",	0xf800000d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.eq.vv",		"d,s,t",	0xf800010d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.ge.vv",		"d,s,t",	0xf800020d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.gt.vv",		"d,s,t",	0xf800030d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.t.vv",		"d,s,t",	0xf800040d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.ne.vv",		"d,s,t",	0xf800050d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.lt.vv",		"d,s,t",	0xf800060d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.le.vv",		"d,s,t",	0xf800070d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.f.vs",		"d,s,t",	0xf800008d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.eq.vs",		"d,s,t",	0xf800018d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.ge.vs",		"d,s,t",	0xf800028d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.gt.vs",		"d,s,t",	0xf800038d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.t.vs",		"d,s,t",	0xf800048d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.ne.vs",		"d,s,t",	0xf800058d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.lt.vs",		"d,s,t",	0xf800068d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.le.vs",		"d,s,t",	0xf800078d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.f.vv.sy",	"d,s,t",	0xf800004d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.eq.vv.sy",	"d,s,t",	0xf800014d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.ge.vv.sy",	"d,s,t",	0xf800024d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.gt.vv.sy",	"d,s,t",	0xf800034d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.t.vv.sy",	"d,s,t",	0xf800044d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.ne.vv.sy",	"d,s,t",	0xf800054d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.lt.vv.sy",	"d,s,t",	0xf800064d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.le.vv.sy",	"d,s,t",	0xf800074d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.f.vs.sy",	"d,s,t",	0xf80000cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.eq.vs.sy",	"d,s,t",	0xf80001cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.ge.vs.sy",	"d,s,t",	0xf80002cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.gt.vs.sy",	"d,s,t",	0xf80003cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.t.vs.sy",	"d,s,t",	0xf80004cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.ne.vs.sy",	"d,s,t",	0xf80005cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.lt.vs.sy",	"d,s,t",	0xf80006cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.qb.le.vs.sy",	"d,s,t",	0xf80007cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.f.vv",		"d,s,t",	0xf800002a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.eq.vv",		"d,s,t",	0xf800012a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.ge.vv",		"d,s,t",	0xf800022a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.gt.vv",		"d,s,t",	0xf800032a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.t.vv",		"d,s,t",	0xf800042a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.ne.vv",		"d,s,t",	0xf800052a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.lt.vv",		"d,s,t",	0xf800062a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.le.vv",		"d,s,t",	0xf800072a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.f.vs",		"d,s,t",	0xf80000aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.eq.vs",		"d,s,t",	0xf80001aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.ge.vs",		"d,s,t",	0xf80002aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.gt.vs",		"d,s,t",	0xf80003aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.t.vs",		"d,s,t",	0xf80004aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.ne.vs",		"d,s,t",	0xf80005aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.lt.vs",		"d,s,t",	0xf80006aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.le.vs",		"d,s,t",	0xf80007aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.f.vv.sy",	"d,s,t",	0xf800006a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.eq.vv.sy",	"d,s,t",	0xf800016a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.ge.vv.sy",	"d,s,t",	0xf800026a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.gt.vv.sy",	"d,s,t",	0xf800036a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.t.vv.sy",	"d,s,t",	0xf800046a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.ne.vv.sy",	"d,s,t",	0xf800056a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.lt.vv.sy",	"d,s,t",	0xf800066a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.le.vv.sy",	"d,s,t",	0xf800076a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.f.vs.sy",	"d,s,t",	0xf80000ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.eq.vs.sy",	"d,s,t",	0xf80001ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.ge.vs.sy",	"d,s,t",	0xf80002ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.gt.vs.sy",	"d,s,t",	0xf80003ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.t.vs.sy",	"d,s,t",	0xf80004ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.ne.vs.sy",	"d,s,t",	0xf80005ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.lt.vs.sy",	"d,s,t",	0xf80006ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.qb.le.vs.sy",	"d,s,t",	0xf80007ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.f.vv",		"d,s,t",	0xf800000e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.eq.vv",	"d,s,t",	0xf800010e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.ge.vv",	"d,s,t",	0xf800020e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.gt.vv",	"d,s,t",	0xf800030e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.t.vv",		"d,s,t",	0xf800040e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.ne.vv",	"d,s,t",	0xf800050e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.lt.vv",	"d,s,t",	0xf800060e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.le.vv",	"d,s,t",	0xf800070e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.f.vs",		"d,s,t",	0xf800008e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.eq.vs",	"d,s,t",	0xf800018e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.ge.vs",	"d,s,t",	0xf800028e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.gt.vs",	"d,s,t",	0xf800038e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.t.vs",		"d,s,t",	0xf800048e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.ne.vs",	"d,s,t",	0xf800058e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.lt.vs",	"d,s,t",	0xf800068e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.le.vs",	"d,s,t",	0xf800078e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.f.vv.sy",	"d,s,t",	0xf800004e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.eq.vv.sy",	"d,s,t",	0xf800014e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.ge.vv.sy",	"d,s,t",	0xf800024e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.gt.vv.sy",	"d,s,t",	0xf800034e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.t.vv.sy",	"d,s,t",	0xf800044e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.ne.vv.sy",	"d,s,t",	0xf800054e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.lt.vv.sy",	"d,s,t",	0xf800064e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.le.vv.sy",	"d,s,t",	0xf800074e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.f.vs.sy",	"d,s,t",	0xf80000ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.eq.vs.sy",	"d,s,t",	0xf80001ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.ge.vs.sy",	"d,s,t",	0xf80002ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.gt.vs.sy",	"d,s,t",	0xf80003ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.t.vs.sy",	"d,s,t",	0xf80004ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.ne.vs.sy",	"d,s,t",	0xf80005ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.lt.vs.sy",	"d,s,t",	0xf80006ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.qb.le.vs.sy",	"d,s,t",	0xf80007ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.f.vv",		"d,s,t",	0xf800002b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.eq.vv",	"d,s,t",	0xf800012b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.ge.vv",	"d,s,t",	0xf800022b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.gt.vv",	"d,s,t",	0xf800032b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.t.vv",		"d,s,t",	0xf800042b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.ne.vv",	"d,s,t",	0xf800052b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.lt.vv",	"d,s,t",	0xf800062b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.le.vv",	"d,s,t",	0xf800072b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.f.vs",		"d,s,t",	0xf80000ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.eq.vs",	"d,s,t",	0xf80001ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.ge.vs",	"d,s,t",	0xf80002ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.gt.vs",	"d,s,t",	0xf80003ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.t.vs",		"d,s,t",	0xf80004ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.ne.vs",	"d,s,t",	0xf80005ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.lt.vs",	"d,s,t",	0xf80006ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.le.vs",	"d,s,t",	0xf80007ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.f.vv.sy",	"d,s,t",	0xf800006b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.eq.vv.sy",	"d,s,t",	0xf800016b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.ge.vv.sy",	"d,s,t",	0xf800026b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.gt.vv.sy",	"d,s,t",	0xf800036b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.t.vv.sy",	"d,s,t",	0xf800046b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.ne.vv.sy",	"d,s,t",	0xf800056b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.lt.vv.sy",	"d,s,t",	0xf800066b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.le.vv.sy",	"d,s,t",	0xf800076b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.f.vs.sy",	"d,s,t",	0xf80000eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.eq.vs.sy",	"d,s,t",	0xf80001eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.ge.vs.sy",	"d,s,t",	0xf80002eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.gt.vs.sy",	"d,s,t",	0xf80003eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.t.vs.sy",	"d,s,t",	0xf80004eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.ne.vs.sy",	"d,s,t",	0xf80005eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.lt.vs.sy",	"d,s,t",	0xf80006eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.qb.le.vs.sy",	"d,s,t",	0xf80007eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.f.vv",	"d,s,t",	0xf800000f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.eq.vv",	"d,s,t",	0xf800010f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.ge.vv",	"d,s,t",	0xf800020f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.gt.vv",	"d,s,t",	0xf800030f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.t.vv",	"d,s,t",	0xf800040f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.ne.vv",	"d,s,t",	0xf800050f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.lt.vv",	"d,s,t",	0xf800060f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.le.vv",	"d,s,t",	0xf800070f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.f.vs",	"d,s,t",	0xf800008f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.eq.vs",	"d,s,t",	0xf800018f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.ge.vs",	"d,s,t",	0xf800028f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.gt.vs",	"d,s,t",	0xf800038f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.t.vs",	"d,s,t",	0xf800048f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.ne.vs",	"d,s,t",	0xf800058f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.lt.vs",	"d,s,t",	0xf800068f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.le.vs",	"d,s,t",	0xf800078f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.f.vv.sy",	"d,s,t",	0xf800004f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.eq.vv.sy","d,s,t",	0xf800014f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.ge.vv.sy","d,s,t",	0xf800024f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.gt.vv.sy","d,s,t",	0xf800034f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.t.vv.sy",	"d,s,t",	0xf800044f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.ne.vv.sy","d,s,t",	0xf800054f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.lt.vv.sy","d,s,t",	0xf800064f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.le.vv.sy","d,s,t",	0xf800074f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.f.vs.sy",	"d,s,t",	0xf80000cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.eq.vs.sy","d,s,t",	0xf80001cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.ge.vs.sy","d,s,t",	0xf80002cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.gt.vs.sy","d,s,t",	0xf80003cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.t.vs.sy",	"d,s,t",	0xf80004cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.ne.vs.sy","d,s,t",	0xf80005cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.lt.vs.sy","d,s,t",	0xf80006cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.qb.le.vs.sy","d,s,t",	0xf80007cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vadd.ph.vv",			"d,s,t",	0xd8000020,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ph.vs",			"d,s,t",	0xd80000a0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ph.vv.lo16",		"d,s,t",	0xd8000220,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ph.vs.lo16",		"d,s,t",	0xd80002a0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ph.vv.sy",		"d,s,t",	0xd8000060,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ph.vs.sy",		"d,s,t",	0xd80000e0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ph.vv.lo16.sy",	"d,s,t",	0xd8000260,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ph.vs.lo16.sy",	"d,s,t",	0xd80002e0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.vv",			"d,s,t",	0xd8000022, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.vs",			"d,s,t",	0xd80000a2, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.sv",			"d,s,t",	0xd8000122, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.vv.lo16",		"d,s,t",	0xd8000222, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.vs.lo16",		"d,s,t",	0xd80002a2, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.sv.lo16",		"d,s,t",	0xd8000322, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.vv.sy",		"d,s,t",	0xd8000062, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.vs.sy",		"d,s,t",	0xd80000e2, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.sv.sy",		"d,s,t",	0xd8000162, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.vv.lo16.sy",	"d,s,t",	0xd8000262, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.vs.lo16.sy",	"d,s,t",	0xd80002e2, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ph.sv.lo16.sy",	"d,s,t",	0xd8000362, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.ph.vv",			"d,s,t",	0xd8000018,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.ph.vs",			"d,s,t",	0xd8000098,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.ph.vv.lo16",	"d,s,t",	0xd8000218,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.ph.vs.lo16",	"d,s,t",	0xd8000298,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.ph.vv.sy",		"d,s,t",	0xd8000058,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.ph.vs.sy",		"d,s,t",	0xd80000d8,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.ph.vv.lo16.sy",	"d,s,t",	0xd8000258,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmult.ph.vs.lo16.sy",	"d,s,t",	0xd80002d8,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.ph.vv",		"d,s,t",	0xd8000019,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.ph.vs",		"d,s,t",	0xd8000099,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.ph.vv.lo16",	"d,s,t",	0xd8000219,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.ph.vs.lo16",	"d,s,t",	0xd8000299,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.ph.vv.sy",		"d,s,t",	0xd8000059,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.ph.vs.sy",		"d,s,t",	0xd80000d9,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.ph.vv.lo16.sy","d,s,t",	0xd8000259,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultu.ph.vs.lo16.sy","d,s,t",	0xd80002d9,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.ph.vv",		"d,s,t",	0xd8000010,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.ph.vs",		"d,s,t",	0xd8000090,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.ph.vv.lo16",	"d,s,t",	0xd8000210,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.ph.vs.lo16",	"d,s,t",	0xd8000290,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.ph.vv.sy",		"d,s,t",	0xd8000050,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.ph.vs.sy",		"d,s,t",	0xd80000d0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.ph.vv.lo16.sy","d,s,t",	0xd8000250,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmulth.ph.vs.lo16.sy","d,s,t",	0xd80002d0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.ph.vv",		"d,s,t",	0xd8000011,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.ph.vs",		"d,s,t",	0xd8000091,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.ph.vv.lo16",	"d,s,t",	0xd8000211,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.ph.vs.lo16",	"d,s,t",	0xd8000291,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.ph.vv.sy",	"d,s,t",	0xd8000051,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.ph.vs.sy",	"d,s,t",	0xd80000d1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.ph.vv.lo16.sy","d,s,t",	0xd8000251,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmultuh.ph.vs.lo16.sy","d,s,t",	0xd80002d1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ph.vv",			"d,s,t",	0xd8000021,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ph.vs",			"d,s,t",	0xd80000a1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ph.vv.lo16",	"d,s,t",	0xd8000221,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ph.vs.lo16",	"d,s,t",	0xd80002a1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ph.vv.sy",		"d,s,t",	0xd8000061,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ph.vs.sy",		"d,s,t",	0xd80000e1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ph.vv.lo16.sy",	"d,s,t",	0xd8000261,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ph.vs.lo16.sy",	"d,s,t",	0xd80002e1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ph.vv",			"d,s,t",	0xd8000023,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ph.vs",			"d,s,t",	0xd80000a3,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ph.vv.lo16",	"d,s,t",	0xd8000223,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ph.vs.lo16",	"d,s,t",	0xd80002a3,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ph.vv.sy",		"d,s,t",	0xd8000063,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ph.vs.sy",		"d,s,t",	0xd80000e3,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ph.vv.lo16.sy",	"d,s,t",	0xd8000263,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ph.vs.lo16.sy",	"d,s,t",	0xd80002e3,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vacc.ph",				"d,s",		0xd800000a,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vacc.ph.sy",			"d,s",		0xd800004a,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vmac.ph.vv",			"d,s,t",	0xd800000b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.ph.vs",			"d,s,t",	0xd800008b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.ph.vv.lo16",		"d,s,t",	0xd800020b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.ph.vs.lo16",		"d,s,t",	0xd800028b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.ph.vv.sy",		"d,s,t",	0xd800004b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.ph.vs.sy",		"d,s,t",	0xd80000cb,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.ph.vv.lo16.sy",	"d,s,t",	0xd800024b,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmac.ph.vs.lo16.sy",	"d,s,t",	0xd80002cb,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.ph.vv",			"d,s,t",	0xd8000024,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.ph.vs",			"d,s,t",	0xd80000a4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.ph.vv.lo16",		"d,s,t",	0xd8000224,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.ph.vs.lo16",		"d,s,t",	0xd80002a4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.ph.vv.sy",		"d,s,t",	0xd8000064,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.ph.vs.sy",		"d,s,t",	0xd80000e4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.ph.vv.lo16.sy",	"d,s,t",	0xd8000264,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vand.ph.vs.lo16.sy",	"d,s,t",	0xd80002e4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.ph.vv",			"d,s,t",	0xd8000025,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.ph.vs",			"d,s,t",	0xd80000a5,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.ph.vv.lo16",		"d,s,t",	0xd8000225,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.ph.vs.lo16",		"d,s,t",	0xd80002a5,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.ph.vv.sy",		"d,s,t",	0xd8000065,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.ph.vs.sy",		"d,s,t",	0xd80000e5,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.ph.vv.lo16.sy",	"d,s,t",	0xd8000265,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vor.ph.vs.lo16.sy",	"d,s,t",	0xd80002e5,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.ph.vv",			"d,s,t",	0xd8000026,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.ph.vs",			"d,s,t",	0xd80000a6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.ph.vv.lo16",		"d,s,t",	0xd8000226,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.ph.vs.lo16",		"d,s,t",	0xd80002a6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.ph.vv.sy",		"d,s,t",	0xd8000066,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.ph.vs.sy",		"d,s,t",	0xd80000e6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.ph.vv.lo16.sy",	"d,s,t",	0xd8000266,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vxor.ph.vs.lo16.sy",	"d,s,t",	0xd80002e6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.ph.vv",			"d,s,t",	0xd8000027,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.ph.vs",			"d,s,t",	0xd80000a7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.ph.vv.lo16",		"d,s,t",	0xd8000227,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.ph.vs.lo16",		"d,s,t",	0xd80002a7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.ph.vv.sy",		"d,s,t",	0xd8000067,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.ph.vs.sy",		"d,s,t",	0xd80000e7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.ph.vv.lo16.sy",	"d,s,t",	0xd8000267,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vnor.ph.vs.lo16.sy",	"d,s,t",	0xd80002e7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.ph.vv",			"d,s,t",	0xd8000004,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.ph.vs",			"d,s,t",	0xd8000084,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.ph.vv.lo16",	"d,s,t",	0xd8000204,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.ph.vs.lo16",	"d,s,t",	0xd8000284,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.ph.vv.sy",		"d,s,t",	0xd8000044,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.ph.vs.sy",		"d,s,t",	0xd80000c4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.ph.vv.lo16.sy",	"d,s,t",	0xd8000244,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsllv.ph.vs.lo16.sy",	"d,s,t",	0xd80002c4,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.ph.vv",			"d,s,t",	0xd8000006,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.ph.vs",			"d,s,t",	0xd8000086,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.ph.vv.lo16",	"d,s,t",	0xd8000206,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.ph.vs.lo16",	"d,s,t",	0xd8000286,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.ph.vv.sy",		"d,s,t",	0xd8000046,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.ph.vs.sy",		"d,s,t",	0xd80000c6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.ph.vv.lo16.sy",	"d,s,t",	0xd8000246,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrlv.ph.vs.lo16.sy",	"d,s,t",	0xd80002c6,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.ph.vv",			"d,s,t",	0xd8000007,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.ph.vs",			"d,s,t",	0xd8000087,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.ph.vv.lo16",	"d,s,t",	0xd8000207,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.ph.vs.lo16",	"d,s,t",	0xd8000287,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.ph.vv.sy",		"d,s,t",	0xd8000047,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.ph.vs.sy",		"d,s,t",	0xd80000c7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.ph.vv.lo16.sy",	"d,s,t",	0xd8000247,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsrav.ph.vs.lo16.sy",	"d,s,t",	0xd80002c7,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.ph.vv",			"d,s,t",	0xd8000000,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.ph.vs",			"d,s,t",	0xd8000080,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.ph.vv.lo16",	"d,s,t",	0xd8000200,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.ph.vs.lo16",	"d,s,t",	0xd8000280,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.ph.vv.sy",		"d,s,t",	0xd8000040,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.ph.vs.sy",		"d,s,t",	0xd80000c0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.ph.vv.lo16.sy",	"d,s,t",	0xd8000240,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtlv.ph.vs.lo16.sy",	"d,s,t",	0xd80002c0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.ph.vv",			"d,s,t",	0xd8000002,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.ph.vs",			"d,s,t",	0xd8000082,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.ph.vv.lo16",	"d,s,t",	0xd8000202,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.ph.vs.lo16",	"d,s,t",	0xd8000282,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.ph.vv.sy",		"d,s,t",	0xd8000042,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.ph.vs.sy",		"d,s,t",	0xd80000c2,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.ph.vv.lo16.sy",	"d,s,t",	0xd8000242,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vrtrv.ph.vs.lo16.sy",	"d,s,t",	0xd80002c2,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.f.vv",		"d,s,t",	0xd8000028,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.eq.vv",		"d,s,t",	0xd8000128,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.ge.vv",		"d,s,t",	0xd8000228,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.gt.vv",		"d,s,t",	0xd8000328,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.t.vv",		"d,s,t",	0xd8000428,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.ne.vv",		"d,s,t",	0xd8000528,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.lt.vv",		"d,s,t",	0xd8000628,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.le.vv",		"d,s,t",	0xd8000728,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.f.vs",		"d,s,t",	0xd80000a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.eq.vs",		"d,s,t",	0xd80001a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.ge.vs",		"d,s,t",	0xd80002a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.gt.vs",		"d,s,t",	0xd80003a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.t.vs",		"d,s,t",	0xd80004a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.ne.vs",		"d,s,t",	0xd80005a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.lt.vs",		"d,s,t",	0xd80006a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.le.vs",		"d,s,t",	0xd80007a8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.f.vv.sy",		"d,s,t",	0xd8000068,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.eq.vv.sy",	"d,s,t",	0xd8000168,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.ge.vv.sy",	"d,s,t",	0xd8000268,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.gt.vv.sy",	"d,s,t",	0xd8000368,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.t.vv.sy",		"d,s,t",	0xd8000468,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.ne.vv.sy",	"d,s,t",	0xd8000568,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.lt.vv.sy",	"d,s,t",	0xd8000668,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.le.vv.sy",	"d,s,t",	0xd8000768,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.f.vs.sy",		"d,s,t",	0xd80000e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.eq.vs.sy",	"d,s,t",	0xd80001e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.ge.vs.sy",	"d,s,t",	0xd80002e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.gt.vs.sy",	"d,s,t",	0xd80003e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.t.vs.sy",		"d,s,t",	0xd80004e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.ne.vs.sy",	"d,s,t",	0xd80005e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.lt.vs.sy",	"d,s,t",	0xd80006e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ph.le.vs.sy",	"d,s,t",	0xd80007e8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.f.vv",		"d,s,t",	0xd800000c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.eq.vv",		"d,s,t",	0xd800010c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.ge.vv",		"d,s,t",	0xd800020c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.gt.vv",		"d,s,t",	0xd800030c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.t.vv",		"d,s,t",	0xd800040c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.ne.vv",		"d,s,t",	0xd800050c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.lt.vv",		"d,s,t",	0xd800060c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.le.vv",		"d,s,t",	0xd800070c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.f.vs",		"d,s,t",	0xd800008c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.eq.vs",		"d,s,t",	0xd800018c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.ge.vs",		"d,s,t",	0xd800028c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.gt.vs",		"d,s,t",	0xd800038c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.t.vs",		"d,s,t",	0xd800048c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.ne.vs",		"d,s,t",	0xd800058c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.lt.vs",		"d,s,t",	0xd800068c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.le.vs",		"d,s,t",	0xd800078c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.f.vv.sy",	"d,s,t",	0xd800004c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.eq.vv.sy",	"d,s,t",	0xd800014c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.ge.vv.sy",	"d,s,t",	0xd800024c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.gt.vv.sy",	"d,s,t",	0xd800034c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.t.vv.sy",	"d,s,t",	0xd800044c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.ne.vv.sy",	"d,s,t",	0xd800054c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.lt.vv.sy",	"d,s,t",	0xd800064c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.le.vv.sy",	"d,s,t",	0xd800074c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.f.vs.sy",	"d,s,t",	0xd80000cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.eq.vs.sy",	"d,s,t",	0xd80001cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.ge.vs.sy",	"d,s,t",	0xd80002cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.gt.vs.sy",	"d,s,t",	0xd80003cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.t.vs.sy",	"d,s,t",	0xd80004cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.ne.vs.sy",	"d,s,t",	0xd80005cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.lt.vs.sy",	"d,s,t",	0xd80006cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ph.le.vs.sy",	"d,s,t",	0xd80007cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.f.vv",		"d,s,t",	0xd8000029,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.eq.vv",		"d,s,t",	0xd8000129,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.ge.vv",		"d,s,t",	0xd8000229,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.gt.vv",		"d,s,t",	0xd8000329,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.t.vv",		"d,s,t",	0xd8000429,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.ne.vv",		"d,s,t",	0xd8000529,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.lt.vv",		"d,s,t",	0xd8000629,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.le.vv",		"d,s,t",	0xd8000729,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.f.vs",		"d,s,t",	0xd80000a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.eq.vs",		"d,s,t",	0xd80001a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.ge.vs",		"d,s,t",	0xd80002a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.gt.vs",		"d,s,t",	0xd80003a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.t.vs",		"d,s,t",	0xd80004a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.ne.vs",		"d,s,t",	0xd80005a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.lt.vs",		"d,s,t",	0xd80006a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.le.vs",		"d,s,t",	0xd80007a9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.f.vv.sy",	"d,s,t",	0xd8000069,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.eq.vv.sy",	"d,s,t",	0xd8000169,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.ge.vv.sy",	"d,s,t",	0xd8000269,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.gt.vv.sy",	"d,s,t",	0xd8000369,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.t.vv.sy",	"d,s,t",	0xd8000469,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.ne.vv.sy",	"d,s,t",	0xd8000569,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.lt.vv.sy",	"d,s,t",	0xd8000669,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.le.vv.sy",	"d,s,t",	0xd8000769,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.f.vs.sy",	"d,s,t",	0xd80000e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.eq.vs.sy",	"d,s,t",	0xd80001e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.ge.vs.sy",	"d,s,t",	0xd80002e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.gt.vs.sy",	"d,s,t",	0xd80003e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.t.vs.sy",	"d,s,t",	0xd80004e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.ne.vs.sy",	"d,s,t",	0xd80005e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.lt.vs.sy",	"d,s,t",	0xd80006e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpu.ph.le.vs.sy",	"d,s,t",	0xd80007e9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.f.vv",		"d,s,t",	0xd800000d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.eq.vv",		"d,s,t",	0xd800010d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.ge.vv",		"d,s,t",	0xd800020d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.gt.vv",		"d,s,t",	0xd800030d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.t.vv",		"d,s,t",	0xd800040d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.ne.vv",		"d,s,t",	0xd800050d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.lt.vv",		"d,s,t",	0xd800060d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.le.vv",		"d,s,t",	0xd800070d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.f.vs",		"d,s,t",	0xd800008d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.eq.vs",		"d,s,t",	0xd800018d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.ge.vs",		"d,s,t",	0xd800028d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.gt.vs",		"d,s,t",	0xd800038d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.t.vs",		"d,s,t",	0xd800048d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.ne.vs",		"d,s,t",	0xd800058d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.lt.vs",		"d,s,t",	0xd800068d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.le.vs",		"d,s,t",	0xd800078d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.f.vv.sy",	"d,s,t",	0xd800004d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.eq.vv.sy",	"d,s,t",	0xd800014d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.ge.vv.sy",	"d,s,t",	0xd800024d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.gt.vv.sy",	"d,s,t",	0xd800034d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.t.vv.sy",	"d,s,t",	0xd800044d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.ne.vv.sy",	"d,s,t",	0xd800054d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.lt.vv.sy",	"d,s,t",	0xd800064d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.le.vv.sy",	"d,s,t",	0xd800074d,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.f.vs.sy",	"d,s,t",	0xd80000cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.eq.vs.sy",	"d,s,t",	0xd80001cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.ge.vs.sy",	"d,s,t",	0xd80002cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.gt.vs.sy",	"d,s,t",	0xd80003cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.t.vs.sy",	"d,s,t",	0xd80004cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.ne.vs.sy",	"d,s,t",	0xd80005cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.lt.vs.sy",	"d,s,t",	0xd80006cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpu.ph.le.vs.sy",	"d,s,t",	0xd80007cd,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.f.vv",		"d,s,t",	0xd800002a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.eq.vv",		"d,s,t",	0xd800012a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.ge.vv",		"d,s,t",	0xd800022a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.gt.vv",		"d,s,t",	0xd800032a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.t.vv",		"d,s,t",	0xd800042a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.ne.vv",		"d,s,t",	0xd800052a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.lt.vv",		"d,s,t",	0xd800062a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.le.vv",		"d,s,t",	0xd800072a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.f.vs",		"d,s,t",	0xd80000aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.eq.vs",		"d,s,t",	0xd80001aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.ge.vs",		"d,s,t",	0xd80002aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.gt.vs",		"d,s,t",	0xd80003aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.t.vs",		"d,s,t",	0xd80004aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.ne.vs",		"d,s,t",	0xd80005aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.lt.vs",		"d,s,t",	0xd80006aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.le.vs",		"d,s,t",	0xd80007aa,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.f.vv.sy",	"d,s,t",	0xd800006a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.eq.vv.sy",	"d,s,t",	0xd800016a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.ge.vv.sy",	"d,s,t",	0xd800026a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.gt.vv.sy",	"d,s,t",	0xd800036a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.t.vv.sy",	"d,s,t",	0xd800046a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.ne.vv.sy",	"d,s,t",	0xd800056a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.lt.vv.sy",	"d,s,t",	0xd800066a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.le.vv.sy",	"d,s,t",	0xd800076a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.f.vs.sy",	"d,s,t",	0xd80000ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.eq.vs.sy",	"d,s,t",	0xd80001ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.ge.vs.sy",	"d,s,t",	0xd80002ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.gt.vs.sy",	"d,s,t",	0xd80003ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.t.vs.sy",	"d,s,t",	0xd80004ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.ne.vs.sy",	"d,s,t",	0xd80005ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.lt.vs.sy",	"d,s,t",	0xd80006ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ph.le.vs.sy",	"d,s,t",	0xd80007ea,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.f.vv",		"d,s,t",	0xd800000e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.eq.vv",	"d,s,t",	0xd800010e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.ge.vv",	"d,s,t",	0xd800020e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.gt.vv",	"d,s,t",	0xd800030e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.t.vv",		"d,s,t",	0xd800040e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.ne.vv",	"d,s,t",	0xd800050e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.lt.vv",	"d,s,t",	0xd800060e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.le.vv",	"d,s,t",	0xd800070e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.f.vs",		"d,s,t",	0xd800008e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.eq.vs",	"d,s,t",	0xd800018e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.ge.vs",	"d,s,t",	0xd800028e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.gt.vs",	"d,s,t",	0xd800038e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.t.vs",		"d,s,t",	0xd800048e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.ne.vs",	"d,s,t",	0xd800058e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.lt.vs",	"d,s,t",	0xd800068e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.le.vs",	"d,s,t",	0xd800078e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.f.vv.sy",	"d,s,t",	0xd800004e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.eq.vv.sy",	"d,s,t",	0xd800014e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.ge.vv.sy",	"d,s,t",	0xd800024e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.gt.vv.sy",	"d,s,t",	0xd800034e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.t.vv.sy",	"d,s,t",	0xd800044e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.ne.vv.sy",	"d,s,t",	0xd800054e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.lt.vv.sy",	"d,s,t",	0xd800064e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.le.vv.sy",	"d,s,t",	0xd800074e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.f.vs.sy",	"d,s,t",	0xd80000ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.eq.vs.sy",	"d,s,t",	0xd80001ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.ge.vs.sy",	"d,s,t",	0xd80002ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.gt.vs.sy",	"d,s,t",	0xd80003ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.t.vs.sy",	"d,s,t",	0xd80004ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.ne.vs.sy",	"d,s,t",	0xd80005ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.lt.vs.sy",	"d,s,t",	0xd80006ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ph.le.vs.sy",	"d,s,t",	0xd80007ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.f.vv",		"d,s,t",	0xd800002b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.eq.vv",	"d,s,t",	0xd800012b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.ge.vv",	"d,s,t",	0xd800022b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.gt.vv",	"d,s,t",	0xd800032b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.t.vv",		"d,s,t",	0xd800042b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.ne.vv",	"d,s,t",	0xd800052b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.lt.vv",	"d,s,t",	0xd800062b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.le.vv",	"d,s,t",	0xd800072b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.f.vs",		"d,s,t",	0xd80000ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.eq.vs",	"d,s,t",	0xd80001ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.ge.vs",	"d,s,t",	0xd80002ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.gt.vs",	"d,s,t",	0xd80003ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.t.vs",		"d,s,t",	0xd80004ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.ne.vs",	"d,s,t",	0xd80005ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.lt.vs",	"d,s,t",	0xd80006ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.le.vs",	"d,s,t",	0xd80007ab,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.f.vv.sy",	"d,s,t",	0xd800006b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.eq.vv.sy",	"d,s,t",	0xd800016b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.ge.vv.sy",	"d,s,t",	0xd800026b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.gt.vv.sy",	"d,s,t",	0xd800036b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.t.vv.sy",	"d,s,t",	0xd800046b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.ne.vv.sy",	"d,s,t",	0xd800056b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.lt.vv.sy",	"d,s,t",	0xd800066b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.le.vv.sy",	"d,s,t",	0xd800076b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.f.vs.sy",	"d,s,t",	0xd80000eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.eq.vs.sy",	"d,s,t",	0xd80001eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.ge.vs.sy",	"d,s,t",	0xd80002eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.gt.vs.sy",	"d,s,t",	0xd80003eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.t.vs.sy",	"d,s,t",	0xd80004eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.ne.vs.sy",	"d,s,t",	0xd80005eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.lt.vs.sy",	"d,s,t",	0xd80006eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmputs.ph.le.vs.sy",	"d,s,t",	0xd80007eb,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.f.vv",	"d,s,t",	0xd800000f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.eq.vv",	"d,s,t",	0xd800010f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.ge.vv",	"d,s,t",	0xd800020f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.gt.vv",	"d,s,t",	0xd800030f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.t.vv",	"d,s,t",	0xd800040f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.ne.vv",	"d,s,t",	0xd800050f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.lt.vv",	"d,s,t",	0xd800060f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.le.vv",	"d,s,t",	0xd800070f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.f.vs",	"d,s,t",	0xd800008f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.eq.vs",	"d,s,t",	0xd800018f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.ge.vs",	"d,s,t",	0xd800028f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.gt.vs",	"d,s,t",	0xd800038f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.t.vs",	"d,s,t",	0xd800048f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.ne.vs",	"d,s,t",	0xd800058f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.lt.vs",	"d,s,t",	0xd800068f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.le.vs",	"d,s,t",	0xd800078f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.f.vv.sy",	"d,s,t",	0xd800004f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.eq.vv.sy","d,s,t",	0xd800014f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.ge.vv.sy","d,s,t",	0xd800024f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.gt.vv.sy","d,s,t",	0xd800034f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.t.vv.sy",	"d,s,t",	0xd800044f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.ne.vv.sy","d,s,t",	0xd800054f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.lt.vv.sy","d,s,t",	0xd800064f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.le.vv.sy","d,s,t",	0xd800074f,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.f.vs.sy",	"d,s,t",	0xd80000cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.eq.vs.sy","d,s,t",	0xd80001cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.ge.vs.sy","d,s,t",	0xd80002cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.gt.vs.sy","d,s,t",	0xd80003cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.t.vs.sy",	"d,s,t",	0xd80004cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.ne.vs.sy","d,s,t",	0xd80005cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.lt.vs.sy","d,s,t",	0xd80006cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmputs.ph.le.vs.sy","d,s,t",	0xd80007cf,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vadd.s.vv",			"d,s,t",	0x7c000000,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.s.vs",			"d,s,t",	0x7c000080,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.s.vv.sy",		"d,s,t",	0x7c000040,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.s.vs.sy",		"d,s,t",	0x7c0000c0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.d.vv",			"d,s,t",	0x7c000008,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.d.vs",			"d,s,t",	0x7c000088,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.d.vv.sy",		"d,s,t",	0x7c000048,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.d.vs.sy",		"d,s,t",	0x7c0000c8,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.s.vv",			"d,s,t",	0x7c000001, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.s.vs",			"d,s,t",	0x7c000081, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.s.sv",			"d,s,t",	0x7c000101, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.s.vv.sy",		"d,s,t",	0x7c000041, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.s.vs.sy",		"d,s,t",	0x7c0000c1, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.s.sv.sy",		"d,s,t",	0x7c000141, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.d.vv",			"d,s,t",	0x7c000009, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.d.vs",			"d,s,t",	0x7c000089, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.d.sv",			"d,s,t",	0x7c000109, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.d.vv.sy",		"d,s,t",	0x7c000049, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.d.vs.sy",		"d,s,t",	0x7c0000c9, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.d.sv.sy",		"d,s,t",	0x7c000149, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.s.vv",			"d,s,t",	0x7c000002,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.s.vs",			"d,s,t",	0x7c000082,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.s.vv.sy",		"d,s,t",	0x7c000042,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.s.vs.sy",		"d,s,t",	0x7c0000c2,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.d.vv",			"d,s,t",	0x7c00000a,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.d.vs",			"d,s,t",	0x7c00008a,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.d.vv.sy",		"d,s,t",	0x7c00004a,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.d.vs.sy",		"d,s,t",	0x7c0000ca,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.s.vv",			"d,s,t",	0x7c000003, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.s.vs",			"d,s,t",	0x7c000083, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.s.sv",			"d,s,t",	0x7c000103, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.s.vv.sy",		"d,s,t",	0x7c000043, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.s.vs.sy",		"d,s,t",	0x7c0000c3, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.s.sv.sy",		"d,s,t",	0x7c000143, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.d.vv",			"d,s,t",	0x7c00000b, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.d.vs",			"d,s,t",	0x7c00008b, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.d.sv",			"d,s,t",	0x7c00010b, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.d.vv.sy",		"d,s,t",	0x7c00004b, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.d.vs.sy",		"d,s,t",	0x7c0000cb, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vdiv.d.sv.sy",		"d,s,t",	0x7c00014b, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vabs.s",				"d,s",		0x7c000005,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vabs.s.sy",			"d,s",		0x7c000045,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vabs.d",				"d,s",		0x7c00000d,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vabs.d.sy",			"d,s",		0x7c00004d,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vmov.s",				"d,s",		0x7c000006,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vmov.s.sy",			"d,s",		0x7c000046,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vmov.d",				"d,s",		0x7c00000e,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vmov.d.sy",			"d,s",		0x7c00004e,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vneg.s",				"d,s",		0x7c000007,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vneg.s.sy",			"d,s",		0x7c000047,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vneg.d",				"d,s",		0x7c00000f,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vneg.d.sy",			"d,s",		0x7c00004f,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vmadd.s.vv",			"d,s,t",	0x7c000010,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd.s.vs",			"d,s,t",	0x7c000090,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd.s.vv.sy",		"d,s,t",	0x7c000050,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd.s.vs.sy",		"d,s,t",	0x7c0000d0,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd.d.vv",			"d,s,t",	0x7c000018,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd.d.vs",			"d,s,t",	0x7c000098,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd.d.vv.sy",		"d,s,t",	0x7c000058,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmadd.d.vs.sy",		"d,s,t",	0x7c0000d8,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.s.vv",			"d,s,t",	0x7c000011,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.s.vs",			"d,s,t",	0x7c000091,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.s.vv.sy",		"d,s,t",	0x7c000051,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.s.vs.sy",		"d,s,t",	0x7c0000d1,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.d.vv",			"d,s,t",	0x7c000019,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.d.vs",			"d,s,t",	0x7c000099,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.d.vv.sy",		"d,s,t",	0x7c000059,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vmsub.d.vs.sy",		"d,s,t",	0x7c0000d9,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.f.vv",			"d,s,t",	0x7c000012,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.eq.vv",		"d,s,t",	0x7c000112,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.ge.vv",		"d,s,t",	0x7c000212,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.gt.vv",		"d,s,t",	0x7c000312,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.t.vv",			"d,s,t",	0x7c000412,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.ne.vv",		"d,s,t",	0x7c000512,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.lt.vv",		"d,s,t",	0x7c000612,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.le.vv",		"d,s,t",	0x7c000712,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.f.vs",			"d,s,t",	0x7c000092,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.eq.vs",		"d,s,t",	0x7c000192,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.ge.vs",		"d,s,t",	0x7c000292,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.gt.vs",		"d,s,t",	0x7c000392,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.t.vs",			"d,s,t",	0x7c000492,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.ne.vs",		"d,s,t",	0x7c000592,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.lt.vs",		"d,s,t",	0x7c000692,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.le.vs",		"d,s,t",	0x7c000792,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.f.vv.sy",		"d,s,t",	0x7c000052,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.eq.vv.sy",		"d,s,t",	0x7c000152,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.ge.vv.sy",		"d,s,t",	0x7c000252,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.gt.vv.sy",		"d,s,t",	0x7c000352,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.t.vv.sy",		"d,s,t",	0x7c000452,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.ne.vv.sy",		"d,s,t",	0x7c000552,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.lt.vv.sy",		"d,s,t",	0x7c000652,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.le.vv.sy",		"d,s,t",	0x7c000752,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.f.vs.sy",		"d,s,t",	0x7c0000d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.eq.vs.sy",		"d,s,t",	0x7c0001d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.ge.vs.sy",		"d,s,t",	0x7c0002d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.gt.vs.sy",		"d,s,t",	0x7c0003d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.t.vs.sy",		"d,s,t",	0x7c0004d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.ne.vs.sy",		"d,s,t",	0x7c0005d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.lt.vs.sy",		"d,s,t",	0x7c0006d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.s.le.vs.sy",		"d,s,t",	0x7c0007d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.f.vv",			"d,s,t",	0x7c00001a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.eq.vv",		"d,s,t",	0x7c00011a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.ge.vv",		"d,s,t",	0x7c00021a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.gt.vv",		"d,s,t",	0x7c00031a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.t.vv",			"d,s,t",	0x7c00041a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.ne.vv",		"d,s,t",	0x7c00051a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.lt.vv",		"d,s,t",	0x7c00061a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.le.vv",		"d,s,t",	0x7c00071a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.f.vs",			"d,s,t",	0x7c00009a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.eq.vs",		"d,s,t",	0x7c00019a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.ge.vs",		"d,s,t",	0x7c00029a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.gt.vs",		"d,s,t",	0x7c00039a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.t.vs",			"d,s,t",	0x7c00049a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.ne.vs",		"d,s,t",	0x7c00059a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.lt.vs",		"d,s,t",	0x7c00069a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.le.vs",		"d,s,t",	0x7c00079a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.f.vv.sy",		"d,s,t",	0x7c00005a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.eq.vv.sy",		"d,s,t",	0x7c00015a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.ge.vv.sy",		"d,s,t",	0x7c00025a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.gt.vv.sy",		"d,s,t",	0x7c00035a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.t.vv.sy",		"d,s,t",	0x7c00045a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.ne.vv.sy",		"d,s,t",	0x7c00055a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.lt.vv.sy",		"d,s,t",	0x7c00065a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.le.vv.sy",		"d,s,t",	0x7c00075a,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.f.vs.sy",		"d,s,t",	0x7c0000da,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.eq.vs.sy",		"d,s,t",	0x7c0001da,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.ge.vs.sy",		"d,s,t",	0x7c0002da,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.gt.vs.sy",		"d,s,t",	0x7c0003da,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.t.vs.sy",		"d,s,t",	0x7c0004da,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.ne.vs.sy",		"d,s,t",	0x7c0005da,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.lt.vs.sy",		"d,s,t",	0x7c0006da,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.d.le.vs.sy",		"d,s,t",	0x7c0007da,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.f.vv",		"d,s,t",	0x7c000013,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.eq.vv",		"d,s,t",	0x7c000113,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.ge.vv",		"d,s,t",	0x7c000213,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.gt.vv",		"d,s,t",	0x7c000313,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.t.vv",		"d,s,t",	0x7c000413,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.ne.vv",		"d,s,t",	0x7c000513,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.lt.vv",		"d,s,t",	0x7c000613,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.le.vv",		"d,s,t",	0x7c000713,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.f.vs",		"d,s,t",	0x7c000093,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.eq.vs",		"d,s,t",	0x7c000193,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.ge.vs",		"d,s,t",	0x7c000293,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.gt.vs",		"d,s,t",	0x7c000393,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.t.vs",		"d,s,t",	0x7c000493,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.ne.vs",		"d,s,t",	0x7c000593,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.lt.vs",		"d,s,t",	0x7c000693,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.le.vs",		"d,s,t",	0x7c000793,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.f.vv.sy",	"d,s,t",	0x7c000053,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.eq.vv.sy",	"d,s,t",	0x7c000153,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.ge.vv.sy",	"d,s,t",	0x7c000253,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.gt.vv.sy",	"d,s,t",	0x7c000353,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.t.vv.sy",	"d,s,t",	0x7c000453,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.ne.vv.sy",	"d,s,t",	0x7c000553,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.lt.vv.sy",	"d,s,t",	0x7c000653,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.le.vv.sy",	"d,s,t",	0x7c000753,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.f.vs.sy",	"d,s,t",	0x7c0000d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.eq.vs.sy",	"d,s,t",	0x7c0001d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.ge.vs.sy",	"d,s,t",	0x7c0002d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.gt.vs.sy",	"d,s,t",	0x7c0003d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.t.vs.sy",	"d,s,t",	0x7c0004d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.ne.vs.sy",	"d,s,t",	0x7c0005d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.lt.vs.sy",	"d,s,t",	0x7c0006d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.s.le.vs.sy",	"d,s,t",	0x7c0007d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.f.vv",		"d,s,t",	0x7c00001b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.eq.vv",		"d,s,t",	0x7c00011b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.ge.vv",		"d,s,t",	0x7c00021b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.gt.vv",		"d,s,t",	0x7c00031b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.t.vv",		"d,s,t",	0x7c00041b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.ne.vv",		"d,s,t",	0x7c00051b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.lt.vv",		"d,s,t",	0x7c00061b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.le.vv",		"d,s,t",	0x7c00071b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.f.vs",		"d,s,t",	0x7c00009b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.eq.vs",		"d,s,t",	0x7c00019b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.ge.vs",		"d,s,t",	0x7c00029b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.gt.vs",		"d,s,t",	0x7c00039b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.t.vs",		"d,s,t",	0x7c00049b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.ne.vs",		"d,s,t",	0x7c00059b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.lt.vs",		"d,s,t",	0x7c00069b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.le.vs",		"d,s,t",	0x7c00079b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.f.vv.sy",	"d,s,t",	0x7c00005b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.eq.vv.sy",	"d,s,t",	0x7c00015b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.ge.vv.sy",	"d,s,t",	0x7c00025b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.gt.vv.sy",	"d,s,t",	0x7c00035b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.t.vv.sy",	"d,s,t",	0x7c00045b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.ne.vv.sy",	"d,s,t",	0x7c00055b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.lt.vv.sy",	"d,s,t",	0x7c00065b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.le.vv.sy",	"d,s,t",	0x7c00075b,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.f.vs.sy",	"d,s,t",	0x7c0000db,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.eq.vs.sy",	"d,s,t",	0x7c0001db,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.ge.vs.sy",	"d,s,t",	0x7c0002db,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.gt.vs.sy",	"d,s,t",	0x7c0003db,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.t.vs.sy",	"d,s,t",	0x7c0004db,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.ne.vs.sy",	"d,s,t",	0x7c0005db,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.lt.vs.sy",	"d,s,t",	0x7c0006db,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.d.le.vs.sy",	"d,s,t",	0x7c0007db,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcvt.s.d",			"d,s",		0x7c000028,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vcvt.s.d.sy",			"d,s",		0x7c000068,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vcvt.s.w",			"d,s",		0x7c000022,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vcvt.s.w.sy",			"d,s",		0x7c000062,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vcvt.d.s",			"d,s",		0x7c000021,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vcvt.d.s.sy",			"d,s",		0x7c000061,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vcvt.d.w",			"d,s",		0x7c00002a,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vcvt.d.w.sy",			"d,s",		0x7c00006a,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vcvt.w.s",			"d,s",		0x7c000024,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vcvt.w.s.sy",			"d,s",		0x7c000064,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vcvt.w.d",			"d,s",		0x7c00002c,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vcvt.w.d.sy",			"d,s",		0x7c00006c,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfmfc",				"d,s",		0x7c000030,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfmfc.sy",			"d,s",		0x7c000070,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfmtc",				"d,s",		0x7c000031,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfmtc.sy",			"d,s",		0x7c000071,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfmfs",				"d,s",		0x7c000032,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfmfs.sy",			"d,s",		0x7c000072,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfmts",				"d,s",		0x7c000033,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfmts.sy",			"d,s",		0x7c000073,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfmfv",				"d,s,t",	0x7c000034,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vfmfv.sy",			"d,s,t",	0x7c000074,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vfmtv",				"d,s,t",	0x7c000035,	0xfc1f07ff,	RD_s|RD_t|WR_d,	0, I1},
{"vfmtv.sy",			"d,s,t",	0x7c000075,	0xfc1f07ff,	RD_s|RD_t|WR_d,	0, I1},
	/* Dont we deal with mask register? (vfmtm.*) */
{"vfmtm",				"s",		0x7c00001e,	0xfc1fffff,	RD_s,			0, I1},
{"vfmtm.sy",			"s",		0x7c00005e,	0xfc1fffff,	RD_s,			0, I1},

{"vfrsv",				"d,s",		0x7c000036,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfrsv.sy",			"d,s",		0x7c000076,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfrls",				"d",		0x7c000037,	0xffff07ff,	WR_d,		0, I1},
{"vfrls.sy",			"d",		0x7c000077,	0xffff07ff,	WR_d,		0, I1},
{"vfdci",				"d,s",		0x7c00002e,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfdci.sy",			"d,s",		0x7c00006e,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vfeci",				"d,s,t,n",	0x7c00002f,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
/* Base register(b) is now replaced by source register s 
 * because compile error in gcc (vflw - vfsd.sy)
 */
{"vflw",				"t,b",		0x7c00003a,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"vflw.sy",				"t,b",		0x7c00007a,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"vfld",				"t,b",		0x7c00003b,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"vfld.sy",				"t,b",		0x7c00007b,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"vfsw",				"t,b",		0x7c00003e,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"vfsw.sy",				"t,b",		0x7c00007e,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"vfsd",				"t,b",		0x7c00003f,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"vfsd.sy",				"t,b",		0x7c00007f,	0xfc00ffff,	RD_b|WR_t,		0, I1},
{"vadd.ps.vv",			"d,s,t",	0xfc000000,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ps.vs",			"d,s,t",	0xfc000080,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ps.vv.lo32",		"d,s,t",	0xfc000200,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ps.vs.lo32",		"d,s,t",	0xfc000280,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ps.vv.sy",		"d,s,t",	0xfc000040,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ps.vs.sy",		"d,s,t",	0xfc0000c0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ps.vv.lo32.sy",	"d,s,t",	0xfc000240,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vadd.ps.vs.lo32.sy",	"d,s,t",	0xfc0002c0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.vv",			"d,s,t",	0xfc000001, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.vs",			"d,s,t",	0xfc000081, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.sv",			"d,s,t",	0xfc000101, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.vv.lo32",		"d,s,t",	0xfc000201, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.vs.lo32",		"d,s,t",	0xfc000281, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.sv.lo32",		"d,s,t",	0xfc000301, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.vv.sy",		"d,s,t",	0xfc000041, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.vs.sy",		"d,s,t",	0xfc0000c1, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.sv.sy",		"d,s,t",	0xfc000141, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.vv.lo32.sy",	"d,s,t",	0xfc000241, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.vs.lo32.sy",	"d,s,t",	0xfc0002c1, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vsub.ps.sv.lo32.sy",	"d,s,t",	0xfc000341, 0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.ps.vv",			"d,s,t",	0xfc000002,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.ps.vs",			"d,s,t",	0xfc000082,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.ps.vv.lo32",		"d,s,t",	0xfc000202,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.ps.vs.lo32",		"d,s,t",	0xfc000282,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.ps.vv.sy",		"d,s,t",	0xfc000042,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.ps.vs.sy",		"d,s,t",	0xfc0000c2,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.ps.vv.lo32.sy",	"d,s,t",	0xfc000242,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmul.ps.vs.lo32.sy",	"d,s,t",	0xfc0002c2,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vabs.ps",				"d,s",		0xfc000005,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vabs.ps.sy",			"d,s",		0xfc000045,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vneg.ps",				"d,s",		0xfc000007,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vneg.ps.sy",			"d,s",		0xfc000047,	0xfc1f07ff,	RD_s|WR_d,		0, I1},
{"vmadd.ps.vv",			"d,s,t",	0xfc000010,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ps.vs",			"d,s,t",	0xfc000090,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ps.vv.lo32",	"d,s,t",	0xfc000210,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ps.vs.lo32",	"d,s,t",	0xfc000290,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ps.vv.sy",		"d,s,t",	0xfc000050,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ps.vs.sy",		"d,s,t",	0xfc0000d0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ps.vv.lo32.sy",	"d,s,t",	0xfc000250,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmadd.ps.vs.lo32.sy",	"d,s,t",	0xfc0002d0,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ps.vv",			"d,s,t",	0xfc000011,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ps.vs",			"d,s,t",	0xfc000091,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ps.vv.lo32",	"d,s,t",	0xfc000211,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ps.vs.lo32",	"d,s,t",	0xfc000291,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ps.vv.sy",		"d,s,t",	0xfc000051,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ps.vs.sy",		"d,s,t",	0xfc0000d1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ps.vv.lo32.sy",	"d,s,t",	0xfc000251,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vmsub.ps.vs.lo32.sy",	"d,s,t",	0xfc0002d1,	0xfc0007ff,	RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.f.vv",		"d,s,t",	0xfc000012,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.eq.vv",		"d,s,t",	0xfc000112,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.ge.vv",		"d,s,t",	0xfc000212,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.gt.vv",		"d,s,t",	0xfc000312,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.t.vv",		"d,s,t",	0xfc000412,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.ne.vv",		"d,s,t",	0xfc000512,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.lt.vv",		"d,s,t",	0xfc000612,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.le.vv",		"d,s,t",	0xfc000712,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.f.vs",		"d,s,t",	0xfc000092,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.eq.vs",		"d,s,t",	0xfc000192,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.ge.vs",		"d,s,t",	0xfc000292,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.gt.vs",		"d,s,t",	0xfc000392,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.t.vs",		"d,s,t",	0xfc000492,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.ne.vs",		"d,s,t",	0xfc000592,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.lt.vs",		"d,s,t",	0xfc000692,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.le.vs",		"d,s,t",	0xfc000792,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.f.vv.sy",		"d,s,t",	0xfc000052,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.eq.vv.sy",	"d,s,t",	0xfc000152,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.ge.vv.sy",	"d,s,t",	0xfc000252,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.gt.vv.sy",	"d,s,t",	0xfc000352,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.t.vv.sy",		"d,s,t",	0xfc000452,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.ne.vv.sy",	"d,s,t",	0xfc000552,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.lt.vv.sy",	"d,s,t",	0xfc000652,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.le.vv.sy",	"d,s,t",	0xfc000752,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.f.vs.sy",		"d,s,t",	0xfc0000d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.eq.vs.sy",	"d,s,t",	0xfc0001d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.ge.vs.sy",	"d,s,t",	0xfc0002d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.gt.vs.sy",	"d,s,t",	0xfc0003d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.t.vs.sy",		"d,s,t",	0xfc0004d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.ne.vs.sy",	"d,s,t",	0xfc0005d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.lt.vs.sy",	"d,s,t",	0xfc0006d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmp.ps.le.vs.sy",	"d,s,t",	0xfc0007d2,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.f.vv",		"d,s,t",	0xfc00000c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.eq.vv",		"d,s,t",	0xfc00010c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.ge.vv",		"d,s,t",	0xfc00020c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.gt.vv",		"d,s,t",	0xfc00030c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.t.vv",		"d,s,t",	0xfc00040c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.ne.vv",		"d,s,t",	0xfc00050c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.lt.vv",		"d,s,t",	0xfc00060c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.le.vv",		"d,s,t",	0xfc00070c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.f.vs",		"d,s,t",	0xfc00008c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.eq.vs",		"d,s,t",	0xfc00018c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.ge.vs",		"d,s,t",	0xfc00028c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.gt.vs",		"d,s,t",	0xfc00038c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.t.vs",		"d,s,t",	0xfc00048c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.ne.vs",		"d,s,t",	0xfc00058c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.lt.vs",		"d,s,t",	0xfc00068c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.le.vs",		"d,s,t",	0xfc00078c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.f.vv.sy",	"d,s,t",	0xfc00004c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.eq.vv.sy",	"d,s,t",	0xfc00014c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.ge.vv.sy",	"d,s,t",	0xfc00024c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.gt.vv.sy",	"d,s,t",	0xfc00034c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.t.vv.sy",	"d,s,t",	0xfc00044c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.ne.vv.sy",	"d,s,t",	0xfc00054c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.lt.vv.sy",	"d,s,t",	0xfc00064c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.le.vv.sy",	"d,s,t",	0xfc00074c,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.f.vs.sy",	"d,s,t",	0xfc0000cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.eq.vs.sy",	"d,s,t",	0xfc0001cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.ge.vs.sy",	"d,s,t",	0xfc0002cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.gt.vs.sy",	"d,s,t",	0xfc0003cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.t.vs.sy",	"d,s,t",	0xfc0004cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.ne.vs.sy",	"d,s,t",	0xfc0005cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.lt.vs.sy",	"d,s,t",	0xfc0006cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmp.ps.le.vs.sy",	"d,s,t",	0xfc0007cc,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.f.vv",		"d,s,t",	0xfc000013,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.eq.vv",		"d,s,t",	0xfc000113,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.ge.vv",		"d,s,t",	0xfc000213,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.gt.vv",		"d,s,t",	0xfc000313,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.t.vv",		"d,s,t",	0xfc000413,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.ne.vv",		"d,s,t",	0xfc000513,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.lt.vv",		"d,s,t",	0xfc000613,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.le.vv",		"d,s,t",	0xfc000713,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.f.vs",		"d,s,t",	0xfc000093,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.eq.vs",		"d,s,t",	0xfc000193,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.ge.vs",		"d,s,t",	0xfc000293,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.gt.vs",		"d,s,t",	0xfc000393,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.t.vs",		"d,s,t",	0xfc000493,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.ne.vs",		"d,s,t",	0xfc000593,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.lt.vs",		"d,s,t",	0xfc000693,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.le.vs",		"d,s,t",	0xfc000793,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.f.vv.sy",	"d,s,t",	0xfc000053,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.eq.vv.sy",	"d,s,t",	0xfc000153,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.ge.vv.sy",	"d,s,t",	0xfc000253,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.gt.vv.sy",	"d,s,t",	0xfc000353,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.t.vv.sy",	"d,s,t",	0xfc000453,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.ne.vv.sy",	"d,s,t",	0xfc000553,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.lt.vv.sy",	"d,s,t",	0xfc000653,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.le.vv.sy",	"d,s,t",	0xfc000753,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.f.vs.sy",	"d,s,t",	0xfc0000d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.eq.vs.sy",	"d,s,t",	0xfc0001d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.ge.vs.sy",	"d,s,t",	0xfc0002d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.gt.vs.sy",	"d,s,t",	0xfc0003d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.t.vs.sy",	"d,s,t",	0xfc0004d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.ne.vs.sy",	"d,s,t",	0xfc0005d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.lt.vs.sy",	"d,s,t",	0xfc0006d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vcmpts.ps.le.vs.sy",	"d,s,t",	0xfc0007d3,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.f.vv",		"d,s,t",	0xfc00000e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.eq.vv",	"d,s,t",	0xfc00010e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.ge.vv",	"d,s,t",	0xfc00020e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.gt.vv",	"d,s,t",	0xfc00030e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.t.vv",		"d,s,t",	0xfc00040e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.ne.vv",	"d,s,t",	0xfc00050e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.lt.vv",	"d,s,t",	0xfc00060e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.le.vv",	"d,s,t",	0xfc00070e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.f.vs",		"d,s,t",	0xfc00008e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.eq.vs",	"d,s,t",	0xfc00018e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.ge.vs",	"d,s,t",	0xfc00028e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.gt.vs",	"d,s,t",	0xfc00038e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.t.vs",		"d,s,t",	0xfc00048e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.ne.vs",	"d,s,t",	0xfc00058e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.lt.vs",	"d,s,t",	0xfc00068e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.le.vs",	"d,s,t",	0xfc00078e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.f.vv.sy",	"d,s,t",	0xfc00004e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.eq.vv.sy",	"d,s,t",	0xfc00014e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.ge.vv.sy",	"d,s,t",	0xfc00024e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.gt.vv.sy",	"d,s,t",	0xfc00034e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.t.vv.sy",	"d,s,t",	0xfc00044e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.ne.vv.sy",	"d,s,t",	0xfc00054e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.lt.vv.sy",	"d,s,t",	0xfc00064e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.le.vv.sy",	"d,s,t",	0xfc00074e,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.f.vs.sy",	"d,s,t",	0xfc0000ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.eq.vs.sy",	"d,s,t",	0xfc0001ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.ge.vs.sy",	"d,s,t",	0xfc0002ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.gt.vs.sy",	"d,s,t",	0xfc0003ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.t.vs.sy",	"d,s,t",	0xfc0004ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.ne.vs.sy",	"d,s,t",	0xfc0005ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.lt.vs.sy",	"d,s,t",	0xfc0006ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},
{"vscmpts.ps.le.vs.sy",	"d,s,t",	0xfc0007ce,	0xfc0007ff, RD_s|RD_t|WR_d,	0, I1},


/*****************************/ 
/* instructions same as MIPS */
/*****************************/

/* load/store instructions*/
{"lb",      "t,o(b)",	0x80000000, 0xfc000000,	LDD|RD_b|WR_t,	0, I1},
{"lb",      "t,A(b)",	0,    (int) M_LB_AB,	INSN_MACRO,		0, I1},
{"lbu",     "t,o(b)",	0x90000000, 0xfc000000,	LDD|RD_b|WR_t,	0, I1},
{"lbu",     "t,A(b)",	0,    (int) M_LBU_AB,	INSN_MACRO,		0, I1},
{"sb",      "t,o(b)",	0xa0000000, 0xfc000000,	SM|RD_t|RD_b,	0, I1},
{"sb",      "t,A(b)",	0,    (int) M_SB_AB,	INSN_MACRO,		0, I1},
{"lh",      "t,o(b)",	0x84000000, 0xfc000000,	LDD|RD_b|WR_t,	0, I1},
{"lh",      "t,A(b)",	0,    (int) M_LH_AB,	INSN_MACRO,		0, I1},
{"lhu",     "t,o(b)",	0x94000000, 0xfc000000,	LDD|RD_b|WR_t,	0, I1},
{"lhu",     "t,A(b)",	0,    (int) M_LHU_AB,	INSN_MACRO,		0, I1},
{"sh",      "t,o(b)",	0xa4000000, 0xfc000000,	SM|RD_t|RD_b,	0, I1},
{"sh",      "t,A(b)",	0,    (int) M_SH_AB,	INSN_MACRO,		0, I1},
{"lw",      "t,o(b)",	0x8c000000, 0xfc000000,	LDD|RD_b|WR_t,	0, I1},
{"lw",      "t,A(b)",	0,    (int) M_LW_AB,	INSN_MACRO,		0, I1},
{"sw",      "t,o(b)",	0xac000000, 0xfc000000,	SM|RD_t|RD_b,	0, I1},
{"sw",      "t,A(b)",	0,    (int) M_SW_AB,	INSN_MACRO,		0, I1},

{"lwl",     "t,o(b)",	0x88000000, 0xfc000000,	LDD|RD_b|WR_t,	0, I1},
{"lwl",     "t,A(b)",	0,    (int) M_LWL_AB,	INSN_MACRO,		0, I1},
{"lwr",     "t,o(b)",	0x98000000, 0xfc000000,	LDD|RD_b|WR_t,	0, I1},
{"lwr",     "t,A(b)",	0,    (int) M_LWR_AB,	INSN_MACRO,		0, I1},
{"swl",     "t,o(b)",	0xa8000000, 0xfc000000,	SM|RD_t|RD_b,	0, I1},
{"swl",     "t,A(b)",	0,    (int) M_SWL_AB,	INSN_MACRO,		0, I1},
{"swr",     "t,o(b)",	0xb8000000, 0xfc000000,	SM|RD_t|RD_b,	0, I1},
{"swr",     "t,A(b)",	0,    (int) M_SWR_AB,	INSN_MACRO,		0, I1},

{"ll",	    "t,o(b)",	0xc0000000, 0xfc000000, LDD|RD_b|WR_t,	0, I1},
{"ll",	    "t,A(b)",	0,    (int) M_LL_AB,	INSN_MACRO,		0, I1},
{"sc",	    "t,o(b)",	0xe0000000, 0xfc000000, SM|RD_t|WR_t|RD_b,	0, I1},
{"sc",	    "t,A(b)",	0,    (int) M_SC_AB,	INSN_MACRO,		0, I1},

{"lwc1",    "T,o(b)",	0xc4000000, 0xfc000000,	CLD|RD_b|WR_T|FP_S,	0, I1},
{"lwc1",    "E,o(b)",	0xc4000000, 0xfc000000,	CLD|RD_b|WR_T|FP_S,	0, I1},
{"lwc1",    "T,A(b)",	0,    (int) M_LWC1_AB,	INSN_MACRO,		0, I1},
{"lwc1",    "E,A(b)",	0,    (int) M_LWC1_AB,	INSN_MACRO,		0, I1},
{"swc1",    "T,o(b)",	0xe4000000, 0xfc000000,	SM|RD_T|RD_b|FP_S,	0, I1},
{"swc1",    "E,o(b)",	0xe4000000, 0xfc000000,	SM|RD_T|RD_b|FP_S,	0, I1},
{"swc1",    "T,A(b)",	0,    (int) M_SWC1_AB,	INSN_MACRO,		0, I1},
{"swc1",    "E,A(b)",	0,    (int) M_SWC1_AB,	INSN_MACRO,		0, I1},
{"ldc1",    "T,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0, I1},
{"ldc1",    "E,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0, I1},
{"ldc1",    "T,A(b)",	0,    (int) M_LDC1_AB,	INSN_MACRO,		0, I1},
{"ldc1",    "E,A(b)",	0,    (int) M_LDC1_AB,	INSN_MACRO,		0, I1},
{"sdc1",    "T,o(b)",	0xf4000000, 0xfc000000, SM|RD_T|RD_b|FP_D,	0, I1},
{"sdc1",    "E,o(b)",	0xf4000000, 0xfc000000, SM|RD_T|RD_b|FP_D,	0, I1},
{"sdc1",    "T,A(b)",	0,    (int) M_SDC1_AB,	INSN_MACRO,		0, I1},
{"sdc1",    "E,A(b)",	0,    (int) M_SDC1_AB,	INSN_MACRO,		0, I1},

/* logical instructions */
{"addi",    "t,r,j",	0x20000000, 0xfc000000,	WR_t|RD_s,		0, I1},
{"addiu",   "t,r,j",	0x24000000, 0xfc000000,	WR_t|RD_s,		0, I1},
{"slti",    "t,r,j",	0x28000000, 0xfc000000,	WR_t|RD_s,		0, I1},
{"sltiu",   "t,r,j",	0x2c000000, 0xfc000000,	WR_t|RD_s,		0, I1},
{"andi",    "t,r,i",	0x30000000, 0xfc000000,	WR_t|RD_s,		0, I1},
{"ori",     "t,r,i",	0x34000000, 0xfc000000,	WR_t|RD_s,		0, I1},
{"xori",    "t,r,i",	0x38000000, 0xfc000000,	WR_t|RD_s,		0, I1},
{"lui",     "t,u",		0x3c000000, 0xffe00000,	WR_t,			0, I1},

{"add",     "d,v,t",	0x00000020, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"add",     "t,r,I",	0,    (int) M_ADD_I,	INSN_MACRO,		0, I1},
{"addu",    "d,v,t",	0x00000021, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"addu",    "t,r,I",	0,    (int) M_ADDU_I,	INSN_MACRO,		0, I1},
{"sub",     "d,v,t",	0x00000022, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sub",     "d,v,I",	0,    (int) M_SUB_I,	INSN_MACRO,		0, I1},
{"subu",    "d,v,t",	0x00000023, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"subu",    "d,v,I",	0,    (int) M_SUBU_I,	INSN_MACRO,		0, I1},
{"slt",     "d,v,t",	0x0000002a, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"slt",     "d,v,I",	0,    (int) M_SLT_I,	INSN_MACRO,		0, I1},
{"sltu",    "d,v,t",	0x0000002b, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"sltu",    "d,v,I",	0,    (int) M_SLTU_I,	INSN_MACRO,		0, I1},
{"and",     "d,v,t",	0x00000024, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"and",     "t,r,I",	0,    (int) M_AND_I,	INSN_MACRO,		0, I1},
{"or",      "d,v,t",	0x00000025, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"or",      "t,r,I",	0,    (int) M_OR_I,	INSN_MACRO,			0, I1},
{"xor",     "d,v,t",	0x00000026, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"xor",     "t,r,I",	0,    (int) M_XOR_I,	INSN_MACRO,		0, I1},
{"nor",     "d,v,t",	0x00000027, 0xfc0007ff,	WR_d|RD_s|RD_t,	0, I1},
{"nor",     "t,r,I",	0,    (int) M_NOR_I,	INSN_MACRO,		0, I1},

{"sllv",    "d,t,s",	0x00000004, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},
{"sll",     "d,w,s",	0x00000004, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},/*sllv*/
{"sll",     "d,w,<",	0x00000000, 0xffe0003f,	WR_d|RD_t,		0, I1},
{"rmtnop",  "d,w,<",	0x03e00000, 0xffe0003f,	WR_d|RD_t,		0, I1},
{"srlv",    "d,t,s",	0x00000006, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},
{"srl",     "d,w,s",	0x00000006, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},/*srlv*/
{"srl",     "d,w,<",	0x00000002, 0xffe0003f,	WR_d|RD_t,		0, I1},
{"srav",    "d,t,s",	0x00000007, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},
{"sra",     "d,w,s",	0x00000007, 0xfc0007ff,	WR_d|RD_t|RD_s,	0, I1},/*srav*/
{"sra",     "d,w,<",	0x00000003, 0xffe0003f,	WR_d|RD_t,		0, I1},

/* jump/branch instructions */
/*{"jr",		"s",	0,		(int) M_BUGJR,	INSN_MACRO,		0, I1},*/
{"jr",      "s",	0x00000008, 0xfc1fffff,	UBD|RD_s,		0, I1},
{"j",       "s",	0x00000008, 0xfc1fffff,	UBD|RD_s,		0, I1}, /* jr */
/* SVR4 PIC code requires special handling for j, so it must be a
   macro.  */
{"j",	    "a",	0,     (int) M_J_A,	INSN_MACRO,		0, I1},
/* This form of j is used by the disassembler and internally by the
   assembler, but will never match user input (because the line above
   will match first).  */
{"j",       "a",	0x08000000, 0xfc000000,	UBD,			0, I1},
{"jalr",    "s",	0x0000f809, 0xfc1fffff,	UBD|RD_s|WR_d,		0, I1},
{"jalr",    "d,s",	0x00000009, 0xfc1f07ff,	UBD|RD_s|WR_d,		0, I1},
/* SVR4 PIC code requires special handling for jal, so it must be a
   macro.  */
{"jal",     "d,s",	0,     (int) M_JAL_2,	INSN_MACRO,		0, I1},
{"jal",     "s",	0,     (int) M_JAL_1,	INSN_MACRO,		0, I1},
{"jal",     "a",	0,     (int) M_JAL_A,	INSN_MACRO,		0, I1},
/* This form of jal is used by the disassembler and internally by the
   assembler, but will never match user input (because the line above
   will match first).  */
{"jal",     "a",	0x0c000000, 0xfc000000,	UBD|WR_31,		0, I1},

//{"beq",     "s,t,p",	0,	  (int) M_BUGBEQ,	INSN_MACRO,		0, I1},
{"beq",     "s,t,p",	0x10000000, 0xfc000000,	CBD|RD_s|RD_t,	0, I1},
{"beq",     "s,I,p",	0,    (int) M_BEQ_I,	INSN_MACRO,		0, I1},
//{"bne",     "s,t,p",	0,	  (int) M_BUGBNE,	INSN_MACRO,		0, I1},
{"bne",     "s,t,p",	0x14000000, 0xfc000000,	CBD|RD_s|RD_t,	0, I1},
{"bne",     "s,I,p",	0,    (int) M_BNE_I,	INSN_MACRO,		0, I1},
//{"blez",    "s,p",		0,	  (int) M_BUGBLEZ,	INSN_MACRO,		0, I1},
{"blez",    "s,p",		0x18000000, 0xfc1f0000,	CBD|RD_s,		0, I1},
//{"bgtz",    "s,p",		0,	  (int) M_BUGBGTZ,	INSN_MACRO,		0, I1},
{"bgtz",    "s,p",		0x1c000000, 0xfc1f0000,	CBD|RD_s,		0, I1},
//{"beql",    "s,t,p",	0,	  (int) M_BUGBEQL,	INSN_MACRO,		0, I1},
{"beql",    "s,t,p",	0x50000000, 0xfc000000,	CBL|RD_s|RD_t,	0, I1},
{"beql",    "s,I,p",	0,    (int) M_BEQL_I,	INSN_MACRO,		0, I1},
//{"bnel",    "s,t,p",	0,	  (int) M_BUGBNEL,	INSN_MACRO,		0, I1},
{"bnel",    "s,t,p",	0x54000000, 0xfc000000,	CBL|RD_s|RD_t,	0, I1},
{"bnel",    "s,I,p",	0,    (int) M_BNEL_I,	INSN_MACRO,		0, I1},
//{"blezl",   "s,p",		0,	  (int) M_BUGBLEZL,	INSN_MACRO,		0, I1},
{"blezl",   "s,p",		0x58000000, 0xfc1f0000,	CBL|RD_s,		0, I1},
//{"bgtzl",   "s,p",		0,	  (int) M_BUGBGTZL,	INSN_MACRO,		0, I1},
{"bgtzl",   "s,p",		0x5c000000, 0xfc1f0000,	CBL|RD_s,		0, I1},

//{"bltz",    "s,p",	0,	  (int) M_BUGBLTZ,	INSN_MACRO,		0, I1},
{"bltz",    "s,p",	0x04000000, 0xfc1f0000,	CBD|RD_s,			0, I1},
//{"bgez",    "s,p",	0,	  (int) M_BUGBGEZ,	INSN_MACRO,		0, I1},
{"bgez",    "s,p",	0x04010000, 0xfc1f0000,	CBD|RD_s,			0, I1},
//{"bltzal",  "s,p",	0,	  (int) M_BUGBLTZAL,INSN_MACRO,		0, I1},
{"bltzal",  "s,p",	0x04100000, 0xfc1f0000,	CBD|RD_s|WR_31,		0, I1},
//{"bgezal",  "s,p",	0,	  (int) M_BUGBGEZAL,INSN_MACRO,		0, I1},
{"bgezal",  "s,p",	0x04110000, 0xfc1f0000,	CBD|RD_s|WR_31,		0, I1},
//{"bltzl",   "s,p",	0,	  (int) M_BUGBLTZL,	INSN_MACRO,		0, I1},
{"bltzl",   "s,p",	0x04020000, 0xfc1f0000,	CBL|RD_s,			0, I1},
//{"bgezl",   "s,p",	0,	  (int) M_BUGBGEZL,	INSN_MACRO,		0, I1},
{"bgezl",   "s,p",	0x04030000, 0xfc1f0000,	CBL|RD_s,			0, I1},
//{"bltzall", "s,p",	0,	  (int) M_BUGBLTZALL,INSN_MACRO,		0, I1},
{"bltzall", "s,p",	0x04120000, 0xfc1f0000,	CBL|RD_s|WR_31,		0, I1},
//{"bgezall", "s,p",	0,	  (int) M_BUGBGEZALL,INSN_MACRO,		0, I1},
{"bgezall", "s,p",	0x04130000, 0xfc1f0000,	CBL|RD_s|WR_31,		0, I1},

/* Macro or substituted by another insn*/
{"bleu",    "s,t,p",	0,    (int) M_BLEU,		INSN_MACRO,	0, I1},
{"bleu",    "s,I,p",	0,    (int) M_BLEU_I,	INSN_MACRO,	0, I1},
{"bgtu",    "s,t,p",	0,    (int) M_BGTU,		INSN_MACRO,	0, I1},
{"bgtu",    "s,I,p",	0,    (int) M_BGTU_I,	INSN_MACRO,	0, I1},
/*{"bnez",    "s,p",		0,	  (int) M_BUGBNEZ,	INSN_MACRO,		0, I1},*/
{"bnez",    "s,p",		0x14000000, 0xfc1f0000,	CBD|RD_s,	0, I1}, /* bne */
/*{"bnezl",   "s,p",		0,	  (int) M_BUGBNEZL,	INSN_MACRO,		0, I1},*/
{"bnezl",   "s,p",		0x54000000, 0xfc1f0000,	CBL|RD_s,	0, I1}, /* bnel */
/*{"beqz",    "s,p",		0,	  (int) M_BUGBEQZ,	INSN_MACRO,		0, I1},*/
{"beqz",    "s,p",		0x10000000, 0xfc1f0000,	CBD|RD_s,	0, I1}, /* beq */
/*{"beqzl",   "s,p",		0,	  (int) M_BUGBEQZL,	INSN_MACRO,		0, I1},*/
{"beqzl",   "s,p",		0x50000000, 0xfc1f0000,	CBL|RD_s,	0, I1}, /* beqzl */
{"bltu",    "s,t,p",	0,    (int) M_BLTU,		INSN_MACRO,	0, I1},
{"bltu",    "s,I,p",	0,    (int) M_BLTU_I,	INSN_MACRO,	0, I1},
{"ulh",     "t,o(b)",	0,    (int) M_ULH,		INSN_MACRO,	0, I1},
{"ulh",     "t,A(b)",	0,    (int) M_ULH_A,	INSN_MACRO,	0, I1},
{"ulhu",    "t,o(b)",	0,    (int) M_ULHU,		INSN_MACRO,	0, I1},
{"ulhu",    "t,A(b)",	0,    (int) M_ULHU_A,	INSN_MACRO,	0, I1},
{"ulw",     "t,o(b)",	0,    (int) M_ULW,		INSN_MACRO,	0, I1},
{"ulw",     "t,A(b)",	0,    (int) M_ULW_A,	INSN_MACRO,	0, I1},
{"ush",     "t,o(b)",	0,    (int) M_USH,		INSN_MACRO,	0, I1},
{"ush",     "t,A(b)",	0,    (int) M_USH_A,	INSN_MACRO,	0, I1},
{"usw",     "t,o(b)",	0,    (int) M_USW,		INSN_MACRO,	0, I1},
{"usw",     "t,A(b)",	0,    (int) M_USW_A,	INSN_MACRO,	0, I1},

/* floating-point instructions */
{"mtc1",    "t,S",	0x44800000, 0xffe007ff,	COD|RD_t|WR_S|FP_S,		0, I1},
{"mtc1",    "t,G",	0x44800000, 0xffe007ff,	COD|RD_t|WR_S|FP_S,		0, I1},
{"mfc1",    "t,S",	0x44000000, 0xffe007ff,	LCD|WR_t|RD_S|FP_S,		0, I1},
{"mfc1",    "t,G",	0x44000000, 0xffe007ff,	LCD|WR_t|RD_S|FP_S,		0, I1},
{"mtc1h",   "t,S",	0x44800040, 0xffe007ff,	COD|RD_t|WR_S|FP_S,		0, I1},
{"mtc1h",   "t,G",	0x44800040, 0xffe007ff,	COD|RD_t|WR_S|FP_S,		0, I1},
{"mfc1h",   "t,S",	0x44000040, 0xffe007ff,	LCD|WR_t|RD_S|FP_S,		0, I1},
{"mfc1h",   "t,G",	0x44000040, 0xffe007ff,	LCD|WR_t|RD_S|FP_S,		0, I1},

{"add.s",   "D,V,T",	0x46000000, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0, I1},
{"add.d",   "D,V,T",	0x46200000, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0, I1},
{"sub.d",   "D,V,T",	0x46200001, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0, I1},
{"sub.s",   "D,V,T",	0x46000001, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0, I1},
{"mul.d",   "D,V,T",	0x46200002, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0, I1},
{"mul.s",   "D,V,T",	0x46000002, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0, I1},
{"div.d",   "D,V,T",	0x46200003, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0, I1},
{"div.s",   "D,V,T",	0x46000003, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0, I1},
{"abs.s",   "D,V",		0x46000005, 0xffff003f,	WR_D|RD_S|FP_S,			0, I1},
{"abs.d",   "D,V",		0x46200005, 0xffff003f,	WR_D|RD_S|FP_D,			0, I1},
{"neg.d",   "D,V",		0x46200007, 0xffff003f,	WR_D|RD_S|FP_D,			0, I1},
{"neg.s",   "D,V",		0x46000007, 0xffff003f,	WR_D|RD_S|FP_S,			0, I1},

{"cvt.s.l", "D,S",	0x46a00020, 0xffff003f,	WR_D|RD_S|FP_S,			0, I1},
{"cvt.s.d", "D,S",	0x46200020, 0xffff003f,	WR_D|RD_S|FP_S|FP_D,	0, I1},
{"cvt.s.w", "D,S",	0x46800020, 0xffff003f,	WR_D|RD_S|FP_S,			0, I1},
{"cvt.d.l", "D,S",	0x46a00021, 0xffff003f,	WR_D|RD_S|FP_D,			0, I1},
{"cvt.d.s", "D,S",	0x46000021, 0xffff003f,	WR_D|RD_S|FP_D|FP_S,	0, I1},
{"cvt.d.w", "D,S",	0x46800021, 0xffff003f,	WR_D|RD_S|FP_D,			0, I1},
{"cvt.w.d", "D,S",	0x46200024, 0xffff003f,	WR_D|RD_S|FP_D,			0, I1},
{"cvt.w.s", "D,S",	0x46000024, 0xffff003f,	WR_D|RD_S|FP_S,			0, I1},

{"round.w.d", "D,S",	0x4620000c, 0xffff003f, WR_D|RD_S|FP_D,	0, I1},
{"round.w.s", "D,S",	0x4600000c, 0xffff003f, WR_D|RD_S|FP_S,	0, I1},
{"trunc.w.d", "D,S",	0x4620000d, 0xffff003f, WR_D|RD_S|FP_D,	0, I1},
{"trunc.w.d", "D,S,x",	0x4620000d, 0xffff003f, WR_D|RD_S|FP_D,	0, I1},
{"trunc.w.d", "D,S,t",	0,    (int) M_TRUNCWD,	INSN_MACRO,		0, I1},
{"trunc.w.s", "D,S",	0x4600000d, 0xffff003f,	WR_D|RD_S|FP_S,	0, I1},
{"trunc.w.s", "D,S,x",	0x4600000d, 0xffff003f,	WR_D|RD_S|FP_S,	0, I1},
{"trunc.w.s", "D,S,t",	0,    (int) M_TRUNCWS,	INSN_MACRO,		0, I1},
{"ceil.w.d", "D,S",		0x4620000e, 0xffff003f, WR_D|RD_S|FP_D,	0, I1},
{"ceil.w.s", "D,S",		0x4600000e, 0xffff003f, WR_D|RD_S|FP_S,	0, I1},
{"floor.w.d", "D,S",	0x4620000f, 0xffff003f, WR_D|RD_S|FP_D,	0, I1},
{"floor.w.s", "D,S",	0x4600000f, 0xffff003f, WR_D|RD_S|FP_S,	0, I1},

{"mov.d",   "D,S",	0x46200006, 0xffff003f,	WR_D|RD_S|FP_D,		0, I1},
{"mov.s",   "D,S",	0x46000006, 0xffff003f,	WR_D|RD_S|FP_S,		0, I1},

/* other instructions */
{"syscall", "",		0x0000000c, 0xffffffff,	TRAP,	0, I1},
{"syscall", "B",	0x0000000c, 0xfc00003f,	TRAP,	0, I1},
{"break",   "",		0x0000000d, 0xffffffff,	TRAP,	0, I1},
{"break",   "c",	0x0000000d, 0xfc00ffff,	TRAP,	0, I1},
{"break",   "c,q",	0x0000000d, 0xfc00003f,	TRAP,	0, I1},

{"tge",	    "s,t",		0x00000030, 0xfc00ffff,	RD_s|RD_t|TRAP,	0, I1},
{"tge",	    "s,t,q",	0x00000030, 0xfc00003f,	RD_s|RD_t|TRAP,	0, I1},
{"tgeu",    "s,t",		0x00000031, 0xfc00ffff, RD_s|RD_t|TRAP,	0, I1},
{"tgeu",    "s,t,q",	0x00000031, 0xfc00003f, RD_s|RD_t|TRAP,	0, I1},
{"tlt",     "s,t",		0x00000032, 0xfc00ffff, RD_s|RD_t|TRAP,	0, I1},
{"tlt",     "s,t,q",	0x00000032, 0xfc00003f, RD_s|RD_t|TRAP,	0, I1},
{"tltu",    "s,t",		0x00000033, 0xfc00ffff, RD_s|RD_t|TRAP,	0, I1},
{"tltu",    "s,t,q",	0x00000033, 0xfc00003f, RD_s|RD_t|TRAP,	0, I1},
{"teq",	    "s,t",		0x00000034, 0xfc00ffff, RD_s|RD_t|TRAP,	0, I1},
{"teq",	    "s,t,q",	0x00000034, 0xfc00003f, RD_s|RD_t|TRAP,	0, I1},
{"tne",     "s,t",		0x00000036, 0xfc00ffff, RD_s|RD_t|TRAP,	0, I1},
{"tne",     "s,t,q",	0x00000036, 0xfc00003f, RD_s|RD_t|TRAP,	0, I1},

{"tgei",    "s,j",	0x04080000, 0xfc1f0000, RD_s|TRAP,		0, I1},
{"tgeiu",   "s,j",	0x04090000, 0xfc1f0000, RD_s|TRAP,		0, I1},
{"tlti",    "s,j",	0x040a0000, 0xfc1f0000,	RD_s|TRAP,		0, I1},
{"tltiu",   "s,j",	0x040b0000, 0xfc1f0000, RD_s|TRAP,		0, I1},
{"teqi",    "s,j",	0x040c0000, 0xfc1f0000, RD_s|TRAP,		0, I1},
{"tnei",    "s,j",	0x040e0000, 0xfc1f0000, RD_s|TRAP,		0, I1},

{"nop",		"",		0x00000000, 0xffffffff, 0,	0, I1}, /* sll */

/* pseudo-like instructions */
{"li",      "t,j",	0x24000000, 0xffe00000, WR_t,		0, I1},/* addiu */
{"li",	    "t,i",	0x34000000, 0xffe00000, WR_t,		0, I1},/* ori */
{"li",      "t,I",	0,    (int) M_LI,	INSN_MACRO,		0, I1},
{"move",    "d,s",	0,    (int) M_MOVE,	INSN_MACRO,		0, I1},
{"move",    "d,s",	0x0000002d, 0xfc1f07ff, WR_d|RD_s,	0, I1},/* daddu */
{"move",    "d,s",	0x00000021, 0xfc1f07ff, WR_d|RD_s,	0, I1},/* addu */
{"move",    "d,s",	0x00000025, 0xfc1f07ff,	WR_d|RD_s,	0, I1},/* or */
{"b",       "p",	0x10000000, 0xffff0000,	UBD,		0, I1},/* beq 0,0 */
{"b",       "p",	0x04010000, 0xffff0000,	UBD,		0, I1},/* bgez 0 */
{"bal",     "p",	0x04110000, 0xffff0000,	UBD|WR_31,	0, I1},/* bgezal 0*/
{"dla",     "t,A(b)",	0,    (int) M_DLA_AB,	INSN_MACRO,	0, I1},
{"dli",     "t,j",      0x24000000, 0xffe00000, WR_t,		0, I1},/* addiu */
{"dli",	    "t,i",		0x34000000, 0xffe00000, WR_t,		0, I1},/* ori */
{"dli",     "t,I",		0,    (int) M_DLI,	INSN_MACRO,		0, I1},
{"la",		"t,A(b)",	0,    (int) M_LA_AB,	INSN_MACRO,		0, I1},
{"ld",		"t,o(b)",   0xdc000000, 0xfc000000, WR_t|RD_b,		0, I1},
{"ld",  	"t,o(b)",	0,    (int) M_LD_OB,	INSN_MACRO,		0, I1},
{"ld",  	"t,A(b)",	0,    (int) M_LD_AB,	INSN_MACRO,		0, I1},
{"l.d",	"T,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0, I1},/* ldc1 */
{"l.d", 	"T,o(b)",	0,    (int) M_L_DOB,	INSN_MACRO,		0, I1},
{"l.d", 	"T,A(b)",	0,    (int) M_L_DAB,	INSN_MACRO,		0, I1},
{"ldl",		"t,o(b)",	0x68000000, 0xfc000000, LDD|WR_t|RD_b,	0, I1},
{"ldl",		"t,A(b)",	0,    (int) M_LDL_AB,	INSN_MACRO,		0, I1},
{"ldr",		"t,o(b)",	0x6c000000, 0xfc000000, LDD|WR_t|RD_b,	0, I1},
{"ldr", 	"t,A(b)",	0,    (int) M_LDR_AB,	INSN_MACRO,		0, I1},
{"ldxc1",   "D,t(b)",	0x4c000001, 0xfc00f83f, LDD|WR_D|RD_t|RD_b,	0, I1},
{"li.d",    "t,F",		0,    (int) M_LI_D,	INSN_MACRO,			0, I1},
{"li.d",    "T,L",		0,    (int) M_LI_DD,	INSN_MACRO,		0, I1},
{"li.s",    "t,f",		0,    (int) M_LI_S,	INSN_MACRO,			0, I1},
{"li.s",    "T,l",		0,    (int) M_LI_SS,	INSN_MACRO,		0, I1},
{"lld",	    "t,o(b)",	0xd0000000, 0xfc000000, LDD|RD_b|WR_t,	0, I1},
{"lld",     "t,A(b)",	0,    (int) M_LLD_AB,	INSN_MACRO,		0, I1},
{"l.s",	"T,o(b)",	0xc4000000, 0xfc000000,	CLD|RD_b|WR_T|FP_S,	0, I1},/* lwc1 */
{"l.s",     "T,A(b)",	0,    (int) M_LWC1_AB,	INSN_MACRO,		0, I1},
{"neg",     "d,w",	0x00000022, 0xffe007ff,	WR_d|RD_t,		0, I1},/* sub 0 */
{"negu",    "d,w",	0x00000023, 0xffe007ff,	WR_d|RD_t,		0, I1},/* subu 0 */
{"not",     "d,v",	0x00000027, 0xfc1f07ff,	WR_d|RD_s|RD_t,	0, I1},/*nor d,s,0*/
{"sd",	    "t,o(b)",	0xfc000000, 0xfc000000,	SM|RD_t|RD_b,	0, I1},
{"sd",      "t,o(b)",	0,    (int) M_SD_OB,	INSN_MACRO,		0, I1},
{"sd",      "t,A(b)",	0,    (int) M_SD_AB,	INSN_MACRO,		0, I1},

/* No hazard protection on coprocessor instructions--they shouldn't
   change the state of the processor and if they do it's up to the
   user to put in nops as necessary.  These are at the end so that the
   disassembler recognizes more specific versions first.  */
{"c0",      "C",	0x42000000, 0xfe000000,	0,			0, I1},
{"c1",      "C",	0x46000000, 0xfe000000,	0,			0, I1},
{"cop0",     "C",	0,    (int) M_COP0,	INSN_MACRO,		0, I1},
{"cop1",     "C",	0,    (int) M_COP1,	INSN_MACRO,		0, I1}

};

#if 0
const struct mips_opcode mips_builtin_opcodes[] =
{
/* These instructions appear first so that the disassembler will find
   them first.  The assemblers uses a hash table based on the
   instruction name anyhow.  */
/* name,    args,	match,	    mask,	pinfo,          	pinfo2,		membership */
{"pref",    "k,o(b)",   0xcc000000, 0xfc000000, RD_b,           	0,		I4|I32|G3	},
{"prefx",   "h,t(b)",	0x4c00000f, 0xfc0007ff, RD_b|RD_t,		0,		I4|I33	},
{"nop",     "",         0x00000000, 0xffffffff, 0,              	INSN2_ALIAS,	I1      }, /* sll */
{"ssnop",   "",         0x00000040, 0xffffffff, 0,              	INSN2_ALIAS,	I32|N55	}, /* sll */
{"ehb",     "",         0x000000c0, 0xffffffff, 0,              	INSN2_ALIAS,	I33	}, /* sll */
{"li",      "t,j",      0x24000000, 0xffe00000, WR_t,			INSN2_ALIAS,	I1	}, /* addiu */
{"li",	    "t,i",	0x34000000, 0xffe00000, WR_t,			INSN2_ALIAS,	I1	}, /* ori */
{"li",      "t,I",	0,    (int) M_LI,	INSN_MACRO,		0,		I1	},
{"move",    "d,s",	0,    (int) M_MOVE,	INSN_MACRO,		0,		I1	},
{"move",    "d,s",	0x0000002d, 0xfc1f07ff, WR_d|RD_s,		INSN2_ALIAS,	I3	},/* daddu */
{"move",    "d,s",	0x00000021, 0xfc1f07ff, WR_d|RD_s,		INSN2_ALIAS,	I1	},/* addu */
{"move",    "d,s",	0x00000025, 0xfc1f07ff,	WR_d|RD_s,		INSN2_ALIAS,	I1	},/* or */
{"b",       "p",	0x10000000, 0xffff0000,	UBD,			INSN2_ALIAS,	I1	},/* beq 0,0 */
{"b",       "p",	0x04010000, 0xffff0000,	UBD,			INSN2_ALIAS,	I1	},/* bgez 0 */
{"bal",     "p",	0x04110000, 0xffff0000,	UBD|WR_31,		INSN2_ALIAS,	I1	},/* bgezal 0*/

{"abs",     "d,v",	0,    (int) M_ABS,	INSN_MACRO,		0,		I1	},
{"abs.s",   "D,V",	0x46000005, 0xffff003f,	WR_D|RD_S|FP_S,		0,		I1	},
{"abs.d",   "D,V",	0x46200005, 0xffff003f,	WR_D|RD_S|FP_D,		0,		I1	},
{"abs.ps",  "D,V",	0x46c00005, 0xffff003f,	WR_D|RD_S|FP_D,		0,		I5	},
{"add",     "d,v,t",	0x00000020, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I1	},
{"add",     "t,r,I",	0,    (int) M_ADD_I,	INSN_MACRO,		0,		I1	},
{"add.s",   "D,V,T",	0x46000000, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0,		I1	},
{"add.d",   "D,V,T",	0x46200000, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I1	},
{"add.ob",  "X,Y,Q",	0x7800000b, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"add.ob",  "D,S,T",	0x4ac0000b, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"add.ob",  "D,S,T[e]",	0x4800000b, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"add.ob",  "D,S,k",	0x4bc0000b, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"add.ps",  "D,V,T",	0x46c00000, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I5	},
{"add.qh",  "X,Y,Q",	0x7820000b, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"adda.ob", "Y,Q",	0x78000037, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX|SB1	},
{"adda.qh", "Y,Q",	0x78200037, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX	},
{"addi",    "t,r,j",	0x20000000, 0xfc000000,	WR_t|RD_s,		0,		I1	},
{"addiu",   "t,r,j",	0x24000000, 0xfc000000,	WR_t|RD_s,		0,		I1	},
{"addl.ob", "Y,Q",	0x78000437, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX|SB1	},
{"addl.qh", "Y,Q",	0x78200437, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX	},
{"addr.ps", "D,S,T",	0x46c00018, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		M3D	},
{"addu",    "d,v,t",	0x00000021, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I1	},
{"addu",    "t,r,I",	0,    (int) M_ADDU_I,	INSN_MACRO,		0,		I1	},
{"alni.ob", "X,Y,Z,O",	0x78000018, 0xff00003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"alni.ob", "D,S,T,%",	0x48000018, 0xff00003f,	WR_D|RD_S|RD_T, 	0,		N54	},
{"alni.qh", "X,Y,Z,O",	0x7800001a, 0xff00003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"alnv.ps", "D,V,T,s",	0x4c00001e, 0xfc00003f,	WR_D|RD_S|RD_T|FP_D,	0,		I5	},
{"alnv.ob", "X,Y,Z,s",	0x78000019, 0xfc00003f,	WR_D|RD_S|RD_T|RD_s|FP_D, 0,		MX|SB1	},
{"alnv.qh", "X,Y,Z,s",	0x7800001b, 0xfc00003f,	WR_D|RD_S|RD_T|RD_s|FP_D, 0,		MX	},
{"and",     "d,v,t",	0x00000024, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I1	},
{"and",     "t,r,I",	0,    (int) M_AND_I,	INSN_MACRO,		0,		I1	},
{"and.ob",  "X,Y,Q",	0x7800000c, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"and.ob",  "D,S,T",	0x4ac0000c, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"and.ob",  "D,S,T[e]",	0x4800000c, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"and.ob",  "D,S,k",	0x4bc0000c, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"and.qh",  "X,Y,Q",	0x7820000c, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"andi",    "t,r,i",	0x30000000, 0xfc000000,	WR_t|RD_s,		0,		I1	},
/* b is at the top of the table.  */
/* bal is at the top of the table.  */
/* bc0[tf]l? are at the bottom of the table.  */
{"bc1any2f", "N,p",	0x45200000, 0xffe30000,	CBD|RD_CC|FP_S,		0,		M3D	},
{"bc1any2t", "N,p",	0x45210000, 0xffe30000,	CBD|RD_CC|FP_S,		0,		M3D	},
{"bc1any4f", "N,p",	0x45400000, 0xffe30000,	CBD|RD_CC|FP_S,		0,		M3D	},
{"bc1any4t", "N,p",	0x45410000, 0xffe30000,	CBD|RD_CC|FP_S,		0,		M3D	},
{"bc1f",    "p",	0x45000000, 0xffff0000,	CBD|RD_CC|FP_S,		0,		I1	},
{"bc1f",    "N,p",      0x45000000, 0xffe30000, CBD|RD_CC|FP_S, 	0,		I4|I32	},
{"bc1fl",   "p",	0x45020000, 0xffff0000,	CBL|RD_CC|FP_S,		0,		I2|T3	},
{"bc1fl",   "N,p",      0x45020000, 0xffe30000, CBL|RD_CC|FP_S, 	0,		I4|I32	},
{"bc1t",    "p",	0x45010000, 0xffff0000,	CBD|RD_CC|FP_S,		0,		I1	},
{"bc1t",    "N,p",      0x45010000, 0xffe30000, CBD|RD_CC|FP_S, 	0,		I4|I32	},
{"bc1tl",   "p",	0x45030000, 0xffff0000,	CBL|RD_CC|FP_S,		0,		I2|T3	},
{"bc1tl",   "N,p",      0x45030000, 0xffe30000, CBL|RD_CC|FP_S, 	0,		I4|I32	},
/* bc2* are at the bottom of the table.  */
{"bc3f",    "p",	0x4d000000, 0xffff0000,	CBD|RD_CC,		0,		I1	},
{"bc3fl",   "p",	0x4d020000, 0xffff0000,	CBL|RD_CC,		0,		I2|T3	},
{"bc3t",    "p",	0x4d010000, 0xffff0000,	CBD|RD_CC,		0,		I1	},
{"bc3tl",   "p",	0x4d030000, 0xffff0000,	CBL|RD_CC,		0,		I2|T3	},
{"beqz",    "s,p",	0x10000000, 0xfc1f0000,	CBD|RD_s,		0,		I1	},
{"beqzl",   "s,p",	0x50000000, 0xfc1f0000,	CBL|RD_s,		0,		I2|T3	},
{"beq",     "s,t,p",	0x10000000, 0xfc000000,	CBD|RD_s|RD_t,		0,		I1	},
{"beq",     "s,I,p",	0,    (int) M_BEQ_I,	INSN_MACRO,		0,		I1	},
{"beql",    "s,t,p",	0x50000000, 0xfc000000,	CBL|RD_s|RD_t,		0,		I2|T3	},
{"beql",    "s,I,p",	0,    (int) M_BEQL_I,	INSN_MACRO,		0,		I2|T3	},
{"bge",     "s,t,p",	0,    (int) M_BGE,	INSN_MACRO,		0,		I1	},
{"bge",     "s,I,p",	0,    (int) M_BGE_I,	INSN_MACRO,		0,		I1	},
{"bgel",    "s,t,p",	0,    (int) M_BGEL,	INSN_MACRO,		0,		I2|T3	},
{"bgel",    "s,I,p",	0,    (int) M_BGEL_I,	INSN_MACRO,		0,		I2|T3	},
{"bgeu",    "s,t,p",	0,    (int) M_BGEU,	INSN_MACRO,		0,		I1	},
{"bgeu",    "s,I,p",	0,    (int) M_BGEU_I,	INSN_MACRO,		0,		I1	},
{"bgeul",   "s,t,p",	0,    (int) M_BGEUL,	INSN_MACRO,		0,		I2|T3	},
{"bgeul",   "s,I,p",	0,    (int) M_BGEUL_I,	INSN_MACRO,		0,		I2|T3	},
{"bgez",    "s,p",	0x04010000, 0xfc1f0000,	CBD|RD_s,		0,		I1	},
{"bgezl",   "s,p",	0x04030000, 0xfc1f0000,	CBL|RD_s,		0,		I2|T3	},
{"bgezal",  "s,p",	0x04110000, 0xfc1f0000,	CBD|RD_s|WR_31,		0,		I1	},
{"bgezall", "s,p",	0x04130000, 0xfc1f0000,	CBL|RD_s|WR_31,		0,		I2|T3	},
{"bgt",     "s,t,p",	0,    (int) M_BGT,	INSN_MACRO,		0,		I1	},
{"bgt",     "s,I,p",	0,    (int) M_BGT_I,	INSN_MACRO,		0,		I1	},
{"bgtl",    "s,t,p",	0,    (int) M_BGTL,	INSN_MACRO,		0,		I2|T3	},
{"bgtl",    "s,I,p",	0,    (int) M_BGTL_I,	INSN_MACRO,		0,		I2|T3	},
{"bgtu",    "s,t,p",	0,    (int) M_BGTU,	INSN_MACRO,		0,		I1	},
{"bgtu",    "s,I,p",	0,    (int) M_BGTU_I,	INSN_MACRO,		0,		I1	},
{"bgtul",   "s,t,p",	0,    (int) M_BGTUL,	INSN_MACRO,		0,		I2|T3	},
{"bgtul",   "s,I,p",	0,    (int) M_BGTUL_I,	INSN_MACRO,		0,		I2|T3	},
{"bgtz",    "s,p",	0x1c000000, 0xfc1f0000,	CBD|RD_s,		0,		I1	},
{"bgtzl",   "s,p",	0x5c000000, 0xfc1f0000,	CBL|RD_s,		0,		I2|T3	},
{"ble",     "s,t,p",	0,    (int) M_BLE,	INSN_MACRO,		0,		I1	},
{"ble",     "s,I,p",	0,    (int) M_BLE_I,	INSN_MACRO,		0,		I1	},
{"blel",    "s,t,p",	0,    (int) M_BLEL,	INSN_MACRO,		0,		I2|T3	},
{"blel",    "s,I,p",	0,    (int) M_BLEL_I,	INSN_MACRO,		0,		I2|T3	},
{"bleu",    "s,t,p",	0,    (int) M_BLEU,	INSN_MACRO,		0,		I1	},
{"bleu",    "s,I,p",	0,    (int) M_BLEU_I,	INSN_MACRO,		0,		I1	},
{"bleul",   "s,t,p",	0,    (int) M_BLEUL,	INSN_MACRO,		0,		I2|T3	},
{"bleul",   "s,I,p",	0,    (int) M_BLEUL_I,	INSN_MACRO,		0,		I2|T3	},
{"blez",    "s,p",	0x18000000, 0xfc1f0000,	CBD|RD_s,		0,		I1	},
{"blezl",   "s,p",	0x58000000, 0xfc1f0000,	CBL|RD_s,		0,		I2|T3	},
{"blt",     "s,t,p",	0,    (int) M_BLT,	INSN_MACRO,		0,		I1	},
{"blt",     "s,I,p",	0,    (int) M_BLT_I,	INSN_MACRO,		0,		I1	},
{"bltl",    "s,t,p",	0,    (int) M_BLTL,	INSN_MACRO,		0,		I2|T3	},
{"bltl",    "s,I,p",	0,    (int) M_BLTL_I,	INSN_MACRO,		0,		I2|T3	},
{"bltu",    "s,t,p",	0,    (int) M_BLTU,	INSN_MACRO,		0,		I1	},
{"bltu",    "s,I,p",	0,    (int) M_BLTU_I,	INSN_MACRO,		0,		I1	},
{"bltul",   "s,t,p",	0,    (int) M_BLTUL,	INSN_MACRO,		0,		I2|T3	},
{"bltul",   "s,I,p",	0,    (int) M_BLTUL_I,	INSN_MACRO,		0,		I2|T3	},
{"bltz",    "s,p",	0x04000000, 0xfc1f0000,	CBD|RD_s,		0,		I1	},
{"bltzl",   "s,p",	0x04020000, 0xfc1f0000,	CBL|RD_s,		0,		I2|T3	},
{"bltzal",  "s,p",	0x04100000, 0xfc1f0000,	CBD|RD_s|WR_31,		0,		I1	},
{"bltzall", "s,p",	0x04120000, 0xfc1f0000,	CBL|RD_s|WR_31,		0,		I2|T3	},
{"bnez",    "s,p",	0x14000000, 0xfc1f0000,	CBD|RD_s,		0,		I1	},
{"bnezl",   "s,p",	0x54000000, 0xfc1f0000,	CBL|RD_s,		0,		I2|T3	},
{"bne",     "s,t,p",	0x14000000, 0xfc000000,	CBD|RD_s|RD_t,		0,		I1	},
{"bne",     "s,I,p",	0,    (int) M_BNE_I,	INSN_MACRO,		0,		I1	},
{"bnel",    "s,t,p",	0x54000000, 0xfc000000,	CBL|RD_s|RD_t, 		0,		I2|T3	},
{"bnel",    "s,I,p",	0,    (int) M_BNEL_I,	INSN_MACRO,		0,		I2|T3	},
{"break",   "",		0x0000000d, 0xffffffff,	TRAP,			0,		I1	},
{"break",   "c",	0x0000000d, 0xfc00ffff,	TRAP,			0,		I1	},
{"break",   "c,q",	0x0000000d, 0xfc00003f,	TRAP,			0,		I1	},
{"c.f.d",   "S,T",	0x46200030, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.f.d",   "M,S,T",    0x46200030, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.f.s",   "S,T",      0x46000030, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.f.s",   "M,S,T",    0x46000030, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.f.ps",  "S,T",	0x46c00030, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.f.ps",  "M,S,T",	0x46c00030, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.un.d",  "S,T",	0x46200031, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.un.d",  "M,S,T",    0x46200031, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.un.s",  "S,T",      0x46000031, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.un.s",  "M,S,T",    0x46000031, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.un.ps", "S,T",	0x46c00031, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.un.ps", "M,S,T",	0x46c00031, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.eq.d",  "S,T",	0x46200032, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.eq.d",  "M,S,T",    0x46200032, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.eq.s",  "S,T",      0x46000032, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.eq.s",  "M,S,T",    0x46000032, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.eq.ob", "Y,Q",	0x78000001, 0xfc2007ff,	WR_CC|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"c.eq.ob", "S,T",	0x4ac00001, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"c.eq.ob", "S,T[e]",	0x48000001, 0xfe2007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"c.eq.ob", "S,k",	0x4bc00001, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"c.eq.ps", "S,T",	0x46c00032, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.eq.ps", "M,S,T",	0x46c00032, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.eq.qh", "Y,Q",	0x78200001, 0xfc2007ff,	WR_CC|RD_S|RD_T|FP_D,	0,		MX	},
{"c.ueq.d", "S,T",	0x46200033, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.ueq.d", "M,S,T",    0x46200033, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.ueq.s", "S,T",      0x46000033, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.ueq.s", "M,S,T",    0x46000033, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.ueq.ps","S,T",	0x46c00033, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ueq.ps","M,S,T",	0x46c00033, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.olt.d", "S,T",      0x46200034, 0xffe007ff, RD_S|RD_T|WR_CC|FP_D,   0,		I1      },
{"c.olt.d", "M,S,T",    0x46200034, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.olt.s", "S,T",	0x46000034, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_S,	0,		I1	},
{"c.olt.s", "M,S,T",    0x46000034, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.olt.ps","S,T",	0x46c00034, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.olt.ps","M,S,T",	0x46c00034, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ult.d", "S,T",	0x46200035, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.ult.d", "M,S,T",    0x46200035, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.ult.s", "S,T",      0x46000035, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.ult.s", "M,S,T",    0x46000035, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.ult.ps","S,T",	0x46c00035, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ult.ps","M,S,T",	0x46c00035, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ole.d", "S,T",      0x46200036, 0xffe007ff, RD_S|RD_T|WR_CC|FP_D,   0,		I1      },
{"c.ole.d", "M,S,T",    0x46200036, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.ole.s", "S,T",      0x46000036, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.ole.s", "M,S,T",    0x46000036, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.ole.ps","S,T",	0x46c00036, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ole.ps","M,S,T",	0x46c00036, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ule.d", "S,T",	0x46200037, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.ule.d", "M,S,T",    0x46200037, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.ule.s", "S,T",      0x46000037, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.ule.s", "M,S,T",    0x46000037, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.ule.ps","S,T",	0x46c00037, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ule.ps","M,S,T",	0x46c00037, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.sf.d",  "S,T",	0x46200038, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.sf.d",  "M,S,T",    0x46200038, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.sf.s",  "S,T",      0x46000038, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.sf.s",  "M,S,T",    0x46000038, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.sf.ps", "S,T",	0x46c00038, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.sf.ps", "M,S,T",	0x46c00038, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ngle.d","S,T",	0x46200039, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.ngle.d","M,S,T",    0x46200039, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.ngle.s","S,T",      0x46000039, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.ngle.s","M,S,T",    0x46000039, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.ngle.ps","S,T",	0x46c00039, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ngle.ps","M,S,T",	0x46c00039, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.seq.d", "S,T",	0x4620003a, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.seq.d", "M,S,T",    0x4620003a, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.seq.s", "S,T",      0x4600003a, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.seq.s", "M,S,T",    0x4600003a, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.seq.ps","S,T",	0x46c0003a, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.seq.ps","M,S,T",	0x46c0003a, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ngl.d", "S,T",	0x4620003b, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.ngl.d", "M,S,T",    0x4620003b, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.ngl.s", "S,T",      0x4600003b, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.ngl.s", "M,S,T",    0x4600003b, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.ngl.ps","S,T",	0x46c0003b, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ngl.ps","M,S,T",	0x46c0003b, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.lt.d",  "S,T",	0x4620003c, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.lt.d",  "M,S,T",    0x4620003c, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.lt.s",  "S,T",	0x4600003c, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_S,	0,		I1	},
{"c.lt.s",  "M,S,T",    0x4600003c, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.lt.ob", "Y,Q",	0x78000004, 0xfc2007ff,	WR_CC|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"c.lt.ob", "S,T",	0x4ac00004, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"c.lt.ob", "S,T[e]",	0x48000004, 0xfe2007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"c.lt.ob", "S,k",	0x4bc00004, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"c.lt.ps", "S,T",	0x46c0003c, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.lt.ps", "M,S,T",	0x46c0003c, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.lt.qh", "Y,Q",	0x78200004, 0xfc2007ff,	WR_CC|RD_S|RD_T|FP_D,	0,		MX	},
{"c.nge.d", "S,T",	0x4620003d, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.nge.d", "M,S,T",    0x4620003d, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.nge.s", "S,T",      0x4600003d, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.nge.s", "M,S,T",    0x4600003d, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.nge.ps","S,T",	0x46c0003d, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.nge.ps","M,S,T",	0x46c0003d, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.le.d",  "S,T",	0x4620003e, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.le.d",  "M,S,T",    0x4620003e, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.le.s",  "S,T",	0x4600003e, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_S,	0,		I1	},
{"c.le.s",  "M,S,T",    0x4600003e, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.le.ob", "Y,Q",	0x78000005, 0xfc2007ff,	WR_CC|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"c.le.ob", "S,T",	0x4ac00005, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"c.le.ob", "S,T[e]",	0x48000005, 0xfe2007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"c.le.ob", "S,k",	0x4bc00005, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"c.le.ps", "S,T",	0x46c0003e, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.le.ps", "M,S,T",	0x46c0003e, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.le.qh", "Y,Q",	0x78200005, 0xfc2007ff,	WR_CC|RD_S|RD_T|FP_D,	0,		MX	},
{"c.ngt.d", "S,T",	0x4620003f, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
{"c.ngt.d", "M,S,T",    0x4620003f, 0xffe000ff, RD_S|RD_T|WR_CC|FP_D,   0,		I4|I32	},
{"c.ngt.s", "S,T",      0x4600003f, 0xffe007ff, RD_S|RD_T|WR_CC|FP_S,   0,		I1      },
{"c.ngt.s", "M,S,T",    0x4600003f, 0xffe000ff, RD_S|RD_T|WR_CC|FP_S,   0,		I4|I32	},
{"c.ngt.ps","S,T",	0x46c0003f, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"c.ngt.ps","M,S,T",	0x46c0003f, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I5	},
{"cabs.eq.d",  "M,S,T",	0x46200072, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.eq.ps", "M,S,T",	0x46c00072, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.eq.s",  "M,S,T",	0x46000072, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.f.d",   "M,S,T",	0x46200070, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.f.ps",  "M,S,T",	0x46c00070, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.f.s",   "M,S,T",	0x46000070, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.le.d",  "M,S,T",	0x4620007e, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.le.ps", "M,S,T",	0x46c0007e, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.le.s",  "M,S,T",	0x4600007e, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.lt.d",  "M,S,T",	0x4620007c, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.lt.ps", "M,S,T",	0x46c0007c, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.lt.s",  "M,S,T",	0x4600007c, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.nge.d", "M,S,T",	0x4620007d, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.nge.ps","M,S,T",	0x46c0007d, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.nge.s", "M,S,T",	0x4600007d, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.ngl.d", "M,S,T",	0x4620007b, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ngl.ps","M,S,T",	0x46c0007b, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ngl.s", "M,S,T",	0x4600007b, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.ngle.d","M,S,T",	0x46200079, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ngle.ps","M,S,T",0x46c00079, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ngle.s","M,S,T",	0x46000079, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.ngt.d", "M,S,T",	0x4620007f, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ngt.ps","M,S,T",	0x46c0007f, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ngt.s", "M,S,T",	0x4600007f, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.ole.d", "M,S,T",	0x46200076, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ole.ps","M,S,T",	0x46c00076, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ole.s", "M,S,T",	0x46000076, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.olt.d", "M,S,T",	0x46200074, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.olt.ps","M,S,T",	0x46c00074, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.olt.s", "M,S,T",	0x46000074, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.seq.d", "M,S,T",	0x4620007a, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.seq.ps","M,S,T",	0x46c0007a, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.seq.s", "M,S,T",	0x4600007a, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.sf.d",  "M,S,T",	0x46200078, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.sf.ps", "M,S,T",	0x46c00078, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.sf.s",  "M,S,T",	0x46000078, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.ueq.d", "M,S,T",	0x46200073, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ueq.ps","M,S,T",	0x46c00073, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ueq.s", "M,S,T",	0x46000073, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.ule.d", "M,S,T",	0x46200077, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ule.ps","M,S,T",	0x46c00077, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ule.s", "M,S,T",	0x46000077, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.ult.d", "M,S,T",	0x46200075, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ult.ps","M,S,T",	0x46c00075, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.ult.s", "M,S,T",	0x46000075, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cabs.un.d",  "M,S,T",	0x46200071, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.un.ps", "M,S,T",	0x46c00071, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
{"cabs.un.s",  "M,S,T",	0x46000071, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
{"cache",   "k,o(b)",   0xbc000000, 0xfc000000, RD_b,           	0,		I3|I32|T3},
{"ceil.l.d", "D,S",	0x4620000a, 0xffff003f, WR_D|RD_S|FP_D,		0,		I3|I33	},
{"ceil.l.s", "D,S",	0x4600000a, 0xffff003f, WR_D|RD_S|FP_S|FP_D,	0,		I3|I33	},
{"ceil.w.d", "D,S",	0x4620000e, 0xffff003f, WR_D|RD_S|FP_S|FP_D,	0,		I2	},
{"ceil.w.s", "D,S",	0x4600000e, 0xffff003f, WR_D|RD_S|FP_S,		0,		I2	},
{"cfc0",    "t,G",	0x40400000, 0xffe007ff,	LCD|WR_t|RD_C0,		0,		I1	},
{"cfc1",    "t,G",	0x44400000, 0xffe007ff,	LCD|WR_t|RD_C1|FP_S,	0,		I1	},
{"cfc1",    "t,S",	0x44400000, 0xffe007ff,	LCD|WR_t|RD_C1|FP_S,	0,		I1	},
/* cfc2 is at the bottom of the table.  */
{"cfc3",    "t,G",	0x4c400000, 0xffe007ff,	LCD|WR_t|RD_C3,		0,		I1	},
{"cftc1",   "d,E",	0x41000023, 0xffe007ff, TRAP|LCD|WR_d|RD_C1|FP_S, 0,		MT32	},
{"cftc1",   "d,T",	0x41000023, 0xffe007ff, TRAP|LCD|WR_d|RD_C1|FP_S, 0,		MT32	},
{"cftc2",   "d,E",	0x41000025, 0xffe007ff, TRAP|LCD|WR_d|RD_C2,	0,		MT32	},
{"clo",     "U,s",      0x70000021, 0xfc0007ff, WR_d|WR_t|RD_s, 	0,		I32|N55 },
{"clz",     "U,s",      0x70000020, 0xfc0007ff, WR_d|WR_t|RD_s, 	0,		I32|N55 },
{"ctc0",    "t,G",	0x40c00000, 0xffe007ff,	COD|RD_t|WR_CC,		0,		I1	},
{"ctc1",    "t,G",	0x44c00000, 0xffe007ff,	COD|RD_t|WR_CC|FP_S,	0,		I1	},
{"ctc1",    "t,S",	0x44c00000, 0xffe007ff,	COD|RD_t|WR_CC|FP_S,	0,		I1	},
/* ctc2 is at the bottom of the table.  */
{"ctc3",    "t,G",	0x4cc00000, 0xffe007ff,	COD|RD_t|WR_CC,		0,		I1	},
{"cttc1",   "t,g",	0x41800023, 0xffe007ff, TRAP|COD|RD_t|WR_CC|FP_S, 0,		MT32	},
{"cttc1",   "t,S",	0x41800023, 0xffe007ff, TRAP|COD|RD_t|WR_CC|FP_S, 0,		MT32	},
{"cttc2",   "t,g",	0x41800025, 0xffe007ff, TRAP|COD|RD_t|WR_CC,	0,		MT32	},
{"cvt.d.l", "D,S",	0x46a00021, 0xffff003f,	WR_D|RD_S|FP_D,		0,		I3|I33	},
{"cvt.d.s", "D,S",	0x46000021, 0xffff003f,	WR_D|RD_S|FP_S|FP_D,	0,		I1	},
{"cvt.d.w", "D,S",	0x46800021, 0xffff003f,	WR_D|RD_S|FP_S|FP_D,	0,		I1	},
{"cvt.l.d", "D,S",	0x46200025, 0xffff003f,	WR_D|RD_S|FP_D,		0,		I3|I33	},
{"cvt.l.s", "D,S",	0x46000025, 0xffff003f,	WR_D|RD_S|FP_S|FP_S,	0,		I3|I33	},
{"cvt.s.l", "D,S",	0x46a00020, 0xffff003f,	WR_D|RD_S|FP_S|FP_S,	0,		I3|I33	},
{"cvt.s.d", "D,S",	0x46200020, 0xffff003f,	WR_D|RD_S|FP_S|FP_D,	0,		I1	},
{"cvt.s.w", "D,S",	0x46800020, 0xffff003f,	WR_D|RD_S|FP_S,		0,		I1	},
{"cvt.s.pl","D,S",	0x46c00028, 0xffff003f,	WR_D|RD_S|FP_S|FP_D,	0,		I5	},
{"cvt.s.pu","D,S",	0x46c00020, 0xffff003f,	WR_D|RD_S|FP_S|FP_D,	0,		I5	},
{"cvt.w.d", "D,S",	0x46200024, 0xffff003f,	WR_D|RD_S|FP_S|FP_D,	0,		I1	},
{"cvt.w.s", "D,S",	0x46000024, 0xffff003f,	WR_D|RD_S|FP_S,		0,		I1	},
{"cvt.ps.pw", "D,S",	0x46800026, 0xffff003f,	WR_D|RD_S|FP_S|FP_D,	0,		M3D	},
{"cvt.ps.s","D,V,T",	0x46000026, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S|FP_D, 0,		I5	},
{"cvt.pw.ps", "D,S",	0x46c00024, 0xffff003f,	WR_D|RD_S|FP_S|FP_D,	0,		M3D	},
{"dabs",    "d,v",	0,    (int) M_DABS,	INSN_MACRO,		0,		I3	},
{"dadd",    "d,v,t",	0x0000002c, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		I3	},
{"dadd",    "t,r,I",	0,    (int) M_DADD_I,	INSN_MACRO,		0,		I3	},
{"daddi",   "t,r,j",	0x60000000, 0xfc000000, WR_t|RD_s,		0,		I3	},
{"daddiu",  "t,r,j",	0x64000000, 0xfc000000, WR_t|RD_s,		0,		I3	},
{"daddu",   "d,v,t",	0x0000002d, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		I3	},
{"daddu",   "t,r,I",	0,    (int) M_DADDU_I,	INSN_MACRO,		0,		I3	},
{"dbreak",  "",		0x7000003f, 0xffffffff,	0,			0,		N5	},
{"dclo",    "U,s",      0x70000025, 0xfc0007ff, RD_s|WR_d|WR_t, 	0,		I64|N55 },
{"dclz",    "U,s",      0x70000024, 0xfc0007ff, RD_s|WR_d|WR_t, 	0,		I64|N55 },
/* dctr and dctw are used on the r5000.  */
{"dctr",    "o(b)",	0xbc050000, 0xfc1f0000, RD_b,			0,		I3	},
{"dctw",    "o(b)",	0xbc090000, 0xfc1f0000, RD_b,			0,		I3	},
{"deret",   "",         0x4200001f, 0xffffffff, 0, 			0,		I32|G2	},
{"dext",    "t,r,I,+I",	0,    (int) M_DEXT,	INSN_MACRO,		0,		I65	},
{"dext",    "t,r,+A,+C", 0x7c000003, 0xfc00003f, WR_t|RD_s,    		0,		I65	},
{"dextm",   "t,r,+A,+G", 0x7c000001, 0xfc00003f, WR_t|RD_s,    		0,		I65	},
{"dextu",   "t,r,+E,+H", 0x7c000002, 0xfc00003f, WR_t|RD_s,    		0,		I65	},
/* For ddiv, see the comments about div.  */
{"ddiv",    "z,s,t",    0x0000001e, 0xfc00ffff, RD_s|RD_t|WR_HILO,      0,		I3      },
{"ddiv",    "d,v,t",	0,    (int) M_DDIV_3,	INSN_MACRO,		0,		I3	},
{"ddiv",    "d,v,I",	0,    (int) M_DDIV_3I,	INSN_MACRO,		0,		I3	},
/* For ddivu, see the comments about div.  */
{"ddivu",   "z,s,t",    0x0000001f, 0xfc00ffff, RD_s|RD_t|WR_HILO,      0,		I3      },
{"ddivu",   "d,v,t",	0,    (int) M_DDIVU_3,	INSN_MACRO,		0,		I3	},
{"ddivu",   "d,v,I",	0,    (int) M_DDIVU_3I,	INSN_MACRO,		0,		I3	},
{"di",      "",		0x41606000, 0xffffffff,	WR_t|WR_C0,		0,		I33	},
{"di",      "t",	0x41606000, 0xffe0ffff,	WR_t|WR_C0,		0,		I33	},
{"dins",    "t,r,I,+I",	0,    (int) M_DINS,	INSN_MACRO,		0,		I65	},
{"dins",    "t,r,+A,+B", 0x7c000007, 0xfc00003f, WR_t|RD_s,    		0,		I65	},
{"dinsm",   "t,r,+A,+F", 0x7c000005, 0xfc00003f, WR_t|RD_s,    		0,		I65	},
{"dinsu",   "t,r,+E,+F", 0x7c000006, 0xfc00003f, WR_t|RD_s,    		0,		I65	},
/* The MIPS assembler treats the div opcode with two operands as
   though the first operand appeared twice (the first operand is both
   a source and a destination).  To get the div machine instruction,
   you must use an explicit destination of $0.  */
{"div",     "z,s,t",    0x0000001a, 0xfc00ffff, RD_s|RD_t|WR_HILO,      0,		I1      },
{"div",     "z,t",      0x0000001a, 0xffe0ffff, RD_s|RD_t|WR_HILO,      0,		I1      },
{"div",     "d,v,t",	0,    (int) M_DIV_3,	INSN_MACRO,		0,		I1	},
{"div",     "d,v,I",	0,    (int) M_DIV_3I,	INSN_MACRO,		0,		I1	},
{"div.d",   "D,V,T",	0x46200003, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I1	},
{"div.s",   "D,V,T",	0x46000003, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0,		I1	},
{"div.ps",  "D,V,T",	0x46c00003, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		SB1	},
/* For divu, see the comments about div.  */
{"divu",    "z,s,t",    0x0000001b, 0xfc00ffff, RD_s|RD_t|WR_HILO,      0,		I1      },
{"divu",    "z,t",      0x0000001b, 0xffe0ffff, RD_s|RD_t|WR_HILO,      0,		I1      },
{"divu",    "d,v,t",	0,    (int) M_DIVU_3,	INSN_MACRO,		0,		I1	},
{"divu",    "d,v,I",	0,    (int) M_DIVU_3I,	INSN_MACRO,		0,		I1	},
{"dla",     "t,A(b)",	0,    (int) M_DLA_AB,	INSN_MACRO,		0,		I3	},
{"dlca",    "t,A(b)",	0,    (int) M_DLCA_AB,	INSN_MACRO,		0,		I3	},
{"dli",     "t,j",      0x24000000, 0xffe00000, WR_t,			0,		I3	}, /* addiu */
{"dli",	    "t,i",	0x34000000, 0xffe00000, WR_t,			0,		I3	}, /* ori */
{"dli",     "t,I",	0,    (int) M_DLI,	INSN_MACRO,		0,		I3	},
{"dmacc",   "d,s,t",	0x00000029, 0xfc0007ff,	RD_s|RD_t|WR_LO|WR_d,	0,		N412	},
{"dmacchi", "d,s,t",	0x00000229, 0xfc0007ff, RD_s|RD_t|WR_LO|WR_d,	0,		N412	},
{"dmacchis", "d,s,t",	0x00000629, 0xfc0007ff, RD_s|RD_t|WR_LO|WR_d,	0,		N412	},
{"dmacchiu", "d,s,t",	0x00000269, 0xfc0007ff, RD_s|RD_t|WR_LO|WR_d,	0,		N412	},
{"dmacchius", "d,s,t",	0x00000669, 0xfc0007ff, RD_s|RD_t|WR_LO|WR_d,	0,		N412	},
{"dmaccs",  "d,s,t",	0x00000429, 0xfc0007ff,	RD_s|RD_t|WR_LO|WR_d,	0,		N412	},
{"dmaccu",  "d,s,t",	0x00000069, 0xfc0007ff,	RD_s|RD_t|WR_LO|WR_d,	0,		N412	},
{"dmaccus", "d,s,t",	0x00000469, 0xfc0007ff,	RD_s|RD_t|WR_LO|WR_d,	0,		N412	},
{"dmadd16", "s,t",      0x00000029, 0xfc00ffff, RD_s|RD_t|MOD_LO,       0,		N411    },
{"dmfc0",   "t,G",	0x40200000, 0xffe007ff, LCD|WR_t|RD_C0,		0,		I3	},
{"dmfc0",   "t,+D",     0x40200000, 0xffe007f8, LCD|WR_t|RD_C0, 	0,		I64     },
{"dmfc0",   "t,G,H",    0x40200000, 0xffe007f8, LCD|WR_t|RD_C0, 	0,		I64     },
{"dmt",     "",		0x41600bc1, 0xffffffff, TRAP,			0,		MT32	},
{"dmt",     "t",	0x41600bc1, 0xffe0ffff, TRAP|WR_t,		0,		MT32	},
{"dmtc0",   "t,G",	0x40a00000, 0xffe007ff, COD|RD_t|WR_C0|WR_CC,	0,		I3	},
{"dmtc0",   "t,+D",     0x40a00000, 0xffe007f8, COD|RD_t|WR_C0|WR_CC,   0,		I64     },
{"dmtc0",   "t,G,H",    0x40a00000, 0xffe007f8, COD|RD_t|WR_C0|WR_CC,   0,		I64     },
{"dmfc1",   "t,S",	0x44200000, 0xffe007ff, LCD|WR_t|RD_S|FP_D,	0,		I3	},
{"dmfc1",   "t,G",      0x44200000, 0xffe007ff, LCD|WR_t|RD_S|FP_D,     0,		I3      },
{"dmtc1",   "t,S",	0x44a00000, 0xffe007ff, COD|RD_t|WR_S|FP_D,	0,		I3	},
{"dmtc1",   "t,G",      0x44a00000, 0xffe007ff, COD|RD_t|WR_S|FP_D,     0,		I3      },
/* dmfc2 is at the bottom of the table.  */
/* dmtc2 is at the bottom of the table.  */
{"dmfc3",   "t,G",      0x4c200000, 0xffe007ff, LCD|WR_t|RD_C3, 	0,		I3      },
{"dmfc3",   "t,G,H",    0x4c200000, 0xffe007f8, LCD|WR_t|RD_C3, 	0,		I64     },
{"dmtc3",   "t,G",      0x4ca00000, 0xffe007ff, COD|RD_t|WR_C3|WR_CC,   0,		I3      },
{"dmtc3",   "t,G,H",    0x4ca00000, 0xffe007f8, COD|RD_t|WR_C3|WR_CC,   0,		I64     },
{"dmul",    "d,v,t",	0,    (int) M_DMUL,	INSN_MACRO,		0,		I3	},
{"dmul",    "d,v,I",	0,    (int) M_DMUL_I,	INSN_MACRO,		0,		I3	},
{"dmulo",   "d,v,t",	0,    (int) M_DMULO,	INSN_MACRO,		0,		I3	},
{"dmulo",   "d,v,I",	0,    (int) M_DMULO_I,	INSN_MACRO,		0,		I3	},
{"dmulou",  "d,v,t",	0,    (int) M_DMULOU,	INSN_MACRO,		0,		I3	},
{"dmulou",  "d,v,I",	0,    (int) M_DMULOU_I,	INSN_MACRO,		0,		I3	},
{"dmult",   "s,t",      0x0000001c, 0xfc00ffff, RD_s|RD_t|WR_HILO,      0,		I3	},
{"dmultu",  "s,t",      0x0000001d, 0xfc00ffff, RD_s|RD_t|WR_HILO,      0,		I3	},
{"dneg",    "d,w",	0x0000002e, 0xffe007ff,	WR_d|RD_t,		0,		I3	}, /* dsub 0 */
{"dnegu",   "d,w",	0x0000002f, 0xffe007ff,	WR_d|RD_t,		0,		I3	}, /* dsubu 0*/
{"drem",    "z,s,t",    0x0000001e, 0xfc00ffff, RD_s|RD_t|WR_HILO,      0,		I3      },
{"drem",    "d,v,t",	3,    (int) M_DREM_3,	INSN_MACRO,		0,		I3	},
{"drem",    "d,v,I",	3,    (int) M_DREM_3I,	INSN_MACRO,		0,		I3	},
{"dremu",   "z,s,t",    0x0000001f, 0xfc00ffff, RD_s|RD_t|WR_HILO,      0,		I3      },
{"dremu",   "d,v,t",	3,    (int) M_DREMU_3,	INSN_MACRO,		0,		I3	},
{"dremu",   "d,v,I",	3,    (int) M_DREMU_3I,	INSN_MACRO,		0,		I3	},
{"dret",    "",		0x7000003e, 0xffffffff,	0,			0,		N5	},
{"drol",    "d,v,t",	0,    (int) M_DROL,	INSN_MACRO,		0,		I3	},
{"drol",    "d,v,I",	0,    (int) M_DROL_I,	INSN_MACRO,		0,		I3	},
{"dror",    "d,v,t",	0,    (int) M_DROR,	INSN_MACRO,		0,		I3	},
{"dror",    "d,v,I",	0,    (int) M_DROR_I,	INSN_MACRO,		0,		I3	},
{"dror",    "d,w,<",	0x0020003a, 0xffe0003f,	WR_d|RD_t,		0,		N5|I65	},
{"drorv",   "d,t,s",	0x00000056, 0xfc0007ff,	RD_t|RD_s|WR_d,		0,		N5|I65	},
{"dror32",  "d,w,<",	0x0020003e, 0xffe0003f,	WR_d|RD_t,		0,		N5|I65	},
{"drotl",   "d,v,t",	0,    (int) M_DROL,	INSN_MACRO,		0,		I65	},
{"drotl",   "d,v,I",	0,    (int) M_DROL_I,	INSN_MACRO,		0,		I65	},
{"drotr",   "d,v,t",	0,    (int) M_DROR,	INSN_MACRO,		0,		I65	},
{"drotr",   "d,v,I",	0,    (int) M_DROR_I,	INSN_MACRO,		0,		I65	},
{"drotrv",  "d,t,s",	0x00000056, 0xfc0007ff,	RD_t|RD_s|WR_d,		0,		I65	},
{"drotr32", "d,w,<",	0x0020003e, 0xffe0003f,	WR_d|RD_t,		0,		I65	},
{"dsbh",    "d,w",	0x7c0000a4, 0xffe007ff,	WR_d|RD_t,		0,		I65	},
{"dshd",    "d,w",	0x7c000164, 0xffe007ff,	WR_d|RD_t,		0,		I65	},
{"dsllv",   "d,t,s",	0x00000014, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I3	},
{"dsll32",  "d,w,<",	0x0000003c, 0xffe0003f, WR_d|RD_t,		0,		I3	},
{"dsll",    "d,w,s",	0x00000014, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I3	}, /* dsllv */
{"dsll",    "d,w,>",	0x0000003c, 0xffe0003f, WR_d|RD_t,		0,		I3	}, /* dsll32 */
{"dsll",    "d,w,<",	0x00000038, 0xffe0003f,	WR_d|RD_t,		0,		I3	},
{"dsrav",   "d,t,s",	0x00000017, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I3	},
{"dsra32",  "d,w,<",	0x0000003f, 0xffe0003f, WR_d|RD_t,		0,		I3	},
{"dsra",    "d,w,s",	0x00000017, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I3	}, /* dsrav */
{"dsra",    "d,w,>",	0x0000003f, 0xffe0003f, WR_d|RD_t,		0,		I3	}, /* dsra32 */
{"dsra",    "d,w,<",	0x0000003b, 0xffe0003f,	WR_d|RD_t,		0,		I3	},
{"dsrlv",   "d,t,s",	0x00000016, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I3	},
{"dsrl32",  "d,w,<",	0x0000003e, 0xffe0003f, WR_d|RD_t,		0,		I3	},
{"dsrl",    "d,w,s",	0x00000016, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I3	}, /* dsrlv */
{"dsrl",    "d,w,>",	0x0000003e, 0xffe0003f, WR_d|RD_t,		0,		I3	}, /* dsrl32 */
{"dsrl",    "d,w,<",	0x0000003a, 0xffe0003f,	WR_d|RD_t,		0,		I3	},
{"dsub",    "d,v,t",	0x0000002e, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I3	},
{"dsub",    "d,v,I",	0,    (int) M_DSUB_I,	INSN_MACRO,		0,		I3	},
{"dsubu",   "d,v,t",	0x0000002f, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I3	},
{"dsubu",   "d,v,I",	0,    (int) M_DSUBU_I,	INSN_MACRO,		0,		I3	},
{"dvpe",    "",		0x41600001, 0xffffffff, TRAP,			0,		MT32	},
{"dvpe",    "t",	0x41600001, 0xffe0ffff, TRAP|WR_t,		0,		MT32	},
{"ei",      "",		0x41606020, 0xffffffff,	WR_t|WR_C0,		0,		I33	},
{"ei",      "t",	0x41606020, 0xffe0ffff,	WR_t|WR_C0,		0,		I33	},
{"emt",     "",		0x41600be1, 0xffffffff, TRAP,			0,		MT32	},
{"emt",     "t",	0x41600be1, 0xffe0ffff, TRAP|WR_t,		0,		MT32	},
{"eret",    "",         0x42000018, 0xffffffff, 0,      		0,		I3|I32	},
{"evpe",    "",		0x41600021, 0xffffffff, TRAP,			0,		MT32	},
{"evpe",    "t",	0x41600021, 0xffe0ffff, TRAP|WR_t,		0,		MT32	},
{"ext",     "t,r,+A,+C", 0x7c000000, 0xfc00003f, WR_t|RD_s,    		0,		I33	},
{"floor.l.d", "D,S",	0x4620000b, 0xffff003f, WR_D|RD_S|FP_D,		0,		I3|I33	},
{"floor.l.s", "D,S",	0x4600000b, 0xffff003f, WR_D|RD_S|FP_S|FP_S,	0,		I3|I33	},
{"floor.w.d", "D,S",	0x4620000f, 0xffff003f, WR_D|RD_S|FP_S|FP_D,	0,		I2	},
{"floor.w.s", "D,S",	0x4600000f, 0xffff003f, WR_D|RD_S|FP_S,		0,		I2	},
{"flushi",  "",		0xbc010000, 0xffffffff, 0,			0,		L1	},
{"flushd",  "",		0xbc020000, 0xffffffff, 0, 			0,		L1	},
{"flushid", "",		0xbc030000, 0xffffffff, 0, 			0,		L1	},
{"hibernate","",        0x42000023, 0xffffffff,	0, 			0,		V1	},
{"ins",     "t,r,+A,+B", 0x7c000004, 0xfc00003f, WR_t|RD_s,    		0,		I33	},
{"jr",      "s",	0x00000008, 0xfc1fffff,	UBD|RD_s,		0,		I1	},
{"jr.hb",   "s",	0x00000408, 0xfc1fffff,	UBD|RD_s,		0,		I33	},
{"j",       "s",	0x00000008, 0xfc1fffff,	UBD|RD_s,		0,		I1	}, /* jr */
/* SVR4 PIC code requires special handling for j, so it must be a
   macro.  */
{"j",	    "a",	0,     (int) M_J_A,	INSN_MACRO,		0,		I1	},
/* This form of j is used by the disassembler and internally by the
   assembler, but will never match user input (because the line above
   will match first).  */
{"j",       "a",	0x08000000, 0xfc000000,	UBD,			0,		I1	},
{"jalr",    "s",	0x0000f809, 0xfc1fffff,	UBD|RD_s|WR_d,		0,		I1	},
{"jalr",    "d,s",	0x00000009, 0xfc1f07ff,	UBD|RD_s|WR_d,		0,		I1	},
{"jalr.hb", "s",	0x0000fc09, 0xfc1fffff,	UBD|RD_s|WR_d,		0,		I33	},
{"jalr.hb", "d,s",	0x00000409, 0xfc1f07ff,	UBD|RD_s|WR_d,		0,		I33	},
/* SVR4 PIC code requires special handling for jal, so it must be a
   macro.  */
{"jal",     "d,s",	0,     (int) M_JAL_2,	INSN_MACRO,		0,		I1	},
{"jal",     "s",	0,     (int) M_JAL_1,	INSN_MACRO,		0,		I1	},
{"jal",     "a",	0,     (int) M_JAL_A,	INSN_MACRO,		0,		I1	},
/* This form of jal is used by the disassembler and internally by the
   assembler, but will never match user input (because the line above
   will match first).  */
{"jal",     "a",	0x0c000000, 0xfc000000,	UBD|WR_31,		0,		I1	},
{"jalx",    "a",	0x74000000, 0xfc000000, UBD|WR_31,		0,		I16     },
{"la",      "t,A(b)",	0,    (int) M_LA_AB,	INSN_MACRO,		0,		I1	},
{"lb",      "t,o(b)",	0x80000000, 0xfc000000,	LDD|RD_b|WR_t,		0,		I1	},
{"lb",      "t,A(b)",	0,    (int) M_LB_AB,	INSN_MACRO,		0,		I1	},
{"lbu",     "t,o(b)",	0x90000000, 0xfc000000,	LDD|RD_b|WR_t,		0,		I1	},
{"lbu",     "t,A(b)",	0,    (int) M_LBU_AB,	INSN_MACRO,		0,		I1	},
{"lca",     "t,A(b)",	0,    (int) M_LCA_AB,	INSN_MACRO,		0,		I1	},
{"ld",	    "t,o(b)",   0xdc000000, 0xfc000000, WR_t|RD_b,		0,		I3	},
{"ld",      "t,o(b)",	0,    (int) M_LD_OB,	INSN_MACRO,		0,		I1	},
{"ld",      "t,A(b)",	0,    (int) M_LD_AB,	INSN_MACRO,		0,		I1	},
{"ldc1",    "T,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0,		I2	},
{"ldc1",    "E,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0,		I2	},
{"ldc1",    "T,A(b)",	0,    (int) M_LDC1_AB,	INSN_MACRO,		0,		I2	},
{"ldc1",    "E,A(b)",	0,    (int) M_LDC1_AB,	INSN_MACRO,		0,		I2	},
{"l.d",     "T,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0,		I2	}, /* ldc1 */
{"l.d",     "T,o(b)",	0,    (int) M_L_DOB,	INSN_MACRO,		0,		I1	},
{"l.d",     "T,A(b)",	0,    (int) M_L_DAB,	INSN_MACRO,		0,		I1	},
{"ldc2",    "E,o(b)",	0xd8000000, 0xfc000000, CLD|RD_b|WR_CC,		0,		I2	},
{"ldc2",    "E,A(b)",	0,    (int) M_LDC2_AB,	INSN_MACRO,		0,		I2	},
{"ldc3",    "E,o(b)",	0xdc000000, 0xfc000000, CLD|RD_b|WR_CC,		0,		I2	},
{"ldc3",    "E,A(b)",	0,    (int) M_LDC3_AB,	INSN_MACRO,		0,		I2	},
{"ldl",	    "t,o(b)",	0x68000000, 0xfc000000, LDD|WR_t|RD_b,		0,		I3	},
{"ldl",	    "t,A(b)",	0,    (int) M_LDL_AB,	INSN_MACRO,		0,		I3	},
{"ldr",	    "t,o(b)",	0x6c000000, 0xfc000000, LDD|WR_t|RD_b,		0,		I3	},
{"ldr",     "t,A(b)",	0,    (int) M_LDR_AB,	INSN_MACRO,		0,		I3	},
{"ldxc1",   "D,t(b)",	0x4c000001, 0xfc00f83f, LDD|WR_D|RD_t|RD_b|FP_D, 0,		I4|I33	},
{"lh",      "t,o(b)",	0x84000000, 0xfc000000,	LDD|RD_b|WR_t,		0,		I1	},
{"lh",      "t,A(b)",	0,    (int) M_LH_AB,	INSN_MACRO,		0,		I1	},
{"lhu",     "t,o(b)",	0x94000000, 0xfc000000,	LDD|RD_b|WR_t,		0,		I1	},
{"lhu",     "t,A(b)",	0,    (int) M_LHU_AB,	INSN_MACRO,		0,		I1	},
/* li is at the start of the table.  */
{"li.d",    "t,F",	0,    (int) M_LI_D,	INSN_MACRO,		0,		I1	},
{"li.d",    "T,L",	0,    (int) M_LI_DD,	INSN_MACRO,		0,		I1	},
{"li.s",    "t,f",	0,    (int) M_LI_S,	INSN_MACRO,		0,		I1	},
{"li.s",    "T,l",	0,    (int) M_LI_SS,	INSN_MACRO,		0,		I1	},
{"ll",	    "t,o(b)",	0xc0000000, 0xfc000000, LDD|RD_b|WR_t,		0,		I2	},
{"ll",	    "t,A(b)",	0,    (int) M_LL_AB,	INSN_MACRO,		0,		I2	},
{"lld",	    "t,o(b)",	0xd0000000, 0xfc000000, LDD|RD_b|WR_t,		0,		I3	},
{"lld",     "t,A(b)",	0,    (int) M_LLD_AB,	INSN_MACRO,		0,		I3	},
{"lui",     "t,u",	0x3c000000, 0xffe00000,	WR_t,			0,		I1	},
{"luxc1",   "D,t(b)",	0x4c000005, 0xfc00f83f, LDD|WR_D|RD_t|RD_b,	0,		I5|N55	},
{"lw",      "t,o(b)",	0x8c000000, 0xfc000000,	LDD|RD_b|WR_t,		0,		I1	},
{"lw",      "t,A(b)",	0,    (int) M_LW_AB,	INSN_MACRO,		0,		I1	},
{"lwc0",    "E,o(b)",	0xc0000000, 0xfc000000,	CLD|RD_b|WR_CC,		0,		I1	},
{"lwc0",    "E,A(b)",	0,    (int) M_LWC0_AB,	INSN_MACRO,		0,		I1	},
{"lwc1",    "T,o(b)",	0xc4000000, 0xfc000000,	CLD|RD_b|WR_T|FP_S,	0,		I1	},
{"lwc1",    "E,o(b)",	0xc4000000, 0xfc000000,	CLD|RD_b|WR_T|FP_S,	0,		I1	},
{"lwc1",    "T,A(b)",	0,    (int) M_LWC1_AB,	INSN_MACRO,		0,		I1	},
{"lwc1",    "E,A(b)",	0,    (int) M_LWC1_AB,	INSN_MACRO,		0,		I1	},
{"l.s",     "T,o(b)",	0xc4000000, 0xfc000000,	CLD|RD_b|WR_T|FP_S,	0,		I1	}, /* lwc1 */
{"l.s",     "T,A(b)",	0,    (int) M_LWC1_AB,	INSN_MACRO,		0,		I1	},
{"lwc2",    "E,o(b)",	0xc8000000, 0xfc000000,	CLD|RD_b|WR_CC,		0,		I1	},
{"lwc2",    "E,A(b)",	0,    (int) M_LWC2_AB,	INSN_MACRO,		0,		I1	},
{"lwc3",    "E,o(b)",	0xcc000000, 0xfc000000,	CLD|RD_b|WR_CC,		0,		I1	},
{"lwc3",    "E,A(b)",	0,    (int) M_LWC3_AB,	INSN_MACRO,		0,		I1	},
{"lwl",     "t,o(b)",	0x88000000, 0xfc000000,	LDD|RD_b|WR_t,		0,		I1	},
{"lwl",     "t,A(b)",	0,    (int) M_LWL_AB,	INSN_MACRO,		0,		I1	},
{"lcache",  "t,o(b)",	0x88000000, 0xfc000000,	LDD|RD_b|WR_t,		0,		I2	}, /* same */
{"lcache",  "t,A(b)",	0,    (int) M_LWL_AB,	INSN_MACRO,		0,		I2	}, /* as lwl */
{"lwr",     "t,o(b)",	0x98000000, 0xfc000000,	LDD|RD_b|WR_t,		0,		I1	},
{"lwr",     "t,A(b)",	0,    (int) M_LWR_AB,	INSN_MACRO,		0,		I1	},
{"flush",   "t,o(b)",	0x98000000, 0xfc000000,	LDD|RD_b|WR_t,		0,		I2	}, /* same */
{"flush",   "t,A(b)",	0,    (int) M_LWR_AB,	INSN_MACRO,		0,		I2	}, /* as lwr */
{"fork",    "d,s,t",	0x7c000008, 0xfc0007ff, TRAP|WR_d|RD_s|RD_t,	0,		MT32	},
{"lwu",     "t,o(b)",	0x9c000000, 0xfc000000,	LDD|RD_b|WR_t,		0,		I3	},
{"lwu",     "t,A(b)",	0,    (int) M_LWU_AB,	INSN_MACRO,		0,		I3	},
{"lwxc1",   "D,t(b)",	0x4c000000, 0xfc00f83f, LDD|WR_D|RD_t|RD_b|FP_D, 0,		I4|I33	},
{"macc",    "d,s,t",	0x00000028, 0xfc0007ff, RD_s|RD_t|WR_HILO|WR_d, 0,		N412    },
{"macc",    "d,s,t",	0x00000158, 0xfc0007ff, RD_s|RD_t|WR_HILO|WR_d,	0,		N5      },
{"maccs",   "d,s,t",	0x00000428, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d, 0,		N412    },
{"macchi",  "d,s,t",	0x00000228, 0xfc0007ff, RD_s|RD_t|WR_HILO|WR_d, 0,		N412    },
{"macchi",  "d,s,t",	0x00000358, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5      },
{"macchis", "d,s,t",	0x00000628, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d, 0,		N412    },
{"macchiu", "d,s,t",	0x00000268, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d, 0,		N412    },
{"macchiu", "d,s,t",	0x00000359, 0xfc0007ff, RD_s|RD_t|WR_HILO|WR_d,	0,		N5      },
{"macchius","d,s,t",	0x00000668, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d, 0,		N412    },
{"maccu",   "d,s,t",	0x00000068, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d, 0,		N412    },
{"maccu",   "d,s,t",	0x00000159, 0xfc0007ff, RD_s|RD_t|WR_HILO|WR_d,	0,		N5      },
{"maccus",  "d,s,t",	0x00000468, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d, 0,		N412    },
{"mad",     "s,t",      0x70000000, 0xfc00ffff, RD_s|RD_t|MOD_HILO,     0,		P3      },
{"madu",    "s,t",      0x70000001, 0xfc00ffff, RD_s|RD_t|MOD_HILO,     0,		P3      },
{"madd.d",  "D,R,S,T",	0x4c000021, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_D,    0,		I4|I33	},
{"madd.s",  "D,R,S,T",	0x4c000020, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_S,    0,		I4|I33	},
{"madd.ps", "D,R,S,T",	0x4c000026, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_D,    0,		I5	},
{"madd",    "s,t",      0x0000001c, 0xfc00ffff, RD_s|RD_t|WR_HILO,           0,		L1 },
{"madd",    "s,t",      0x70000000, 0xfc00ffff, RD_s|RD_t|MOD_HILO,          0,		I32|N55},
{"madd",    "s,t",      0x70000000, 0xfc00ffff, RD_s|RD_t|WR_HILO|IS_M,      0,		G1 },
{"madd",    "d,s,t",    0x70000000, 0xfc0007ff, RD_s|RD_t|WR_HILO|WR_d|IS_M, 0,		G1 },
{"maddu",   "s,t",      0x0000001d, 0xfc00ffff, RD_s|RD_t|WR_HILO,           0,		L1 },
{"maddu",   "s,t",      0x70000001, 0xfc00ffff, RD_s|RD_t|MOD_HILO,          0,		I32|N55},
{"maddu",   "s,t",      0x70000001, 0xfc00ffff, RD_s|RD_t|WR_HILO|IS_M,      0,		G1	},
{"maddu",   "d,s,t",    0x70000001, 0xfc0007ff, RD_s|RD_t|WR_HILO|WR_d|IS_M, 0,		G1	},
{"madd16",  "s,t",      0x00000028, 0xfc00ffff, RD_s|RD_t|MOD_HILO,	0,		N411    },
{"max.ob",  "X,Y,Q",	0x78000007, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"max.ob",  "D,S,T",	0x4ac00007, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"max.ob",  "D,S,T[e]",	0x48000007, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"max.ob",  "D,S,k",	0x4bc00007, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"max.qh",  "X,Y,Q",	0x78200007, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"mfpc",    "t,P",	0x4000c801, 0xffe0ffc1,	LCD|WR_t|RD_C0,		0,		M1|N5	},
{"mfps",    "t,P",	0x4000c800, 0xffe0ffc1,	LCD|WR_t|RD_C0,		0,		M1|N5	},
{"mftacx",  "d",	0x41020021, 0xffff07ff, TRAP|WR_d|RD_a,		0,		MT32	},
{"mftacx",  "d,*",	0x41020021, 0xfff307ff, TRAP|WR_d|RD_a,		0,		MT32	},
{"mftc0",   "d,+t",	0x41000000, 0xffe007ff, TRAP|LCD|WR_d|RD_C0,	0,		MT32	},
{"mftc0",   "d,+T",	0x41000000, 0xffe007f8, TRAP|LCD|WR_d|RD_C0,	0,		MT32	},
{"mftc0",   "d,E,H",	0x41000000, 0xffe007f8, TRAP|LCD|WR_d|RD_C0,	0,		MT32	},
{"mftc1",   "d,T",	0x41000022, 0xffe007ff, TRAP|LCD|WR_d|RD_T|FP_S, 0,		MT32	},
{"mftc1",   "d,E",	0x41000022, 0xffe007ff, TRAP|LCD|WR_d|RD_T|FP_S, 0,		MT32	},
{"mftc2",   "d,E",	0x41000024, 0xffe007ff, TRAP|LCD|WR_d|RD_C2,	0,		MT32	},
{"mftdsp",  "d",	0x41100021, 0xffff07ff, TRAP|WR_d,		0,		MT32	},
{"mftgpr",  "d,t",	0x41000020, 0xffe007ff, TRAP|WR_d|RD_t,		0,		MT32	},
{"mfthc1",  "d,T",	0x41000032, 0xffe007ff, TRAP|LCD|WR_d|RD_T|FP_D, 0,		MT32	},
{"mfthc1",  "d,E",	0x41000032, 0xffe007ff, TRAP|LCD|WR_d|RD_T|FP_D, 0,		MT32	},
{"mfthc2",  "d,E",	0x41000034, 0xffe007ff, TRAP|LCD|WR_d|RD_C2,	0,		MT32	},
{"mfthi",   "d",	0x41010021, 0xffff07ff, TRAP|WR_d|RD_a,		0,		MT32	},
{"mfthi",   "d,*",	0x41010021, 0xfff307ff, TRAP|WR_d|RD_a,		0,		MT32	},
{"mftlo",   "d",	0x41000021, 0xffff07ff, TRAP|WR_d|RD_a,		0,		MT32	},
{"mftlo",   "d,*",	0x41000021, 0xfff307ff, TRAP|WR_d|RD_a,		0,		MT32	},
{"mftr",    "d,t,!,H,$", 0x41000000, 0xffe007c8, TRAP|WR_d,		0,		MT32	},
{"mfc0",    "t,G",	0x40000000, 0xffe007ff,	LCD|WR_t|RD_C0,		0,		I1	},
{"mfc0",    "t,+D",     0x40000000, 0xffe007f8, LCD|WR_t|RD_C0, 	0,		I32     },
{"mfc0",    "t,G,H",    0x40000000, 0xffe007f8, LCD|WR_t|RD_C0, 	0,		I32     },
{"mfc1",    "t,S",	0x44000000, 0xffe007ff,	LCD|WR_t|RD_S|FP_S,	0,		I1	},
{"mfc1",    "t,G",	0x44000000, 0xffe007ff,	LCD|WR_t|RD_S|FP_S,	0,		I1	},
{"mfhc1",   "t,S",	0x44600000, 0xffe007ff,	LCD|WR_t|RD_S|FP_D,	0,		I33	},
{"mfhc1",   "t,G",	0x44600000, 0xffe007ff,	LCD|WR_t|RD_S|FP_D,	0,		I33	},
/* mfc2 is at the bottom of the table.  */
/* mfhc2 is at the bottom of the table.  */
{"mfc3",    "t,G",	0x4c000000, 0xffe007ff,	LCD|WR_t|RD_C3,		0,		I1	},
{"mfc3",    "t,G,H",    0x4c000000, 0xffe007f8, LCD|WR_t|RD_C3, 	0,		I32     },
{"mfdr",    "t,G",	0x7000003d, 0xffe007ff,	LCD|WR_t|RD_C0,		0,		N5      },
{"mfhi",    "d",	0x00000010, 0xffff07ff,	WR_d|RD_HI,		0,		I1	},
{"mfhi",    "d,9",	0x00000010, 0xff9f07ff, WR_d|RD_HI,		0,		D32	},
{"mflo",    "d",	0x00000012, 0xffff07ff,	WR_d|RD_LO,		0,		I1	},
{"mflo",    "d,9",	0x00000012, 0xff9f07ff, WR_d|RD_LO,		0,		D32	},
{"min.ob",  "X,Y,Q",	0x78000006, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"min.ob",  "D,S,T",	0x4ac00006, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"min.ob",  "D,S,T[e]",	0x48000006, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"min.ob",  "D,S,k",	0x4bc00006, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"min.qh",  "X,Y,Q",	0x78200006, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"mov.d",   "D,S",	0x46200006, 0xffff003f,	WR_D|RD_S|FP_D,		0,		I1	},
{"mov.s",   "D,S",	0x46000006, 0xffff003f,	WR_D|RD_S|FP_S,		0,		I1	},
{"mov.ps",  "D,S",	0x46c00006, 0xffff003f,	WR_D|RD_S|FP_D,		0,		I5	},
{"movf",    "d,s,N",    0x00000001, 0xfc0307ff, WR_d|RD_s|RD_CC|FP_S|FP_D, 0,		I4|I32  },
{"movf.d",  "D,S,N",    0x46200011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,   0,		I4|I32	},
{"movf.l",  "D,S,N",	0x46a00011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,	0,		MX|SB1	},
{"movf.l",  "X,Y,N",	0x46a00011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,	0,		MX|SB1	},
{"movf.s",  "D,S,N",    0x46000011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_S,   0,		I4|I32	},
{"movf.ps", "D,S,N",	0x46c00011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,	0,		I5	},
{"movn",    "d,v,t",    0x0000000b, 0xfc0007ff, WR_d|RD_s|RD_t, 	0,		I4|I32	},
{"ffc",     "d,v",	0x0000000b, 0xfc1f07ff,	WR_d|RD_s,		0,		L1	},
{"movn.d",  "D,S,t",    0x46200013, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		I4|I32	},
{"movn.l",  "D,S,t",    0x46a00013, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		MX|SB1	},
{"movn.l",  "X,Y,t",    0x46a00013, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		MX|SB1	},
{"movn.s",  "D,S,t",    0x46000013, 0xffe0003f, WR_D|RD_S|RD_t|FP_S,    0,		I4|I32	},
{"movn.ps", "D,S,t",    0x46c00013, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		I5	},
{"movt",    "d,s,N",    0x00010001, 0xfc0307ff, WR_d|RD_s|RD_CC|FP_S|FP_D, 0,		I4|I32	},
{"movt.d",  "D,S,N",    0x46210011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,   0,		I4|I32	},
{"movt.l",  "D,S,N",    0x46a10011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,   0,		MX|SB1	},
{"movt.l",  "X,Y,N",    0x46a10011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,   0,		MX|SB1	},
{"movt.s",  "D,S,N",    0x46010011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_S,   0,		I4|I32	},
{"movt.ps", "D,S,N",	0x46c10011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,	0,		I5	},
{"movz",    "d,v,t",    0x0000000a, 0xfc0007ff, WR_d|RD_s|RD_t, 	0,		I4|I32	},
{"ffs",     "d,v",	0x0000000a, 0xfc1f07ff,	WR_d|RD_s,		0,		L1	},
{"movz.d",  "D,S,t",    0x46200012, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		I4|I32	},
{"movz.l",  "D,S,t",    0x46a00012, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		MX|SB1	},
{"movz.l",  "X,Y,t",    0x46a00012, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		MX|SB1	},
{"movz.s",  "D,S,t",    0x46000012, 0xffe0003f, WR_D|RD_S|RD_t|FP_S,    0,		I4|I32	},
{"movz.ps", "D,S,t",    0x46c00012, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		I5	},
{"msac",    "d,s,t",	0x000001d8, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5	},
{"msacu",   "d,s,t",	0x000001d9, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5	},
{"msachi",  "d,s,t",	0x000003d8, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5	},
{"msachiu", "d,s,t",	0x000003d9, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5	},
/* move is at the top of the table.  */
{"msgn.qh", "X,Y,Q",	0x78200000, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"msub.d",  "D,R,S,T",	0x4c000029, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_D, 0,		I4|I33	},
{"msub.s",  "D,R,S,T",	0x4c000028, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_S, 0,		I4|I33	},
{"msub.ps", "D,R,S,T",	0x4c00002e, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_D, 0,		I5	},
{"msub",    "s,t",      0x0000001e, 0xfc00ffff, RD_s|RD_t|WR_HILO,	0,		L1    	},
{"msub",    "s,t",      0x70000004, 0xfc00ffff, RD_s|RD_t|MOD_HILO,     0,		I32|N55 },
{"msubu",   "s,t",      0x0000001f, 0xfc00ffff, RD_s|RD_t|WR_HILO,	0,		L1	},
{"msubu",   "s,t",      0x70000005, 0xfc00ffff, RD_s|RD_t|MOD_HILO,     0,		I32|N55	},
{"mtpc",    "t,P",	0x4080c801, 0xffe0ffc1,	COD|RD_t|WR_C0,		0,		M1|N5	},
{"mtps",    "t,P",	0x4080c800, 0xffe0ffc1,	COD|RD_t|WR_C0,		0,		M1|N5	},
{"mtc0",    "t,G",	0x40800000, 0xffe007ff,	COD|RD_t|WR_C0|WR_CC,	0,		I1	},
{"mtc0",    "t,+D",     0x40800000, 0xffe007f8, COD|RD_t|WR_C0|WR_CC,   0,		I32     },
{"mtc0",    "t,G,H",    0x40800000, 0xffe007f8, COD|RD_t|WR_C0|WR_CC,   0,		I32     },
{"mtc1",    "t,S",	0x44800000, 0xffe007ff,	COD|RD_t|WR_S|FP_S,	0,		I1	},
{"mtc1",    "t,G",	0x44800000, 0xffe007ff,	COD|RD_t|WR_S|FP_S,	0,		I1	},
{"mthc1",   "t,S",	0x44e00000, 0xffe007ff,	COD|RD_t|WR_S|FP_D,	0,		I33	},
{"mthc1",   "t,G",	0x44e00000, 0xffe007ff,	COD|RD_t|WR_S|FP_D,	0,		I33	},
/* mtc2 is at the bottom of the table.  */
/* mthc2 is at the bottom of the table.  */
{"mtc3",    "t,G",	0x4c800000, 0xffe007ff,	COD|RD_t|WR_C3|WR_CC,	0,		I1	},
{"mtc3",    "t,G,H",    0x4c800000, 0xffe007f8, COD|RD_t|WR_C3|WR_CC,   0,		I32     },
{"mtdr",    "t,G",	0x7080003d, 0xffe007ff,	COD|RD_t|WR_C0,		0,		N5	},
{"mthi",    "s",	0x00000011, 0xfc1fffff,	RD_s|WR_HI,		0,		I1	},
{"mthi",    "s,7",	0x00000011, 0xfc1fe7ff, RD_s|WR_HI,		0,		D32	},
{"mtlo",    "s",	0x00000013, 0xfc1fffff,	RD_s|WR_LO,		0,		I1	},
{"mtlo",    "s,7",	0x00000013, 0xfc1fe7ff, RD_s|WR_LO,		0,		D32	},
{"mttc0",   "t,G",	0x41800000, 0xffe007ff, TRAP|COD|RD_t|WR_C0|WR_CC, 0,		MT32	},
{"mttc0",   "t,+D",	0x41800000, 0xffe007f8, TRAP|COD|RD_t|WR_C0|WR_CC, 0,		MT32	},
{"mttc0",   "t,G,H",	0x41800000, 0xffe007f8, TRAP|COD|RD_t|WR_C0|WR_CC, 0,		MT32	},
{"mttc1",   "t,S",	0x41800022, 0xffe007ff, TRAP|COD|RD_t|WR_S|FP_S, 0,		MT32	},
{"mttc1",   "t,G",	0x41800022, 0xffe007ff, TRAP|COD|RD_t|WR_S|FP_S, 0,		MT32	},
{"mttc2",   "t,g",	0x41800024, 0xffe007ff, TRAP|COD|RD_t|WR_C2|WR_CC, 0,		MT32	},
{"mttacx",  "t",	0x41801021, 0xffe0ffff, TRAP|WR_a|RD_t,		0,		MT32	},
{"mttacx",  "t,&",	0x41801021, 0xffe09fff, TRAP|WR_a|RD_t,		0,		MT32	},
{"mttdsp",  "t",	0x41808021, 0xffe0ffff, TRAP|RD_t,		0,		MT32	},
{"mttgpr",  "t,d",	0x41800020, 0xffe007ff, TRAP|WR_d|RD_t,		0,		MT32	},
{"mtthc1",  "t,S",	0x41800032, 0xffe007ff, TRAP|COD|RD_t|WR_S|FP_D, 0,		MT32	},
{"mtthc1",  "t,G",	0x41800032, 0xffe007ff, TRAP|COD|RD_t|WR_S|FP_D, 0,		MT32	},
{"mtthc2",  "t,g",	0x41800034, 0xffe007ff, TRAP|COD|RD_t|WR_C2|WR_CC, 0,		MT32	},
{"mtthi",   "t",	0x41800821, 0xffe0ffff, TRAP|WR_a|RD_t,		0,		MT32	},
{"mtthi",   "t,&",	0x41800821, 0xffe09fff, TRAP|WR_a|RD_t,		0,		MT32	},
{"mttlo",   "t",	0x41800021, 0xffe0ffff, TRAP|WR_a|RD_t,		0,		MT32	},
{"mttlo",   "t,&",	0x41800021, 0xffe09fff, TRAP|WR_a|RD_t,		0,		MT32	},
{"mttr",    "t,d,!,H,$", 0x41800000, 0xffe007c8, TRAP|RD_t,		0,		MT32	},
{"mul.d",   "D,V,T",	0x46200002, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I1	},
{"mul.s",   "D,V,T",	0x46000002, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0,		I1	},
{"mul.ob",  "X,Y,Q",	0x78000030, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"mul.ob",  "D,S,T",	0x4ac00030, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"mul.ob",  "D,S,T[e]",	0x48000030, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"mul.ob",  "D,S,k",	0x4bc00030, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"mul.ps",  "D,V,T",	0x46c00002, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I5	},
{"mul.qh",  "X,Y,Q",	0x78200030, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"mul",     "d,v,t",    0x70000002, 0xfc0007ff, WR_d|RD_s|RD_t|WR_HILO, 0,		I32|P3|N55},
{"mul",     "d,s,t",	0x00000058, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N54	},
{"mul",     "d,v,t",	0,    (int) M_MUL,	INSN_MACRO,		0,		I1	},
{"mul",     "d,v,I",	0,    (int) M_MUL_I,	INSN_MACRO,		0,		I1	},
{"mula.ob", "Y,Q",	0x78000033, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX|SB1	},
{"mula.ob", "S,T",	0x4ac00033, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"mula.ob", "S,T[e]",	0x48000033, 0xfe2007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"mula.ob", "S,k",	0x4bc00033, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"mula.qh", "Y,Q",	0x78200033, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX	},
{"mulhi",   "d,s,t",	0x00000258, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5	},
{"mulhiu",  "d,s,t",	0x00000259, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5	},
{"mull.ob", "Y,Q",	0x78000433, 0xfc2007ff,	RD_S|RD_T|FP_D, 	WR_MACC,	MX|SB1	},
{"mull.ob", "S,T",	0x4ac00433, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"mull.ob", "S,T[e]",	0x48000433, 0xfe2007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"mull.ob", "S,k",	0x4bc00433, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"mull.qh", "Y,Q",	0x78200433, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX	},
{"mulo",    "d,v,t",	0,    (int) M_MULO,	INSN_MACRO,		0,		I1	},
{"mulo",    "d,v,I",	0,    (int) M_MULO_I,	INSN_MACRO,		0,		I1	},
{"mulou",   "d,v,t",	0,    (int) M_MULOU,	INSN_MACRO,		0,		I1	},
{"mulou",   "d,v,I",	0,    (int) M_MULOU_I,	INSN_MACRO,		0,		I1	},
{"mulr.ps", "D,S,T",	0x46c0001a, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		M3D	},
{"muls",    "d,s,t",	0x000000d8, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5	},
{"mulsu",   "d,s,t",	0x000000d9, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5	},
{"mulshi",  "d,s,t",	0x000002d8, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5	},
{"mulshiu", "d,s,t",	0x000002d9, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5	},
{"muls.ob", "Y,Q",	0x78000032, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX|SB1	},
{"muls.ob", "S,T",	0x4ac00032, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"muls.ob", "S,T[e]",	0x48000032, 0xfe2007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"muls.ob", "S,k",	0x4bc00032, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"muls.qh", "Y,Q",	0x78200032, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX	},
{"mulsl.ob", "Y,Q",	0x78000432, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX|SB1	},
{"mulsl.ob", "S,T",	0x4ac00432, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"mulsl.ob", "S,T[e]",	0x48000432, 0xfe2007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"mulsl.ob", "S,k",	0x4bc00432, 0xffe007ff,	WR_CC|RD_S|RD_T,	0,		N54	},
{"mulsl.qh", "Y,Q",	0x78200432, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX	},
{"mult",    "s,t",      0x00000018, 0xfc00ffff, RD_s|RD_t|WR_HILO|IS_M, 0,		I1	},
{"mult",    "d,s,t",    0x00000018, 0xfc0007ff, RD_s|RD_t|WR_HILO|WR_d|IS_M, 0,		G1	},
{"multu",   "s,t",      0x00000019, 0xfc00ffff, RD_s|RD_t|WR_HILO|IS_M, 0,		I1	},
{"multu",   "d,s,t",    0x00000019, 0xfc0007ff, RD_s|RD_t|WR_HILO|WR_d|IS_M, 0,		G1	},
{"mulu",    "d,s,t",	0x00000059, 0xfc0007ff,	RD_s|RD_t|WR_HILO|WR_d,	0,		N5	},
{"neg",     "d,w",	0x00000022, 0xffe007ff,	WR_d|RD_t,		0,		I1	}, /* sub 0 */
{"negu",    "d,w",	0x00000023, 0xffe007ff,	WR_d|RD_t,		0,		I1	}, /* subu 0 */
{"neg.d",   "D,V",	0x46200007, 0xffff003f,	WR_D|RD_S|FP_D,		0,		I1	},
{"neg.s",   "D,V",	0x46000007, 0xffff003f,	WR_D|RD_S|FP_S,		0,		I1	},
{"neg.ps",  "D,V",	0x46c00007, 0xffff003f,	WR_D|RD_S|FP_D,		0,		I5	},
{"nmadd.d", "D,R,S,T",	0x4c000031, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_D, 0,		I4|I33	},
{"nmadd.s", "D,R,S,T",	0x4c000030, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_S, 0,		I4|I33	},
{"nmadd.ps","D,R,S,T",	0x4c000036, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_D, 0,		I5	},
{"nmsub.d", "D,R,S,T",	0x4c000039, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_D, 0,		I4|I33	},
{"nmsub.s", "D,R,S,T",	0x4c000038, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_S, 0,		I4|I33	},
{"nmsub.ps","D,R,S,T",	0x4c00003e, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_D, 0,		I5	},
/* nop is at the start of the table.  */
{"nor",     "d,v,t",	0x00000027, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I1	},
{"nor",     "t,r,I",	0,    (int) M_NOR_I,	INSN_MACRO,		0,		I1	},
{"nor.ob",  "X,Y,Q",	0x7800000f, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"nor.ob",  "D,S,T",	0x4ac0000f, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"nor.ob",  "D,S,T[e]",	0x4800000f, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"nor.ob",  "D,S,k",	0x4bc0000f, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"nor.qh",  "X,Y,Q",	0x7820000f, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"not",     "d,v",	0x00000027, 0xfc1f07ff,	WR_d|RD_s|RD_t,		0,		I1	},/*nor d,s,0*/
{"or",      "d,v,t",	0x00000025, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I1	},
{"or",      "t,r,I",	0,    (int) M_OR_I,	INSN_MACRO,		0,		I1	},
{"or.ob",   "X,Y,Q",	0x7800000e, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"or.ob",   "D,S,T",	0x4ac0000e, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"or.ob",   "D,S,T[e]",	0x4800000e, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"or.ob",   "D,S,k",	0x4bc0000e, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"or.qh",   "X,Y,Q",	0x7820000e, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"ori",     "t,r,i",	0x34000000, 0xfc000000,	WR_t|RD_s,		0,		I1	},
{"pabsdiff.ob", "X,Y,Q",0x78000009, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		SB1	},
{"pabsdiffc.ob", "Y,Q",	0x78000035, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	SB1	},
{"pavg.ob", "X,Y,Q",	0x78000008, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		SB1	},
{"pickf.ob", "X,Y,Q",	0x78000002, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"pickf.ob", "D,S,T",	0x4ac00002, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"pickf.ob", "D,S,T[e]",0x48000002, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"pickf.ob", "D,S,k",	0x4bc00002, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"pickf.qh", "X,Y,Q",	0x78200002, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"pickt.ob", "X,Y,Q",	0x78000003, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"pickt.ob", "D,S,T",	0x4ac00003, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"pickt.ob", "D,S,T[e]",0x48000003, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"pickt.ob", "D,S,k",	0x4bc00003, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"pickt.qh", "X,Y,Q",	0x78200003, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"pll.ps",  "D,V,T",	0x46c0002c, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I5	},
{"plu.ps",  "D,V,T",	0x46c0002d, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I5	},
  /* pref and prefx are at the start of the table.  */
{"pul.ps",  "D,V,T",	0x46c0002e, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I5	},
{"puu.ps",  "D,V,T",	0x46c0002f, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I5	},
{"rach.ob", "X",	0x7a00003f, 0xfffff83f,	WR_D|FP_D,		RD_MACC,	MX|SB1	},
{"rach.ob", "D",	0x4a00003f, 0xfffff83f,	WR_D,			0,		N54	},
{"rach.qh", "X",	0x7a20003f, 0xfffff83f,	WR_D|FP_D,		RD_MACC,	MX	},
{"racl.ob", "X",	0x7800003f, 0xfffff83f,	WR_D|FP_D,		RD_MACC,	MX|SB1	},
{"racl.ob", "D",	0x4800003f, 0xfffff83f,	WR_D,			0,		N54	},
{"racl.qh", "X",	0x7820003f, 0xfffff83f,	WR_D|FP_D,		RD_MACC,	MX	},
{"racm.ob", "X",	0x7900003f, 0xfffff83f,	WR_D|FP_D,		RD_MACC,	MX|SB1	},
{"racm.ob", "D",	0x4900003f, 0xfffff83f,	WR_D,			0,		N54	},
{"racm.qh", "X",	0x7920003f, 0xfffff83f,	WR_D|FP_D,		RD_MACC,	MX	},
{"recip.d", "D,S",	0x46200015, 0xffff003f, WR_D|RD_S|FP_D,		0,		I4|I33	},
{"recip.ps","D,S",	0x46c00015, 0xffff003f, WR_D|RD_S|FP_D,		0,		SB1	},
{"recip.s", "D,S",	0x46000015, 0xffff003f, WR_D|RD_S|FP_S,		0,		I4|I33	},
{"recip1.d",  "D,S",	0x4620001d, 0xffff003f,	WR_D|RD_S|FP_D,		0,		M3D	},
{"recip1.ps", "D,S",	0x46c0001d, 0xffff003f,	WR_D|RD_S|FP_S,		0,		M3D	},
{"recip1.s",  "D,S",	0x4600001d, 0xffff003f,	WR_D|RD_S|FP_S,		0,		M3D	},
{"recip2.d",  "D,S,T",	0x4620001c, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		M3D	},
{"recip2.ps", "D,S,T",	0x46c0001c, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0,		M3D	},
{"recip2.s",  "D,S,T",	0x4600001c, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0,		M3D	},
{"rem",     "z,s,t",    0x0000001a, 0xfc00ffff, RD_s|RD_t|WR_HILO,      0,		I1	},
{"rem",     "d,v,t",	0,    (int) M_REM_3,	INSN_MACRO,		0,		I1	},
{"rem",     "d,v,I",	0,    (int) M_REM_3I,	INSN_MACRO,		0,		I1	},
{"remu",    "z,s,t",    0x0000001b, 0xfc00ffff, RD_s|RD_t|WR_HILO,      0,		I1	},
{"remu",    "d,v,t",	0,    (int) M_REMU_3,	INSN_MACRO,		0,		I1	},
{"remu",    "d,v,I",	0,    (int) M_REMU_3I,	INSN_MACRO,		0,		I1	},
{"rdhwr",   "t,K",	0x7c00003b, 0xffe007ff, WR_t,			0,		I33	},
{"rdpgpr",  "d,w",	0x41400000, 0xffe007ff, WR_d,			0,		I33	},
{"rfe",     "",		0x42000010, 0xffffffff,	0,			0,		I1|T3	},
{"rnas.qh", "X,Q",	0x78200025, 0xfc20f83f,	WR_D|RD_T|FP_D,		RD_MACC,	MX	},
{"rnau.ob", "X,Q",	0x78000021, 0xfc20f83f,	WR_D|RD_T|FP_D,		RD_MACC,	MX|SB1	},
{"rnau.qh", "X,Q",	0x78200021, 0xfc20f83f,	WR_D|RD_T|FP_D,		RD_MACC,	MX	},
{"rnes.qh", "X,Q",	0x78200026, 0xfc20f83f,	WR_D|RD_T|FP_D,		RD_MACC,	MX	},
{"rneu.ob", "X,Q",	0x78000022, 0xfc20f83f,	WR_D|RD_T|FP_D,		RD_MACC,	MX|SB1	},
{"rneu.qh", "X,Q",	0x78200022, 0xfc20f83f,	WR_D|RD_T|FP_D,		RD_MACC,	MX	},
{"rol",     "d,v,t",	0,    (int) M_ROL,	INSN_MACRO,		0,		I1	},
{"rol",     "d,v,I",	0,    (int) M_ROL_I,	INSN_MACRO,		0,		I1	},
{"ror",     "d,v,t",	0,    (int) M_ROR,	INSN_MACRO,		0,		I1	},
{"ror",     "d,v,I",	0,    (int) M_ROR_I,	INSN_MACRO,		0,		I1	},
{"ror",	    "d,w,<",	0x00200002, 0xffe0003f,	WR_d|RD_t,		0,		N5|I33	},
{"rorv",    "d,t,s",	0x00000046, 0xfc0007ff,	RD_t|RD_s|WR_d,		0,		N5|I33	},
{"rotl",    "d,v,t",	0,    (int) M_ROL,	INSN_MACRO,		0,		I33	},
{"rotl",    "d,v,I",	0,    (int) M_ROL_I,	INSN_MACRO,		0,		I33	},
{"rotr",    "d,v,t",	0,    (int) M_ROR,	INSN_MACRO,		0,		I33	},
{"rotr",    "d,v,I",	0,    (int) M_ROR_I,	INSN_MACRO,		0,		I33	},
{"rotrv",   "d,t,s",	0x00000046, 0xfc0007ff,	RD_t|RD_s|WR_d,		0,		I33	},
{"round.l.d", "D,S",	0x46200008, 0xffff003f, WR_D|RD_S|FP_D,		0,		I3|I33	},
{"round.l.s", "D,S",	0x46000008, 0xffff003f, WR_D|RD_S|FP_S|FP_D,	0,		I3	},
{"round.w.d", "D,S",	0x4620000c, 0xffff003f, WR_D|RD_S|FP_S|FP_D,	0,		I2	},
{"round.w.s", "D,S",	0x4600000c, 0xffff003f, WR_D|RD_S|FP_S,		0,		I2	},
{"rsqrt.d", "D,S",	0x46200016, 0xffff003f, WR_D|RD_S|FP_D,		0,		I4|I33	},
{"rsqrt.ps","D,S",	0x46c00016, 0xffff003f, WR_D|RD_S|FP_D,		0,		SB1	},
{"rsqrt.s", "D,S",	0x46000016, 0xffff003f, WR_D|RD_S|FP_S,		0,		I4|I33	},
{"rsqrt1.d",  "D,S",	0x4620001e, 0xffff003f,	WR_D|RD_S|FP_D,		0,		M3D	},
{"rsqrt1.ps", "D,S",	0x46c0001e, 0xffff003f,	WR_D|RD_S|FP_S,		0,		M3D	},
{"rsqrt1.s",  "D,S",	0x4600001e, 0xffff003f,	WR_D|RD_S|FP_S,		0,		M3D	},
{"rsqrt2.d",  "D,S,T",	0x4620001f, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		M3D	},
{"rsqrt2.ps", "D,S,T",	0x46c0001f, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0,		M3D	},
{"rsqrt2.s",  "D,S,T",	0x4600001f, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0,		M3D	},
{"rzs.qh",  "X,Q",	0x78200024, 0xfc20f83f,	WR_D|RD_T|FP_D,		RD_MACC,	MX	},
{"rzu.ob",  "X,Q",	0x78000020, 0xfc20f83f,	WR_D|RD_T|FP_D,		RD_MACC,	MX|SB1	},
{"rzu.ob",  "D,k",	0x4bc00020, 0xffe0f83f,	WR_D|RD_S|RD_T,		0,		N54	},
{"rzu.qh",  "X,Q",	0x78200020, 0xfc20f83f,	WR_D|RD_T|FP_D,		RD_MACC,	MX	},
{"sb",      "t,o(b)",	0xa0000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I1	},
{"sb",      "t,A(b)",	0,    (int) M_SB_AB,	INSN_MACRO,		0,		I1	},
{"sc",	    "t,o(b)",	0xe0000000, 0xfc000000, SM|RD_t|WR_t|RD_b,	0,		I2	},
{"sc",	    "t,A(b)",	0,    (int) M_SC_AB,	INSN_MACRO,		0,		I2	},
{"scd",	    "t,o(b)",	0xf0000000, 0xfc000000, SM|RD_t|WR_t|RD_b,	0,		I3	},
{"scd",	    "t,A(b)",	0,    (int) M_SCD_AB,	INSN_MACRO,		0,		I3	},
{"sd",	    "t,o(b)",	0xfc000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I3	},
{"sd",      "t,o(b)",	0,    (int) M_SD_OB,	INSN_MACRO,		0,		I1	},
{"sd",      "t,A(b)",	0,    (int) M_SD_AB,	INSN_MACRO,		0,		I1	},
{"sdbbp",   "",		0x0000000e, 0xffffffff,	TRAP,           	0,		G2	},
{"sdbbp",   "c",	0x0000000e, 0xfc00ffff,	TRAP,			0,		G2	},
{"sdbbp",   "c,q",	0x0000000e, 0xfc00003f,	TRAP,			0,		G2	},
{"sdbbp",   "",         0x7000003f, 0xffffffff, TRAP,           	0,		I32     },
{"sdbbp",   "B",        0x7000003f, 0xfc00003f, TRAP,           	0,		I32     },
{"sdc1",    "T,o(b)",	0xf4000000, 0xfc000000, SM|RD_T|RD_b|FP_D,	0,		I2	},
{"sdc1",    "E,o(b)",	0xf4000000, 0xfc000000, SM|RD_T|RD_b|FP_D,	0,		I2	},
{"sdc1",    "T,A(b)",	0,    (int) M_SDC1_AB,	INSN_MACRO,		0,		I2	},
{"sdc1",    "E,A(b)",	0,    (int) M_SDC1_AB,	INSN_MACRO,		0,		I2	},
{"sdc2",    "E,o(b)",	0xf8000000, 0xfc000000, SM|RD_C2|RD_b,		0,		I2	},
{"sdc2",    "E,A(b)",	0,    (int) M_SDC2_AB,	INSN_MACRO,		0,		I2	},
{"sdc3",    "E,o(b)",	0xfc000000, 0xfc000000, SM|RD_C3|RD_b,		0,		I2	},
{"sdc3",    "E,A(b)",	0,    (int) M_SDC3_AB,	INSN_MACRO,		0,		I2	},
{"s.d",     "T,o(b)",	0xf4000000, 0xfc000000, SM|RD_T|RD_b|FP_D,	0,		I2	},
{"s.d",     "T,o(b)",	0,    (int) M_S_DOB,	INSN_MACRO,		0,		I1	},
{"s.d",     "T,A(b)",	0,    (int) M_S_DAB,	INSN_MACRO,		0,		I1	},
{"sdl",     "t,o(b)",	0xb0000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I3	},
{"sdl",     "t,A(b)",	0,    (int) M_SDL_AB,	INSN_MACRO,		0,		I3	},
{"sdr",     "t,o(b)",	0xb4000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I3	},
{"sdr",     "t,A(b)",	0,    (int) M_SDR_AB,	INSN_MACRO,		0,		I3	},
{"sdxc1",   "S,t(b)",   0x4c000009, 0xfc0007ff, SM|RD_S|RD_t|RD_b|FP_D,	0,		I4|I33	},
{"seb",     "d,w",	0x7c000420, 0xffe007ff,	WR_d|RD_t,		0,		I33	},
{"seh",     "d,w",	0x7c000620, 0xffe007ff,	WR_d|RD_t,		0,		I33	},
{"selsl",   "d,v,t",	0x00000005, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		L1	},
{"selsr",   "d,v,t",	0x00000001, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		L1	},
{"seq",     "d,v,t",	0,    (int) M_SEQ,	INSN_MACRO,		0,		I1	},
{"seq",     "d,v,I",	0,    (int) M_SEQ_I,	INSN_MACRO,		0,		I1	},
{"sge",     "d,v,t",	0,    (int) M_SGE,	INSN_MACRO,		0,		I1	},
{"sge",     "d,v,I",	0,    (int) M_SGE_I,	INSN_MACRO,		0,		I1	},
{"sgeu",    "d,v,t",	0,    (int) M_SGEU,	INSN_MACRO,		0,		I1	},
{"sgeu",    "d,v,I",	0,    (int) M_SGEU_I,	INSN_MACRO,		0,		I1	},
{"sgt",     "d,v,t",	0,    (int) M_SGT,	INSN_MACRO,		0,		I1	},
{"sgt",     "d,v,I",	0,    (int) M_SGT_I,	INSN_MACRO,		0,		I1	},
{"sgtu",    "d,v,t",	0,    (int) M_SGTU,	INSN_MACRO,		0,		I1	},
{"sgtu",    "d,v,I",	0,    (int) M_SGTU_I,	INSN_MACRO,		0,		I1	},
{"sh",      "t,o(b)",	0xa4000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I1	},
{"sh",      "t,A(b)",	0,    (int) M_SH_AB,	INSN_MACRO,		0,		I1	},
{"shfl.bfla.qh", "X,Y,Z", 0x7a20001f, 0xffe0003f, WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"shfl.mixh.ob", "X,Y,Z", 0x7980001f, 0xffe0003f, WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"shfl.mixh.ob", "D,S,T", 0x4980001f, 0xffe0003f, WR_D|RD_S|RD_T, 	0,		N54	},
{"shfl.mixh.qh", "X,Y,Z", 0x7820001f, 0xffe0003f, WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"shfl.mixl.ob", "X,Y,Z", 0x79c0001f, 0xffe0003f, WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"shfl.mixl.ob", "D,S,T", 0x49c0001f, 0xffe0003f, WR_D|RD_S|RD_T, 	0,		N54	},
{"shfl.mixl.qh", "X,Y,Z", 0x78a0001f, 0xffe0003f, WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"shfl.pach.ob", "X,Y,Z", 0x7900001f, 0xffe0003f, WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"shfl.pach.ob", "D,S,T", 0x4900001f, 0xffe0003f, WR_D|RD_S|RD_T, 	0,		N54	},
{"shfl.pach.qh", "X,Y,Z", 0x7920001f, 0xffe0003f, WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"shfl.pacl.ob", "D,S,T", 0x4940001f, 0xffe0003f, WR_D|RD_S|RD_T, 	0,		N54	},
{"shfl.repa.qh", "X,Y,Z", 0x7b20001f, 0xffe0003f, WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"shfl.repb.qh", "X,Y,Z", 0x7ba0001f, 0xffe0003f, WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"shfl.upsl.ob", "X,Y,Z", 0x78c0001f, 0xffe0003f, WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"sle",     "d,v,t",	0,    (int) M_SLE,	INSN_MACRO,		0,		I1	},
{"sle",     "d,v,I",	0,    (int) M_SLE_I,	INSN_MACRO,		0,		I1	},
{"sleu",    "d,v,t",	0,    (int) M_SLEU,	INSN_MACRO,		0,		I1	},
{"sleu",    "d,v,I",	0,    (int) M_SLEU_I,	INSN_MACRO,		0,		I1	},
{"sllv",    "d,t,s",	0x00000004, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I1	},
{"sll",     "d,w,s",	0x00000004, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I1	}, /* sllv */
{"sll",     "d,w,<",	0x00000000, 0xffe0003f,	WR_d|RD_t,		0,		I1	},
{"sll.ob",  "X,Y,Q",	0x78000010, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"sll.ob",  "D,S,T[e]",	0x48000010, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"sll.ob",  "D,S,k",	0x4bc00010, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"sll.qh",  "X,Y,Q",	0x78200010, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"slt",     "d,v,t",	0x0000002a, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I1	},
{"slt",     "d,v,I",	0,    (int) M_SLT_I,	INSN_MACRO,		0,		I1	},
{"slti",    "t,r,j",	0x28000000, 0xfc000000,	WR_t|RD_s,		0,		I1	},
{"sltiu",   "t,r,j",	0x2c000000, 0xfc000000,	WR_t|RD_s,		0,		I1	},
{"sltu",    "d,v,t",	0x0000002b, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I1	},
{"sltu",    "d,v,I",	0,    (int) M_SLTU_I,	INSN_MACRO,		0,		I1	},
{"sne",     "d,v,t",	0,    (int) M_SNE,	INSN_MACRO,		0,		I1	},
{"sne",     "d,v,I",	0,    (int) M_SNE_I,	INSN_MACRO,		0,		I1	},
{"sqrt.d",  "D,S",	0x46200004, 0xffff003f, WR_D|RD_S|FP_D,		0,		I2	},
{"sqrt.s",  "D,S",	0x46000004, 0xffff003f, WR_D|RD_S|FP_S,		0,		I2	},
{"sqrt.ps", "D,S",	0x46c00004, 0xffff003f, WR_D|RD_S|FP_D,		0,		SB1	},
{"srav",    "d,t,s",	0x00000007, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I1	},
{"sra",     "d,w,s",	0x00000007, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I1	}, /* srav */
{"sra",     "d,w,<",	0x00000003, 0xffe0003f,	WR_d|RD_t,		0,		I1	},
{"sra.qh",  "X,Y,Q",	0x78200013, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"srlv",    "d,t,s",	0x00000006, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I1	},
{"srl",     "d,w,s",	0x00000006, 0xfc0007ff,	WR_d|RD_t|RD_s,		0,		I1	}, /* srlv */
{"srl",     "d,w,<",	0x00000002, 0xffe0003f,	WR_d|RD_t,		0,		I1	},
{"srl.ob",  "X,Y,Q",	0x78000012, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"srl.ob",  "D,S,T[e]",	0x48000012, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"srl.ob",  "D,S,k",	0x4bc00012, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"srl.qh",  "X,Y,Q",	0x78200012, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
/* ssnop is at the start of the table.  */
{"standby", "",         0x42000021, 0xffffffff,	0,			0,		V1	},
{"sub",     "d,v,t",	0x00000022, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I1	},
{"sub",     "d,v,I",	0,    (int) M_SUB_I,	INSN_MACRO,		0,		I1	},
{"sub.d",   "D,V,T",	0x46200001, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I1	},
{"sub.s",   "D,V,T",	0x46000001, 0xffe0003f,	WR_D|RD_S|RD_T|FP_S,	0,		I1	},
{"sub.ob",  "X,Y,Q",	0x7800000a, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"sub.ob",  "D,S,T",	0x4ac0000a, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"sub.ob",  "D,S,T[e]",	0x4800000a, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"sub.ob",  "D,S,k",	0x4bc0000a, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"sub.ps",  "D,V,T",	0x46c00001, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I5	},
{"sub.qh",  "X,Y,Q",	0x7820000a, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"suba.ob", "Y,Q",	0x78000036, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX|SB1	},
{"suba.qh", "Y,Q",	0x78200036, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX	},
{"subl.ob", "Y,Q",	0x78000436, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX|SB1	},
{"subl.qh", "Y,Q",	0x78200436, 0xfc2007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX	},
{"subu",    "d,v,t",	0x00000023, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I1	},
{"subu",    "d,v,I",	0,    (int) M_SUBU_I,	INSN_MACRO,		0,		I1	},
{"suspend", "",         0x42000022, 0xffffffff,	0,			0,		V1	},
{"suxc1",   "S,t(b)",   0x4c00000d, 0xfc0007ff, SM|RD_S|RD_t|RD_b,	0,		I5|N55	},
{"sw",      "t,o(b)",	0xac000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I1	},
{"sw",      "t,A(b)",	0,    (int) M_SW_AB,	INSN_MACRO,		0,		I1	},
{"swc0",    "E,o(b)",	0xe0000000, 0xfc000000,	SM|RD_C0|RD_b,		0,		I1	},
{"swc0",    "E,A(b)",	0,    (int) M_SWC0_AB,	INSN_MACRO,		0,		I1	},
{"swc1",    "T,o(b)",	0xe4000000, 0xfc000000,	SM|RD_T|RD_b|FP_S,	0,		I1	},
{"swc1",    "E,o(b)",	0xe4000000, 0xfc000000,	SM|RD_T|RD_b|FP_S,	0,		I1	},
{"swc1",    "T,A(b)",	0,    (int) M_SWC1_AB,	INSN_MACRO,		0,		I1	},
{"swc1",    "E,A(b)",	0,    (int) M_SWC1_AB,	INSN_MACRO,		0,		I1	},
{"s.s",     "T,o(b)",	0xe4000000, 0xfc000000,	SM|RD_T|RD_b|FP_S,	0,		I1	}, /* swc1 */
{"s.s",     "T,A(b)",	0,    (int) M_SWC1_AB,	INSN_MACRO,		0,		I1	},
{"swc2",    "E,o(b)",	0xe8000000, 0xfc000000,	SM|RD_C2|RD_b,		0,		I1	},
{"swc2",    "E,A(b)",	0,    (int) M_SWC2_AB,	INSN_MACRO,		0,		I1	},
{"swc3",    "E,o(b)",	0xec000000, 0xfc000000,	SM|RD_C3|RD_b,		0,		I1	},
{"swc3",    "E,A(b)",	0,    (int) M_SWC3_AB,	INSN_MACRO,		0,		I1	},
{"swl",     "t,o(b)",	0xa8000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I1	},
{"swl",     "t,A(b)",	0,    (int) M_SWL_AB,	INSN_MACRO,		0,		I1	},
{"scache",  "t,o(b)",	0xa8000000, 0xfc000000,	RD_t|RD_b,		0,		I2	}, /* same */
{"scache",  "t,A(b)",	0,    (int) M_SWL_AB,	INSN_MACRO,		0,		I2	}, /* as swl */
{"swr",     "t,o(b)",	0xb8000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I1	},
{"swr",     "t,A(b)",	0,    (int) M_SWR_AB,	INSN_MACRO,		0,		I1	},
{"invalidate", "t,o(b)",0xb8000000, 0xfc000000,	RD_t|RD_b,		0,		I2	}, /* same */
{"invalidate", "t,A(b)",0,    (int) M_SWR_AB,	INSN_MACRO,		0,		I2	}, /* as swr */
{"swxc1",   "S,t(b)",   0x4c000008, 0xfc0007ff, SM|RD_S|RD_t|RD_b|FP_S,	0,		I4|I33	},
{"sync",    "",		0x0000000f, 0xffffffff,	INSN_SYNC,		0,		I2|G1	},
{"sync.p",  "",		0x0000040f, 0xffffffff,	INSN_SYNC,		0,		I2	},
{"sync.l",  "",		0x0000000f, 0xffffffff,	INSN_SYNC,		0,		I2	},
{"synci",   "o(b)",	0x041f0000, 0xfc1f0000,	SM|RD_b,		0,		I33	},
{"syscall", "",		0x0000000c, 0xffffffff,	TRAP,			0,		I1	},
{"syscall", "B",	0x0000000c, 0xfc00003f,	TRAP,			0,		I1	},
{"teqi",    "s,j",	0x040c0000, 0xfc1f0000, RD_s|TRAP,		0,		I2	},
{"teq",	    "s,t",	0x00000034, 0xfc00ffff, RD_s|RD_t|TRAP,		0,		I2	},
{"teq",	    "s,t,q",	0x00000034, 0xfc00003f, RD_s|RD_t|TRAP,		0,		I2	},
{"teq",     "s,j",	0x040c0000, 0xfc1f0000, RD_s|TRAP,		0,		I2	}, /* teqi */
{"teq",     "s,I",	0,    (int) M_TEQ_I,	INSN_MACRO,		0,		I2	},
{"tgei",    "s,j",	0x04080000, 0xfc1f0000, RD_s|TRAP,		0,		I2	},
{"tge",	    "s,t",	0x00000030, 0xfc00ffff,	RD_s|RD_t|TRAP,		0,		I2	},
{"tge",	    "s,t,q",	0x00000030, 0xfc00003f,	RD_s|RD_t|TRAP,		0,		I2	},
{"tge",     "s,j",	0x04080000, 0xfc1f0000, RD_s|TRAP,		0,		I2	}, /* tgei */
{"tge",	    "s,I",	0,    (int) M_TGE_I,    INSN_MACRO,		0,		I2	},
{"tgeiu",   "s,j",	0x04090000, 0xfc1f0000, RD_s|TRAP,		0,		I2	},
{"tgeu",    "s,t",	0x00000031, 0xfc00ffff, RD_s|RD_t|TRAP,		0,		I2	},
{"tgeu",    "s,t,q",	0x00000031, 0xfc00003f, RD_s|RD_t|TRAP,		0,		I2	},
{"tgeu",    "s,j",	0x04090000, 0xfc1f0000, RD_s|TRAP,		0,		I2	}, /* tgeiu */
{"tgeu",    "s,I",	0,    (int) M_TGEU_I,	INSN_MACRO,		0,		I2	},
{"tlbp",    "",         0x42000008, 0xffffffff, INSN_TLB,       	0,		I1   	},
{"tlbr",    "",         0x42000001, 0xffffffff, INSN_TLB,       	0,		I1   	},
{"tlbwi",   "",         0x42000002, 0xffffffff, INSN_TLB,       	0,		I1   	},
{"tlbwr",   "",         0x42000006, 0xffffffff, INSN_TLB,       	0,		I1   	},
{"tlti",    "s,j",	0x040a0000, 0xfc1f0000,	RD_s|TRAP,		0,		I2	},
{"tlt",     "s,t",	0x00000032, 0xfc00ffff, RD_s|RD_t|TRAP,		0,		I2	},
{"tlt",     "s,t,q",	0x00000032, 0xfc00003f, RD_s|RD_t|TRAP,		0,		I2	},
{"tlt",     "s,j",	0x040a0000, 0xfc1f0000,	RD_s|TRAP,		0,		I2	}, /* tlti */
{"tlt",     "s,I",	0,    (int) M_TLT_I,	INSN_MACRO,		0,		I2	},
{"tltiu",   "s,j",	0x040b0000, 0xfc1f0000, RD_s|TRAP,		0,		I2	},
{"tltu",    "s,t",	0x00000033, 0xfc00ffff, RD_s|RD_t|TRAP,		0,		I2	},
{"tltu",    "s,t,q",	0x00000033, 0xfc00003f, RD_s|RD_t|TRAP,		0,		I2	},
{"tltu",    "s,j",	0x040b0000, 0xfc1f0000, RD_s|TRAP,		0,		I2	}, /* tltiu */
{"tltu",    "s,I",	0,    (int) M_TLTU_I,	INSN_MACRO,		0,		I2	},
{"tnei",    "s,j",	0x040e0000, 0xfc1f0000, RD_s|TRAP,		0,		I2	},
{"tne",     "s,t",	0x00000036, 0xfc00ffff, RD_s|RD_t|TRAP,		0,		I2	},
{"tne",     "s,t,q",	0x00000036, 0xfc00003f, RD_s|RD_t|TRAP,		0,		I2	},
{"tne",     "s,j",	0x040e0000, 0xfc1f0000, RD_s|TRAP,		0,		I2	}, /* tnei */
{"tne",     "s,I",	0,    (int) M_TNE_I,	INSN_MACRO,		0,		I2	},
{"trunc.l.d", "D,S",	0x46200009, 0xffff003f, WR_D|RD_S|FP_D,		0,		I3|I33	},
{"trunc.l.s", "D,S",	0x46000009, 0xffff003f,	WR_D|RD_S|FP_S|FP_D,	0,		I3|I33	},
{"trunc.w.d", "D,S",	0x4620000d, 0xffff003f, WR_D|RD_S|FP_S|FP_D,	0,		I2	},
{"trunc.w.d", "D,S,x",	0x4620000d, 0xffff003f, WR_D|RD_S|FP_S|FP_D,	0,		I2	},
{"trunc.w.d", "D,S,t",	0,    (int) M_TRUNCWD,	INSN_MACRO,		0,		I1	},
{"trunc.w.s", "D,S",	0x4600000d, 0xffff003f,	WR_D|RD_S|FP_S,		0,		I2	},
{"trunc.w.s", "D,S,x",	0x4600000d, 0xffff003f,	WR_D|RD_S|FP_S,		0,		I2	},
{"trunc.w.s", "D,S,t",	0,    (int) M_TRUNCWS,	INSN_MACRO,		0,		I1	},
{"uld",     "t,o(b)",	0,    (int) M_ULD,	INSN_MACRO,		0,		I3	},
{"uld",     "t,A(b)",	0,    (int) M_ULD_A,	INSN_MACRO,		0,		I3	},
{"ulh",     "t,o(b)",	0,    (int) M_ULH,	INSN_MACRO,		0,		I1	},
{"ulh",     "t,A(b)",	0,    (int) M_ULH_A,	INSN_MACRO,		0,		I1	},
{"ulhu",    "t,o(b)",	0,    (int) M_ULHU,	INSN_MACRO,		0,		I1	},
{"ulhu",    "t,A(b)",	0,    (int) M_ULHU_A,	INSN_MACRO,		0,		I1	},
{"ulw",     "t,o(b)",	0,    (int) M_ULW,	INSN_MACRO,		0,		I1	},
{"ulw",     "t,A(b)",	0,    (int) M_ULW_A,	INSN_MACRO,		0,		I1	},
{"usd",     "t,o(b)",	0,    (int) M_USD,	INSN_MACRO,		0,		I3	},
{"usd",     "t,A(b)",	0,    (int) M_USD_A,	INSN_MACRO,		0,		I3	},
{"ush",     "t,o(b)",	0,    (int) M_USH,	INSN_MACRO,		0,		I1	},
{"ush",     "t,A(b)",	0,    (int) M_USH_A,	INSN_MACRO,		0,		I1	},
{"usw",     "t,o(b)",	0,    (int) M_USW,	INSN_MACRO,		0,		I1	},
{"usw",     "t,A(b)",	0,    (int) M_USW_A,	INSN_MACRO,		0,		I1	},
{"wach.ob", "Y",	0x7a00003e, 0xffff07ff,	RD_S|FP_D,		WR_MACC,	MX|SB1	},
{"wach.ob", "S",	0x4a00003e, 0xffff07ff,	RD_S,			0,		N54	},
{"wach.qh", "Y",	0x7a20003e, 0xffff07ff,	RD_S|FP_D,		WR_MACC,	MX	},
{"wacl.ob", "Y,Z",	0x7800003e, 0xffe007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX|SB1	},
{"wacl.ob", "S,T",	0x4800003e, 0xffe007ff,	RD_S|RD_T,		0,		N54	},
{"wacl.qh", "Y,Z",	0x7820003e, 0xffe007ff,	RD_S|RD_T|FP_D,		WR_MACC,	MX	},
{"wait",    "",         0x42000020, 0xffffffff, TRAP,   		0,		I3|I32	},
{"wait",    "J",        0x42000020, 0xfe00003f, TRAP,   		0,		I32|N55	},
{"waiti",   "",		0x42000020, 0xffffffff,	TRAP,			0,		L1	},
{"wb", 	    "o(b)",	0xbc040000, 0xfc1f0000, SM|RD_b,		0,		L1	},
{"wrpgpr",  "d,w",	0x41c00000, 0xffe007ff, RD_t,			0,		I33	},
{"wsbh",    "d,w",	0x7c0000a0, 0xffe007ff,	WR_d|RD_t,		0,		I33	},
{"xor",     "d,v,t",	0x00000026, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I1	},
{"xor",     "t,r,I",	0,    (int) M_XOR_I,	INSN_MACRO,		0,		I1	},
{"xor.ob",  "X,Y,Q",	0x7800000d, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
{"xor.ob",  "D,S,T",	0x4ac0000d, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"xor.ob",  "D,S,T[e]",	0x4800000d, 0xfe20003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"xor.ob",  "D,S,k",	0x4bc0000d, 0xffe0003f,	WR_D|RD_S|RD_T,		0,		N54	},
{"xor.qh",  "X,Y,Q",	0x7820000d, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX	},
{"xori",    "t,r,i",	0x38000000, 0xfc000000,	WR_t|RD_s,		0,		I1	},
{"yield",   "s",	0x7c000009, 0xfc1fffff, TRAP|RD_s,		0,		MT32	},
{"yield",   "d,s",	0x7c000009, 0xfc1f07ff, TRAP|WR_d|RD_s,		0,		MT32	},

/* Coprocessor 2 move/branch operations overlap with VR5400 .ob format
   instructions so they are here for the latters to take precedence.  */
{"bc2f",    "p",	0x49000000, 0xffff0000,	CBD|RD_CC,		0,		I1	},
{"bc2fl",   "p",	0x49020000, 0xffff0000,	CBL|RD_CC,		0,		I2|T3	},
{"bc2t",    "p",	0x49010000, 0xffff0000,	CBD|RD_CC,		0,		I1	},
{"bc2tl",   "p",	0x49030000, 0xffff0000,	CBL|RD_CC,		0,		I2|T3	},
{"cfc2",    "t,G",	0x48400000, 0xffe007ff,	LCD|WR_t|RD_C2,		0,		I1	},
{"ctc2",    "t,G",	0x48c00000, 0xffe007ff,	COD|RD_t|WR_CC,		0,		I1	},
{"dmfc2",   "t,G",	0x48200000, 0xffe007ff,	LCD|WR_t|RD_C2,		0,		I3	},
{"dmfc2",   "t,G,H",	0x48200000, 0xffe007f8,	LCD|WR_t|RD_C2,		0,		I64	},
{"dmtc2",   "t,G",	0x48a00000, 0xffe007ff,	COD|RD_t|WR_C2|WR_CC,	0,		I3	},
{"dmtc2",   "t,G,H",	0x48a00000, 0xffe007f8,	COD|RD_t|WR_C2|WR_CC,	0,		I64	},
{"mfc2",    "t,G",	0x48000000, 0xffe007ff,	LCD|WR_t|RD_C2,		0,		I1	},
{"mfc2",    "t,G,H",	0x48000000, 0xffe007f8,	LCD|WR_t|RD_C2,		0,		I32	},
{"mfhc2",   "t,i",	0x48600000, 0xffe00000,	LCD|WR_t|RD_C2,		0,		I33	},
{"mtc2",    "t,G",	0x48800000, 0xffe007ff,	COD|RD_t|WR_C2|WR_CC,	0,		I1	},
{"mtc2",    "t,G,H",	0x48800000, 0xffe007f8,	COD|RD_t|WR_C2|WR_CC,	0,		I32	},
{"mthc2",   "t,i",	0x48e00000, 0xffe00000,	COD|RD_t|WR_C2|WR_CC,	0,		I33	},

/* No hazard protection on coprocessor instructions--they shouldn't
   change the state of the processor and if they do it's up to the
   user to put in nops as necessary.  These are at the end so that the
   disassembler recognizes more specific versions first.  */
{"c0",      "C",	0x42000000, 0xfe000000,	0,			0,		I1	},
{"c1",      "C",	0x46000000, 0xfe000000,	0,			0,		I1	},
{"c2",      "C",	0x4a000000, 0xfe000000,	0,			0,		I1	},
{"c3",      "C",	0x4e000000, 0xfe000000,	0,			0,		I1	},
{"cop0",     "C",	0,    (int) M_COP0,	INSN_MACRO,		0,		I1	},
{"cop1",     "C",	0,    (int) M_COP1,	INSN_MACRO,		0,		I1	},
{"cop2",     "C",	0,    (int) M_COP2,	INSN_MACRO,		0,		I1	},
{"cop3",     "C",	0,    (int) M_COP3,	INSN_MACRO,		0,		I1	},

  /* Conflicts with the 4650's "mul" instruction.  Nobody's using the
     4010 any more, so move this insn out of the way.  If the object
     format gave us more info, we could do this right.  */
{"addciu",  "t,r,j",	0x70000000, 0xfc000000,	WR_t|RD_s,		0,		L1	},
/* MIPS DSP ASE */
{"absq_s.ph", "d,t",	0x7c000252, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"absq_s.w", "d,t",	0x7c000452, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"addq.ph", "d,s,t",	0x7c000290, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"addq_s.ph", "d,s,t",	0x7c000390, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"addq_s.w", "d,s,t",	0x7c000590, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"addsc",   "d,s,t",	0x7c000410, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"addu.qb", "d,s,t",	0x7c000010, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"addu_s.qb", "d,s,t",	0x7c000110, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"addwc",   "d,s,t",	0x7c000450, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"bitrev",  "d,t",	0x7c0006d2, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"bposge32", "p",	0x041c0000, 0xffff0000, CBD,			0,		D32	},
{"cmp.eq.ph", "s,t",	0x7c000211, 0xfc00ffff, RD_s|RD_t,		0,		D32	},
{"cmpgu.eq.qb", "d,s,t", 0x7c000111, 0xfc0007ff, WR_d|RD_s|RD_t,	0,		D32	},
{"cmpgu.le.qb", "d,s,t", 0x7c000191, 0xfc0007ff, WR_d|RD_s|RD_t,	0,		D32	},
{"cmpgu.lt.qb", "d,s,t", 0x7c000151, 0xfc0007ff, WR_d|RD_s|RD_t,	0,		D32	},
{"cmp.le.ph", "s,t",	0x7c000291, 0xfc00ffff, RD_s|RD_t,		0,		D32	},
{"cmp.lt.ph", "s,t",	0x7c000251, 0xfc00ffff, RD_s|RD_t,		0,		D32	},
{"cmpu.eq.qb", "s,t",	0x7c000011, 0xfc00ffff, RD_s|RD_t,		0,		D32	},
{"cmpu.le.qb", "s,t",	0x7c000091, 0xfc00ffff, RD_s|RD_t,		0,		D32	},
{"cmpu.lt.qb", "s,t",	0x7c000051, 0xfc00ffff, RD_s|RD_t,		0,		D32	},
{"dpaq_sa.l.w", "7,s,t", 0x7c000330, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"dpaq_s.w.ph", "7,s,t", 0x7c000130, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"dpau.h.qbl", "7,s,t",	0x7c0000f0, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"dpau.h.qbr", "7,s,t",	0x7c0001f0, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"dpsq_sa.l.w", "7,s,t", 0x7c000370, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"dpsq_s.w.ph", "7,s,t", 0x7c000170, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"dpsu.h.qbl", "7,s,t",	0x7c0002f0, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"dpsu.h.qbr", "7,s,t",	0x7c0003f0, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"extpdp",  "t,7,6",	0x7c0002b8, 0xfc00e7ff, WR_t|RD_a|DSP_VOLA,	0,		D32	},
{"extpdpv", "t,7,s",	0x7c0002f8, 0xfc00e7ff, WR_t|RD_a|RD_s|DSP_VOLA, 0,		D32	},
{"extp",    "t,7,6",	0x7c0000b8, 0xfc00e7ff, WR_t|RD_a,		0,		D32	},
{"extpv",   "t,7,s",	0x7c0000f8, 0xfc00e7ff, WR_t|RD_a|RD_s,		0,		D32	},
{"extr_rs.w", "t,7,6",	0x7c0001b8, 0xfc00e7ff, WR_t|RD_a,		0,		D32	},
{"extr_r.w", "t,7,6",	0x7c000138, 0xfc00e7ff, WR_t|RD_a,		0,		D32	},
{"extr_s.h", "t,7,6",	0x7c0003b8, 0xfc00e7ff, WR_t|RD_a,		0,		D32	},
{"extrv_rs.w", "t,7,s",	0x7c0001f8, 0xfc00e7ff, WR_t|RD_a|RD_s,		0,		D32	},
{"extrv_r.w", "t,7,s",	0x7c000178, 0xfc00e7ff, WR_t|RD_a|RD_s,		0,		D32	},
{"extrv_s.h", "t,7,s",	0x7c0003f8, 0xfc00e7ff, WR_t|RD_a|RD_s,		0,		D32	},
{"extrv.w", "t,7,s",	0x7c000078, 0xfc00e7ff, WR_t|RD_a|RD_s,		0,		D32	},
{"extr.w",  "t,7,6",	0x7c000038, 0xfc00e7ff, WR_t|RD_a,		0,		D32	},
{"insv",    "t,s",	0x7c00000c, 0xfc00ffff, WR_t|RD_s,		0,		D32	},
{"lbux",    "d,t(b)",	0x7c00018a, 0xfc0007ff, LDD|WR_d|RD_t|RD_b,	0,		D32	},
{"lhx",     "d,t(b)",	0x7c00010a, 0xfc0007ff, LDD|WR_d|RD_t|RD_b,	0,		D32	},
{"lwx",     "d,t(b)",	0x7c00000a, 0xfc0007ff, LDD|WR_d|RD_t|RD_b,	0,		D32	},
{"maq_sa.w.phl", "7,s,t", 0x7c000430, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"maq_sa.w.phr", "7,s,t", 0x7c0004b0, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"maq_s.w.phl", "7,s,t", 0x7c000530, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"maq_s.w.phr", "7,s,t", 0x7c0005b0, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"modsub",  "d,s,t",	0x7c000490, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"mthlip",  "s,7",	0x7c0007f8, 0xfc1fe7ff, RD_s|MOD_a|DSP_VOLA,	0,		D32	},
{"muleq_s.w.phl", "d,s,t", 0x7c000710, 0xfc0007ff, WR_d|RD_s|RD_t|WR_HILO, 0,		D32	},
{"muleq_s.w.phr", "d,s,t", 0x7c000750, 0xfc0007ff, WR_d|RD_s|RD_t|WR_HILO, 0,		D32	},
{"muleu_s.ph.qbl", "d,s,t", 0x7c000190, 0xfc0007ff, WR_d|RD_s|RD_t|WR_HILO, 0,		D32	},
{"muleu_s.ph.qbr", "d,s,t", 0x7c0001d0, 0xfc0007ff, WR_d|RD_s|RD_t|WR_HILO, 0,		D32	},
{"mulq_rs.ph", "d,s,t",	0x7c0007d0, 0xfc0007ff, WR_d|RD_s|RD_t|WR_HILO,	0,		D32	},
{"mulsaq_s.w.ph", "7,s,t", 0x7c0001b0, 0xfc00e7ff, MOD_a|RD_s|RD_t,	0,		D32	},
{"packrl.ph", "d,s,t",	0x7c000391, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"pick.ph", "d,s,t",	0x7c0002d1, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"pick.qb", "d,s,t",	0x7c0000d1, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"precequ.ph.qbla", "d,t", 0x7c000192, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"precequ.ph.qbl", "d,t", 0x7c000112, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"precequ.ph.qbra", "d,t", 0x7c0001d2, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"precequ.ph.qbr", "d,t", 0x7c000152, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"preceq.w.phl", "d,t",	0x7c000312, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"preceq.w.phr", "d,t",	0x7c000352, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"preceu.ph.qbla", "d,t", 0x7c000792, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"preceu.ph.qbl", "d,t", 0x7c000712, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"preceu.ph.qbra", "d,t", 0x7c0007d2, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"preceu.ph.qbr", "d,t", 0x7c000752, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"precrq.ph.w", "d,s,t", 0x7c000511, 0xfc0007ff, WR_d|RD_s|RD_t,	0,		D32	},
{"precrq.qb.ph", "d,s,t", 0x7c000311, 0xfc0007ff, WR_d|RD_s|RD_t,	0,		D32	},
{"precrq_rs.ph.w", "d,s,t", 0x7c000551, 0xfc0007ff, WR_d|RD_s|RD_t,	0,		D32	},
{"precrqu_s.qb.ph", "d,s,t", 0x7c0003d1, 0xfc0007ff, WR_d|RD_s|RD_t,	0,		D32	},
{"raddu.w.qb", "d,s",	0x7c000510, 0xfc1f07ff, WR_d|RD_s,		0,		D32	},
{"rddsp",   "d",	0x7fff04b8, 0xffff07ff, WR_d,			0,		D32	},
{"rddsp",   "d,'",	0x7c0004b8, 0xffc007ff, WR_d,			0,		D32	},
{"repl.ph", "d,@",	0x7c000292, 0xfc0007ff, WR_d,			0,		D32	},
{"repl.qb", "d,5",	0x7c000092, 0xff0007ff, WR_d,			0,		D32	},
{"replv.ph", "d,t",	0x7c0002d2, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"replv.qb", "d,t",	0x7c0000d2, 0xffe007ff, WR_d|RD_t,		0,		D32	},
{"shilo",   "7,0",	0x7c0006b8, 0xfc0fe7ff, MOD_a,			0,		D32	},
{"shilov",  "7,s",	0x7c0006f8, 0xfc1fe7ff, MOD_a|RD_s,		0,		D32	},
{"shll.ph", "d,t,4",	0x7c000213, 0xfe0007ff, WR_d|RD_t,		0,		D32	},
{"shll.qb", "d,t,3",	0x7c000013, 0xff0007ff, WR_d|RD_t,		0,		D32	},
{"shll_s.ph", "d,t,4",	0x7c000313, 0xfe0007ff, WR_d|RD_t,		0,		D32	},
{"shll_s.w", "d,t,6",	0x7c000513, 0xfc0007ff, WR_d|RD_t,		0,		D32	},
{"shllv.ph", "d,t,s",	0x7c000293, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"shllv.qb", "d,t,s",	0x7c000093, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"shllv_s.ph", "d,t,s",	0x7c000393, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"shllv_s.w", "d,t,s",	0x7c000593, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"shra.ph", "d,t,4",	0x7c000253, 0xfe0007ff, WR_d|RD_t,		0,		D32	},
{"shra_r.ph", "d,t,4",	0x7c000353, 0xfe0007ff, WR_d|RD_t,		0,		D32	},
{"shra_r.w", "d,t,6",	0x7c000553, 0xfc0007ff, WR_d|RD_t,		0,		D32	},
{"shrav.ph", "d,t,s",	0x7c0002d3, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"shrav_r.ph", "d,t,s",	0x7c0003d3, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"shrav_r.w", "d,t,s",	0x7c0005d3, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"shrl.qb", "d,t,3",	0x7c000053, 0xff0007ff, WR_d|RD_t,		0,		D32	},
{"shrlv.qb", "d,t,s",	0x7c0000d3, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"subq.ph", "d,s,t",	0x7c0002d0, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"subq_s.ph", "d,s,t",	0x7c0003d0, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"subq_s.w", "d,s,t",	0x7c0005d0, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"subu.qb", "d,s,t",	0x7c000050, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"subu_s.qb", "d,s,t",	0x7c000150, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		D32	},
{"wrdsp",   "s",	0x7c1ffcf8, 0xfc1fffff, RD_s|DSP_VOLA,		0,		D32	},
{"wrdsp",   "s,8",	0x7c0004f8, 0xfc1e07ff, RD_s|DSP_VOLA,		0,		D32	},
/* Move bc0* after mftr and mttr to avoid opcode collision.  */
{"bc0f",    "p",	0x41000000, 0xffff0000,	CBD|RD_CC,		0,		I1	},
{"bc0fl",   "p",	0x41020000, 0xffff0000,	CBL|RD_CC,		0,		I2|T3	},
{"bc0t",    "p",	0x41010000, 0xffff0000,	CBD|RD_CC,		0,		I1	},
{"bc0tl",   "p",	0x41030000, 0xffff0000,	CBL|RD_CC,		0,		I2|T3	},
};
#endif

#define MIPS_NUM_OPCODES \
	((sizeof mips_builtin_opcodes) / (sizeof (mips_builtin_opcodes[0])))
const int bfd_mips_num_builtin_opcodes = MIPS_NUM_OPCODES;

/* const removed from the following to allow for dynamic extensions to the
 * built-in instruction set. */
struct mips_opcode *mips_opcodes =
  (struct mips_opcode *) mips_builtin_opcodes;
int bfd_mips_num_opcodes = MIPS_NUM_OPCODES;
#undef MIPS_NUM_OPCODES
