#include <regs.h>
#include <dma.h>
#include <cache.h>
#include <addrmap.h>

	.text
	.align 4

	.globl	_start
	.global boot
	.ent	_start
_start:
	.set 	noreorder
	.set 	volatile

	nop
	nop
	nop
	nop

	la	gp, _gp
	li	t0, 0x32 /* magic number */
mem_wait_loop:
	addiu	t0, t0, -1
	bne	zero, t0, mem_wait_loop
	nop
	
#if 0
_128bit_sdram:
	la	t0, 0xfffff000
	li	t1, 0x01
	sw	t1, 0x20(t0) # 128-bit SDRAM
#else
_32bit_sdram:
	la	t0, 0xfffff000
	sw	zero, 0x20(t0) # 32-bit SDRAM
#endif
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

_256MB_sdram_module:
	lui	t1, 0x0031
	ori	t1, t1, 0x0131
	sw	t1, 0x0c(t0)
#if 0 /* Hynix double */
	la	t1, 0x00020d09
#else /* Hynix single */
	la	t1, 0x00010d0a
#endif
	sw	t1, 0x04(t0)
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

_refresh_counter:
	li	t2, 0xf9
	sw	t2, 0x1c(t0)

	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

_start_sdram:
	la	t0, 0xfffff000
	sw  	zero, 0(t0)

#if 0
_start_link_sdram:
	la	t0, 0xffffe000
	sw  	zero, 0(t0)
#endif
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

_clear_bss:
	la	t0, _bss_start	# _bss_start
	la	t1, _end	# _end

	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
_clear_bss_loop:
	sw	zero, 0(t0)
	nop
	nop
	nop
	nop
	bltu	t0, t1, _clear_bss_loop
	addiu	t0, t0, 4

	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

#if 0
_cache_on_all:
	la	t0, CACHE_ON_ALL
	la	t1, RMT_ICACHE_ON
	mtc0	t0, t1
#endif


#
# MDA transfer
#
_dma_setting:
	la      t0, DMAC_TMC(0,0)
        la      t1, DMAC_PSA(0,0)
        la      t2, DMAC_MDA(0,0)
        la      t3, DMAC_LN(0,0)
	la	t4, _end - FIRM_START # length
	la	t5, FIRM_START # sdram start address

_transfer: # rom to sdram
	sw      zero, 0(t0)             # reset TMC
        sw      zero, 0(t1)		# set PSA 0x00000000
        sw      t5, 0(t2)               # set MDA LOAD_ADDRESS
        li      t6, DMA_ROM2SDRAM       # set DMA mode (rom to sdram)
        sw      t4, 0(t3)               # set LN
        sw      t6, 0(t0)               # GO!
_dma_wait:
        li      t7, 0x03
dma_wait_loop:
        addiu   t7, t7, -1
        bne     t7, zero, dma_wait_loop
	nop
	
_led1:
	la	t0, 0x20000000
	la	t1, 0xfe
	sb	t1, 0x00(t0)

_jump_to_firmmain:
	/* fake sp */
	la	sp, SDRAM1_END

	/* jump to SDRAM! remember never comes back here */
	la	t7, firm_main
	jr	t7
	subu	sp, sp, 32
	.set 	novolatile
	.set 	reorder
	.end	_start
