#ifndef	__A_RMT_CACHE_H__
#define	__A_RMT_CACHE_H__


/*
 * Cache Control Registers (for chip ver2 only)
 * use mtc0 and mfc0
 */
#define RMT_ICACHE_ON		0x80
#define RMT_ICACHE_REP_MOD	0x81
#define RMT_ICACHE_ACC_SCHE	0x82
#define RMT_ICACHE_LOCK		0x83
#define RMT_ICACHE_RESET	0x84
#define RMT_DCACHE_ON		0x86
#define RMT_DCACHE_REP_MOD	0x87
#define RMT_DCACHE_ACC_SCHE	0x88
#define RMT_DCACHE_LOCK		0x89
#define RMT_DCACHE_RESET	0x8a
#define RMT_DCACHE_FLUSH	0x8b
#define RMT_DCACHE_ALL_FLUSH	0x8c

// ON
#define CACHE_ON_CNTXT(x)	(0x3<<((x)*2))	// sel:1, val:1
#define CACHE_OFF_CNTXT(x)	(0x2<<((x)*2))	// sel:1, val:0
#define CACHE_ON_ALL		0xffff		// sel:1, val:1
#define CACHE_OFF_ALL		0xaaaa		// sel:1, val:0

// REP_MOD
#define CACHE_REP_LRU	0
#define CACHE_REP_PRI	1
#ifdef	CONFIG_CACHE_REP_LRU
#	define	DEFAULT_CACHE_REP	CACHE_REP_LRU
#	define	DEFAULT_CACHE_REP_STR	"LRU"
#elif	defined(CONFIG_CACHE_REP_PRI)
#	define	DEFAULT_CACHE_REP	CACHE_REP_PRI
#	define	DEFAULT_CACHE_REP_STR	"PRI"
#endif

// ACC_SCHE
#define CACHE_ACC_FIFO	0
#define CACHE_ACC_PRI	1
#ifdef	CONFIG_CACHE_ACC_FIFO
#	define	DEFAULT_CACHE_ACC	CACHE_ACC_FIFO
#	define	DEFAULT_CACHE_ACC_STR	"FIFO"
#elif	defined(CONFIG_CACHE_ACC_PRI)
#	define	DEFAULT_CACHE_ACC	CACHE_ACC_PRI
#	define	DEFAULT_CACHE_ACC_STR	"PRI"
#endif

// LOCK
#define CACHE_LOCK_CNTXT(x)	(0x3<<((x)*2))	// sel:1, val:1
#define CACHE_UNLOCK_CNTXT(x)	(0x2<<((x)*2))	// sel:1, val:0
#define CACHE_LOCK_ALL		0xffff		// sel:1, val:1
#define CACHE_UNLOCK_ALL	0xaaaa		// sel:1, val:0

// RESET
#define CACHE_RESET	1

// FLUSH (DCACHE only)
#define CACHE_FLUSH_CNTXT(x)	(0x3<<((x)*2))	// sel:1, val:1

// ALL_FLUSH (DCACHE only)
#define CACHE_FLUSH_ALL		1


#ifndef	__ASSEMBLY__
#ifdef KERNEL
#include "asm.h"

static inline void cache_reset(void)
{
	mtc0(RMT_ICACHE_RESET, CACHE_RESET);
	mtc0(RMT_DCACHE_RESET, CACHE_RESET);
}

static inline void set_cache_rep_mode(void)
{
	mtc0(RMT_ICACHE_REP_MOD, DEFAULT_CACHE_REP);
	mtc0(RMT_DCACHE_REP_MOD, DEFAULT_CACHE_REP);
}

static inline void set_cache_acc_sched(void)
{
	mtc0(RMT_ICACHE_ACC_SCHE, DEFAULT_CACHE_ACC);
	mtc0(RMT_DCACHE_ACC_SCHE, DEFAULT_CACHE_ACC);
}

static inline void flush_all_cache(void)
{
	mtc0(RMT_DCACHE_ALL_FLUSH, CACHE_FLUSH_ALL);
}

extern void cache_off_all(void);
extern void cache_on_all(void);
extern void cache_off(unsigned int);
extern void cache_on(unsigned int);
extern void sys_flush_i_cache(void);
extern void sys_flush_d_cache(void);
#else
static inline void flush_i_cache(void) { }
extern void flush_d_cache(void);

#endif /* KERNEL */

#define	__DCACHE_ALIGNED__	__BYTE_ALIGNED(256)
#endif	/* !__ASSEMBLY__ */

#endif	/* __RT_FRONTIER_RMT_CACHE_H__ */
