#include <addrmap.h>
#include <pci.h>
#include <stddef.h>
#include <types.h>
#include <uart.h>

#define RMT_CMD_INIT	0x11111111
#define RMT_CMD_END		0x22222222
#define RMT_CMD_LOAD	0x33333333

void simple_print(char *s)
{
	size_t size, i = 0;
	while(s[i] != '\0') {
		i++;
		asm volatile("sync");
	}
	size = i + 1;
	sdtr_write(0, s, size);
}

void pci_main(void)
{
	ulong_t cmd, ent;
	int i;
	void (*func) (void);

	*(unsigned char*)0x20000000 = 0xe0;

	/* set up the PCI */
	pci_setup();

	/* waiting for a load command */
	simple_print("OK\n");

	/* waiting for a end command */
	do {
		pci_read_mailbox(&cmd, &ent);
		nop7();
	} while (cmd != RMT_CMD_END);

#if 0
	for (i = SDRAM1_START; i < SDRAM1_END; i += sizeof(ulong_t)) {
		cmd = MEM_RD_W(i);
		printk("0x%x\n", cmd);
		nop7();
	}
#endif

	printk("0x%x\n", ent);
	func = (void (*)(void))ent;
	func();

#if 0
	asm(
		".set	noreorder	\n"
		"jr	%0	\n"
		"nop	\n"
		".set	reorder	\n"
		:
		: "r" (ent));
#endif
	nop7();
}

void firm_main(void)
{
	ulong_t rom_end;

	/* LED */
	*(unsigned char*)0x20000000 = 0xfc;

	/* set up the RS232C and print the hello message */
	sdtr_setup();

	*(unsigned char*)0x20000000 = 0xf8;

//	simple_print("PCILoader\n");

	*(unsigned char*)0x20000000 = 0xf0;

#if 1
	pci_main();
#else
	/* memory check routine. this function calls pci_main() 
	   and never comes back here. */
	asm ("test:\nla	%0, _end\n"
		 :"=r" (rom_end) : );
	mem_check(FIRM_START, rom_end);
#endif
}
