#include <uart.h>
#include <stdarg.h>

#define TRUE 	1
#define FALSE 	0
/* Be aware that no overflow checking is done */
#define	FOUT_SZ	0x100
#define	MAX_DIGIT	16

struct conv_flag {
	short pad;
	short digit;
};

static inline int iout(int d, int base, char *dst, int n, struct conv_flag *cf)
{
	int i;
	char tmp[MAX_DIGIT];
	unsigned int ud;
	char pad = ' ';

	if (base == 10 && d < 0) {
		dst[n++] = '-';
		ud = d * -1;
	} else ud = d;

	for (i = 1; i < MAX_DIGIT; i++) {
		tmp[i] = ud % base;
		if (tmp[i] < 10) tmp[i] += '0';
		else tmp[i] += 'a' - 10;

		if ((ud /= base) == 0) {

			if (cf->pad) pad = '0';
			if (FOUT_SZ < n + cf->digit) return -1;
			while (i < cf->digit) {
				dst[n++] = pad;
				cf->digit--;
			}

			if (FOUT_SZ < n + i) return -1;
			while (i) dst[n++] = tmp[i--];
			break;
		}
	}

	return n;
}

/* nobody should write their program as below ... */
int printk(const char *fmt, ...)
{
	int n = 0, ret;
	char buf[FOUT_SZ];
	va_list ap;
	int d;
	char *p, *s;
	struct conv_flag cf;

	va_start(ap, fmt);

	while (*fmt) {
		if (*fmt != '%') {
			p = (char *)fmt + 1;
			while (*p && *p != '%') p++;
			if (FOUT_SZ < n + (int) (p - fmt)) goto out;
			while (fmt != p) buf[n++] = *fmt++;
			if (!*p) break;
		}
		fmt++;

		/* at least one */
		if (FOUT_SZ < n + 1) goto out;
		cf = (struct conv_flag) {.pad = FALSE, .digit = 0};
skip:
		switch (*fmt++) {
			case 's':	/* string */
				s = va_arg(ap, char *);
				while (*s) {
					if (FOUT_SZ < n) goto out;
					buf[n++] = *s++;
				}
				break;
			case 'd':	/* dec int */
				d = va_arg(ap, int);
				ret = iout(d, 10, buf, n, &cf);
				if (ret == -1) goto out;
				n = ret;
				break;
			case 'x':	/* hex int */
				d = va_arg(ap, int);
				ret = iout(d, 16, buf, n, &cf);
				if (ret == -1) goto out;
				n = ret;
				break;
			case 'c':	/* char */
				buf[n++] = (char) va_arg(ap, int);
				break;
			case '0':
				cf.pad = TRUE;
				fmt++;
			case '1' ... '8':
				cf.digit = *(fmt-1) - '0';
			default:
				goto skip;
		}
	}

out:
	va_end(ap);

	sdtr_write(0, buf, n);

	return n;
}
