/*
 * rmtproc.h:	Macros and definitions for the rmtproc module
 *
 * Editors:
 *	Shinpei Kato <shinpei@ny.ics.keio.ac.jp>
 */

#include <linux/sem.h>

#define THIS_MODULE_NAME "rmtproc"
#define PFX "rmtproc: "

/* PCI vender and device IDs */
#define PCI_VENDER_ID_RMT	0x2345
#define PCI_DEVICE_ID_RMT	0x10cf

/* major and minor number of a driver */
#define RMTPROC_MAJOR 0
#define RMTPROC_MINOR 0

/* Commands */
#define PCI_CMD_WRITE	0x11111111 /* PCI -> LOCAL */
#define PCI_CMD_READ	0x22222222 /* LOCAL -> PCI */
#define PCI_CMD_END		0x33333333
#define PCI_CMD_INIT	0x44444444
#define PCI_CMD_ACK		0xeeeeeeee
#define PCI_CMD_LOAD	0xffffffff
/* Test */
#define PCI_TEST_ADDR	0x80000000
#define PCI_TEST_DATA1	0xa5a5a5a5
#define PCI_TEST_DATA2	0x5a5a5a5a

/* Interruption Control Register */
#define OFFSET_ICR 0x00
#define ICR_PE 0x1 << 31 
#define ICR_PS 0x1 << 30
#define ICR_LE 0x1 << 29
#define ICR_LS 0x3 << 27
//#define ICR_LS_L 0x1 << 27
//#define ICR_LS_H 0x1 << 28
#define ICR_LS_L 0x1 << 28
#define ICR_LS_H 0x1 << 27
#define ICR_ID 0x3 << 25
#define ICR_ID0 0x1 << 25
#define ICR_ID1 0x1 << 26
#define ICR_TE 0x1 << 23
#define ICR_ME 0x1 << 22
#define ICR_EE 0x1 << 21
#define ICR_LTE 0x1 << 20
#define ICR_LTS 0x1 << 19
#define ICR_LME 0x1 << 18
#define ICR_LMS 0x1 << 17

/* Mail Boxes */
#define OFFSET_MAILBOX_A_L 0x08
#define OFFSET_MAILBOX_A_H 0x0c
#define OFFSET_MAILBOX_B 0x10

/* Bus Access Ports */
#define OFFSET_LOCAL_AD 	0x18
#define OFFSET_LOCAL_BAP 	0x20
#define OFFSET_PCI_BAP 		0x28

/* timer count to wait for flags to be down */
#define TIMER_COUNT	(1000000)

/* definitions for device structure */
#define MAIL_NUM 0x1000
#define NAME_LEN 8

#undef PDEBUG			/* undef it, just in case */
#ifdef RMTPROC_DEBUG
#  ifdef __KERNEL__
     /* This one if debugging is on, and kernel space */
#    define PDEBUG(fmt, args...) printk(KERN_ERR "resproc: " fmt, ## args)
#  else
     /* This one for user space */
#    define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
#  endif
#else
#  define PDEBUG(fmt, args...)	/* not debugging: nothing */
#endif

#define TIMER_COUNT (1000000)

//#define RMTP_DRV

/*
 * RMTP PCI device structure
 */
typedef struct Rmtproc_Dev {
	struct pci_dev *pci_dev; 	/* pci device structure */
#ifdef RMTP_DRV
	struct cdev cdev;			/* kernel internal char device structure */
#else
	struct cdev *cdev;			/* kernel internal char device structure */
#endif
	unsigned long Wdma_data;	/* (dma) buffer(one page) for write */
	unsigned long Rdma_data;    /* (dma) buffer(one page) for read */
	unsigned long mail[MAIL_NUM];   /* for storing data through mailbox */
	unsigned short mail_head;
	unsigned short mail_tail;
	unsigned long addr_base;	/* the base address of PCI I/O memory*/
	unsigned long addr_end; 	/* memory address end */
	unsigned long addr_len; 	/* memory address length */
	unsigned char irq;			/* irq of this device */
	unsigned int access_key; 	/* used by resprocuid and resprocpriv */
	unsigned int count;     	/* opened count */
	struct semaphore sem;   	/* Mutual exclusion semaphore */
	struct wait_queue *wq;  	/* wait queue */
	struct list_head list;
} Rmtproc_Dev;
