/*
 * RT-FRONTIER
 * Copyright (C) Real-Time Network Project / Keio University
 *
 * $Id: addr.h 1365 2004-11-28 10:27:53Z kitsunai $
 */


#ifndef __A_RMT_ADDRMAP_H__
#define __A_RMT_ADDRMAP_H__

/*
 * Address Decoder: use mtc0
 */
#define	ADDRDEC_ROM	0xA0
#define	ADDRDEC_EXT1	0xA1
#define	ADDRDEC_SDRAM0	0xA2
#define	ADDRDEC_SDRAM1	0xA3
#define	ADDRDEC_SDRAM2	0xA4
#define	ADDRDEC_SDRAM3	0xA5
#define	ADDRDEC_LINK_SDRAM	0xA6
#define	ADDRDEC_LINK_DPM	0xA7
#define	ADDRDEC_DMAC0	0xA8
#define	ADDRDEC_DMAC1	0xA9
#define	ADDRDEC_DMAC2	0xAA
#define	ADDRDEC_PCI	0xAB
#define	ADDRDEC_USB_IN	0xAC
#define	ADDRDEC_USB_OUT	0xAD
#define	ADDRDEC_UART	0xAE
#define	ADDRDEC_PP	0xAF
#define	ADDRDEC_1394	0xB0
#define	ADDRDEC_LINK	0xB1
#define	ADDRDEC_IRC	0xB2
#define	ADDRDEC_CLK	0xB3
#define	ADDRDEC_MDMAC	0xB4
#define	ADDRDEC_LINK_SDRAM_MODE	0xB5
#define	ADDRDEC_SDRAM_MODE	0xB6
#define	ADDRDEC_IO_BASE	0xB7

/*
 * Default mappings
 */
/* ROM & SDRAM */
#ifndef __ASSEMBLY__
#define	ROM_START	0x00000000UL
#define	ROM_END		0x01000000UL	/* physical ROM size is 1 MB */
#define	SDRAM0_START	0x04000000UL	/* SDRAM for Responsive Link */
#define	SDRAM1_START	0x80000000UL	/* SDRAM_IF0? */
//#define	SDRAM1_END	0x88000000UL
#define	SDRAM1_END	0x84000000UL
#define	OTHER_PERI_START	0xFFFF0000UL
#define FIRM_START	0x82000000UL	/* start address of the firmware */
#else
#define	ROM_START	0x00000000
#define	ROM_END		0x01000000	/* physical ROM size is 1 MB */
#define	SDRAM0_START	0x04000000	/* SDRAM for Responsive Link */
#define	SDRAM1_START	0x80000000	/* SDRAM_IF0? */
//#define	SDRAM1_END	0x88000000
#define	SDRAM1_END	0x84000000
#define	OTHER_PERI_START	0xFFFF0000
#define FIRM_START	0x82000000	/* start address of the firmware */
#endif

/* DMA */
#ifndef __ASSEMBLY__
#define	DMA0_START 0xFFFF0000UL
#define	DMA1_START 0xFFFF1000UL
#define	DMA2_START 0xFFFF2000UL
#else
#define	DMA0_START 0xFFFF0000
#define	DMA1_START 0xFFFF1000
#define	DMA2_START 0xFFFF2000
#endif


#endif /* __A_RMT_ADDRMAP_H__ */
