#include <addrmap.h>
#include <stddef.h>
#include <types.h>
#include <uart.h>

void mem_check(ulong_t start, ulong_t end)
{
	ulong_t addr, word, tmp, sdram_len, sep;
	int err1 = 0, err2 = 0;
	int ret;
	register ulong_t data1 = 0x5a5a5a5a;
	register ulong_t data2 = 0xa5a5a5a5;
	word = sizeof(ulong_t);
	sdram_len = SDRAM1_END - SDRAM1_START;
	sep = (sdram_len / word) / 8;

#if 1
//	printk("Checking memory ");
	simple_print("MEMTEST ");
	/* check agains all the addresses */
	for (addr = SDRAM1_START; addr < SDRAM1_END; addr += word) {
		if (addr >= start && addr < end) {
			continue;
		}
		if (addr % sep == 0) {
			sdtr_put(0, '.');
		}

		/* 1st write */
		*(volatile ulong_t*) addr = data1;
		/* 1st read */
		tmp = *(volatile ulong_t*) addr;
		/* 2nd write */
		*(volatile ulong_t*) addr = tmp;
		/* 2nd read */
//		tmp = *(volatile ulong_t*) address;

		/* 1st check */
		if (tmp == data1) {
			/* write 0x11111111 if the check was passed */
			*(volatile ulong_t*) addr = 0x11111111;
		}
		else {
			/* increment error counter */
			err1++;
			/* write 0x22222222 if the check was not passed */
			*(volatile ulong_t*) addr = 0x22222222;
		}

		/* 1st write */
		*(volatile ulong_t*) addr = data2;
		/* 1st read */
		tmp = *(volatile ulong_t*) addr;
		/* 2nd write */
		*(volatile ulong_t*) addr = tmp;
		/* 2nd read */
//		tmp = *(volatile ulong_t*) address;

		/* 1st check */
		if (tmp == data2) {
			/* write 0x33333333 if the check was passed */
			*(volatile ulong_t*) addr = 0x33333333;
		}
		else {
			/* increment error counter */
			err2++;
			/* write 0x44444444 if the check was not passed */
			*(volatile ulong_t*) addr = 0x44444444;
		}
	}

	asm ("la	$sp, %0\n"
		 :
		 : "i" (SDRAM1_END));

	if (err1 == 0 && err2 == 0) {
		printk(" OK\n");
		ret = TRUE;
	}
	else {
		printk(" Error!\n");
		ret = FALSE;
	}
#endif
	/* jump to pci_main() */
	pci_main();
}
