#include <endian.h>
#include <pci.h>
#include <stddef.h>

int pci_setup(void)
{
	ulong_t mb_l, mb_h;
	word_t tmp;
	int ret = TRUE;

	pci_reset();
	pci_trans_stop();
	pci_ls_clear();
	pci_le_enable();

	asm volatile ("sync");

	return ret;
}

ssize_t pci_write(int ch, const void *input_data, size_t length)
{
	return length;
}

ssize_t pci_read(int ch, const void *output_data, size_t length)
{
	ulong_t cmd, addr, size, ret;
	word_t tmp;
	ulong_t *buflp = (ulong_t *)output_data;

	/* get the command */
	pci_read_mailbox(&cmd, NULL);
	nop7();
	sync();
	if (cmd != PCI_CMD_READ) {
		printk("Error: not READ command: 0x%x\n", cmd);
		return -1;
	}

	/* send the destination address */
	tmp = word_endian((word_t)output_data);
	pci_write_mailbox((ulong_t)tmp);

	/* send the length of data */
	tmp = word_endian((word_t)length);
	pci_write_mailbox((ulong_t)tmp);

	/* get the written length */
	pci_read_mailbox(&ret, NULL);

	/* polling */
	do {
		asm volatile("sync");
		pci_read_mailbox(&cmd, NULL);
		asm volatile("sync");
	} while (cmd != PCI_CMD_END);

	return ret;
}
