#include <stdio.h>
#include <string.h>
#include <mb86941.h>  

extern void ASI4put(/* unsigned long data, unsigned long address */);
extern unsigned long ASI4get(/* unsigned long address */);
extern void ASI1put(/* unsigned long data, unsigned long address */);
extern unsigned long ASI1get(/* unsigned long address */);
extern void cache_on(/* void */);
extern void cache_off(/* void */);


#define RTBL_ADDR_BASE		0xfffe2000
#define RTBL_LINK_BASE		0xfffe3000
#define EVENT_DPM_IN_BASE	0x0c000000
#define EVENT_DPM_OUT_BASE	0x0c100000
#define DATA_DPM_IN_BASE	0x0c200000
#define DATA_DPM_OUT_BASE	0x0c300000
#define RL_SDRAM_MODE		0xfffe0000
#define RL_S_REG			0xfffe0004
#define RL_INIT_REG			0xfffe0008
#define RL_TBL_BREQ_REG		0xfffe0028
#define RL_TBL_BGRNT_REG	0xfffe002c
#define RL_SD_BREQ_REG		0xfffe0020
#define RL_SD_BGRNT_REG		0xfffe0024
#define	RL_SD_INIT_REG		0xffffe000
#define	SD_INIT_REG			0xfffff000
#define RL_SD_BASE			0x04000000
#define SD_BASE				0x08400000
#define RL_OFFLINE		0xfffe004c


#define EVENT_IN_CNTL_REG		(EVENT_DPM_IN_BASE + 0x80)
#define EVENT_IN_PACKET_NUM		(EVENT_DPM_IN_BASE + 0x88)
#define EVENT_IN_PACKET_VALID	(EVENT_DPM_IN_BASE + 0x8c)
#define EVENT_OUT_CNTL_REG		(EVENT_DPM_OUT_BASE + 0x80)
#define EVENT_OUT_COUNT_REG		(EVENT_DPM_OUT_BASE + 0x84)
#define DATA_IN_CNTL_REG		(DATA_DPM_IN_BASE + 0x800)
#define DATA_IN_PACKET_NUM		(DATA_DPM_IN_BASE + 0x808)
#define DATA_IN_PACKET_VALID	(DATA_DPM_IN_BASE + 0x80c)
#define DATA_OUT_CNTL_REG		(DATA_DPM_OUT_BASE + 0x800)
#define DATA_OUT_COUNT_REG		(DATA_DPM_OUT_BASE + 0x804)

#define EVENT_HV_IN_BASE	0xf0001000
#define EVENT_HV_OUT_BASE	0xf0002000

#define	DMA_BASE	0xffff2000
#define	DMA_PSA(x)	(DMA_BASE + 0x40*(x) + 0x04)
#define	DMA_MDA(x)	(DMA_BASE + 0x40*(x) + 0x08)
#define	DMA_IDR(x)	(DMA_BASE + 0x40*(x) + 0x0c)
#define	DMA_TMR(x)	(DMA_BASE + 0x40*(x) + 0x10)
#define	DMA_SR(x)	(DMA_BASE + 0x40*(x) + 0x14)
#define	DMA_LR(x)	(DMA_BASE + 0x40*(x) + 0x18)
#define	DMA_SASI(x)	(DMA_BASE + 0x40*(x) + 0x1c)
#define	DMA_DASI(x)	(DMA_BASE + 0x40*(x) + 0x20)



  /* DPLL Mode Setting */
void set_dpll()
{
# if 1 
	ASI4put( 0x00000000, RL_S_REG ); /* normal */
# else
/*  ASI4put( 0x02490249, RL_S_REG );*/ /* half */
	ASI4put( 0x06db06db, RL_S_REG ); /* lowest */
# endif
}

/* Link Initialization */

void all_init(){
	unsigned long flag;
	int i;

#if 0 
	set_dpll();
#endif

	/* Show the value of RL_OFFLINE */
	flag = ASI4get( RL_OFFLINE );
	printf( "RL_OFFLINE(1) = %08x", flag );

	/* NULL clear RL_OFFLINE REG. */
	ASI4put( 0x00000000, RL_OFFLINE );

	/* wait */
	wait( 1000 );

	/* Show the value of RL_OFFLINE */
	flag = ASI4get( RL_OFFLINE );
	printf( "RL_OFFLINE(2) = %08x\n", flag );

	ASI4put( 0x00010001, RL_INIT_REG );
	flag = ASI4get( RL_INIT_REG );
	printf( "all_init(0x00010001)=%08x\n", flag );
	ASI4put( 0x00000000, RL_INIT_REG );
	flag = ASI4get( RL_INIT_REG );
	printf( "all_init(0x00000000)=%08x\n", flag );
	ASI4put( 0x001e001e, RL_INIT_REG );
	flag = ASI4get( RL_INIT_REG );
	printf( "all_init(0x001e001e)=%08x\n", flag );
	ASI4put( 0x00000000, RL_INIT_REG );
	flag = ASI4get( RL_INIT_REG ); 
	printf( "all_init(0x00000000)=%08x\n", flag );

	/* Tell reset sequence was completed. */
	printf("link full reset!!\n");

	/* wait */
	wait( 1000 );

	/* Show the value of RL_OFFLINE */
	flag = ASI4get( RL_OFFLINE );
	printf( "RL_OFFLINE(3) %08x\n", flag );

}

part_init(){
	unsigned long flag;
 
	flag = ASI4get( RL_OFFLINE );
	printf( "RL_OFFLINE(1) %08x\n", flag );
	ASI4put( 0x00000000, RL_OFFLINE );

	ASI4put( 0x001e001e, RL_INIT_REG );
	flag = ASI4get( RL_INIT_REG );
	printf("part_init(0x001e001e)=%08x\n",flag);
	ASI4put( 0x00000000, RL_INIT_REG );
	flag = ASI4get( RL_INIT_REG );
	printf("part_init(0x00000000)=%08x\n",flag);
	printf("link part reset\n");

	flag = ASI4get( RL_OFFLINE );
	printf( "RL_OFFLINE(2) %08x\n", flag );
}
