/* 
 *      id: @(#)tim82C54.c 1.1 96/07/18
 *
 
 *      All rights reserved.
 *
 *      This software (including any documentation) is untested, has not been
 *      fully tested for viruses and has been provided to you without charge.
 *      ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *      IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *      FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *      risk of nonperformance, loss of data and other problems and Fujitsu
 *      Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *      contract, negligence, strict liability or other theory for any damages
 *      including, without limitation, direct, consequential or incidental nor
 *      be required to provide substitute goods, services or technology.
 *
*/

#include "sparclit.h"
#include "board.h"

/* GET_TIME returns the BootROM maintained time in usecs. It assumes that the BootROM:
   1) Maintains a memory location (SECONDS_ADDR) which is incremented every 1 sec
   2) Timer 1's counter is programmed to decrement every 50 usec and timeout every 1 sec.
*/

#define TIMER_CMD   (TIMER_BASE_ADDR+0xC)
#define TIMER_TMR0  (TIMER_BASE_ADDR+0x0)
#define TIMER_TMR1  (TIMER_BASE_ADDR+0x4)
#define TIMER_TMR2  (TIMER_BASE_ADDR+0x8)
#define TIMER_TICK_USECS 50
#define TIMER_RELOAD 1000000/TIMER_TICK_USECS

volatile unsigned int *seconds = (unsigned int *)SECONDS_ADDR;

extern void timer_delay();
asm ("
_timer_delay: 
	 addcc %g0, 40, %o0
	 bg .       
	 deccc %o0       /* SPARC delay slot */
	 retl
	 nop
");

#define I82C54_PUT(ADDR,DATA) \
  write_asi_b(TIMER_ASI, ADDR, DATA)

#define I82C54_GET(ADDR) \
  ({unsigned char c; \
    read_asi_b(TIMER_ASI, ADDR, c); \
    c ; \
   })

/* GET_TIME and RESET_TIME are capitalized for compatibility
   with previous versions of the evaluation board s/w 
*/

unsigned int
GET_TIME() {
  unsigned int hibyte;
  unsigned int lobyte;

  timer_delay();
  I82C54_PUT(TIMER_CMD,0x40);
  timer_delay();
  lobyte = I82C54_GET(TIMER_TMR2);
  timer_delay();
  hibyte = I82C54_GET(TIMER_TMR2);
  
  return( *seconds*1000000 + ( (TIMER_RELOAD - (((hibyte<<8) | lobyte)&0xffff)) * TIMER_TICK_USECS) );
}

void
RESET_TIMER() {
	*seconds = 0 ;
}
