#include "common.h"

	.text
	.align 4

	.globl	_start
	.ent	_start
_start:
	.set noreorder
	.set volatile

	/* SDRAM controller initialization */
	la      $8, SDRAM1_ENABLE
	sw      $zero, 0($8)

	/* set temporary stack pointer */
	la	$sp, 0x88000000

	/* DMA transfer */
rom_to_sdram:
	lui	$5, 0xffff
	ori	$6, $5,0x2010	#TMR
	ori	$3, $5,0x2004	#PSA
	ori	$4, $5,0x2008	#MDA
	ori	$5, $5,0x2018	#LR

	lui	$2, %hi(SDRAM1_START)
	sw	$0, 0($6)
	sw	$0, 0($3)
	la	$3, (edata -SDRAM1_START)
	sw	$2, 0($4)
	li	$2, 513			#0x201 - DMA_START
	sw	$3, 0($5)
	sw	$2, 0($6)

	/* set temporary stack pointer */
	la	$sp, 0x88000000

	/* jump to the top of SDRAM */
	la	$9, SDRAM1_START
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

	jr	$9
	 nop

	.set novolatile
	.set reorder
	.end	_start
