/*
 * This file is subject to the terms and conditions of the GNU General
 * Public License.  See the file "COPYING" in the main directory of this
 * archive for more details.
 *
 * Copyright (C) 2000 - 2001 by Kanoj Sarcar (kanoj@sgi.com)
 * Copyright (C) 2000 - 2001 by Silicon Graphics, Inc.
 */
#include <linux/init.h>
#include <linux/sched.h>
#include <asm/page.h>
#include <asm/processor.h>
#include <asm/thread_control.h>

void __init prom_build_cpu_map(void)
{
	rmt_str_printf("prom_build_cpu_map(): #1\n");
}

void __init prom_prepare_cpus(unsigned int max_cpus)
{
	rmt_str_printf("prom_prepare_cpus(): #1 status=0x");
	rmt_hex_printf(read_c0_status());
}

/*
 * Launch a slave into smp_bootstrap().  It doesn't take an argument, and we
 * set sp to the kernel stack of the newly created idle process, gp to the proc
 * struct so that current_thread_info() will work.
 */
void __init prom_boot_secondary(int cpu, struct task_struct *idle)
{
	unsigned long gp = (unsigned long) idle->thread_info;
	unsigned long sp = gp + THREAD_SIZE - 32;
	unsigned int	tmp, tmp2;

	__asm__ __volatile__ (
		".set	push\n\t"
		".set	noreorder\n\t"
		"getotid	%1		\n\t"
		"cpthtoa	%0, %1, %2	\n\t"
		"beq		$0, %0, 1f	\n\t"
		" nop				\n\t"
		"runth		%0, %2		\n\t"
		"beq		$0, %0, 1f	\n\t"
		" nop				\n\t"
		"getotid	%0		\n\t"
		"bne		%0, %2, 1f	\n\t"
		" nop				\n\t"
		"or		$28, $0, %3	\n\t"
		"or		$29, $0, %4	\n\t"
		"j		smp_bootstrap	\n\t"
		" nop				\n\t"
		"1:				\n\t"
		".set	pop"
		: "=&r" ((unsigned int)tmp), "=&r" ((unsigned int)tmp2)
		: "r" ((int)cpu),
		  "r" ((unsigned int)gp), "r" ((unsigned int)sp)
	);
	AXE_BREAK(0xbeef);
	rmt_str_printf("status(0)=0x");
	rmt_hex_printf(read_c0_status());
}

void __init per_cpu_init(void)
{
	rmt_str_printf("per_cpu_init()\n");
}

void prom_init_secondary(void)
{
	rmt_str_printf("prom_init_secondary(): #1\n");
	rmt_str_printf("status=0x");
	rmt_hex_printf(read_c0_status());
	per_cpu_init();
	rmtsim_timer_setup();
	local_irq_enable();
	rmt_str_printf("status=0x");
	rmt_hex_printf(read_c0_status());
}

void __init prom_cpus_done(void)
{
}

void prom_smp_finish(void)
{
}

void core_send_ipi(int destid, unsigned int action)
{
	int	cause, tmp;

	if(action != SMP_RESCHEDULE_YOURSELF && action != SMP_CALL_FUNCTION) {
		printk(KERN_WARNING "%s: invalid action number\n",
				__FUNCTION__);
		return;
	}

	tmp = rmt_getcnum(destid);
	if(tmp & GETCNUM_AFLAG)
		tmp = tmp & GETCNUM_AMASK;
	else
		tmp = tmp & GETCNUM_CMASK;

	tmp = CP0_CAUSE(tmp);
	
	__asm__ __volatile__ (
	"mfc0	%0, %1\n"
	"or	%0, %0, %2\n"
	"mtc0	%0, %1\n"
	: "=&r"((int)cause)
	: "r"((int)tmp), "r"((int)action)
	);
	rmt_str_printf("causereg=0x"); rmt_hex_printf(tmp);
	rmt_str_printf("causeval=0x"); rmt_hex_printf(cause);
}

