/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1994, 1995 Waldorf Electronics
 * Written by Ralf Baechle and Andreas Busse
 * Copyright (C) 1994, 95, 96, 97, 98, 99, 2003 Ralf Baechle
 * Copyright (C) 1996 Paul M. Antoine
 * Modified for DECStation and hence R3000 support by Paul M. Antoine
 * Further modifications by David S. Miller and Harald Koerfgen
 * Copyright (C) 1999 Silicon Graphics, Inc.
 * Kevin Kissell, kevink@mips.com and Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 2000 MIPS Technologies, Inc.  All rights reserved.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/threads.h>

#include <asm/asm.h>
#include <asm/regdef.h>
#include <asm/page.h>
#include <asm/rmtregs.h>
#include <asm/stackframe.h>
	
	.macro	putchar ch
#ifdef CONFIG_AXE_DEBUG
# ifdef CONFIG_RMT_UARTIO
	.set noreorder
	lui	v0, %hi(0xffff6000)	# RMT_UART_BASE
	addiu	v0, v0, %lo(0xffff6000)
	addiu	v0, v0, 0x17		# UART_LSR
9:
	iolb	v1, v0
	andi	v1, v1, 0x40 | 0x20	# UART_LSR_TEMT | UART_LSR_THRE
	beq	v1, zero, 9b
	 nop
	lui	v0, %hi(0xffff6000)	# RMT_UART_BASE
	addiu	v0, v0, %lo(0xffff6000)
	ori	v1, zero, \ch
	sb	v1, 3(v0)		# TX_REG
	.set reorder
# elif CONFIG_RMT_AXEIO
	lui	v0, 0x200
	ori	v0, v0, \ch
	ori	v1, zero, 0xff
	mtc0	v0, v1
# endif
#endif
	.endm

NESTED(loader_entry, 16, sp)
	putchar	'L'
	putchar	'o'
	putchar	'a'
	putchar	'd'
	putchar	'e'
	putchar	'r'
	putchar	'\n'

	/* ROM or SDRAM */
	jal	check_memory
	 nop

check_memory:
	srl	t0, ra, 31
	bgtz	t0, 1f
	 nop

	putchar	'R'
	putchar	'O'
	putchar	'M'
	putchar	'\n'

	/* initialize SDRAM */
	lui 	t0, 0xffff
	ori 	t0, t0, 0xf000
	sw  	zero, 0x0(t0)
	
	/* cp 0x00000000 to 0x80000000  */
#if 0   /* Skip for Clock Level Simulator */
	lui 	t0, 0xffff
	ori	t1, t0, 0x2010			# TMR: Mode
	ori	t2, t0, 0x2004			# PSA: Source
	ori	t3, t0, 0x2008			# MDA: Dest
	ori 	t0, t0, 0x2018			# TransferLength
	sync
	sync			
	lui 	t4, %hi(SD_BASE)
	sw  	zero, 0x0(t1)
	sw  	zero, 0x0(t2)
	lui 	t2, %hi(_end - SD_BASE)
	addiu  	t2, t2, %lo(_end- SD_BASE)
	sw  	t4, 0x0(t3)
	li  	t4, 513				# 0x201 - DMA_START
	sw  	t2, 0x0(t0)
	sw  	t4, 0x0(t1)
#endif

1:
	putchar	'S'
	putchar	'D'
	putchar	'R'
	putchar	'A'
	putchar	'M'
	putchar	'\n'

	lui	t0, %hi(kernel_entry)
	addiu	t0, t0, %lo(kernel_entry)

	jr	t0
	 nop

END(loader_entry)
	.align		0x8
	.fill		0x500

EXPORT(stext)					# used for profiling
EXPORT(_stext)

	__INIT

NESTED(kernel_entry, 16, sp)			# kernel entry point
	putchar	'K'
	putchar	'e'
	putchar	'r'
	putchar	'n'
	putchar	'e'
	putchar	'l'
	putchar	'\n'

	CLI					# disable interrupts
	putchar	'C'
	putchar	'L'
	putchar	'I'
	putchar	'\n'

	lui	t0, %hi(EXP_BASE_ADDR)
	addiu	t0, t0, %lo(EXP_BASE_ADDR)
	ori	t1, zero, CP0_EXP_BASE_ADDR
	mtc0	t0, t1				# set ExceptionBaseAddress

	ori	t1, zero, CP0_OWN_STATUS
	mfc0	t0, t1
	RMTBUG_MMUREAD_SYNC
	ori	t0, t0, 0xc40			# Timer & Hardware Interruption
						# mask
	mtc0	t0, t1				# Exp. -> 0x80000300+offset
	
	lui	t0, %hi(__bss_start)		# clear .bss section
	addiu	t0, t0, %lo(__bss_start)
	sw	zero, 0x0(t0)
	lui	t1, %hi(__bss_stop)
	addiu	t1, t1, %lo(__bss_stop)

/*	RMTSYNC_MAYBE */

2:
	addiu	t0, t0, 0x4
	sw	zero, 0x0(t0)
	sltu	t2, t0, t1
	bne	zero, t2, 2b
	 nop
	putchar	'b'
	putchar	's'
	putchar	's'
	putchar	'\n'
	
	PTR_LA		gp, init_thread_union
	PTR_ADDIU	sp, gp, _THREAD_SIZE - 32
	set_saved_sp	sp, t0, t1
	PTR_SUBU	sp, 4 * SZREG		# init stack pointer
	putchar	'$'
	putchar	's'
	putchar	'p'
	putchar	'\n'

	jal		start_kernel
	 nop
	END(kernel_entry)

#ifdef CONFIG_SMP
/*
 * SMP slave cpus entry point.  Board specific code for bootstrap calls this
 * function after setting up the stack and gp registers.
 */
NESTED(smp_bootstrap, 16, sp)

	CLI
	jal	start_secondary
	 nop
	END(smp_bootstrap)
#endif /* CONFIG_SMP */

#ifdef NEVER /* XXXX */
#if defined(CONFIG_RMT_RTTHREAD) /* || defined(CONFIG_RMTTIMER_NOUSE) */
NESTED(tc_thread_bootstrap, 16, sp)
	CLI
	jal	start_timer_count_thread
	 nop
	END(tc_thread_bootstrap)
#endif
#endif

	__FINIT

	.comm	kernelsp,    NR_CPUS * 8, 8
	.comm	pgd_current, NR_CPUS * 8, 8

	.comm	fw_arg0, SZREG, SZREG		# firmware arguments
	.comm	fw_arg1, SZREG, SZREG
	.comm	fw_arg2, SZREG, SZREG
	.comm	fw_arg3, SZREG, SZREG

	.macro	page name, order=0
	.globl	\name
\name:	.size	\name, (_PAGE_SIZE << \order)
	.org	. + (_PAGE_SIZE << \order)
	.type	\name, @object
	.endm

	.data
	.align	PAGE_SHIFT

	page	swapper_pg_dir, _PGD_ORDER
	page	invalid_pte_table, _PTE_ORDER

