/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1994, 1995, 1996, 1998, 1999, 2002, 2003 Ralf Baechle
 * Copyright (C) 1996 David S. Miller (dm@engr.sgi.com)
 * Copyright (C) 1994, 1995, 1996, by Andreas Busse
 * Copyright (C) 1999 Silicon Graphics, Inc.
 * Copyright (C) 2000 MIPS Technologies, Inc.
 *    written by Carsten Langgaard, carstenl@mips.com
 */
#include <linux/config.h>
#include <asm/asm.h>
#include <asm/cachectl.h>
#include <asm/fpregdef.h>
#include <asm/rmtregs.h>
#include <asm/offset.h>
#include <asm/page.h>
#include <asm/pgtable-bits.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>
#include <asm/thread_info.h>

#include <asm/asmmacro.h>

#include <asm/rmt.h>

	.macro	axe_fpregdump num
#if defined(CONFIG_AXE_DEBUG) && defined(CONFIG_RMT_INSTSIM)
	lui	t0, 0x600
	ori	t0, t0, \num
	ori	t1, zero, 0xff
	mtc0	t0, t1
#endif
	.endm
/*
 * Offset to the current process status flags, the first 32 bytes of the
 * stack are not used.
 */
#define ST_OFF (_THREAD_SIZE - 32 - PT_SIZE + PT_STATUS)

/*
 * FPU context is saved iff the process has used it's FPU in the current
 * time slice as indicated by _TIF_USEDFPU.  In any case, the CU1 bit for user
 * space STATUS register should be 0, so that a process *always* starts its 
 * userland with FPU disabled after each context switch.
 *
 * FPU will be enabled as soon as the process accesses FPU again, through
 * do_cpu() trap.
 */

/*
 * task_struct *resume(task_struct *prev, task_struct *next,
 *                     struct thread_info *next_ti)
 */
	.align	5
	LEAF(resume)
	ori	t0, zero, CP0_OWN_STATUS
	mfc0	t1, t0
	RMTBUG_MMUREAD_SYNC
	LONG_S	t1, THREAD_STATUS(a0)
	cpu_save_nonscratch a0
	LONG_S	ra, THREAD_REG31(a0)

	fpu_save	a0
	fpu_restore	a1
1:

	/*
	 * The order of restoring the registers takes care of the race
	 * updating $28, $29 and kernelsp without disabling ints.
	 */
	or	$28, $0, a2
	cpu_restore_nonscratch a1

	PTR_ADDIU	t0, $28, _THREAD_SIZE - 32
	set_saved_sp	t0, t1, t2

	ori	a3, zero, CP0_OWN_STATUS
	mfc0	t1, a3	/* Do we really need this? */
	RMTBUG_MMUREAD_SYNC
	li	a3, 0xff00
	and	t1, a3
	LONG_L	a2, THREAD_STATUS(a1)
	nor	a3, $0, a3
	and	a2, a2, a3
	or	a2, t1
	ori	a3, zero, CP0_OWN_STATUS
	mtc0	a2, a3
	move	v0, a0
	jr	ra
	END(resume)

/*
 * Save a thread's fp context.
 */
LEAF(_save_fp)
	fpu_save	a0
	jr	ra
	END(_save_fp)

/*
 * Restore a thread's fp context.
 */
LEAF(_restore_fp)
	fpu_restore	a0
	jr	ra
	END(_restore_fp)

/*
 * Load the FPU with signalling NANS.  This bit pattern we're using has
 * the property that no matter whether considered as single or as double
 * precision represents signaling NANS.
 *
 * We initialize fcr31 to rounding to nearest, no exceptions.
 */

#define FPU_DEFAULT  0x0000000F

LEAF(_init_fpu)
	fpu_enable_hazard

	li	t1, FPU_DEFAULT
#ifdef CONFIG_RMT
	rmt_mtc0	t1, CP0_OWN_FP_CTRL, t2
#else
	ctc1	t1, fcr31
#endif

	li	t1, -1				# SNaN
	mtc1	t1, $f0
	mtc1	t1, $f1
	mtc1	t1, $f2
	mtc1	t1, $f3
	mtc1	t1, $f4
	mtc1	t1, $f5
	mtc1	t1, $f6
	mtc1	t1, $f7
	jr	ra
	END(_init_fpu)
