/*
 * r2300.c: R2000 and R3000 specific mmu/cache code.
 *
 * Copyright (C) 1996 David S. Miller (dm@engr.sgi.com)
 *
 * with a lot of changes to make this thing work for R3000s
 * Tx39XX R4k style caches added. HK
 * Copyright (C) 1998, 1999, 2000 Harald Koerfgen
 * Copyright (C) 1998 Gleb Raiko & Vladimir Roganov
 * Copyright (C) 2001  Maciej W. Rozycki
 */
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/mm.h>

#include <asm/page.h>
#include <asm/pgtable.h>
#include <asm/mmu_context.h>
#include <asm/system.h>
#include <asm/isadep.h>
#include <asm/io.h>
#include <asm/bootinfo.h>
#include <asm/cpu.h>

#include <asm/rmtregs.h>

#undef DEBUG_CACHE

static void rmtp_flush_icache_all(void)
{
	__write_32bit_c0_register(CP0_ICACHE_RESET, 0, 0);
}

static void rmtp_flush_dcache_all(void)
{
	__write_32bit_c0_register(CP0_DCACHE_ALL_FLUSH, 0, 0);
}

static void rmtp_flush_thread_icache(int cid)
{
	rmtp_flush_icache_all();
}

static void rmtp_flush_thread_dcache(int cid)
{
	__write_32bit_c0_register(CP0_DCACHE_FLUSH, 0, 3 << (cid<<1));
}

static void rmtp_flush_cache_all(void)
{
	rmtp_flush_icache_all();
	rmtp_flush_dcache_all();
}

static inline void rmtp___flush_cache_all(void)
{
	rmtp_flush_cache_all();
}

static void rmtp_flush_icache_range(unsigned long start, unsigned long end)
{
	rmtp_flush_thread_icache(rmt_mycnum());
}

static void rmtp_flush_dcache_range(unsigned long start, unsigned long end)
{
	rmtp_flush_thread_dcache(rmt_mycnum());
}

static void rmtp_flush_cache_mm(struct mm_struct *mm)
{
	rmtp_flush_thread_icache(rmt_mycnum());
	rmtp_flush_thread_dcache(rmt_mycnum());
}

static void rmtp_flush_cache_range(struct vm_area_struct *vma,
	unsigned long start, unsigned long end)
{
	rmtp_flush_thread_icache(rmt_mycnum());
	rmtp_flush_thread_dcache(rmt_mycnum());
}

static void rmtp_flush_cache_page(struct vm_area_struct *vma,
	unsigned long page)
{
	rmtp_flush_thread_icache(rmt_mycnum());
	rmtp_flush_thread_dcache(rmt_mycnum());
}

static void rmtp_flush_data_cache_page(unsigned long addr)
{
	rmtp_flush_thread_dcache(rmt_mycnum());
}

static void rmtp_flush_icache_page(struct vm_area_struct *vma, struct page *page)
{
	rmtp_flush_thread_icache(rmt_mycnum());
}

static void rmtp_flush_dcache_page(struct page *page)
{
	rmtp_flush_thread_icache(rmt_mycnum());
	rmtp_flush_thread_dcache(rmt_mycnum());
}

static void rmtp_flush_cache_sigtramp(unsigned long addr)
{
	rmtp_flush_thread_icache(rmt_mycnum());
	rmtp_flush_thread_dcache(rmt_mycnum());
}

static void rmtp_dma_cache_wback_inv(unsigned long start, unsigned long size)
{
}

static void rmtp_dma_cache_wback(unsigned long start, unsigned long size)
{
}

static void rmtp_dma_cache_inv(unsigned long start, unsigned long size)
{
}

static void rmtp_probe_cache(void)
{
}

void __init ld_mmu_rmtp(void)
{
	extern void build_clear_page(void);
	extern void build_copy_page(void);
	int cid = rmt_mycnum();

	rmt_str_printf("ld_mmu_rmtp() #1\n");
	rmtp_probe_cache();
	rmt_str_printf("ld_mmu_rmtp() #2\n");

	flush_cache_all		= rmtp_flush_cache_all;
	__flush_cache_all	= rmtp___flush_cache_all;
	flush_cache_mm		= rmtp_flush_cache_mm;
	flush_cache_range	= rmtp_flush_cache_range;
	flush_cache_page	= rmtp_flush_cache_page;
	flush_icache_page	= rmtp_flush_icache_page;
	flush_icache_range	= rmtp_flush_icache_range;
	flush_dcache_page	= rmtp_flush_dcache_page;

	flush_cache_sigtramp	= rmtp_flush_cache_sigtramp;
	flush_data_cache_page	= rmtp_flush_data_cache_page;

	_dma_cache_wback_inv	= rmtp_dma_cache_wback_inv;
	_dma_cache_wback	= rmtp_dma_cache_wback;
	_dma_cache_inv		= rmtp_dma_cache_inv;

	rmt_str_printf("ld_mmu_rmtp() #3\n");
#if 0
	if(!rmt_mycnum()) {
		printk("Primary instruction cache %ldkB, linesize %ld bytes.\n",
			icache_size >> 10, icache_lsize);
		printk("Primary data cache %ldkB, linesize %ld bytes.\n",
			dcache_size >> 10, dcache_lsize);
	}
#endif

	__flush_cache_all();
	rmt_str_printf("ld_mmu_rmtp() #4\n");

#ifdef CONFIG_RMT_CACHE_ENABLE
	__write_32bit_c0_register(CP0_ICACHE_ON, 0, 3<<(cid<<1));
	__write_32bit_c0_register(CP0_DCACHE_ON, 0, 3<<(cid<<1));
#endif

	build_clear_page();
	rmt_str_printf("ld_mmu_rmtp() #5\n");
	build_copy_page();
	rmt_str_printf("ld_mmu_rmtp() #0\n");
}
