/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1994 - 2003 by Ralf Baechle
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/mm.h>

#include <asm/cacheflush.h>
#include <asm/processor.h>
#include <asm/cpu.h>
#include <asm/cpu-features.h>

/* Cache operations. */
void (*flush_cache_all)(void);
void (*__flush_cache_all)(void);
void (*flush_cache_mm)(struct mm_struct *mm);
void (*flush_cache_range)(struct vm_area_struct *vma, unsigned long start,
	unsigned long end);
void (*flush_cache_page)(struct vm_area_struct *vma, unsigned long page);
void (*flush_icache_range)(unsigned long start, unsigned long end);
void (*flush_icache_page)(struct vm_area_struct *vma, struct page *page);
void (*flush_dcache_page)(struct page *page);

/* MIPS specific cache operations */
void (*flush_cache_sigtramp)(unsigned long addr);
void (*flush_data_cache_page)(unsigned long addr);
void (*flush_icache_all)(void);

#ifdef CONFIG_DMA_NONCOHERENT

/* DMA cache operations. */
void (*_dma_cache_wback_inv)(unsigned long start, unsigned long size);
void (*_dma_cache_wback)(unsigned long start, unsigned long size);
void (*_dma_cache_inv)(unsigned long start, unsigned long size);

EXPORT_SYMBOL(_dma_cache_wback_inv);
EXPORT_SYMBOL(_dma_cache_wback);
EXPORT_SYMBOL(_dma_cache_inv);

#endif /* CONFIG_DMA_NONCOHERENT */

asmlinkage int sys_cacheflush(void *addr, int bytes, int cache)
{
	/* This should flush more selectivly ...  */
	__flush_cache_all();

	return 0;
}

#if 0 /* move to "c-r3k.c" */
void flush_dcache_page(struct page *page)
{
	unsigned long addr;

	if (page->mapping &&
	    list_empty(&page->mapping->i_mmap) &&
	    list_empty(&page->mapping->i_mmap_shared)) {
		SetPageDcacheDirty(page);

		return;
	}

	/*
	 * We could delay the flush for the !page->mapping case too.  But that
	 * case is for exec env/arg pages and those are %99 certainly going to
	 * get faulted into the tlb (and thus flushed) anyways.
	 */
	addr = (unsigned long) page_address(page);
	flush_data_cache_page(addr);
}
#endif

void __update_cache(struct vm_area_struct *vma, unsigned long address,
	pte_t pte)
{
	struct page *page;
	unsigned long pfn, addr;

	pfn = pte_pfn(pte);
	if (pfn_valid(pfn) && (page = pfn_to_page(pfn), page->mapping) &&
	    Page_dcache_dirty(page)) {
		if (pages_do_alias((unsigned long)page_address(page),
		                   address & PAGE_MASK)) {
			addr = (unsigned long) page_address(page);
			flush_data_cache_page(addr);
		}

		ClearPageDcacheDirty(page);
	}
}

//EXPORT_SYMBOL(flush_dcache_page);

extern void ld_mmu_rmpt(void);
extern void ld_mmu_r23000(void);
extern void ld_mmu_r4xx0(void);
extern void ld_mmu_tx39(void);
extern void ld_mmu_r6000(void);
extern void ld_mmu_tfp(void);
extern void ld_mmu_andes(void);
extern void ld_mmu_sb1(void);

void __init cpu_cache_init(void)
{
	rmt_str_printf("cpu_cache_init() #1\n");
	if (cpu_has_4ktlb) {
	rmt_str_printf("cpu_cache_init() #2\n");
#if defined(CONFIG_CPU_R4X00)  || defined(CONFIG_CPU_VR41XX) || \
    defined(CONFIG_CPU_R4300)  || defined(CONFIG_CPU_R5000)  || \
    defined(CONFIG_CPU_NEVADA) || defined(CONFIG_CPU_R5432)  || \
    defined(CONFIG_CPU_R5500)  || defined(CONFIG_CPU_MIPS32) || \
    defined(CONFIG_CPU_MIPS64) || defined(CONFIG_CPU_TX49XX) || \
    defined(CONFIG_CPU_RM7000) || defined(CONFIG_CPU_RM9000) 
		ld_mmu_r4xx0();
#endif
	} else {
		rmt_str_printf("cpu_cache_init() #3\n");
		switch (current_cpu_data.cputype) {
	
		case CPU_URMTP1:
		case CPU_URMTP2:
		case CPU_MRMTP1:
		case CPU_MRMTP2:
	rmt_str_printf("cpu_cache_init() #4\n");
			ld_mmu_rmtp();
		rmt_str_printf("cpu_cache_init() #5\n");
			break;
	
		default:
		rmt_str_printf("cpu_cache_init() #6\n");
			panic("Yeee, unsupported cache architecture.");
		}
	}
	rmt_str_printf("cpu_cache_init() #0\n");
}
