/*
 * r2300.c: R2000 and R3000 specific mmu/cache code.
 *
 * Copyright (C) 1996 David S. Miller (dm@engr.sgi.com)
 *
 * with a lot of changes to make this thing work for R3000s
 * Tx39XX R4k style caches added. HK
 * Copyright (C) 1998, 1999, 2000 Harald Koerfgen
 * Copyright (C) 1998 Gleb Raiko & Vladimir Roganov
 * Copyright (C) 2002  Ralf Baechle
 * Copyright (C) 2002  Maciej W. Rozycki
 */
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/mm.h>

#include <asm/page.h>
#include <asm/pgtable.h>
#include <asm/mmu_context.h>
#include <asm/system.h>
#include <asm/isadep.h>
#include <asm/io.h>
#include <asm/bootinfo.h>
#include <asm/cpu.h>
#include <asm/tlb.h>
#include <asm/thread_control.h>
#include <asm/sharereg_lock.h>
#include <asm/ioctls.h>

#include <asm/uaccess.h>
#ifdef CONFIG_RMT_TLBFLUSH_UACCESS        
extern atomic_t flag_wptlb_exist; 
#endif
int start_mmu_flag = 0;

/* TLB operations. */
void local_flush_tlb_all(void)
{
	int	i;
	
	rmt_str_printf("### LOCAL_FLUSH_TLB_ALL ###\n");
	sharereg_lock_tlb();

#if defined(CONFIG_RMT_TLB_GROUP_FIX_BIND) && 0
	/* flush group-id 2 - 9 */
	for (i=TLB_GRP_USER; i<TLB_GRP_USER+8; i++)
		write_mmu_register(MMU_SPR_GRP_FLUSH, i);
#else	
	/* flush group-id 2 - 63 */
	for (i=TLB_GRP_USER; i<(1UL<<TLB_ENT2_GRP_BITS); i++)
		write_mmu_register(MMU_SPR_GRP_FLUSH, i);
#endif
	
	sharereg_unlock_tlb();

	AXE_ITLBDUMP();
	AXE_DTLBDUMP();
}

#ifdef CONFIG_RMT_TLBFLUSH_UACCESS        
/* All flush TLB entries of data. */
void local_flush_dtlb_all(void)
{
	int	i;
	
	rmt_str_printf("### LOCAL_FLUSH_DTLB_ALL ###\n");
	sharereg_lock_tlb();

#if defined(CONFIG_RMT_TLB_GROUP_FIX_BIND) && 0
	/* flush group-id 2 - 9 */
	for (i=TLB_GRP_USER; i<TLB_GRP_USER+8; i++)
		write_dmmu_register(MMU_SPR_GRP_FLUSH, i);
#else	
	/* flush group-id 2 - 63 */
	for (i=TLB_GRP_USER; i<(1UL<<TLB_ENT2_GRP_BITS); i++)
		write_dmmu_register(MMU_SPR_GRP_FLUSH, i);
#endif
	
             atomic_set(&flag_wptlb_exist, 0);

	sharereg_unlock_tlb();

	AXE_ITLBDUMP();
	AXE_DTLBDUMP();
}
#endif

/*
 * This one is only used for pages with the global bit set so we don't care
 * much about the ASID.
 */
void local_flush_tlb_one(unsigned long page)
{
	rmt_str_printf("### LOCAL_FLUSH_TLB_ONE ###\n");
	local_flush_tlb_all();
}

void local_flush_tlb_mm(struct mm_struct *mm)
{
	int cpu = smp_processor_id();
	rmt_str_printf("### LOCAL_FLUSH_TLB_MM ###\n");

#if defined(CONFIG_RMT_TLB_GROUP_FIX_BIND)
	local_flush_tlb_all();
#else	
#error '!CONFIG_RMT_TLB_GROUP_FIX_BIND no support'
	if (cpu_context(cpu, mm) != 0)
		drop_mmu_context(mm, cpu);

	/* XXXX */
#endif
}

void local_flush_tlb_range(struct vm_area_struct *vma, unsigned long start,
			   unsigned long end)
{
	rmt_str_printf("### LOCAL_FLUSH_TLB_RANGE ###\n");
	local_flush_tlb_mm(vma->vm_mm);
}

void local_flush_tlb_kernel_range(unsigned long start, unsigned long end)
{
	rmt_str_printf("### LOCAL_FLUSH_KERNEL_RANGE ###\n");
	local_flush_tlb_all();
}

void local_flush_tlb_page(struct vm_area_struct *vma, unsigned long page)
{
	rmt_str_printf("### LOCAL_FLUSH_TLB_PAGE ###\n");
	local_flush_tlb_mm(vma->vm_mm);
}

void __update_tlb(struct vm_area_struct *vma, unsigned long address, pte_t pte)
{
	unsigned long flags;
	unsigned int group, padd, shr_th, pro;
	int	cause;
	spinlock_t tlb_lock = SPIN_LOCK_UNLOCKED;
	
	rmt_str_printf("### __UPDATE_TLB ###\n");
	rmt_str_printf("address=0x"); rmt_hex_printf(address);
	rmt_str_printf("pte=0x"); rmt_hex_printf(pte.pte);
	rmt_str_printf("PAGE_KERNEL=0x"); rmt_hex_printf(PAGE_KERNEL.pgprot);
	rmt_str_printf("PAGE_USERIO=0x"); rmt_hex_printf(PAGE_USERIO.pgprot);

	if (current->active_mm != vma->vm_mm)
		return;

	if(pte_val(pte) & _PAGE_WRITE) pro = 1;
	else pro = 0 ;

	if (pte_val(pte) & _PAGE_GLOBAL) {
		group = TLB_GRP_KERNEL;
		if(pro) pro = TLB_ENT1_PRO_KERRW;
		else pro = TLB_ENT1_PRO_KERR;
	} else {
#ifdef CONFIG_RMT_TLB_GROUP_FIX_BIND
		group = cpu_fix_context(rmt_mycnum());

#else
#error '!CONFIG_RMT_TLB_GROUP_FIX_BIND no support'

#if 0
		if(!vma->vm_mm->context.grpid)
			group = get_tlb_grpid_unused();

		group = vma->vm_mm->context.grpid;
#endif
#endif /* CONFIG_RMT_TLB_GROUP_FIX_BIND */

		if(pro) pro = TLB_ENT1_PRO_USRRW;
		else pro = TLB_ENT1_PRO_USRR;
	}
	shr_th = 1 << rmt_mycnum();
	
	local_irq_save(flags);
	address &= PAGE_MASK;
	padd = pte_val(pte) & PAGE_MASK;

	rmt_str_printf("group=0x"); rmt_hex_printf(group);
	rmt_str_printf("pro=0x"); rmt_hex_printf(pro);
	rmt_str_printf("shr_th=0x"); rmt_hex_printf(shr_th);
	rmt_str_printf("address=0x"); rmt_hex_printf(address);
	rmt_str_printf("padd=0x"); rmt_hex_printf(padd);

	sharereg_lock_tlb();
	write_mmu_register(MMU_SPR_GRP_FLUSH, group);

	cause = read_c0_cause() >> CAUSE_CODE_SFT;
	/* I-TLB */
	if(cause >= 0x1 && cause <= 0x5) {
		write_immu_register(MMU_SPR_ENTRY1,
			address | shr_th << TLB_ENT1_SHR_SHIFT | pro);
		write_immu_register(MMU_SPR_ENTRY2, 
			padd | TLB_ENT2_PSZ_4K |  group << TLB_ENT2_GRP_SHIFT |
			TLB_ENT2_UNC | TLB_ENT2_BRT_32B);
		write_immu_register(MMU_SPR_ENTRY_LRU, 0);
	/* D-TLB */
	} else if(cause >= 0x6 && cause <= 0xa ) {
		write_dmmu_register(MMU_SPR_ENTRY1,
			address | shr_th << TLB_ENT1_SHR_SHIFT | pro);
		write_dmmu_register(MMU_SPR_ENTRY2, 
			padd | TLB_ENT2_PSZ_4K |  group << TLB_ENT2_GRP_SHIFT |
			TLB_ENT2_UNC | TLB_ENT2_BRT_32B);
#ifdef CONFIG_RMT_TLBFLUSH_UACCESS        
                if (pro == TLB_ENT1_PRO_USRR) {
                        atomic_set(&flag_wptlb_exist, 1);
                }
#endif
		write_dmmu_register(MMU_SPR_ENTRY_LRU, 0);
	/* Other */
	} else {
		write_mmu_register(MMU_SPR_ENTRY1,
			address | shr_th << TLB_ENT1_SHR_SHIFT | pro);
		write_mmu_register(MMU_SPR_ENTRY2, 
			padd | TLB_ENT2_PSZ_4K |  group << TLB_ENT2_GRP_SHIFT |
			TLB_ENT2_UNC | TLB_ENT2_BRT_32B);
		write_mmu_register(MMU_SPR_ENTRY_LRU, 0);
	}

	sharereg_unlock_tlb();
	local_irq_restore(flags);
	AXE_DTLBDUMP();
	AXE_ITLBDUMP();
}

static int set_tlb_entry(unsigned int start, unsigned int size,
			 unsigned int entnum, int uncache)
{
	unsigned int i, vpn, page_size, psz;
	int rest;

	vpn = start;
	rest = size;
	i = entnum;
	do {
		if(rest <= (page_size=4<10)) psz = TLB_ENT2_PSZ_4K;
		else if(rest <= (page_size=64<<10)) psz = TLB_ENT2_PSZ_64K;
		else if(rest <= (page_size=1<<20)) psz = TLB_ENT2_PSZ_1M;
		else {page_size=16<<20; psz = TLB_ENT2_PSZ_16M;}

		rmt_str_printf("rest=0x"); rmt_hex_printf(rest);
		rmt_str_printf("start=0x"); rmt_hex_printf(start);
		rmt_str_printf("size=0x"); rmt_hex_printf(size);
		rmt_str_printf("page_size=0x"); rmt_hex_printf(page_size);
		/*
		if(mem >= (page_size=16<<20)) psz = TLB_ENT2_PSZ_16M;
		else if(mem >= (page_size=1<<20)) psz = TLB_ENT2_PSZ_1M;
		else if(mem >= (page_size=64<<10)) psz = TLB_ENT2_PSZ_64K;
		else {page_size = 4<<10; psz = TLB_ENT2_PSZ_4K;}
		*/
		
		/*
		 * [Index]		: i ( 1-- )
		 * [Entry1]
		 *	Lock		: ON
		 *	Protect		: Kernel R/W
		 *	Share Thread	: Enable with All Thread
		 * [Entry2]
		 *	Page Size	: psz
		 *	Group		: 1 (for Kernel)
		 *	Cache Lock	: OFF
		 *	Uncache		: ON
		 *	Burst		: 32Bytes
		 */
		write_mmu_register(MMU_SPR_ENTRY1, 
			(((vpn>>PAGE_SHIFT) << TLB_ENT1_VPN_SHIFT) |
			 TLB_ENT1_LCK |
			 TLB_ENT1_PRO_KERRW |
			 0xff<<TLB_ENT1_SHR_SHIFT ));

		write_mmu_register(MMU_SPR_ENTRY2,
			(((vpn>>PAGE_SHIFT) << TLB_ENT2_PPN_SHIFT) |
			psz |
			(TLB_GRP_KERNEL << TLB_ENT2_GRP_SHIFT) |
			 (uncache ? TLB_ENT2_UNC : 0) |
			TLB_ENT2_BRT_32B ));

		write_mmu_register(MMU_SPR_ENTRY_INDEX, i);
		
		i++;
		rest -= page_size;
		vpn += page_size;
		
		rmt_str_printf("set_tlb_entry i=0x");
		rmt_hex_printf(i);
		BUG_ON(i >= current_cpu_data.tlbsize);

	} while(rest > 0);

	return i;
}

#ifdef CONFIG_RMT_KERNEL_ICACHE_ENABLE
static void enable_rmtp_icache(int cid)
{
	__write_32bit_c0_register(CP0_ICACHE_ON, 0, 3 << (cid<<1));
}
#endif

/*
 * Turn on the MMU
 */
void enable_mmu(void)
{
	unsigned int i;
	rmt_str_printf("enable_mmu(): #1\n");
	if(rmt_mycnum()) {
		/* only enable mmu */
		write_mmu_register(MMU_SPR_START, 0x3<<(rmt_mycnum()*2));
#ifdef CONFIG_RMT_KERNEL_ICACHE_ENABLE
		enable_rmtp_icache(rmt_mycnum());
#endif
		return;
	}
	
	rmt_str_printf("MMU_SPR_ALL_FLUSH\n");
	write_mmu_register(MMU_SPR_ALL_FLUSH, 0x1);

	rmt_str_printf("enable_mmu(): #2 tlbent=0x");
	rmt_hex_printf(current_cpu_data.tlbsize);
	i = set_tlb_entry(RAM_BASE, RAM_SIZE, 1, 0);
	rmt_str_printf("enable_mmu(): #3 i=0x");
	rmt_hex_printf(i);
	i = set_tlb_entry(RMT_LINK_BASE, RMT_LINK_SIZE, i, 1);
	rmt_str_printf("enable_mmu(): #4 i=0x");
	rmt_hex_printf(i);
	i = set_tlb_entry(RMT_IO_BASE, RMT_IO_SIZE, i, 1);
	i = set_tlb_entry(RMT_DPM_EVNTIN_BASE, RMT_DPM_EVNTIN_SIZE, i, 1);
	i = set_tlb_entry(RMT_DPM_EVNTOUT_BASE, RMT_DPM_EVNTOUT_SIZE, i, 1);
	i = set_tlb_entry(RMT_DPM_DATAIN_BASE, RMT_DPM_DATAIN_SIZE, i, 1);
	i = set_tlb_entry(RMT_DPM_DATAOUT_BASE, RMT_DPM_DATAOUT_SIZE, i, 1);
	
#ifdef CONFIG_RMT_DEBUGIO
	/* 
	 * Memory Maped I/O
	 * for RMT Instruction-Level Simurator
	 */
	write_dmmu_register(MMU_SPR_ENTRY1,
		(((RMTSIM_DIO_ADDR>>PAGE_SHIFT) << TLB_ENT1_VPN_SHIFT) |
		TLB_ENT1_LCK |
		TLB_ENT1_PRO_ALLRW |
		(0x1<<TLB_ENT1_SHR_SHIFT) ));

	write_dmmu_register(MMU_SPR_ENTRY2,
		(((RMTSIM_DIO_ADDR>>PAGE_SHIFT) << TLB_ENT2_PPN_SHIFT) |
		TLB_ENT2_PSZ_4K |
		(TLB_GRP_KERNEL << TLB_ENT2_GRP_SHIFT) |
		TLB_ENT2_UNC |
		TLB_ENT2_BRT_32B ));
	
	write_dmmu_register(MMU_SPR_ENTRY_INDEX, i);
	i++;
#endif
	
#ifdef CONFIG_RMT_FILEMAPIO
	/* FileMap I/O  (for gethostfile) */
	write_dmmu_register(MMU_SPR_ENTRY1,
		(((RMTSIM_FILEMAP_ADDR>>PAGE_SHIFT) << TLB_ENT1_VPN_SHIFT) |
		TLB_ENT1_LCK |
		TLB_ENT1_PRO_ALLRW |
		(0x1<<TLB_ENT1_SHR_SHIFT) ));
		
	write_dmmu_register(MMU_SPR_ENTRY2,
		(((RMTSIM_FILEMAP_ADDR>>PAGE_SHIFT) << TLB_ENT2_PPN_SHIFT) |
		TLB_ENT2_PSZ_16M |
		(TLB_GRP_KERNEL << TLB_ENT2_GRP_SHIFT) |
		TLB_ENT2_UNC |
		TLB_ENT2_BRT_32B ));
	
	write_dmmu_register(MMU_SPR_ENTRY_INDEX, i);
#endif

	write_mmu_register(MMU_SPR_GROUP, TLB_GRP_KERNEL<<16|0xffff);
	write_mmu_register(MMU_SPR_START, 0x3);

	AXE_DTLBDUMP();
	AXE_ITLBDUMP();

	rmt_str_printf("- enable_mmu()\n");

#ifdef CONFIG_RMT_TLBFLUSH_UACCESS
        atomic_set(&flag_wptlb_exist, 0);
#endif

#ifdef CONFIG_RMT_KERNEL_ICACHE_ENABLE
	enable_rmtp_icache(rmt_mycnum());
#endif
}

void __init tlb_init(void)
{
	if(!rmt_mycnum())
		local_flush_tlb_all();
	
	rmt_str_printf("enable_mmu()\n");
	enable_mmu();
}


inline static 
void *__copy_to_user_with_test(void *vto, __const__ void *vfrom, size_t vlen)
{
	int next_page;
	size_t tmp_len;
	int tmp_vfrom = vfrom;
	int tmp_vto = vto;
	
	if (tmp_vto >= __UA_LIMIT) {
		goto no_check;
	}

	if (access_ok(VERIFY_WRITE, tmp_vto, vlen)) {
		goto out;
	}
        
	next_page = ((tmp_vto + PAGE_SIZE) & PAGE_MASK) - tmp_vto;
	while (vlen > 0){
		if (pretest_page_waccess(tmp_vto)) {
			//printk("tmp_vto = 0x%08x, tmp_vfrom = 0x%08x, vlen = %d\n",
			//		tmp_vto, tmp_vfrom, vlen);
			//panic(__FILE__,"(%d)",__LINE__);
			goto out;
		}
		tmp_len = min(next_page, vlen);
		_memcpy(tmp_vto, tmp_vfrom, tmp_len);			
		tmp_vto += tmp_len;
		tmp_vfrom += tmp_len;
		vlen -= tmp_len;
		next_page = PAGE_SIZE;        
	}
 out:
	return tmp_vto;

 no_check:
	return _memcpy(vto, vfrom, vlen);
}

void *memcpy(void *vto, __const__ void *vfrom, size_t vlen)
{
#ifdef CONFIG_RMT_TESTPAGE_UACCESS
        return __copy_to_user_with_test(vto, vfrom,  vlen);
#else
        return _memcpy(vto, vfrom, vlen);
#endif
}

inline static 
void *__move_to_user_with_test(void *vto, __const__ void *vfrom, size_t vlen)
{
	int next_page;
	size_t tmp_len;
	int tmp_vfrom = vfrom;
	int tmp_vto = vto;
	

	if (tmp_vto >= __UA_LIMIT) {
		goto no_check;
	}

	if (access_ok(VERIFY_WRITE, tmp_vto, vlen)) {
		goto out;
	}

	next_page = ((tmp_vto + PAGE_SIZE) & PAGE_MASK) - tmp_vto;
	while (vlen > 0){
		if (pretest_page_waccess(tmp_vto)) {
			//printk("tmp_vto = 0x%08x, tmp_vfrom = 0x%08x, vlen = %d\n",
			//		tmp_vto, tmp_vfrom, vlen);
			//panic(__FILE__,"(%d)",__LINE__);
			goto out;
		}
		tmp_len = min(next_page, vlen);
		_memmove(tmp_vto, tmp_vfrom, tmp_len);			
		tmp_vto += tmp_len;
		tmp_vfrom += tmp_len;
		vlen -= tmp_len;
		next_page = PAGE_SIZE;        
	}
 out:
	return tmp_vto;

 no_check:
	return _memmove(vto, vfrom, vlen);

}

void *memmove(void *vto, __const__ void *vfrom, size_t vlen)
{
#ifdef CONFIG_RMT_TESTPAGE_UACCESS
        return __move_to_user_with_test(vto, vfrom,  vlen);
#else
        return _memmove(vto, vfrom, vlen);
#endif
}

static inline memset_wait(unsigned long wait)
{
	unsigned long before, after;

	asm volatile("mfc0	%0, %1" : "=r"(before): "r"(0x39));
	do {
		asm volatile("mfc0	%0, %1" : "=r"(after) : "r"(0x39));
		asm volatile("sync");
	} while (after - before < wait);
}	

void *__set_to_user_with_test(void *vto, int c, size_t vlen)
{
	int i;
	int next_page;
	size_t tmp_len;
	int tmp_vto = vto;     

	unsigned long before;
	unsigned long after;

	if (tmp_vto >= __UA_LIMIT) {
		goto no_check;
	}

	if (access_ok(VERIFY_WRITE, tmp_vto, vlen)) {
		goto out;
	}

	next_page = ((tmp_vto + PAGE_SIZE) & PAGE_MASK) - tmp_vto;
	while (vlen > 0){
		rmt_str_printf("call pretest_page_waccess()\n");
		if (pretest_page_waccess(tmp_vto)) {
			//printk("tmp_vto = 0x%08x, c = 0x%08x, vlen = 0x%d\n"
			//	, tmp_vto, c, vlen);
			//panic(__FILE__, "(%d)", __LINE__);
			//goto out;
		}
		tmp_len = min(next_page, vlen);
		rmt_str_printf("call _memset()\n");
		_memset(tmp_vto, c, tmp_len);			
		rmt_str_printf("return from _memset()\n");
		tmp_vto += tmp_len;
		vlen -= tmp_len;
		next_page = PAGE_SIZE;        
	}
	goto out;

 no_check:
	rmt_str_printf("call _memset()\n");
	//printk("\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a");
	//printk("\a\a\a\a\a\a\a\a\a\a\a");
	//printk("\a\a\a\a\a\a\a\a\a\a\a\a");
	//asm volatile("mfc0	%0, %1" : "=r"(before): "r"(0x39));
	//printk("start = 0x%08x\n", vto);
	//memset_wait(240000);
	memset_wait(1000);
	//memset_wait(240000);
	//memset_wait(240000);
	//memset_wait(240000);
	//asm volatile("mfc0	%0, %1" : "=r"(after) : "r"(0x39));
	//printk("%lu\n", after - before);
	//printk("char = 0x%x\n", c);
	//printk("char = 0x%x\n", c);
	//printk("vlen = 0x%x\n", vlen);
	//for (i = 0; i < 10000; i++)
	//	asm volatile("sync");
	return _memset(vto, c, vlen);

 out:
	return tmp_vto;
}


void *memset(void *vto, int c, size_t vlen)
{
#ifdef CONFIG_RMT_TESTPAGE_UACCESS
	rmt_str_printf("call __set_to_user_with_test()\n");
        return __set_to_user_with_test(vto, c,  vlen);
	rmt_str_printf("return from __set_to_user_with_test()\n");
#else
	rmt_str_printf("call _memset()\n");
        return _memset(vto, c, vlen);
	rmt_str_printf("return from _memset()\n");
#endif
}

