/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2003 Ralf Baechle
 */
#ifndef _ASM_ASMMACRO_H
#define _ASM_ASMMACRO_H
 
#include <linux/config.h>
#include <asm/asmmacro-32.h>
#include <asm/rmt.h>

	.macro	local_irq_enable reg=t0 tmp
	ori	\tmp, $0, CP0_OWN_STATUS
	mfc0	\reg, \tmp
#ifdef CONFIG_RMTBUG_MMUREAD
	sync
#endif
	ori	\reg, \reg, 0x1
	mtc0	\reg, \tmp
	.endm

	.macro	local_irq_disable reg=t0 tmp
	ori	\tmp, $0, CP0_OWN_STATUS
	mfc0	\reg, \tmp
#ifdef CONFIG_RMTBUG_MMUREAD
	sync
#endif
	ori	\reg, \reg, 0x1
	xori	\reg, \reg, 0x1
	mtc0	\reg, \tmp
	SSNOP; SSNOP; SSNOP
	.endm

#ifdef CONFIG_CPU_SB1
	.macro	fpu_enable_hazard
	.set	push
	.set	noreorder
	.set	mips2
	SSNOP
	bnel	$0, $0, .+4
	 SSNOP
	.set	pop
	.endm
#else
	.macro	fpu_enable_hazard
	.endm
#endif

#endif /* _ASM_ASMMACRO_H */
