#ifndef _AXE_AXE_H
#define _AXE_AXE_H

#include <asm/rmtregs.h>

#define	CP0_TMP	$31 /* CP0_INTR_PND */

#if defined(CONFIG_AXE_DEBUG) && defined(CONFIG_RMT_INSTSIM)
#define AXE_BREAK(a) __axe_write_c0_register(0x01000000 | (a));
#define AXE_TRACE(a) __axe_write_c0_register(0x03000000 | (a));
#define AXE_INSTRDISP() __axe_write_c0_register(0x04000000);
#define AXE_REGDUMP(a) __axe_write_c0_register(0x05000000 | (a));
#define AXE_FPREGDUMP(a) __axe_write_c0_register(0x06000000 | (a));
//#define AXE_ITLBDUMP() __axe_write_c0_register(0x08000000);
//#define AXE_DTLBDUMP() __axe_write_c0_register(0x09000000);
#define AXE_ITLBDUMP()
#define AXE_DTLBDUMP()
#define AXE_CP0DUMP(a) __axe_write_c0_register(0x0a000000 | (a));
#define AXE_MEMDUMP(a) __axe_write_c0_register(a);
#define AXE_EXIT() __axe_write_c0_register(0x07000000);
#define	AXE_MONITOR() ({__asm__ __volatile__ (".long 0x01234567");})
#else
#define AXE_BREAK(a)
#define AXE_TRACE(a)
#define AXE_INSTRDISP()
#define AXE_REGDUMP(a)
#define AXE_FPREGDUMP(a)
#define AXE_ITLBDUMP()
#define AXE_DTLBDUMP()
#define AXE_CP0DUMP(a)
#define AXE_MEMDUMP(a)
#define AXE_EXIT()
#define	AXE_MONITOR()
#endif /* CONFIG_AXE_DEBUG */

#ifndef CONFIG_RMT_REALMACHINE
#define AXE_PUTCHAR(a) __axe_write_c0_register(0x02000000 | (a));

#define __axe_write_c0_register(value)\
do {\
	__asm__ __volatile__(\
		"nop\n"\
		"mtc0\t%0, %1\n\t"\
		"nop\n"\
		: : "r" ((unsigned int)value), "r"((unsigned int)0xff));\
} while (0)
#endif

#ifdef CONFIG_AXE_DEBUG
#define axe_dbg(...) printk(__VA_ARGS__)
#define axe_dbg2(...) printk(__VA_ARGS__)
#define dbg_str(...) _rmt_str_printf(__VA_ARGS__)
#define dbg_hex(...) _rmt_hex_printf(__VA_ARGS__)
#define rmt_str_printf(...) _rmt_str_printf(__VA_ARGS__)
#define rmt_hex_printf(...) _rmt_hex_printf(__VA_ARGS__)
#define rmt_hex_print(...) _rmt_hex_print(__VA_ARGS__)
#define rmt_show_regs(...) _rmt_show_regs(__VA_ARGS__)
#define rmt_show_pt_regs(...) _rmt_show_pt_regs(__VA_ARGS__)
#define rmt_print_hex(...) _rmt_print_hex(__VA_ARGS__)
#define rmt_print_dec(...) _rmt_print_dec(__VA_ARGS__)
#define rmt_print_val_hex(...) _rmt_print_val_hex(__VA_ARGS__)
#define rmt_print_val_dec(...) _rmt_print_val_dec(__VA_ARGS__)
#define rmt_print_task(...) _rmt_print_task(__VA_ARGS__)
#else /* CONFIG_AXE_DEBUG */
#define axe_dbg(...)
#define axe_dbg2(...)
#define dbg_str(...)
#define dbg_hex(...)
#define rmt_str_printf(...)
#define rmt_hex_printf(...)
#define rmt_hex_print(...)
#define rmt_show_regs(...)
#define rmt_show_pt_regs(...)
#define rmt_print_hex(...)
#define rmt_print_dec(...)
#define rmt_print_val_hex(...)
#define rmt_print_val_dec(...)
#define rmt_print_task(...)
#endif

#endif /* _AXE_AXE_H */
