/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1994, 1995, 1996, 1997, 2000, 2001 by Ralf Baechle
 * Copyright (C) 2000 Silicon Graphics, Inc.
 * Modified for further R[236]000 support by Paul M. Antoine, 1996.
 * Kevin D. Kissell, kevink@mips.com and Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 2000 MIPS Technologies, Inc.  All rights reserved.
 * Copyright (C) 2003  Maciej W. Rozycki
 */
#ifndef _ASM_MIPSREGS_H
#define _ASM_MIPSREGS_H

#include <linux/config.h>
#include <linux/linkage.h>
#include <asm/hazards.h>
#include <asm/dbgout.h>

/*
 * The following macros are especially useful for __asm__
 * inline assembler.
 */
#ifndef __STR
#define __STR(x) #x
#endif
#ifndef STR
#define STR(x) __STR(x)
#endif

/*
 *  Configure language
 */
#ifdef __ASSEMBLY__
#define _ULCAST_
#else
#define _ULCAST_ (unsigned long)
#endif

/*
 * Coprocessor 0 register names
 */
#define CP0_STATUS(x)		(CP0_STATUS_0 + (x))
#define	CP0_STATUS_0		0x00
#define	CP0_STATUS_1		0x01
#define	CP0_STATUS_2		0x02
#define	CP0_STATUS_3		0x03
#define	CP0_STATUS_4		0x04
#define	CP0_STATUS_5		0x05
#define	CP0_STATUS_6		0x06
#define	CP0_STATUS_7		0x07

#define CP0_THREAD_TABLE(x)	(CP0_THREAD_TABLE_0 + (x))
#define	CP0_THREAD_TABLE_0	0x08
#define	CP0_THREAD_TABLE_1	0x09
#define	CP0_THREAD_TABLE_2	0x0a
#define	CP0_THREAD_TABLE_3	0x0b
#define	CP0_THREAD_TABLE_4	0x0c
#define	CP0_THREAD_TABLE_5	0x0d
#define	CP0_THREAD_TABLE_6	0x0e
#define	CP0_THREAD_TABLE_7	0x0f

#define CP0_THREAD_ID(x)	(CP0_THREAD_ID_0 + (x))
#define	CP0_THREAD_ID_0		0x10
#define	CP0_THREAD_ID_1		0x11
#define	CP0_THREAD_ID_2		0x12
#define	CP0_THREAD_ID_3		0x13
#define	CP0_THREAD_ID_4		0x14
#define	CP0_THREAD_ID_5		0x15
#define	CP0_THREAD_ID_6		0x16
#define	CP0_THREAD_ID_7		0x17

#define CP0_INST_COUNT(x)	(CP0_INST_COUNT_0 + (x))
#define	CP0_INST_COUNT_0	0x18
#define	CP0_INST_COUNT_1	0x19
#define	CP0_INST_COUNT_2	0x1a
#define	CP0_INST_COUNT_3	0x1b
#define	CP0_INST_COUNT_4	0x1c
#define	CP0_INST_COUNT_5	0x1d
#define	CP0_INST_COUNT_6	0x1e
#define	CP0_INST_COUNT_7	0x1f

#define CP0_COUNT(x)		(CP0_COUNT_0 + (x))
#define	CP0_COUNT_0		0x20
#define	CP0_COUNT_1		0x21
#define	CP0_COUNT_2		0x22
#define	CP0_COUNT_3		0x23
#define	CP0_COUNT_4		0x24
#define	CP0_COUNT_5		0x25
#define	CP0_COUNT_6		0x26
#define	CP0_COUNT_7		0x27

#define CP0_COMPARE(x)		(CP0_COMPARE_0 + (x))
#define	CP0_COMPARE_0		0x28
#define	CP0_COMPARE_1		0x29
#define	CP0_COMPARE_2		0x2a
#define	CP0_COMPARE_3		0x2b
#define	CP0_COMPARE_4		0x2c
#define	CP0_COMPARE_5		0x2d
#define	CP0_COMPARE_6		0x2e
#define	CP0_COMPARE_7		0x2f

#define CP0_FP_CTRL(x)		(CP0_FP_CTRL_0 + (x))
#define	CP0_FP_CTRL_0		0x30
#define	CP0_FP_CTRL_1		0x31
#define	CP0_FP_CTRL_2		0x32
#define	CP0_FP_CTRL_3		0x33
#define	CP0_FP_CTRL_4		0x34
#define	CP0_FP_CTRL_5		0x35
#define	CP0_FP_CTRL_6		0x36
#define	CP0_FP_CTRL_7		0x37

#define	CP0_ISSUE_MODE		0x38

#define	CP0_CPU_COUNT_LOW	0x39
#define	CP0_CPU_COUNT_HIGH	0x3a

/* MMU Regosters */
#define	MMU_SPR_START		0x00
#define	MMU_SPR_ALL_FLUSH	0x04
#define	MMU_SPR_THREAD_FLUSH	0x08
#define	MMU_SPR_TLB_FLUSH	0x0c
#define	MMU_SPR_GRP_FLUSH	0x10
#define	MMU_SPR_LRU_FLUSH	0x14
#define	MMU_SPR_MAX_LOCK	0x18
#define	MMU_SPR_ENTRY1		0x1c
#define	MMU_SPR_ENTRY2		0x20
#define	MMU_SPR_ENTRY_INDEX	0x24
#define	MMU_SPR_ENTRY_LRU	0x28
#define	MMU_SPR_GROUP		0x2c
# define MMU_SPR_GROUP_SHIFT	16
#define	MMU_SPR_EXP_ADDR	0x30
#define	MMU_SPR_EXP_LOG		0x34

#define CP0_EPC(x)		(CP0_EPC_0 + (x))
#define CP0_EPC_0		0x48
#define CP0_EPC_1		0x49
#define CP0_EPC_2		0x4a
#define CP0_EPC_3		0x4b
#define CP0_EPC_4		0x4c
#define CP0_EPC_5		0x4d
#define CP0_EPC_6		0x4e
#define CP0_EPC_7		0x4f

#define CP0_CAUSE(x)		(CP0_CAUSE_0 + (x))
#define CP0_CAUSE_0		0x50
#define CP0_CAUSE_1		0x51
#define CP0_CAUSE_2		0x52
#define CP0_CAUSE_3		0x53
#define CP0_CAUSE_4		0x54
#define CP0_CAUSE_5		0x55
#define CP0_CAUSE_6		0x56
#define CP0_CAUSE_7		0x57

#define CP0_INTRP_WAIT(x)	(CP0_INTRP_WAIT_0 + (x))
#define	CP0_INTRP_WAIT_0	0x58
#define	CP0_INTRP_WAIT_1	0x59
#define	CP0_INTRP_WAIT_2	0x5a
#define	CP0_INTRP_WAIT_3	0x5b
#define	CP0_INTRP_WAIT_4	0x5c
#define	CP0_INTRP_WAIT_5	0x5d
#define	CP0_INTRP_WAIT_6	0x5e
#define	CP0_INTRP_WAIT_7	0x5f

#define CP0_EXT_INTRP_LV(x)	(CP0_EXT_INTRP_LV_0 + (x))
#define	CP0_EXT_INTRP_LV_0	0x60
#define	CP0_EXT_INTRP_LV_1	0x61
#define	CP0_EXT_INTRP_LV_2	0x62
#define	CP0_EXT_INTRP_LV_3	0x63
#define	CP0_EXT_INTRP_LV_4	0x64
#define	CP0_EXT_INTRP_LV_5	0x65
#define	CP0_EXT_INTRP_LV_6	0x66
#define	CP0_EXT_INTRP_LV_7	0x67

#define	CP0_INTR_PND		0x68
#define	CP0_INTR_CLEAR		0x69
#define	CP0_EXP_BASE_ADDR	0x6a
#define	CP0_EVENT_LINK_IN	0x70
#define	CP0_EVENT_LINK_OUT	0x76

/* Cache */
#define	CP0_ICACHE_ON		0x80
#define	CP0_ICACHE_REP_MODE	0x81
#define	CP0_ICACHE_ACC_SCHE	0x82
#define	CP0_ICACHE_LOCK		0x83
#define	CP0_ICACHE_RESET	0x84
#undef	CP0_ICACHE_FLUSH
#undef	CP0_ICACHE_ALL_FLUSH

#define	CP0_DCACHE_ON		0x86
#define	CP0_DCACHE_REP_MODE	0x87
#define	CP0_DCACHE_ACC_SCHE	0x88
#define	CP0_DCACHE_LOCK		0x89
#define	CP0_DCACHE_RESET	0x8a
#define	CP0_DCACHE_FLUSH	0x8b
#define	CP0_DCACHE_ALL_FLUSH	0x8c

#define	CP0_OWN_STATUS		0xe0
#define CP0_OWN_THREAD_TABLE	0xe1
#define CP0_OWN_THREAD_ID	0xe2
#define CP0_OWN_INST_COUNT	0xe3
#define CP0_OWN_COUNT		0xe4
#define CP0_OWN_COMPARE		0xe5
#define CP0_OWN_FP_CTRL		0xe6
#undef	CP0_OWN_BADVADDR
#define CP0_OWN_EPC		0xe8
#define CP0_OWN_CAUSE		0xe9
#define CP0_OWN_INTRP_WAIT	0xea
#define CP0_OWN_EXT_INTRP_LV	0xeb

/* Shared Registers */
#define	SHRREG_TLB		1

/*
 * FPU Status Register Values
 */
/*
 * Status Register Values
 */

#define FPU_CSR_FLUSH   0x01000000      /* flush denormalised results to 0 */
#define FPU_CSR_COND    0x00800000      /* $fcc0 */
#define FPU_CSR_COND0   0x00800000      /* $fcc0 */
#define FPU_CSR_COND1   0x02000000      /* $fcc1 */
#define FPU_CSR_COND2   0x04000000      /* $fcc2 */
#define FPU_CSR_COND3   0x08000000      /* $fcc3 */
#define FPU_CSR_COND4   0x10000000      /* $fcc4 */
#define FPU_CSR_COND5   0x20000000      /* $fcc5 */
#define FPU_CSR_COND6   0x40000000      /* $fcc6 */
#define FPU_CSR_COND7   0x80000000      /* $fcc7 */

/*
 * X the exception cause indicator
 * E the exception enable
 * S the sticky/flag bit
*/
#define FPU_CSR_ALL_X   0x0003f000
#define FPU_CSR_UNI_X   0x00020000
#define FPU_CSR_INV_X   0x00010000
#define FPU_CSR_DIV_X   0x00008000
#define FPU_CSR_OVF_X   0x00004000
#define FPU_CSR_UDF_X   0x00002000
#define FPU_CSR_INE_X   0x00001000

#define FPU_CSR_ALL_E   0x00000f80
#define FPU_CSR_INV_E   0x00000800
#define FPU_CSR_DIV_E   0x00000400
#define FPU_CSR_OVF_E   0x00000200
#define FPU_CSR_UDF_E   0x00000100
#define FPU_CSR_INE_E   0x00000080

#define FPU_CSR_ALL_S   0x0000007c
#define FPU_CSR_INV_S   0x00000040
#define FPU_CSR_DIV_S   0x00000020
#define FPU_CSR_OVF_S   0x00000010
#define FPU_CSR_UDF_S   0x00000008
#define FPU_CSR_INE_S   0x00000004

/* rounding mode */
#define FPU_CSR_RN      0x0     /* nearest */
#define FPU_CSR_RZ      0x1     /* towards zero */
#define FPU_CSR_RU      0x2     /* towards +Infinity */
#define FPU_CSR_RD      0x3     /* towards -Infinity */


/*
 * Values for PageMask register
 */
#ifdef CONFIG_RMT

#define PM_1K		0x00000000
#define PM_4K		0x00001800
#define PM_8K		0x00003000
#define PM_256K		0x0007f800
#define PM_16M		0x01fff800

#else

#define PM_4K		0x00000000
#define PM_16K		0x00006000
#define PM_64K		0x0001e000
#define PM_256K		0x0007e000
#define PM_1M		0x001fe000
#define PM_4M		0x007fe000
#define PM_16M		0x01ffe000
#define PM_64M		0x07ffe000
#define PM_256M		0x1fffe000

#endif

/*
 * Default page size for a given kernel configuration
 */
/*
#define	PSZ_4K		0x00000000
#define	PSZ_64K		0x00000400
#define	PSZ_1M		0x00000800
#define	PSZ_16M		0x00000c00
*/

#ifdef CONFIG_PAGE_SIZE_1KB
#define DEFAULT_PSZ	PM_1K
#elif defined(CONFIG_PAGE_SIZE_4KB)
#define DEFAULT_PSZ	PM_4K
#elif defined(CONFIG_PAGE_SIZE_8KB)
#define DEFAULT_PSZ	PM_8K
#elif defined(CONFIG_PAGE_SIZE_16KB)
#define DEFAULT_PSZ	PM_16K
#elif defined(CONFIG_PAGE_SIZE_64KB)
#define DEFAULT_PSZ	PM_64K
#else
#error Bad page size configuration!
#endif

#ifdef CONFIG_PAGE_SIZE_1KB
#define PM_DEFAULT_MASK	PM_1K
#elif defined(CONFIG_PAGE_SIZE_4KB)
#define PM_DEFAULT_MASK	PM_4K
#elif defined(CONFIG_PAGE_SIZE_8KB)
#define PM_DEFAULT_MASK	PM_8K
#elif defined(CONFIG_PAGE_SIZE_16KB)
#define PM_DEFAULT_MASK	PM_16K
#elif defined(CONFIG_PAGE_SIZE_64KB)
#define PM_DEFAULT_MASK	PM_64K
#else
#error Bad page size configuration!
#endif


/*
 * Values used for computation of new tlb entries
 */
#define PL_1K		10
#define PL_4K		12
#define PL_8K		13
#define PL_16K		14
#define PL_64K		16
#define PL_256K		18
#define PL_1M		20
#define PL_4M		22
#define PL_16M		24
#define PL_64M		26
#define PL_256M		28

/*
 * R4x00 interrupt enable / cause bits
 */
#define IE_SW0          (_ULCAST_(1) <<  8)
#define IE_SW1          (_ULCAST_(1) <<  9)
#define IE_IRQ0         (_ULCAST_(1) << 10)
#define IE_IRQ1         (_ULCAST_(1) << 11)
#define IE_IRQ2         (_ULCAST_(1) << 12)
#define IE_IRQ3         (_ULCAST_(1) << 13)
#define IE_IRQ4         (_ULCAST_(1) << 14)
#define IE_IRQ5         (_ULCAST_(1) << 15)

/*
 * R4x00 interrupt cause bits
 */
#define C_SW0           (_ULCAST_(1) <<  8)
#define C_SW1           (_ULCAST_(1) <<  9)
#define C_IRQ0          (_ULCAST_(1) << 10)
#define C_IRQ1          (_ULCAST_(1) << 11)
#define C_IRQ2          (_ULCAST_(1) << 12)
#define C_IRQ3          (_ULCAST_(1) << 13)
#define C_IRQ4          (_ULCAST_(1) << 14)
#define C_IRQ5          (_ULCAST_(1) << 15)

/*
 * Bitfields int the RMT cp0 status register
 */
#define ST0_IE			0x00000001
#define ST0_EL			0x00000002
#define ST0_KSU			0x00000018
# define KSU_USER		0x00000010
# define KSU_SUPERVISOR		0x00000008
# define KSU_KERNEL		0x00000000
#define ST0_EB			0x00000040
#define ST0_IM			0x00000f00
# define ST0_IM_TIMER		0x00000800
# define ST0_IM_HW		0x00000400
# define ST0_IM_SW1		0x00000200
# define ST0_IM_SW2		0x00000100
#define ST0_EV			0x00400000
#define ST0_PE			0x00800000
#define ST0_TS			0x01000000

#define EVECTOR0		0x80000180
#define	EVECTOR1		0xbfc00380

/*
 * Bitfields and bit numbers in the coprocessor 0 cause register.
 */
#define CAUSE_CODE_MSK		0x0000007c
#define CAUSE_CODE_SFT		0x00000002
#define CAUSE_PND_S0		0x00000100
#define CAUSE_PND_S1		0x00000200
#define CAUSE_PND_HI		0x00000400
#define CAUSE_PND_TI		0x00000800

#define  CAUSEB_EXCCODE		2
#define  CAUSEF_EXCCODE		(_ULCAST_(31)  <<  2)
#define  CAUSEB_IV		23
#define  CAUSEF_IV		(_ULCAST_(1)   << 23)
#define  CAUSEB_CE		28
#define  CAUSEF_CE		(_ULCAST_(3)   << 28)
#define  CAUSEB_BD		31
#define  CAUSEF_BD		(_ULCAST_(1)   << 31)

/*
 * These flags define in which privilege mode the counters count events
 */
#define CEB_USER	8	/* Count events in user mode, EXL = ERL = 0 */
#define CEB_SUPERVISOR	4	/* Count events in supvervisor mode EXL = ERL = 0 */
#define CEB_KERNEL	2	/* Count events in kernel mode EXL = ERL = 0 */
#define CEB_EXL		1	/* Count events with EXL = 1, ERL = 0 */

#ifndef __ASSEMBLY__

/*
 * Functions to access the r10k performance counter and control registers
 */
#define read_r10k_perf_cntr(counter)                            \
({ unsigned int __res;                                          \
        __asm__ __volatile__(                                   \
        "mfpc\t%0, "STR(counter)                                \
        : "=r" (__res));                                        \
        __res;})

#define write_r10k_perf_cntr(counter,val)                       \
        __asm__ __volatile__(                                   \
        "mtpc\t%0, "STR(counter)                                \
        : : "r" (val));

#define read_r10k_perf_cntl(counter)                            \
({ unsigned int __res;                                          \
        __asm__ __volatile__(                                   \
        "mfps\t%0, "STR(counter)                                \
        : "=r" (__res));                                        \
        __res;})

#define write_r10k_perf_cntl(counter,val)                       \
        __asm__ __volatile__(                                   \
        "mtps\t%0, "STR(counter)                                \
        : : "r" (val));

/*
 * Macros to access the system control coprocessor
 */

#ifdef CONFIG_RMT
#ifdef CONFIG_RMTBUG_MMUREAD
#define __read_32bit_c0_register(source, sel)				\
({ int __res;								\
	if (sel == 0)							\
		__asm__ __volatile__(					\
			"mfc0\t%0, %1\n\t"				\
			"sync\n\t"					\
			: "=r" (__res)					\
			: "r" ((unsigned int)source));			\
	else								\
		__asm__ __volatile__(					\
			".set\tmips32\n\t"				\
			"mfc0\t%0, %1 " #sel "\n\t"			\
			"sync\n\t"					\
			".set\tmips0\n\t"				\
			: "=r" (__res) 					\
			: "r" ((unsigned int)source));			\
	__res;								\
})

#else
#define __read_32bit_c0_register(source, sel)				\
({ int __res;								\
	if (sel == 0)							\
		__asm__ __volatile__(					\
			"mfc0\t%0, %1\n\t"				\
			: "=r" (__res)					\
			: "r" ((unsigned int)source));			\
	else								\
		__asm__ __volatile__(					\
			".set\tmips32\n\t"				\
			"mfc0\t%0, %1 " #sel "\n\t"			\
			".set\tmips0\n\t"				\
			: "=r" (__res) 					\
			: "r" ((unsigned int)source));			\
	__res;								\
})
#endif /* CONFIG_RMTBUG_MMUREAD */
#else
#define __read_32bit_c0_register(source, sel)				\
({ int __res;								\
	if (sel == 0)							\
		__asm__ __volatile__(					\
			"mfc0\t%0, " #source "\n\t"			\
			: "=r" (__res));				\
	else								\
		__asm__ __volatile__(					\
			".set\tmips32\n\t"				\
			"mfc0\t%0, " #source ", " #sel "\n\t"		\
			".set\tmips0\n\t"				\
			: "=r" (__res));				\
	__res;								\
})
#endif

#define __read_64bit_c0_register(source, sel)				\
({ unsigned long __res;							\
	if (sel == 0)							\
		__asm__ __volatile__(					\
			".set\tmips3\n\t"				\
			"dmfc0\t%0, " #source "\n\t"			\
			".set\tmips0"					\
			: "=r" (__res));				\
	else								\
		__asm__ __volatile__(					\
			".set\tmips64\n\t"				\
			"dmfc0\t%0, " #source ", " #sel "\n\t"		\
			".set\tmips0"					\
			: "=r" (__res));				\
	__res;								\
})

#ifdef CONFIG_RMT
#ifdef CONFIG_RMTBUG_MMUREAD
#define __write_32bit_c0_register(register, sel, value)			\
do {									\
	if (sel == 0)							\
		__asm__ __volatile__(					\
			"mtc0\t%0, %1\n\t"				\
			"sync\n\t"					\
			: 						\
			: "r" ((unsigned int)value), 			\
			  "r" ((unsigned int)register)			\
			);						\
	else								\
		__asm__ __volatile__(					\
			".set\tmips32\n\t"				\
			"mtc0\t%0, %1, " #sel "\n\t"			\
			"sync\n\t"					\
			".set\tmips0"					\
			: 						\
			: "r" ((unsigned int)value), 			\
			  "r" ((unsigned int)register) 			\
			);		\
} while (0)
#else
#define __write_32bit_c0_register(register, sel, value)			\
do {\
	if (sel == 0)\
		__asm__ __volatile__(					\
			"mtc0\t%0, %1\n\t"			\
			: \
			: "r" ((unsigned int)value), "r" ((unsigned int)register) \
			);		\
	else								\
		__asm__ __volatile__(					\
			".set\tmips32\n\t"				\
			"mtc0\t%0, %1, " #sel "\n\t"	\
			".set\tmips0"					\
			: \
			: "r" ((unsigned int)value), "r" ((unsigned int)register) \
			);		\
} while (0)
#endif /* CONFIG_RMTBUG_MMUREAD */
#else
#define __write_32bit_c0_register(register, sel, value)			\
do {\
	if (sel == 0)\
		__asm__ __volatile__(					\
			"mtc0\t%z0, " #register "\n\t"			\
			: : "Jr" ((unsigned int)value));		\
	else								\
		__asm__ __volatile__(					\
			".set\tmips32\n\t"				\
			"mtc0\t%z0, " #register ", " #sel "\n\t"	\
			".set\tmips0"					\
			: : "Jr" ((unsigned int)value));		\
} while (0)
#endif

#define __write_64bit_c0_register(register, sel, value)			\
do {									\
	if (sel == 0)							\
		__asm__ __volatile__(					\
			".set\tmips3\n\t"				\
			"dmtc0\t%z0, " #register "\n\t"			\
			".set\tmips0"					\
			: : "Jr" (value));				\
	else								\
		__asm__ __volatile__(					\
			".set\tmips64\n\t"				\
			"dmtc0\t%z0, " #register ", " #sel "\n\t"	\
			".set\tmips0"					\
			: : "Jr" (value));				\
} while (0)

#define __read_ulong_c0_register(reg, sel)				\
	((sizeof(unsigned long) == 4) ?					\
	__read_32bit_c0_register(reg, sel) :				\
	__read_64bit_c0_register(reg, sel))

#define __write_ulong_c0_register(reg, sel, val)			\
do {									\
	if (sizeof(unsigned long) == 4)					\
		__write_32bit_c0_register(reg, sel, val);		\
	else								\
		__write_64bit_c0_register(reg, sel, val);		\
} while (0)

/*
 * These versions are only needed for systems with more than 38 bits of
 * physical address space running the 32-bit kernel.  That's none atm :-)
 */
#define __read_64bit_c0_split(source, sel)				\
({									\
	unsigned long long val;						\
	unsigned long flags;						\
									\
	local_irq_save(flags);						\
	if (sel == 0)							\
		__asm__ __volatile__(					\
			".set\tmips64\n\t"				\
			"dmfc0\t%M0, " #source "\n\t"			\
			"dsll\t%L0, %M0, 32\n\t"			\
			"dsrl\t%M0, %M0, 32\n\t"			\
			"dsrl\t%L0, %L0, 32\n\t"			\
			".set\tmips0"					\
			: "=r" (val));					\
	else								\
		__asm__ __volatile__(					\
			".set\tmips64\n\t"				\
			"dmfc0\t%M0, " #source ", " #sel "\n\t"		\
			"dsll\t%L0, %M0, 32\n\t"			\
			"dsrl\t%M0, %M0, 32\n\t"			\
			"dsrl\t%L0, %L0, 32\n\t"			\
			".set\tmips0"					\
			: "=r" (val));					\
	local_irq_restore(flags);					\
									\
	val;								\
})

#define __write_64bit_c0_split(source, sel, val)			\
do {									\
	unsigned long flags;						\
									\
	local_irq_save(flags);						\
	if (sel == 0)							\
		__asm__ __volatile__(					\
			".set\tmips64\n\t"				\
			"dsll\t%L0, %L0, 32\n\t"			\
			"dsrl\t%L0, %L0, 32\n\t"			\
			"dsll\t%M0, %M0, 32\n\t"			\
			"or\t%L0, %L0, %M0\n\t"				\
			"dmtc0\t%L0, " #source "\n\t"			\
			".set\tmips0"					\
			: : "r" (val));					\
	else								\
		__asm__ __volatile__(					\
			".set\tmips64\n\t"				\
			"dsll\t%L0, %L0, 32\n\t"			\
			"dsrl\t%L0, %L0, 32\n\t"			\
			"dsll\t%M0, %M0, 32\n\t"			\
			"or\t%L0, %L0, %M0\n\t"				\
			"dmtc0\t%L0, " #source ", " #sel "\n\t"		\
			".set\tmips0"					\
			: : "r" (val));					\
	local_irq_restore(flags);					\
} while (0)

#define read_c0_inst_counter()		__read_32bit_c0_register(CP0_OWN_INST_COUNT, 0)

#define read_c0_exp_base_addr()		__read_32bit_c0_register(CP0_EXP_BASE_ADDR, 0)
#define write_c0_exp_base_addr(val)	__write_32bit_c0_register(CP0_EXP_BASE_ADDR, 0, val)

#define read_c0_count()		__read_32bit_c0_register(CP0_OWN_COUNT, 0)
#define write_c0_count(val)	__write_32bit_c0_register(CP0_OWN_COUNT, 0, val)

#define read_c0_compare()	__read_32bit_c0_register(CP0_OWN_COMPARE, 0)
#define write_c0_compare(val)	__write_32bit_c0_register(CP0_OWN_COMPARE, 0, val)

#define read_c0_status()	__read_32bit_c0_register(CP0_OWN_STATUS, 0)
#define write_c0_status(val)	__write_32bit_c0_register(CP0_OWN_STATUS, 0, val)

#define read_c0_cause()		__read_32bit_c0_register(CP0_OWN_CAUSE, 0)
#define write_c0_cause(val)	__write_32bit_c0_register(CP0_OWN_CAUSE, 0, val)

#define read_c0_epc()		__read_32bit_c0_register(CP0_OWN_EPC, 0)
#define write_c0_epc(val)	__write_32bit_c0_register(CP0_OWN_EPC, 0, val)

#define read_c0_count_n(n)	__read_32bit_c0_register(CP0_COUNT(n), 0)

#define read_c0_cpu_count_low()	__read_32bit_c0_register(CP0_CPU_COUNT_LOW, 0)
#define read_c0_cpu_count_high() __read_32bit_c0_register(CP0_CPU_COUNT_HIGH, 0)

/*
 * Macros to access the common format control registers
 */
#ifdef CONFIG_RMTBUG_MMUREAD
#define __read_mmu_register(name, reg)	\
({\
	unsigned int ret;\
	__asm__ __volatile__ (\
		"mf"#name"mm %0, %1\n\t"\
		"sync"\
		: "=r" ((unsigned int)ret)\
		: "r" ((unsigned int)reg)\
	);\
	ret;\
})
#else
#define __read_mmu_register(name, reg)	\
({\
	unsigned int ret;\
	__asm__ __volatile__ (\
		"mf"#name"mm %0, %1\n"\
		: "=r" ((unsigned int)ret)\
		: "r" ((unsigned int)reg)\
	);\
	ret;\
})
#endif
#define read_immu_register(reg) __read_mmu_register(i, (reg))
#define read_dmmu_register(reg) __read_mmu_register(d, (reg))

#define __write_mmu_register(name, reg, val)	\
do {\
	__asm__ __volatile__ (\
		"mt"#name"mm %0, %1\n\t"\
		"sync\n"\
		: \
		: "r"((unsigned int)val), "r" ((unsigned int)reg)\
	);\
} while(0)
#define write_immu_register(reg, val) __write_mmu_register(i, (reg), (val))
#define write_dmmu_register(reg, val) __write_mmu_register(d, (reg), (val))

#define write_mmu_register(reg, val)	\
do {\
	write_immu_register(reg, val);\
	write_dmmu_register(reg, val);\
} while(0)

#define __set_common_mmu_register(name, reg, id)\
do {\
	__write_mmu_register(name, (reg), (0x3<<(id)*2));\
} while(0)
#define set_common_immu_register(reg, id) __set_common_mmu_register(i, (reg), (id))
#define set_common_dmmu_register(reg, id) __set_common_mmu_register(d, (reg), (id))

#define __clear_common_mmu_register(name, reg, id)\
do {\
	__write_mmu_register(name, (reg), (~(0x3<<(id)*2)));\
} while(0)
#define clear_common_immu_register(reg, id) __clear_common_mmu_register(i, (reg), (id))
#define clear_common_dmmu_register(reg, id) __clear_common_mmu_register(d, (reg), (id))

#define __set_mmu_register(name, reg, set)\
do {\
	unsigned int val;\
	val = __read_mmu_register(name, reg);\
	val |= set;\
	__write_mmu_register(name, reg, val);\
} while(0)
#define set_immu_register(reg, set) __set_mmu_register(i, (reg), (set))
#define set_dmmu_register(reg, set) __set_mmu_register(d, (reg), (set))

#define __clear_mmu_register(name, reg, clear)\
do {\
	unsigned int val;\
	val = __read_mmu_register(name, reg);\
	val &= ~clear;\
	__write_mmu_register(name, reg, val);\
} while(0)
#define clear_immu_register(reg, clear) __clear_mmu_register(i, (reg), (clear))
#define clear_dmmu_register(reg, clear) __clear_mmu_register(d, (reg), (clear))

/*
 * Manipulate bits in a c0 register.
 */
#define __BUILD_SET_C0(name,register)				\
static inline unsigned int					\
set_c0_##name(unsigned int set)					\
{								\
	unsigned int res;					\
								\
	res = read_c0_##name();					\
	res |= set;						\
	write_c0_##name(res);					\
								\
	return res;						\
}								\
								\
static inline unsigned int					\
clear_c0_##name(unsigned int clear)				\
{								\
	unsigned int res;					\
								\
	res = read_c0_##name();					\
	res &= ~clear;						\
	write_c0_##name(res);					\
								\
	return res;						\
}								\
								\
static inline unsigned int					\
change_c0_##name(unsigned int change, unsigned int new)		\
{								\
	unsigned int res;					\
								\
	res = read_c0_##name();					\
	res &= ~change;						\
	res |= (new & change);					\
	write_c0_##name(res);					\
								\
	return res;						\
}

__BUILD_SET_C0(status,CP0_OWN_STATUS)
__BUILD_SET_C0(cause,CP0_OWN_CAUSE)
/*
__BUILD_SET_C0(config,CP0_CONFIG)
__BUILD_SET_C0(intcontrol,CP0_CONFIG)
*/
#define read_gp_register(register)	\
({\
	unsigned int	val;\
	__asm__ __volatile__ (\
		".set	push\n\t"\
		".set	noat\n\t"\
		"or	%0," #register ",$0\n\t"\
		".set	pop\n"\
		: "=r"((unsigned int)val)\
		: /* No Input */\
	);\
	val;\
})

#endif /* !__ASSEMBLY__ */

/*
 * for RMT Bug ......
 */
#ifdef CONFIG_RMTBUG_BEQJALR
# define RMTBUG_BEQJALR_SYNC ({__asm__ __volatile__ ("sync");})
#else /* CONFIG_RMTBUG_BEQJALR */
# define RMTBUG_BEQJALR_SYNC
#endif

#ifdef CONFIG_RMTBUG_MMUREAD
# ifdef __ASSEMBLY__
#  define RMTBUG_MMUREAD_SYNC sync 
# else
#  define RMTBUG_MMUREAD_SYNC ({__asm__ __volatile__ ("sync");})
# endif
#else
# define RMTBUG_MMUREAD_SYNC
#endif

#ifdef CONFIG_RMTBUG_BEQSYS
# ifdef __ASSEMBLY__
#  define RMTBUG_BEQSYS_NOP (nop;nop;nop;nop;nop;nop;nop;)
# else
#  define RMTBUG_BEQSYS_NOP ("nop\nnop\nnop\nnop\nnop\nnop\nnop")
# endif
#else /* CONFIG_RMTBUG_BEQSYS */
# define RMTBUG_BEQSYS_NOP
#endif

#ifdef CONFIG_RMTBUG_SWBEQ
# ifdef __ASSEMBLY__
#  define RMTBUG_SWBEQ_SYNC sync
# else
#  define RMTBUG_SWBEQ_SYNC ({__asm__ __volatile__ ("sync");})
# endif
#else /* CONFIG_RMTBUG_SWBEQ */
# define RMTBUG_SWBEQ_SYNC
#endif

#ifdef CONFIG_RMTBUG_RMTSYNC_MAYBE
#ifdef __ASSEMBLY__
#define RMTSYNC_MAYBE rmtsync_maybe
	.macro rmtsync_maybe
	.set    push
	.set    noreorder
	nop
	nop
	beq	zero, zero, 99f
	 nop
       99:
	sync
	sync
	sync
	sync
	sync
	.set	pop
	.endm

#define RMTSYNC_MAYBE_1	sync

#else
#define RMTSYNC_MAYBE __asm__ __volatile__(".set volatile\n"	\
		     "sync\n"					\
		     "sync\n"					\
		     "beq $0, $0, 1f\n"				\
		     "1: sync\n"				\
		     "sync\n"					\
		     "sync\n"					\
		     "sync\n"					\
		     "sync\n"					\
		     "sync\n"					\
		     "sync\n"					\
		     "sync\n"					\
		     ".set novolatile\n")
#define RMTSYNC_MAYBE_1	sync
#endif
#else /* !CONFIG_RMTBUG_RMTSYNC_MAYBE */
#define RMTSYNC_MAYBE
#define RMTSYNC_MAYBE_1 
#endif /* !CONFIG_RMTBUG_RMTSYNC_MAYBE */

#endif /* _ASM_MIPSREGS_H */
