#ifndef _ASM_SHAREREG_LOCK_H
#define _ASM_SHAREREG_LOCK_H

#ifndef __ASSEMBLY__

#define sharereg_lock(reg)					\
do {								\
	unsigned int	cid;					\
	__asm__ __volatile__ (					\
	".set	noreorder\n"					\
	"getotid	%0\n"					\
	"getcnum	%0, %0\n"				\
	"andi   	%0, %0, 0x7	# GETCNUM_AMASK\n"	\
	"gppr		$0, %1, %0\n"				\
	".set	reorder"					\
	: "=&r" ((unsigned int)cid)				\
	: "n" ((unsigned int)reg)				\
	);							\
} while(0)

#define sharereg_unlock(reg)					\
do {								\
	unsigned int	cid;					\
	__asm__ __volatile__ (					\
	".set	noreorder\n"					\
	"getotid	%0\n"					\
	"getcnum	%0, %0\n"				\
	"andi   	%0, %0, 0x7	# GETCNUM_AMASK\n"	\
	"gpco		%0, %1, %0\n"				\
	".set	reorder"					\
	: "=&r" ((unsigned int)cid)				\
	: "n" ((unsigned int)reg)				\
	);							\
} while(0)

#define sharereg_lock_tlb()	sharereg_lock(SHRREG_TLB)
#define sharereg_unlock_tlb()	sharereg_unlock(SHRREG_TLB)

#endif /* __ASSEMBLY__ */
#endif /* _ASM_SHAREREG_LOCK_H */
