/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1994, 95, 96, 99, 2001 Ralf Baechle
 * Copyright (C) 1994, 1995, 1996 Paul M. Antoine.
 * Copyright (C) 1999 Silicon Graphics, Inc.
 */
#ifndef _ASM_STACKFRAME_H
#define _ASM_STACKFRAME_H

#include <linux/config.h>
#include <linux/threads.h>

#include <asm/asm.h>
#include <asm/rmtregs.h>
#include <asm/offset.h>
#include <asm/rmt.h>
#include <asm/thread_control.h>

		.macro	SAVE_AT
		.set	push
		.set	noat
		LONG_S	$1, PT_R1(sp)
		.set	pop
		.endm

		.macro	SAVE_TEMP
		LONG_S	$8, PT_R8(sp)
		LONG_S	$9, PT_R9(sp)
		LONG_S	$10, PT_R10(sp)
		LONG_S	$11, PT_R11(sp)
		LONG_S	$12, PT_R12(sp)
		LONG_S	$13, PT_R13(sp)
		LONG_S	$14, PT_R14(sp)
		LONG_S	$15, PT_R15(sp)
		LONG_S	$24, PT_R24(sp)
		.endm

		.macro	SAVE_STATIC
		LONG_S	$16, PT_R16(sp)
		LONG_S	$17, PT_R17(sp)
		LONG_S	$18, PT_R18(sp)
		LONG_S	$19, PT_R19(sp)
		LONG_S	$20, PT_R20(sp)
		LONG_S	$21, PT_R21(sp)
		LONG_S	$22, PT_R22(sp)
		LONG_S	$23, PT_R23(sp)
		LONG_S	$30, PT_R30(sp)
		.endm

#ifdef CONFIG_SMP
		.macro	get_saved_sp	/* SMP variation */
		lui	k0, %hi(kernelsp)
		addiu	k0, k0, %lo(kernelsp)
		getotid	k1
		getcnum	k1, k1
		andi	k1, k1, GETCNUM_AMASK
		sll	k1, k1, 2
		addu	k0, k0, k1
		LONG_L	k1, 0x0(k0)
		.endm

		.macro	set_saved_sp stackp temp temp2
		lui	\temp, %hi(kernelsp)
		addiu	\temp, \temp, %lo(kernelsp)
		getotid	\temp2
		getcnum	\temp2, \temp2
		andi	\temp2, \temp2, GETCNUM_AMASK
		sll	\temp2, \temp2, 2
		addu	\temp, \temp, \temp2
		LONG_S	\stackp, 0x0(\temp)
		.endm
#else /* !CONFIG_SMP */
		.macro	get_saved_sp	/* Uniprocessor variation */
		lui	k1, %hi(kernelsp)
		LONG_L	k1, %lo(kernelsp)(k1)
		.endm

		.macro	set_saved_sp stackp temp temp2
		LONG_S	\stackp, kernelsp
		.endm
#endif /* CONFIG_SMP */

#ifdef CONFIG_PREEMPT
		.macro	bump_lock_count
		lw	t0, TI_PRE_COUNT($28)
		addiu	t0, t0, 1
		sw	t0, TI_PRE_COUNT($28)
		.endm
#else
		.macro	bump_lock_count
		.endm
#endif

		.macro	SAVE_SOME
		.set	push
		.set	reorder
		ori	k1, zero, CP0_OWN_STATUS
		mfc0	k0, k1
#ifdef CONFIG_RMTBUG_MMUREAD
		sync
#endif
		andi	k0, k0, KSU_USER
		.set	noreorder
		beq	zero, k0, 8f
		 or	k1, zero, sp
		.set	reorder
		/* Called from user mode, new stack. */
		get_saved_sp
8:		
		or	k0, zero, sp
		PTR_SUBU sp, k1, PT_SIZE
		LONG_S	k0, PT_R29(sp)
		LONG_S	$25, PT_R25(sp)
		LONG_S	$3, PT_R3(sp)
		LONG_S	$0, PT_R0(sp)
		ori	k0, zero, CP0_OWN_STATUS
		mfc0	v1, k0			/* read status register */
#ifdef CONFIG_RMTBUG_MMUREAD
		sync
#endif
		LONG_S	$2, PT_R2(sp)
		LONG_S	v1, PT_STATUS(sp)
		LONG_S	$4, PT_R4(sp)
		MFC0	k1, CP0_OWN_CAUSE, $25 /* Don't use $2-$7 (syscall) */
		LONG_S	$5, PT_R5(sp)
		LONG_S	k1, PT_CAUSE(sp)
		LONG_S	$6, PT_R6(sp)
		MFC0	v1, CP0_OWN_EPC, $25
		LONG_S	$7, PT_R7(sp)
#ifndef CONFIG_RMTBUG_EXCEPTION_ON_DELAYSLOT
		li	k0, CAUSEF_BD
		and	k0, k1, k0
		beq	k0, zero, 1f
		addiu   v1, v1, -4
1:
#endif
		LONG_S	v1, PT_EPC(sp)
		LONG_S	$28, PT_R28(sp)
		LONG_S	$31, PT_R31(sp)
		ori	$28, sp, _THREAD_MASK
		xori	$28, _THREAD_MASK
		bump_lock_count
		.set	pop
		.endm

		.macro	SAVE_ALL
		SAVE_SOME
		SAVE_AT
		SAVE_TEMP
		SAVE_STATIC
		.endm

		.macro	RESTORE_AT
		.set	push
		.set	noat
		LONG_L	$1,  PT_R1(sp)
		.set	pop
		.endm

		.macro	RESTORE_TEMP
		LONG_L	$8, PT_R8(sp)
		LONG_L	$9, PT_R9(sp)
		LONG_L	$10, PT_R10(sp)
		LONG_L	$11, PT_R11(sp)
		LONG_L	$12, PT_R12(sp)
		LONG_L	$13, PT_R13(sp)
		LONG_L	$14, PT_R14(sp)
		LONG_L	$15, PT_R15(sp)
		LONG_L	$24, PT_R24(sp)
		.endm

		.macro	RESTORE_STATIC
		LONG_L	$16, PT_R16(sp)
		LONG_L	$17, PT_R17(sp)
		LONG_L	$18, PT_R18(sp)
		LONG_L	$19, PT_R19(sp)
		LONG_L	$20, PT_R20(sp)
		LONG_L	$21, PT_R21(sp)
		LONG_L	$22, PT_R22(sp)
		LONG_L	$23, PT_R23(sp)
		LONG_L	$30, PT_R30(sp)
		.endm

		.macro	RESTORE_SOME
		.set	push
		.set	reorder
		.set	noat
		ori	v1, zero, CP0_OWN_STATUS
		mfc0	a0, v1 		/* Disable Inturrupts */
#ifdef CONFIG_RMTBUG_MMUREAD
		sync
#endif
		ori	a0, a0, 0x1
		xori	a0, a0, 0x1
		mtc0	a0, v1

		LONG_L	v1, PT_EPC(sp)
		ori	v0, $0, CP0_OWN_EPC
		mtc0	v1, v0
		
		ori	v1, zero, 0xf00	/* InturruptMask */
		and	a0, a0, v1
		LONG_L	v0, PT_STATUS(sp)
		nor	v1, zero, v1
		and	v0, v0, v1
		or	v0, v0, a0
		ori	v1, zero, CP0_OWN_STATUS
		mtc0	v0, v1
		LONG_L	$31, PT_R31(sp)
		LONG_L	$28, PT_R28(sp)
		LONG_L	$25, PT_R25(sp)
		LONG_L	$7,  PT_R7(sp)
		LONG_L	$6,  PT_R6(sp)
		LONG_L	$5,  PT_R5(sp)
		LONG_L	$4,  PT_R4(sp)
		LONG_L	$3,  PT_R3(sp)
		LONG_L	$2,  PT_R2(sp)
		.set	pop
		.endm

		.macro	RESTORE_SP_AND_RET
		LONG_L	sp, PT_R29(sp)
		.set	mips3
		eret
		.set	mips0
		.endm

		.macro	RESTORE_SP
		LONG_L	sp, PT_R29(sp)
		.endm

		.macro	RESTORE_ALL
		RESTORE_TEMP
		RESTORE_AT
		RESTORE_STATIC
		RESTORE_SOME
		RESTORE_SP
		.endm

		.macro	RESTORE_ALL_AND_RET
		RESTORE_TEMP
		RESTORE_AT
		RESTORE_STATIC
		RESTORE_SOME
		RESTORE_SP_AND_RET
		.endm

/*
 * Move to kernel mode and disable interrupts.
 * Set cp0 enable bit as sign that we're running on the kernel stack
 */
		.macro	CLI
		ori	t1, zero, CP0_OWN_STATUS
		mfc0	t0, t1
#ifdef CONFIG_RMTBUG_MMUREAD
		sync
#endif
		ori	t0, t0, 0x1f
		xori	t0, t0, 0x1f
		mtc0	t0, t1
		.endm

/*
 * Move to kernel mode and enable interrupts.
 * Set cp0 enable bit as sign that we're running on the kernel stack
 */
		.macro	STI
		ori	t1, zero, CP0_OWN_STATUS
		mfc0	t0, t1
#ifdef CONFIG_RMTBUG_MMUREAD
		sync
#endif
		ori	t0, t0, 0x1f
		xori	t0, t0, 0x1e
		mtc0	t0, t1
		.endm

/*
 * Just move to kernel mode and leave interrupts as they are.
 * Set cp0 enable bit as sign that we're running on the kernel stack
 */
		.macro	KMODE
		ori	t1, zero, CP0_OWN_STATUS
		mfc0	t0, t1
#ifdef CONFIG_RMTBUG_MMUREAD
		sync
#endif
		ori	t0, t0, 0x1e
		xori	t0, 0x1e
		mtc0	t0, t1
		.endm

#endif /* _ASM_STACKFRAME_H */
