#ifndef _ASM_THREAD_CONTROL_H
#define _ASM_THREAD_CONTROL_H

#define GETCNUM_AFLAG	0x100
#define GETCNUM_CFLAG	0x040
#define GETCNUM_AMASK	0x007
#define GETCNUM_CMASK	0x01f

#ifndef __ASSEMBLY__

#define	__BUILD_RMT_THCTRL0(type, name)		\
type rmt_##name (void)				\
{						\
	type __ret;				\
	__asm__ __volatile__ (			\
		STR(name) " %0"			\
		: "=r"((type)__ret)		\
	);					\
	return __ret;				\
}

#define	__BUILD_RMT_THCTRL1(type, name, type1, name1)\
type rmt_##name (type1 name1)			\
{						\
	type __ret;				\
	__asm__ __volatile__ (			\
		STR(name) " %0, %1"			\
		: "=r"((type)__ret)		\
		: "r"((type1)name1)		\
	);					\
	return __ret;				\
}

#define	__BUILD_RMT_THCTRL2(type, name, type1, name1, type2, name2)\
type rmt_##name (type1 name1, type2 name2)	\
{						\
	type __ret;				\
	__asm__ __volatile__ (			\
		STR(name) " %0, %1, %2"		\
		: "=r"((type)__ret)		\
		: "r"((type1)name1),		\
		  "r"((type2)name2)		\
	);					\
	return __ret;				\
}

/* rmt_mkth() */
static inline __BUILD_RMT_THCTRL2(int, mkth, unsigned int, id, unsigned long, pc)

/* rmt_delth() */
static inline __BUILD_RMT_THCTRL1(int, delth, unsigned int, id)

/* rmt_chgpr() */
static inline __BUILD_RMT_THCTRL2(int, chgpr, unsigned int, id, unsigned int, prio)

/* rmt_chgst() */
static inline __BUILD_RMT_THCTRL2(int, chgst, unsigned int, id, int, status)

/* rmt_runth() */
static inline __BUILD_RMT_THCTRL1(int, runth, unsigned int, id)

/* rmt_stopth() */
static inline __BUILD_RMT_THCTRL1(int, stopth, unsigned int, id)

/* rmt_stopslf() */
static inline __BUILD_RMT_THCTRL0(int, stopslf)

/* rmt_bkupth() */
static inline __BUILD_RMT_THCTRL1(int, bkupth, unsigned int, id)

/* rmt_bkupslf() */
static inline __BUILD_RMT_THCTRL0(int, bkupslf)

/* rmt_rstrth() */
static inline __BUILD_RMT_THCTRL1(int, rstrth, unsigned int, id)

/* rmt_swapth() */
static inline __BUILD_RMT_THCTRL2(int, swapth, unsigned int, aid, unsigned int, cid)

/* rmt_swapslf() */
static inline __BUILD_RMT_THCTRL1(int, swapslf, unsigned int, id)

/* rmt_cpthtoa() */
static inline __BUILD_RMT_THCTRL2(int, cpthtoa, unsigned int, pid, unsigned int, cid)

/* rmt_cpthtom() */
static inline __BUILD_RMT_THCTRL2(int, cpthtom, unsigned int, pid, unsigned int, cid)

/* rmt_gettt() */
static inline __BUILD_RMT_THCTRL1(unsigned int, gettt, unsigned int, id)

/* rmt_gettid() */
static inline __BUILD_RMT_THCTRL1(unsigned int, gettid, unsigned int, id)

/* rmt_getotid() */
static inline __BUILD_RMT_THCTRL0(unsigned int, getotid)

/* rmt_getmtid() */
static inline __BUILD_RMT_THCTRL1(unsigned int, getmtid, unsigned int, id)

/* rmt_getcnum() */
static inline __BUILD_RMT_THCTRL1(unsigned int, getcnum, unsigned int, id)

static inline unsigned int rmt_mycnum(void) {
	return (rmt_getcnum(rmt_getotid()) & GETCNUM_AMASK);
}

/* thread assignment */

#ifdef CONFIG_RMT_RTTHREAD

#define NNTHREADS (CONFIG_NR_CPUS - CONFIG_NR_RTTHREADS)
#define NRTTHREADS (CONFIG_NR_RTTHREADS)

#define RTT_CPU_START	NNTHREADS
#define RTT_CPU_END	(NNTHREADS + NRTTHREADS)

#define rtt_current()	(rmt_mycnum() - RTT_CPU_START)
#define rtt_smp_processor_id(rtt_n)  ((rtt_n)+RTT_CPU_START)

#else /* !CONFIG_RMT_RTTHREAD */

#define NNTHREADS CONFIG_NR_CPUS
#define NRTTHREADS 0

#endif /* !CONFIG_RMT_RTTHREAD */

#endif /* ! __ASSEMBLY__ */
#endif /* _ASM_THREAD_CONTROL_H */
