#ifndef __ENDIAN_H__
#define __ENDIAN_H__

#include <types.h>

hword_t hword_endian(hword_t x)
{
	return (((x << 8) & 0xff00) | ((x >> 8) & 0x00ff));
}

word_t word_endian(word_t x)
{
	return (((x << 24) & 0xff000000) | ((x << 8) & 0x00ff0000)
			| ((x >> 8) & 0x0000ff00) | ((x >> 24) & 0x000000ff));
}

#endif
