/*
 *
 *  $Id:$
 *
 *   Instruction Header File
 *
 */

#ifndef __INSTRUCTION_H__
#define __INSTRUCTION_H__

static inline void nop( void ){
asm volatile(
	"nop"
);
}


static inline void sync( void ){
asm volatile(
	"sync"
);
}


/* Thread Control Instruction */
static inline unsigned long mkth( unsigned long id, unsigned long pc ){
	unsigned long state;

asm volatile(
	"mkth	%0, %1, %2"
: "=r"(state) : "r"(id), "r"(pc));

	return state;
}


static inline unsigned long delth( unsigned long id ){
	unsigned long state;

asm volatile(
	"delth	%0, %1"
: "=r"(state) : "r"(id));

	return state;
}


static inline unsigned long stopslf( void ){
	unsigned long state;

asm volatile(
	"stopslf	%0"
: "=r"(state));

	return state;
}


static inline unsigned long chgpr( unsigned long id, unsigned long pr ){
	unsigned long state;

asm volatile(
	"chgpr	%0, %1, %2"
: "=r"(state) : "r"(id), "r"(pr));

	return state;
}


static inline unsigned long runth( unsigned long id ){
	unsigned long state;

asm volatile(
	"runth	%0, %1"
: "=r"(state) : "r"(id));

	return state;
}


static inline unsigned long bkupslf( void ){
	register unsigned long state;

asm volatile(
	"bkupslf	%0"
: "=r"(state));

	return state;
}


static inline unsigned long rstrth( unsigned long id ){
	register unsigned long state;

asm volatile(
	"rstrth	%0, %1"
: "=r"(state) : "r"(id));

	return state;
}


static inline unsigned long swapslf( unsigned long id ){
	register unsigned long state;

asm volatile(
	"swapslf	%0, %1"
: "=r"(state) : "r"(id));

	return state;
}


static inline unsigned long cpthtoa( unsigned long from, unsigned long to ){
	register unsigned long state;

asm volatile(
	"cpthtoa	%0, %1, %2"
: "=r"(state) : "r"(from), "r"(to));

	return state;
}


static inline unsigned long cpthtom( unsigned long from, unsigned long to ){
	register unsigned long state;

asm volatile(
	"cpthtom	%0, %1, %2"
: "=r"(state) : "r"(from), "r"(to));

	return state;
}


static inline unsigned long getotid( void ){
	unsigned long id;

asm volatile(
	"getotid	%0"
: "=r"(id));

	return id;
}


static inline unsigned long getcnum( unsigned long id ){
	unsigned long cid;

asm volatile(
	"getcnum	%0, %1"
: "=r"(cid) : "r"(id));

	return cid;
}


/* Sytem Instruction */
static inline void mtc0( unsigned long addr, unsigned long data ){
asm volatile(
	"mtc0	%0, %1"
: : "r"(data), "r"(addr));
}


static inline unsigned long mfc0( unsigned long addr ){
	unsigned long data;

asm volatile(
	"mfc0	%0, %1"
: "=r"(data) : "r"(addr));

	return data;
}


static inline void mtimm( unsigned long addr, unsigned long data ){
asm volatile(
	"mtimm	%0, %1"
: : "r"(data), "r"(addr));
}


static inline unsigned long mfimm( unsigned long addr ){
	unsigned long data;

asm volatile(
	"mfimm	%0, %1"
: "=r"(data) : "r"(addr));

	return data;
}


static inline void mtdmm( unsigned long addr, unsigned long data ){
asm volatile(
	"mtdmm	%0, %1"
: : "r"(data), "r"(addr));
}


static inline unsigned long mfdmm( unsigned long addr ){
	unsigned long data;

asm volatile(
	"mfdmm	%0, %1"
: "=r"(data) : "r"(addr));

	return data;
}


static inline long ll( unsigned long addr ){
	long data;

asm volatile(
	"ll		%0, 0(%1)"
: "=r"(data) : "r"(addr));

	return data;
}


static inline void sc( unsigned long addr, long data ){
asm volatile(
	"sc		%0, 0(%1)"
: : "r"(data), "r"(addr));
}


static inline void eret( void ){
asm volatile(
	"eret"
);
}


static inline long rem( long a, long b ){
	long result;

asm volatile(
	"rem	%0, %1, %2"
: "=r"(result) : "r"(a), "r"(b));

	return result;
}


static inline unsigned long remu( unsigned long a, unsigned long b ){
	unsigned long result;

asm volatile(
	"remu	%0, %1, %2"
: "=r"(result) : "r"(a), "r"(b));

	return result;
}


static inline long rtlv( long a, long b ){
	long result;

	asm volatile(
		"rtlv	%0, %1, %2"
	: "=r"(result) : "r"(a), "r"(b));

	return result;
}


static inline long getocnum( void ){
	return getcnum( getotid()) & 0x07;
}

#endif
