#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <elf.h>
#include <asm/page.h>
#include <time.h>
#include "rmtpcidump.h"

unsigned char cmd[SDRAM1_END - SDRAM1_START];


int main(int argc, char **argv)
{
	FILE *fdump = NULL;
	int fd;
	int i;
	char *dumpfile = NULL;
	char defaultdumpfile[100];
	time_t now;
	struct tm *date;
	int size = SDRAM1_END - SDRAM1_START;
	int ret;

#if 0
	if (argc == 2) {
		dumpfile = argv[1];		
	}
	else if (argc == 1) {		
		time(&now);
		date = localtime(&now);
		sprintf(defaultdumpfile, "%s_%s_%s_%s_%s.log", 
			date->tm_year + 1900, date->tm_mon + 1,
			date->tm_mday, date->tm_hour, data->tm_min);
		dumpfile = defaultdumpfile;
	}
	else {
		fprintf(stderr, "Usage: rmtpcidump LOGFILE\n");
		exit(1);
	}

	if (!(fdump = fopen(dumpfile, "w"))) {
		fprintf(stderr, "Failed to open %s\n", dumpfile);
		goto end;
	}
#endif

	printf("Opening the device...\n");
	/* open the pci device */
	fd = open(DEVNAME, O_RDWR);
	if (fd < 0) {
		ERROR("Cannot open %s.\n", DEVNAME);
		exit(2);
	}

	printf("Now dumping...\n");

	if ((ret = read(fd, (char*)cmd, size)) != size) {
		printf("Error: ret = %d\n", ret);
		exit(3);
	}
	for (i = 0; i < size / 4; i++) {
		printf("%08x %02x%02x%02x%02x\n",
					 SDRAM1_START + 4 * i,
					 cmd[4 * i + 0], cmd[4 * i + 1], cmd[4 * i + 2], cmd[4 * i + 3]);
	}

	return 0;
}

