/*

*/


#define	ADDR	0xffff3000

#define	DADDR(X)	0xffff2000+0x40*(X)

#define	C_P2S	0x11111111
#define	C_S2P	0x22222222
#define	C_ACK	0xffffffff

#define	CMD_GET_STATUS	0x00
#define	CMD_LOAD	0x01
#define	CMD_RUN_SR	0x02
#define	CMD_EXEC	0x03
#define	CMD_MOVE_TRAP	0x04
#define	CMD_REP_VER	0x05


#define NTOHL(X) \
	((unsigned long int)((((unsigned long int)(X) & 0x000000ffU) << 24) | \
		(((unsigned long int)(X) & 0x0000ff00U) <<  8) | \
		(((unsigned long int)(X) & 0x00ff0000U) >>  8) | \
		(((unsigned long int)(X) & 0xff000000U) >> 24)))

#define	UP_ID0	( { \
		wrasi4b( ADDR+3, 0x24 ); \
	} )

#define	DOWN_ID0 ( { \
		wrasi4b( ADDR+3, 0x20 ); \
	} )

#define	WAIT_SDMA_ED(x) ( { \
		while( ! ( rdasi4w(DADDR(x)+0x14) & 0x01 ) ) \
			; \
	} )

#define	WAIT_EOP ( { \
		while( ! ( rdasi4b(ADDR+0x38) & 0x01 ) ) \
			; \
	} )

#define	WAIT_XMREQ ( { \
		while( ! ( rdasi4b(ADDR+0x38) & 0x10 ) ) \
			; \
	} )


#define	WAIT_FULL ( { \
		while( ! (rdasi4b( ADDR+0x38 ) & 0x80) ) \
			; \
	} )

#define	DOWN_FULL ( { \
		while( (rdasi4b( ADDR+0x38 ) & 0x80) ) \
			; \
	} )

#define	DOWN_EMPTY ( { \
		while( (rdasi4b( ADDR+0x38 ) & 0x60) ) \
			; \
	} )

#define	SEND_MAIL( X ) ( { \
		while ( rdasi4w(ADDR) & 0x00000040 ) \
			; \
		wrasi4w( ADDR+0x08, X ); \
	} )

#define	RECV_MAIL( X ) ( { \
		unsigned long   l; \
		while (!((l=rdasi4w(ADDR)) & 0x00000010)) \
			; \
		*X = (unsigned long) rdasi4w( ADDR+4 ); \
		wrasi4w( ADDR, l|0x00000010 ); \
	} )
