
/* FILE*/
/*      nes.s*/

/*      Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.          */
/*      All rights reserved.                                                  */

/*      This software (including any documentation) is untested, has not been */
/*      fully tested for viruses and has been provided to you without charge. */
/*      ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR    */
/*      IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,  */
/*      FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all    */
/*      risk of nonperformance, loss of data and other problems and Fujitsu   */
/*      Microelectronics, Inc. and Fujitsu Limited will not be liable under   */
/*      any contract, negligence, strict liability or other theory for any    */
/*      damages including, without limitation, direct, consequential or       */
/*      incidental nor be required to provide substitute goods, services      */
/*      or technology.                                                        */

        .text

        .global _rdasi4b 
        .global _wrasi4b
        .global _rdasi4h 
        .global _wrasi4h
        .global _set_tbr

/*---------------------------------------------------------------*/
/* FUNCTION*/
/*      Read a byte from ASI 4 space*/
/* INPUT*/
/*      %o0 = addr*/
/* OUTPUT*/
/*      %o0 = output byte*/
/*---------------------------------------------------------------*/
_rdasi4b:
        lduba   [%o0] 4, %o0
        jmp     %o7+8
        nop


/*---------------------------------------------------------------*/
/* FUNCTION*/
/*      Write a byte to ASI 4 space*/
/* INPUT*/
/*      %o0 = addr*/
/*      %o1 = data byte*/
/* OUTPUT*/
/*---------------------------------------------------------------*/
_wrasi4b:
        stba    %o1, [%o0] 4
        jmp     %o7+8
        nop

/*---------------------------------------------------------------*/
/* FUNCTION*/
/*      Read a halfword from ASI 4 space*/
/* INPUT*/
/*      %o0 = addr*/
/* OUTPUT*/
/*      %o0 = output halfword*/
/*---------------------------------------------------------------*/
_rdasi4h:
        lduha   [%o0] 4, %o0
        jmp     %o7+8
        nop

/*---------------------------------------------------------------*/
/* FUNCTION*/
/*      Write a halfword to ASI 4 space*/
/* INPUT*/
/*      %o0 = addr*/
/*      %o1 = data halfword*/
/* OUTPUT*/
/*---------------------------------------------------------------*/
_wrasi4h:
        stha    %o1, [%o0] 4
        jmp     %o7+8
        nop

/*---------------------------------------------------------------*/
/* FUNCTION*/
/*      Set a value to %tbr*/
/* INPUT*/
/*      %o0 = value*/
/* OUTPUT*/
/*---------------------------------------------------------------*/
_set_tbr:
        wr      %o0, 0x0, %tbr
        jmp     %o7+8
        nop


