#
# FILE
#	prom.mak
#
#	Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.
#	All rights reserved.
#	
#	This software (including any documentation) is untested, has not been
#	fully tested for viruses and has been provided to you without charge.
#	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
#	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
#	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
#	risk of nonperformance, loss of data and other problems and Fujitsu
#	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
#	contract, negligence, strict liability or other theory for any damages
#	including, without limitation, direct, consequential or incidental nor
#	be required to provide substitute goods, services or technology.
#
# DESCRIPTION
#	This is the PC version of the Fujitsu monitor makefile on the 
#	SPARClite Evaluation Board.
#
# HISTORY
#	April 1993	Clark Li
#	November 1995	CCF
# 

ENTRY		= _traptbl

OBJECTS		= thndlrsl.o \
		  resetsl.o \
		  utilsl.o \
		  sdtrsl.o \
		  flash.o

CSOURCES	= $(SRC)/flash.c

SSOURCES	= $(SRC)/ttblsl.s \
		  $(SRC)/thndlrsl.s \
		  $(SRC)/resetsl.s \
		  $(SRC)/utilsl.s \
		  $(SRC)/dtrsl.s

SOURCES		= $(SSOURCES) \
		  $(CSOURCES)

HEADERS		= $(SRC)/utilsl.h

NESRCS          = $(SRC)/ne.c \
		  $(SRC)/nes.s

NEOBJS          = ne.o \
		  nes.o

NEHEADERS	= $(SRC)/splite.h \
		  $(SRC)/net.h

PCISRCS         = $(SRC)/pci.c \
		  $(SRC)/nes.s

PCIOBJS         = pci.o

PCIHEADERS	= $(SRC)/pci.h

$(TARGET):	$(OBJECTS) $(HEADERS) $(NEOBJS) $(NEHEADERS) \
			$(PCIOBJS) $(PCIHEADERS)
#
# create initial cksumsl.h file containing a temporary value of "0"
#
	echo .word 0 > $(SRC)/cksumsl.h
#
# always compile ttblsl.s
#
#	$(CPP) $(CPPFLAGS) $(SRC)/ttblsl.s ttblsl.i
#	$(AS) $(AFLAGS) -o ttblsl.o ttblsl.i
#	$(LN) $(LFLAGS) -o $(TARGETFILE) ttblsl.o $(OBJECTS) $(NEOBJS)
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/ttblsl.s ttblsl.i
	$(AS) -o ttblsl.o ttblsl.i
	$(LN) $(LFLAGS) -o $(TARGETFILE) ttblsl.o $(OBJECTS) $(NEOBJS) $(PCIOBJS)
#
# the following inserts a 16-bit value into the prom binary file
# such that the 16-bit checksum for the complete prom image will be
# zero.
#
	$(CREATECKSUM)

#
# relink with checksum
#
#	$(CPP) $(CPPFLAGS) $(SRC)/ttblsl.s ttblsl.i
#	$(AS) $(AFLAGS) -o ttblsl.o ttblsl.i
#	$(LN) $(LFLAGS) -o $(TARGETFILE) ttblsl.o $(OBJECTS) $(NEOBJS)
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/ttblsl.s ttblsl.i
	$(AS) -o ttblsl.o ttblsl.i
	$(LN) $(LFLAGS) -o $(TARGETFILE) ttblsl.o $(OBJECTS) $(NEOBJS) $(PCIOBJS)
#
# the following creates a prom binary image without any header or
# other extraneous information
#
	$(MAKEIMAGE)
#
# print final checksum to verify it is zero, then remove temporary files
#
	$(PRINTCKSUM)

#	$(REMOVE) *.o
	$(REMOVE) *.i
	
# Individual object dependencies

ttblsl.o:	$(SRC)/ttblsl.s
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/ttblsl.s ttblsl.i
	$(AS) -o ttblsl.o ttblsl.i
#	$(CPP) $(CPPFLAGS) $(SRC)/ttblsl.s ttblsl.i
#	$(AS) $(AFLAGS) -o ttblsl.o ttblsl.i

thndlrsl.o:	$(SRC)/thndlrsl.s $(HEADERS)
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/thndlrsl.s thndlrsl.i
	$(AS) -o thndlrsl.o thndlrsl.i
#	$(CPP) $(CPPFLAGS) $(SRC)/thndlrsl.s thndlrsl.i
#	$(AS) $(AFLAGS) -o thndlrsl.o thndlrsl.i

resetsl.o:	$(SRC)/resetsl.s $(HEADERS)
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/resetsl.s resetsl.i
	$(AS) -o resetsl.o resetsl.i
#	$(CPP) $(CPPFLAGS) $(SRC)/resetsl.s resetsl.i
#	$(AS) $(AFLAGS) -o resetsl.o resetsl.i

utilsl.o:	$(SRC)/utilsl.s
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/utilsl.s utilsl.i
	$(AS) -o utilsl.o utilsl.i
#	$(CPP) $(CPPFLAGS) $(SRC)/utilsl.s utilsl.i
#	$(AS) $(AFLAGS) -o utilsl.o utilsl.i

sdtrsl.o:	$(SRC)/sdtrsl.s
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/sdtrsl.s sdtrsl.i
	$(AS) -o sdtrsl.o sdtrsl.i
#	$(CPP) $(CPPFLAGS) $(SRC)/sdtrsl.s sdtrsl.i
#	$(AS) $(AFLAGS) -o sdtrsl.o sdtrsl.i

ne.o:		$(SRC)/ne.c $(SRC)/net.h $(SRC)/splite.h
	$(CC) $(CFLAGS) $(SRC)/ne.c

nes.o:		$(SRC)/nes.s 
	$(CPP) $(CPPFLAGS) $(AFLAGS) $(SRC)/nes.s nes.i
	$(AS) -o nes.o nes.i
#	$(CPP) $(CPPFLAGS) $(SRC)/nes.s nes.i
#	$(AS) $(AFLAGS) -o nes.o nes.i

flash.o:	$(SRC)/flash.c 
	$(CC) $(CFLAGS) $(SRC)/flash.c

pci.o:		$(SRC)/pci.c $(SRC)/pci.h
	$(CC) $(CFLAGS) $(SRC)/pci.c

#pci.o:		$(SRC)/pci.c $(SRC)/pci.h
#	$(CC) $(CFLAGS) $(SRC)/pci.c

#pci.o:		$(SRC)/pci.c $(SRC)/pci.h
#	sparc-gcc -S $(SRC)/pci.c
#	$(AS) -o pci.o pci.s

clean:
	-$(REMOVE) *.i 
	-$(REMOVE) *.o

clobber: clean
	-$(REMOVE) $(TARGETFILE) 
	-$(REMOVE) $(BINFILE)
