/*
 * FILE
 *      splite.h
 *
 *      Copyright(c) 1993, FMI, Fujitsu Microelectronics, Inc.
 *      All rights reserved.
 *
 *      This software (including any documentation) is untested, has not been
 *      fully tested for viruses and has been provided to you without charge.
 *      ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *      IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *      FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *      risk of nonperformance, loss of data and other problems and Fujitsu
 *      Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *      contract, negligence, strict liability or other theory for any damages
 *      including, without limitation, direct, consequential or incidental nor
 *      be required to provide substitute goods, services or technology.
 *
 * DESCRIPTION
 *      This header file describes mapping addresses of NICE registers
 *      on SPARClite evaluation board.
 *
 * HISTORY
 *      April 1993      Clark Li
 *      September 1996  kob
 */

#ifdef  BOARD_831C
#define BOARD_831       1
#endif

#define     SRAM_START  0x30000000      /* SRAM start address */
#define     DRAM_START  0x40000000      /* DRAM start address */

#define     NICEADDR    0x20000000      /* NICE regs base addr */

#define     NE_DLCR0    0x20000002      /* NICE DLRC regs */
#define     NE_DLCR1    0x20000003
#define     NE_DLCR2    0x20000006
#define     NE_DLCR3    0x20000007
#define     NE_DLCR4    0x2000000a
#define     NE_DLCR5    0x2000000b
#define     NE_DLCR6    0x2000000e
#define     NE_DLCR7    0x2000000f

#define     NE_IDR8     0x20000012      /* NICE IDR regs */
#define     NE_IDR9     0x20000013
#define     NE_IDR10    0x20000016
#define     NE_IDR11    0x20000017
#define     NE_IDR12    0x2000001a
#define     NE_IDR13    0x2000001b
#define     NE_IDR14    0x2000001e
#define     NE_IDR15    0x2000001f

#define     NE_HT8      0x20000012      /* NICE HT regs */
#define     NE_HT9      0x20000013
#define     NE_HT10     0x20000016
#define     NE_HT11     0x20000017
#define     NE_HT12     0x2000001a
#define     NE_HT13     0x2000001b
#define     NE_HT14     0x2000001e
#define     NE_HT15     0x2000001f

#define     NE_BMR8     0x20000012      /* NICE BMR regs */
#define     NE_BMR9     0x20000013
#define     NE_BMR10    0x20000016
#define     NE_BMR11    0x20000017
#define     NE_BMR12    0x2000001a
#define     NE_BMR13    0x2000001b
#define     NE_BMR14    0x2000001e
#define     NE_BMR15    0x2000001f


typedef unsigned char   uchar;
typedef unsigned short  ushort;
typedef unsigned long   ulong;
typedef unsigned int    uint;


