
/* FILE */
/*      utilsl.h         */

/*      Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.          */
/*      All rights reserved.                                                  */

/*      This software (including any documentation) is untested, has not been */
/*      fully tested for viruses and has been provided to you without charge. */
/*      ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR    */
/*      IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,  */
/*      FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all    */
/*      risk of nonperformance, loss of data and other problems and Fujitsu   */
/*      Microelectronics, Inc. and Fujitsu Limited will not be liable under   */
/*      any contract, negligence, strict liability or other theory for any    */
/*      damages including, without limitation, direct, consequential or       */
/*      incidental nor be required to provide substitute goods, services      */
/*      or technology.                                                        */

/* DESCRIPTION */
/*      This is a header file for various chip and board dependencies for     */
/*      evaluation board.                                                     */

/* HISTORY */
/*      April 1993      Clark Li                                              */
/*      November 1995   CCF                                                   */
/*      September 1996  kob                                                   */

/* The ASI for the 940 companion chip registers                               */
/*  varies between the 930/932/933/933H/934/936 (separate companion chip)     */
/*  and 931 (940 functions folded in).                                        */ 
/* Additionally, the byte alignment is different between the above-mentioned  */
/*  SPARClite chips.                                                          */

/* The following macros have been provided to abstract accesses to the 940    */
/*  address space as well as data alignment.                                  */

/* The defines BOARD_93(0,1,2,3,3H,4 or 6) and CHIP_93(0,1,2,3,3H,4 or 6),    */
/*  provide compile-time switch, and ifs                                      */
/*  relevent to version-specific anomalies are confined to this header file.  */

/* For backward compatibility to code written for the 930, these macros have  */
/*  been designed from the 930 point of view with respect to the need to      */

#ifdef BOARD_930
# define CHIP_930       1
# define WS_SRAM        0x4             /* SRAM wait 2 cycles w/o override */
# define WS_CC1         0x0             /* 0 wait state for companion chip */
# define AT_INTERFACE   1
# define DRAM_START     0x40000000
# define DRAM_HI_START  0x40400000      /* hi dram starts with 4MB */
# define DRAM_END       0x41000000      /* maximum 16MB */
#endif

#ifdef BOARD_931
# define CHIP_931       1
# define WS_SRAM        0x4             /* SRAM wait 2 cycles w/o override */
# define WS_CC1         0x0             /* 0 wait state for companion chip */
# define AT_INTERFACE   1
# define DRAM_START     0x40000000
# define DRAM_HI_START  0x40400000      /* hi dram starts with 4MB */
# define DRAM_END       0x41000000      /* maximum 16MB */
#endif

#ifdef BOARD_932
# define CHIP_932       1
# define WS_SRAM        0x10D           /* SRAM wait 2 cycles with override */
# define WS_CC1         0x214           /* 3 wait state for companion chip */
# define AT_INTERFACE   1
# define DRAM_START     0x40000000
# define DRAM_HI_START  0x40800000      /* only 8MB dram */
# define DRAM_END       0x40800000      /* only 8MB dram */
#endif

#ifdef BOARD_933
# define CHIP_933       1
# define WS_SRAM        0x5             /* SRAM wait 2 cycles with override */
# define WS_CC1         0x0             /* 0 wait state for companion chip */
# define AT_INTERFACE   1
# define DRAM_START     0x40000000
# define DRAM_HI_START  0x40400000      /* hi dram starts with 4MB */
# define DRAM_END       0x41000000      /* maximum 16MB */
# define TIMER_REGISTER 1
#endif

#ifdef BOARD_933H
# define CHIP_933H      1
# define WS_SRAM        0x5             /* SRAM wait 2 cycles with override */
# define WS_CC1         0x0             /* 0 wait state for companion chip */
# define ALT_CLOCK      1               /* alternate serial clock */
# define DRAM_START     0x40000000
# define DRAM_HI_START  0x40100000      /* hi dram starts with 1MB */
# define DRAM_END       0x40800000      /* maximum 8MB */
# define NO_HW_RESET    1
#endif

#ifdef BOARD_934
# define CHIP_934       1
# define FLASH          1
# define WS_SRAM        0x10D           /* SRAM wait 2 cycles with override  */
# define WS_FLASHRAM    0x634           /* 8 cycle flashram wait state  */
# define WS_CC1         0x214           /* 3 wait state for companion chip  */
# define SDRAM          1
# define ALT_CLOCK      1               /* alternate serial clock  */
# define DRAM_CONFIG_REGS 1
# define DRAM_BURST     1
# define DRAM_START     0x40000000
# define DRAM_HI_START  0x40400000      /* 4MB dram  */
# define DRAM_END       0x40800000      /* 8MB dram  */
# define SDRAM_START    0x50000000
# define SDRAM_HI_START 0x50400000      /* 4MB sdram  */
# define SDRAM_END      0x50800000      /* 8MB  dram  */
# define FLASHRAM_START 0x3000000
# define TIMER_REGISTER 1
# define NO_HW_RESET    1
#endif

#ifdef BOARD_936
# define CHIP_936       1
# define ALT_CLOCK      1               /* alternate serial clock */
# define DRAM_CONFIG_REGS 1
# define DRAM_BURST     1
# define FLASH          1
# define WS_SRAM        0x10D           /* SRAM wait 2 cycles with override */
# define WS_FLASHRAM    0x634           /* 8 cycle flashram wait state */
# define WS_CC1         0x214           /* 3 wait state for companion chip */
# define DRAM_START     0x40000000
# define DRAM_HI_START  0x40400000      /* 4MB dram */
# define DRAM_END       0x41000000      /* 16MB dram */
# define FLASHRAM_START 0x3000000
# define TIMER_REGISTER 1
# define NO_HW_RESET    1
# define INT_MODE1      1               /* Use mode 1 for internal int cntl */
                                        /*  if switch 8 is off */
#endif

#ifdef BOARD_831
# define CHIP_831       1
# define CHIP_83X       1

# define WS_SRAM        ((0<<8)|(0<<3)|5) /* SRAM r/w wait 1 cycles with override */
# define WS_DRAM        ((0<<8)|(0<<3)|0) /* DRAM                           */
# define WS_NICE        ((0<<8)|(0<<3)|0) /* wait state of NICE             */
# define WS_PERIRES     ((0<<8)|(0<<3)|0) /* Internal DRAMC & IRC           */
# define WS_CC1         ((7<<8)|(7<<3)|4) /* 8 wait state for companion chip*/

# define DRAM_START     0x04000000      /* Start of DRAM                    */
# define DRAM_HI_START  0x04400000      /* Start of expanded DRAM           */
# define DRAM_END_BANK_4MB  0x05000000  /* 4MB*4=16MB                       */
# define DRAM_END_BANK_16MB 0x08000000  /* 16MB*4=64MB                      */
# define DRAM_BANK_4MB  ((3<<4)|3)      /* 4MB/8MB : page=1024, bank=4MB    */
# define DRAM_BANK_16MB ((4<<4)|5)      /* 16/32MB : page=2048, bank=16MB   */


# define DRAM_ASR       (0xb04<<15)     /* ASI<8:B>, 0x04000000-0x07FFFFFF*/
# define DRAM_AMR       (0xfcfc<<15)
# define CS3_DRAMC      1               /* Internal DRAMC               */
# define CS3_IRC        1               /* Internal IRC                 */
# define CS3_ASI        7               /* ASI of CS3 resources         */
# define CS3_BASE       0x00000000      /* Base of CS3 resources        */
# define IRC_BASE       CS3_BASE        /* Base address of IRC          */
# define IRC_ASI        CS3_ASI         /* ASI of IRC                   */
# define DRAMC_BASE     (CS3_BASE+0x20) /* base of DRAMC                */
# define DRAM_STADR     3               /* DRAM StartAddress            */
                                        /*   1  (0x01000000)            */
                                        /*   2  (0x02000000)            */
                                        /*   3  (0x04000000)            */
# define DRAM_HE        1               /* Hyper-page enable            */
# define DRAM_TP        0               /* DRAM type                    */
                                        /*   0  4CAS-1WE                */
                                        /*   1  4WE-1CAS                */
# define DRAM_TRPS      0               /* RAS# precharge cycle         */
                                        /*      0 : 2 cycle             */
                                        /*      1 : 4 cycle             */
# define DRAM_RASCBR    2               /* RAS# pulse width             */
                                        /*      0 : 1 cycle             */
                                        /*      1 : 2 cycle             */
                                        /*      2 : 3 cycle             */
# define DRAM_TCAS      1               /* CAS# pulse width             */
                                        /*      0 : 1 cycle             */
                                        /*      1 : 2 cycle             */
# define DRAM_TRP       1               /* RAS# precharge width         */
                                        /*      0 : 1 cycle             */
                                        /*      1 : 2 cycle             */
# define NO_HW_RESET    1               /* no use trap %g0              */

#ifndef BAUDRATE
#define BAUDRATE        9600            /* boud rate                    */
#endif

#define CACHE_OFF_DISABLE   1   /* disable cache_off call after */
                                        /* memory test.                 */
#endif


#ifdef BOARD_832D
# define BOARD_831      1
# define CHIP_832       1
# define CHIP_83X       1

# define WS_SRAM        ((0<<8)|(0<<3)|5) /* SRAM r/w wait 1 cycles with override */
# define WS_DRAM        ((0<<8)|(0<<3)|0) /* DRAM                           */
# define WS_NICE        ((0<<8)|(0<<3)|0) /* wait state of NICE             */
# define WS_PERIRES     ((0<<8)|(0<<3)|0) /* Internal DRAMC & IRC           */
# define WS_CC1         ((7<<8)|(7<<3)|4) /* 8 wait state for companion chip*/

#if YBOARD == 0
# define DRAM_START     0x04000000      /* Start of DRAM                    */
# define DRAM_HI_START  0x04400000      /* Start of expanded DRAM           */
# define DRAM_END_BANK_4MB  0x05000000  /* 4MB*4=16MB                       */
# define DRAM_END_BANK_16MB 0x08000000  /* 16MB*4=64MB                      */
# define DRAM_BANK_4MB  ((3<<4)|3)      /* 4MB/8MB : page=1024, bank=4MB    */
# define DRAM_BANK_16MB ((4<<4)|5)      /* 16/32MB : page=2048, bank=16MB   */
#else
# define DRAM_START     0x08000000      /* Start of DRAM                    */
# define DRAM_HI_START  0x08400000      /* Start of expanded DRAM           */
# define DRAM_END_BANK_4MB  0x09000000  /* 4MB*4=16MB                       */
# define DRAM_END_BANK_16MB 0x0c000000  /* 16MB*4=64MB                      */
# define DRAM_BANK_4MB  ((3<<4)|3)      /* 4MB/8MB : page=1024, bank=4MB    */
# define DRAM_BANK_16MB ((4<<4)|5)      /* 16/32MB : page=2048, bank=16MB   */

# define SDRAM_START	0x08000000
# define SDRAM_HI_START	0x08400000	/* ad hoc, from upper DRAM value */
# define SDRAM_END	0x09000000	/* 16MB */
#endif

# define DRAM_ASR       (0xb04<<15)     /* ASI<8:B>, 0x04000000-0x07FFFFFF*/
# define DRAM_AMR       (0xfcfc<<15)
# define CS3_DRAMC      1               /* Internal DRAMC               */
# define CS3_IRC        1               /* Internal IRC                 */
# define CS3_ASI        7               /* ASI of CS3 resources         */
# define CS3_BASE       0x00000000      /* Base of CS3 resources        */
# define IRC_BASE       0xffffd000      /* Base address of IRC          */
# define IRC_ASI        37              /* ASI of IRC                   */
# define DRAMC_BASE     (CS3_BASE+0x20) /* base of DRAMC                */
# define DRAM_STADR     3               /* DRAM StartAddress            */
                                        /*   1  (0x01000000)            */
                                        /*   2  (0x02000000)            */
                                        /*   3  (0x04000000)            */
# define DRAM_HE        1               /* Hyper-page enable            */
# define DRAM_TP        0               /* DRAM type                    */
                                        /*   0  4CAS-1WE                */
                                        /*   1  4WE-1CAS                */
# define DRAM_TRPS      0               /* RAS# precharge cycle         */
                                        /*      0 : 2 cycle             */
                                        /*      1 : 4 cycle             */
# define DRAM_RASCBR    2               /* RAS# pulse width             */
                                        /*      0 : 1 cycle             */
                                        /*      1 : 2 cycle             */
                                        /*      2 : 3 cycle             */
# define DRAM_TCAS      1               /* CAS# pulse width             */
                                        /*      0 : 1 cycle             */
                                        /*      1 : 2 cycle             */
# define DRAM_TRP       1               /* RAS# precharge width         */
                                        /*      0 : 1 cycle             */
                                        /*      1 : 2 cycle             */
# define NO_HW_RESET    1               /* no use trap %g0              */

#define CACHE_OFF_DISABLE   1           /* disable cache_off call after */
                                        /* memory test.                 */
#ifdef MASTER_CK_10
#define FIX_CLK         10              /* fixed CPU clock (MHz)        */
#endif
#ifdef MASTER_CK_20
#define FIX_CLK         20              /* fixed CPU clock (MHz)        */
#endif
#ifdef MASTER_CK_30
#define FIX_CLK         30              /* fixed CPU clock (MHz)        */
#endif
#ifdef MASTER_CK_40
#define FIX_CLK         40              /* fixed CPU clock (MHz)        */
#endif
#ifdef MASTER_CK_50
#define FIX_CLK         50              /* fixed CPU clock (MHz)        */
#endif

#define FIX_SW1         0x00            /* fixed SW1                    */
# define NO_DRAM                         /* No DRAM                      */

#define NO_NICE                         /* No NICE                      */
#define NO_LED                          /* No LED                       */
#define NO_IRC                          /* No IRC                       */
#define NO_TIMER                        /* No Timer                     */
#endif


#ifdef BOARD_832DD

# define BOARD_831      1
# define CHIP_832       1
# define CHIP_83X       1

# define WS_SRAM        ((0<<8)|(0<<3)|5) /* SRAM r/w wait 1 cycles with override */
# define WS_DRAM        ((0<<8)|(0<<3)|0) /* DRAM                           */
# define WS_NICE        ((0<<8)|(0<<3)|0) /* wait state of NICE             */
# define WS_PERIRES     ((0<<8)|(0<<3)|0) /* Internal DRAMC & IRC           */
# define WS_CC1         ((7<<8)|(7<<3)|4) /* 8 wait state for companion chip*/

# define DRAM_START     0x04000000      /* Start of DRAM                    */
# define DRAM_HI_START  0x04400000      /* Start of expanded DRAM           */
# define DRAM_END_BANK_4MB  0x05000000  /* 4MB*4=16MB                       */
# define DRAM_END_BANK_16MB 0x08000000  /* 16MB*4=64MB                      */
# define DRAM_BANK_4MB  ((3<<4)|3)      /* 4MB/8MB : page=1024, bank=4MB    */
# define DRAM_BANK_16MB ((4<<4)|5)      /* 16/32MB : page=2048, bank=16MB   */

# define DRAM_ASR       (0xb04<<15)     /* ASI<8:B>, 0x04000000-0x07FFFFFF*/
# define DRAM_AMR       (0xfcfc<<15)
# define CS3_DRAMC      1               /* Internal DRAMC               */
# define CS3_IRC        1               /* Internal IRC                 */
# define CS3_ASI        7               /* ASI of CS3 resources         */
# define CS3_BASE       0x00000000      /* Base of CS3 resources        */
# define IRC_BASE       CS3_BASE        /* Base address of IRC          */
# define IRC_ASI        CS3_ASI         /* ASI of IRC                   */
# define DRAMC_BASE     (CS3_BASE+0x20) /* base of DRAMC                */
# define DRAM_STADR     3               /* DRAM StartAddress            */
                                        /*   1  (0x01000000)            */
                                        /*   2  (0x02000000)            */
                                        /*   3  (0x04000000)            */
# define DRAM_HE        1               /* Hyper-page enable            */
# define DRAM_TP        0               /* DRAM type                    */
                                        /*   0  4CAS-1WE                */
                                        /*   1  4WE-1CAS                */
# define DRAM_TRPS      0               /* RAS# precharge cycle         */
                                        /*      0 : 2 cycle             */
                                        /*      1 : 4 cycle             */
# define DRAM_RASCBR    2               /* RAS# pulse width             */
                                        /*      0 : 1 cycle             */
                                        /*      1 : 2 cycle             */
                                        /*      2 : 3 cycle             */
# define DRAM_TCAS      1               /* CAS# pulse width             */
                                        /*      0 : 1 cycle             */
                                        /*      1 : 2 cycle             */
# define DRAM_TRP       1               /* RAS# precharge width         */
                                        /*      0 : 1 cycle             */
                                        /*      1 : 2 cycle             */
# define NO_HW_RESET    1               /* no use trap %g0              */

#ifndef BAUDRATE
#define BAUDRATE        9600            /* boud rate                    */
#endif

#define CACHE_OFF_DISABLE   1           /* disable cache_off call after */
                                        /* memory test.                 */
#define NO_DRAM                         /* No DRAM                      */
#define NO_NICE                         /* No LANC                      */
/*#define NO_LED     */                     /* No LED                       */
#define NO_IRC                          /* No IRC                       */
#define NO_TIMER                        /* No Timer                     */

#endif


#ifdef BOARD_831C
# define BOARD_831      1
# define CHIP_831       1
# define WS_SRAM        ((0<<8)|(0<<3)|5) /* SRAM r/w wait 0 cycles with override */
# define WS_DRAM        ((0<<8)|(0<<3)|0) /* DRAM */
# define WS_NICE        ((0<<8)|(0<<3)|0) /* wait state of NICE             */
# define WS_PERIRES     ((0<<8)|(0<<3)|0) /* Internal DRAMC & IRC           */
# define WS_CC1         ((7<<8)|(7<<3)|4) /* 8 wait state for companion chip*/

# define DRAM_START     0x40000000      /* Start of DRAM                    */
# define DRAM_HI_START  0x40400000      /* Start of expanded DRAM           */
# define DRAM_END_BANK_4MB  0x41000000  /* 4MB*4=16MB                       */
# define DRAM_END_BANK_16MB 0x44000000  /* 16MB*4=64MB                      */
# define DRAM_BANK_4MB  ((3<<4)|3)      /* 4MB/8MB : page=1024, bank=4MB    */
# define DRAM_BANK_16MB ((4<<4)|5)      /* 16/32MB : page=2048, bank=16MB   */

# define DRAM_ASR       (0xb4<<19)      /* ASI<8:B>, 0x04000000-0x07FFFFFF  */
# define DRAM_AMR       (0xfcfc<<15)

# define CS3_ASI        7               /* ASI of CS3 resources         */
# define CS3_BASE       0x00000000      /* Base of CS3 resources        */

# define NO_HW_RESET    1               /* no use trap %g0              */

#ifndef BAUDRATE
#define BAUDRATE        9600            /* boud rate                    */
#endif

#define CACHE_OFF_DISABLE   1   /* disable cache_off call after */
                                        /* memory test.                 */

#endif


#ifdef BOARD_931
# define CC1_ASI                1
# define CC1_BASE_ADDR          0x0200
# define ALIGN_2LO_STA(reg)     srl     reg, 0x10, reg
# define ALIGN_2LO_LDA(reg)
# define ALIGN_2HI_STA(reg)
# define ALIGN_2HI_LDA(reg)     sll     reg, 0x10, reg
#else
# ifdef BOARD_832D
#  define CC1_ASI                4
#  define CC1_BASE_ADDR          0xffff6000
#  define CC1_ADDR               0xffff6000
#  define ALIGN_2LO_STA(reg)     srl     reg, 0x10, reg
#  define ALIGN_2LO_LDA(reg)
#  define ALIGN_2HI_STA(reg)
#  define ALIGN_2HI_LDA(reg)     sll     reg, 0x10, reg
# else
#  define CC1_ASI                4
#  define CC1_BASE_ADDR          0x10000000
#  define CC1_ADDR               0x10000000
#  define ALIGN_2LO_STA(reg)
#  define ALIGN_2LO_LDA(reg)     srl     reg, 0x10, reg
#  define ALIGN_2HI_STA(reg)     sll     reg, 0x10, reg
#  define ALIGN_2HI_LDA(reg)
# endif
#endif

#define SL_DCACHE_LINE          64      /* number of dcache lines */
#define SL_DCACHE_BYTENUM       16      /* number of bytes in a dcache line */

/* Different configuration parameters by chips */

#ifdef CHIP_930
# define PSR_RESET      0xfa7   /* Set psr: trap enabled, S=1, PS=0, */
                                /*  cwp=7, int mask=15 */
# define NWINDOWS       8       /* number of register windows */
# define SL_CACHE       1       /* has cache */
# define SL_ICACHE_LINE 64      /* number of icache lines */
# define SL_ICACHE_BYTENUM 16   /* number of bytes in an icache line */
#endif

#ifdef CHIP_931
# define PSR_RESET      0xfa7   /* Set psr: trap enabled, S=1, PS=0, */
                                /*  cwp=7, int mask=15 */
# define NWINDOWS       8       /* number of register windows */
# define SL_CACHE       1       /* has no cache */
# define SL_ICACHE_LINE 64      /* number of icache lines */
# define SL_ICACHE_BYTENUM 16   /* number of bytes in an icache line */
#endif

#ifdef CHIP_932
# define PSR_RESET      0xfa7   /* Set psr: trap enabled, S=1, PS=0, */
                                /*  cwp=7, int mask=15 */
# define NWINDOWS       8       /* number register windows */
# define SL_CACHE       1       /* has cache */
# define SL_ICACHE_LINE 128     /* number of icache lines */
# define SL_ICACHE_BYTENUM 32   /* number of bytes in an icache line */
#endif

#ifdef CHIP_933
# define PSR_RESET      0xfa5   /* Set psr: trap enabled, S=1, PS=0, */
                                /*  cwp=5, int mask=15 */
# define NWINDOWS       6       /* number of register windows */
#endif

#ifdef CHIP_933H
# define PSR_RESET      0xfa5   /* Set psr: trap enabled, S=1, PS=0, */
                                /*  cwp=5, int mask=15 */
# define NWINDOWS       6       /* number of register windows */
# define SL_CACHE       1       /* has cache */
# define SL_ICACHE_LINE 64      /* number of icache lines */
# define SL_ICACHE_BYTENUM 16   /* number of bytes in an icache line */
#endif 

#ifdef CHIP_934
# define PSR_RESET      0xfa7   /* Set psr: trap enabled S=1, PS=0,  */
                                /*  cwp=7, int mask=15  */
# define NWINDOWS       8       /* number register windows  */
# define SL_CACHE       0x1     /* has cache   */
# define SL_ICACHE_LINE 128     /* number of icache lines  */
# define SL_ICACHE_BYTENUM 32   /* number of bytes in an icache line  */
#endif

#ifdef CHIP_936
# define PSR_RESET      0xfa7   /* Set psr: trap enabled, S=1, PS=0, */
                                /*  cwp=7, int mask=15 */
# define NWINDOWS       8       /* number register windows */
# define SL_CACHE       1       /* has cache */
# define SL_ICACHE_LINE 128     /* number of icache lines */
# define SL_ICACHE_BYTENUM 32   /* number of bytes in an icache line */
#endif

#ifdef CHIP_83X
# define PSR_RESET      0xfa7   /* Set psr: trap enabled, S=1, PS=0, */
                                /*  cwp=7, int mask=15 */
# define NWINDOWS       8       /* number register windows */
# define SL_CACHE       1       /* has cache */
# define SL_ICACHE_LINE 128     /* number of icache lines */
# define SL_ICACHE_BYTENUM 32   /* number of bytes in an icache line */
#endif

/* Different time parameters  */

#ifdef  MASTER_CK_60
# ifdef BOARD_831
#  define WS_EPROM  ((11<<8)|(11<<3)|4) /* 12 cycle eprom access - 11 waits */
                                        /* access time = 12cycles / 60MHz = 200ns */
#  define ERRLOOP_CNT       0x78000     /* loopcount between flashing leds      */
/*#define REFRESH_PRELOAD*/             /* Auto DRAM refresh timer cycles       */
/*#define TMR1_PRESCALE*/               /* Auto system timer's prescale count   */
/*#define TMR3_RELOAD*/                 /* Auto baud-rate generater reload count*/
# else
#  define CLK_DOUBLED   1               /* 60MHz same as 30 except for memory */
#  define MASTER_CK_30  1               /*   934/936 ONLY */
# endif
#endif

#ifdef  MASTER_CK_50
# ifdef BOARD_831
#  define WS_EPROM   ((9<<8)|(9<<3)|4)  /* 10 cycle eprom access - 9 waits */
                                        /* access time = 10cycles / 50MHz = 200ns */
#  define ERRLOOP_CNT       0x64000     /* loopcount between flashing leds      */
# else
#  define CLK_DOUBLED   1               /* 50MHz same as 25 except for memory */
#  define MASTER_CK_25  1               /*   934/936 ONLY */
# endif
#endif

#ifdef MASTER_CK_10
# define ERRLOOP_CNT    0x14000         /* loopcount between flashing leds */
# define REFRESH_PRELOAD 150            /* DRAM refresh timer cycles */
# define TMR1_PRESCALE  0x17d0000       /*  select(1<<1) * prescale(125) = 10MHz * 25 */
# define TMR3_RELOAD    0x1f0000        /* 10MHz / baud(9600) / 32 - 1 = 31 */
# define WS_EPROM       0x214           /* 5 cycle eprom access - 4 waits */
#endif

#ifdef MASTER_CK_14
# define ERRLOOP_CNT    0x1c000         /* loopcount between flashing leds */
# define REFRESH_PRELOAD 210            /* DRAM refresh timer cycles */
# define TMR1_PRESCALE  0x1af0000 
# define TMR3_RELOAD    0x2d0000 
# define WS_EPROM       0x214           /* 4 cycle eprom access - 3 waits  */
#endif

#ifdef MASTER_CK_20
# define ERRLOOP_CNT    0x28000         /* loopcount between flashing leds */
# define REFRESH_PRELOAD 300            /* DRAM refresh timer cycles */
# define TMR1_PRESCALE  0x1fa0000
# define TMR3_RELOAD    0x400000
# define WS_EPROM       0x31c           /* 5 cycle eprom access - 4 waits */
#endif

#ifdef  MASTER_CK_25
# define ERRLOOP_CNT    0x28000         /* loopcount between flashing leds */
# define REFRESH_PRELOAD 375            /* DRAM refresh timer cycles */
# define TMR1_PRESCALE  0x29c0000       
# define TMR3_RELOAD    0x500000
# define WS_EPROM       0x424           /* 6 cycle eprom access - 5 waits */
#endif

#ifdef MASTER_CK_30
# define ERRLOOP_CNT    0x50000         /* loopcount between flashing leds */
# define REFRESH_PRELOAD 450            /* DRAM refresh timer cycles */
# define TMR1_PRESCALE  0x2bc0000
# define TMR3_RELOAD    0x610000
# define WS_EPROM       0x52c           /* 7 cycle eprom access - 6 waits */
#endif

#ifdef MASTER_CK_40
# define ERRLOOP_CNT    0x50000         /* loopcount between flashing leds */
# define REFRESH_PRELOAD 600            /* DRAM refresh timer cycles */
# define TMR1_PRESCALE  0x2fa0000
# define TMR3_RELOAD    0x810000 
# define WS_EPROM       0x634           /* 8 cycle eprom access - 7 waits */
#endif


/* The following macros are provided as a generalized programmatic interface */
/* to the SPARClite CC1 registers. */

/* USER BEWARE: */

/* ALIGN_{2LO/2HI}_STA will sometimes leave the contents of src reg shifted */
/* up or down by 16 bits depending on the processor being compiled for. */


#define CC1_STA_HI(src,dest)    \
        ALIGN_2LO_STA(src) ; \
        sta     src, dest CC1_ASI
/* End macro CC1_STA_HI */
        

/* Store value in low half word of src reg to dest CC1 reg. */

#define CC1_STA_LO(src,dest) \
        ALIGN_2HI_STA(src) ; \
        sta     src, dest CC1_ASI
/* End macro CC1_STA_LO */
        

/* Store value loaded from CC1 src reg to high half word of dest reg. */

#define CC1_LDA_HI(src,dest) \
        lda     src CC1_ASI, dest ; \
        ALIGN_2HI_LDA(dest)
/* End macro CC1_LDA_HI */
        

/* Store value loaded from CC1 src reg to low half word of dest reg. */

#define CC1_LDA_LO(src,dest) \
        lda     src CC1_ASI, dest ; \
        ALIGN_2LO_LDA(dest)
/* End macro CC1_LDA_LO */
        
        
#define TMR1_POLL       0x2000          /* # of polls Timer1 interrupt test */
#define TMR1_RELOAD     0x4e1f0000      /* Timer1 reload value */
#define TMR3_RELOAD_SER 0x70000         /* Timer3 reload for serial clock */
#define _EMULATION_BP   0x300001d0
#define TOP_OF_STACK    0x40400000
#define TRDY_MASK       0x00040000
#define DEFAULT_STACK_FRAME     -0x80
#ifdef BOARD_832D
#if YBOARD==0
#define SRAM_START      0x02000000
#define SRAM_HI_START   0x02020000
#define SRAM_END        0x02080000
#else
#define SRAM_START      0x08000000
#define SRAM_HI_START   0x08020000
#define SRAM_END        0x08080000
#endif	/* YBOARD */
#else
#define SRAM_START      0x30000000
#define SRAM_HI_START   0x30020000
#define SRAM_END        0x30080000
#endif

#define INT1_MASK       0x00020000      /* 0x00020000 - IRQ1  Timer2 */
#define INT2_MASK       0x00040000      /* 0x00040000 - IRQ2  OBInt* */
#define INT3_MASK       0x00080000      /* 0x00080000 - IRQ3  Timer1 */
#define INT4_MASK       0x00100000      /* 0x00100000 - IRQ4  NICE* */
#define INT5_MASK       0x00200000      /* 0x00200000 - IRQ5  AT* */
#define INT6_MASK       0x00400000      /* 0x00400000 - IRQ6  SDTR1 Tx */
#define INT7_MASK       0x00800000      /* 0x00800000 - IRQ7  SDTR1 Rx */
#define INT8_MASK       0x01000000      /* 0x01000000 - IRQ8  Timer1 */
#define INT9_MASK       0x02000000      /* 0x02000000 - IRQ9  SDTR0 Tx */
#define INT10_MASK      0x04000000      /* 0x04000000 - IRQ10 SDTR0 Rx */
#define INT11_MASK      0x08000000      /* 0x08000000 - IRQ11 AT* */
#define INT12_MASK      0x10000000      /* 0x10000000 - IRQ12 OBInt* */
#define INT13_MASK      0x20000000      /* 0x20000000 - IRQ13 Timer2 */
#define INT14_MASK      0x40000000      /* 0x40000000 - IRQ14 NICE* */
#define INT15_MASK      0x80000000      /* 0x80000000 - IRQ15 NICE* */
#define TRIGGER_MODE0   0x11400000
#define TRIGGER_MODE1   0x05100000
#define IRL_CLEAR       0x00100000
#define IRQ_MASK        0xfefe0000

/*------The monitor in EPROM is copied to DRAM at location PROG_MEM_START. */
/*      If PROG_MEM_START is changed, the start address has to be changed */
/*       to the same address (-T option in Cygnus and Sun makefiles, */
/*       command file 'ram.cmd' used by lnksp for MRI). */
#ifdef BOARD_832D
#  define PROG_MEM_START  (SRAM_START)     /* start at 32K in DRAM */
#else
# ifdef BOARD_832DD
#   define PROG_MEM_START  (SRAM_START)     /* start at 32K in DRAM */
# else
#   define PROG_MEM_START  (DRAM_START+0x8000)     /* start at 32K in DRAM */
# endif
#endif

#define NICEADDR        0x20000000      /* NICE regs base addr */

#define DLCR0   0x2             /* NICE DLRC regs offsets */
#define DLCR1   0x3
#define DLCR2   0x6
#define DLCR3   0x7
#define DLCR4   0xa
#define DLCR5   0xb
#define DLCR6   0xe
#define DLCR7   0xf

#define IDR8    0x12            /* NICE IDR regs offsets */
#define IDR9    0x13
#define IDR10   0x16
#define IDR11   0x17
#define IDR12   0x1a
#define IDR13   0x1b
#define IDR14   0x1e
#define IDR15   0x1f

#define HT8     0x12            /* NICE HT regs offsets */
#define HT9     0x13
#define HT10    0x16
#define HT11    0x17
#define HT12    0x1a
#define HT13    0x1b
#define HT14    0x1e
#define HT15    0x1f

#define BMR8    0x12            /* NICE BMR regs offsets */
#define BMR9    0x13
#define BMR10   0x16
#define BMR11   0x17
#define BMR12   0x1a
#define BMR13   0x1b
#define BMR14   0x1e
#define BMR15   0x1f
