#ifndef BOARD_832DB
# define RELOAD3_INIT    64              /* Baudrate reload count  20MHz/9600/32-1 = 64  */
#endif
                                        /* Mapping */
#ifdef  BOARD_832D 
#define CC_BASE     0xffff6002          /* Low half word        */
#else
#define CC_BASE     0x10000000          /* High half word       */
#endif


#define CC_ASI      4
#define TCR3        (0x1d<<2)
#define RELOAD3     (0x1e<<2)
#define SDTR0_DATA  (0x08<<2)
#define SDTR0_CMD   (0x09<<2)
#define SDTR0_STS   (0x09<<2)
#define SDTR1_DATA  (0x30)
#define SDTR1_CMD   (0x34)
#define SDTR1_STS	(0x34)


DebugInit:
        wr      %g0, 0xfa7, %psr    /* Initialize %psr by chip version*/
		nop
		nop
		nop
!        wr      %g0, -256, %wim          /* Initialize %wim to more than 8*/
	wr	%g0, 0x1, %wim		/* Initialize %wim to window 0 */
		nop
		nop
		nop
        wr      %g0, 0x0, %tbr          /* Initialize %tbr to 0*/
		nop
		nop
		nop
#if 0
#if 1
	set	0xffffc000, %l0
	set	0x9f, %l1 	/* CPU to 100 MHz */
	sta	%l1, [%l0] 0x4
	nop
	nop
	nop
	set	0x00020004, %l0
	set	0x1, %l1
	sta	%l1, [%l0] 0x1
	nop
	nop
	nop
#else
	set	0xffffc000, %l0
	set	0xab, %l1
	sta	%l1, [%l0] 0x4
	nop
	nop
	nop
	set	0x00020004, %l0
	set	0x1, %l1
	sta	%l1, [%l0] 0x1
	nop
	nop
	nop
#endif
#endif

#ifndef BOARD_832D
        /* -CS1: 86940  ASI=0x4, addr<31:28>=0x1 */
        sethi   %hi(0x41<<19), %l0
        or      %g0, 0x124, %l1
        sta     %l0, [%l1] 1
        nop
#if 1
        /* -CS2: NICE ASI=0x4, addr<31:28>=0x2 */
        sethi   %hi(0x42<<19), %l0
        or      %g0, 0x128, %l1
        sta     %l0, [%l1] 1
        nop
#endif

        /* -CS3: Internal Peri. ASI=0x7, addr<31:28>=0x0*/
        sethi   %hi(0x70<<19), %l0
        or      %g0, 0x12c, %l1
        sta     %l0, [%l1] 1
        nop
#if 1
        /* -CS4: DRAM  ASI=0xb04, addr<31:24>=0x04*/
        sethi   %hi(0xb04<<15), %l0 
        or      %g0, 0x130, %l1
        sta     %l0, [%l1] 1
        nop
#endif

        /* -CS5: SRAM  ASI=0xb, addr<31:28>=0x3*/
        sethi   %hi(0xb3<<19), %l0
        or      %g0, 0x134, %l1
        sta     %l0, [%l1] 1
        nop

        sethi   %hi(0xfcfc<<15), %l0  /* ASI0=x, 00000000-03FFFFFF */
        xnor    %g0, %l0, %l0   /*SI and SD ASI, addr=0x0XXXXXXX*/
        or      %g0, 0x140, %l1 /* Set address mask register for -CS0           */
        or      %g0, 0x144, %l2 /* Set address mask register for -CS1 */
        sta     %l0, [%l2] 1
        sta     %l0, [%l1] 1
        nop

        sethi   %hi(0x7f<<19), %l0
        xnor    %g0, %l0, %l0   /* Set address mask register for -CS1*/
        or      %g0, 0x144, %l1 /*  addr<27:0>=0xXXXXXXX*/
        sta     %l0, [%l1] 1    /*  ASI=4, addr=0x1XXXXXXX*/
        nop
#if 1
        sethi   %hi(0x7f<<19), %l0
        xnor    %g0, %l0, %l0   /* Set address mask register for -CS2*/
        or      %g0, 0x148, %l1 /*  addr<27:0>=0xXXXXXXX*/
        sta     %l0, [%l1] 1    /*  ASI=4, addr=0x2XXXXXXX*/
        nop
#endif
        sethi   %hi(0x7ffff<<7), %l0    /* 64KB space */
        or      %l0, %lo(0x7ffff<<7), %l0
        xnor    %g0, %l0, %l0   /* Set address mask register for -CS3*/
        or      %g0, 0x14c, %l1 /*  addr<27:0>=0xXXXXXXX*/
        sta     %l0, [%l1] 1    /*  SI, SD, UI and UD ASI, end addr=0x3001ffff*/
        nop
#if 1
        sethi   %hi(0xfcfc<<15), %l0 
        xnor    %g0, %l0, %l0   /* Set address mask register for -CS4*/
        or      %g0, 0x150, %l1 /*  ASI<1,0>=xx, addr<27:0>=0xXXXXXXX*/
        sta     %l0, [%l1] 1    /*  SI, SD, UI and UD ASI, end addr=0x40ffffff*/
#endif
        sethi   %hi(0xfcfff8<<7), %l0
        or      %l0, %lo(0xfcfff8<<7), %l0
        xnor    %g0, %l0, %l0   /* Set address mask register for -CS5*/
        or      %g0, 0x154, %l1 /*  addr<27:0>=0xXXXXXXX*/
        sta     %l0, [%l1] 1    /*  ASI=4, addr=0x5XXXXXXX*/
        nop

        /* set wait state for -CS0(EPROM, lower) and -CS1(CC1, higher)*/
        or      %g0, 0x160, %l2         /* %l2 = address*/
        sethi   %hi((WS_CC1<<19)|(WS_EPROM<<6)), %l1    /* set CC1 value(higher) to %l1*/
        or      %l1,%lo((WS_CC1<<19)|(WS_EPROM<<6)), %l1
        sta     %l1, [%l2] 1            /* set wait state value*/

        /* set wait state for -CS2(AT/NICE, lower) and -CS3(Internal Resources, higher)*/
        or      %g0, 0x164, %l2         /* %l2 = address*/
        sethi   %hi((WS_PERIRES<<19)|(WS_NICE<<6)), %l1  /* set Internal Resources value to %l1*/
        or      %l1, %lo((WS_PERIRES<<19)|(WS_NICE<<6)), %l1
        sta     %l1, [%l2] 1            /* set wait state value*/

        /* set wait state for -CS4(DRAM, lower) and -CS5(SRAM, higher)*/
        or      %g0, 0x168, %l2         /* %l2 = address*/
        sethi   %hi((WS_SRAM<<19)|(WS_DRAM<<6)), %l1   /* set SRAM value to %l1*/
        or      %l1, %lo((WS_SRAM<<19)|(WS_DRAM<<6)), %l1
        sta     %l1, [%l2] 1            /* set wait state value*/

#endif /* BOARD_832D */

        sta     %g0, [%g0] 1            /* Write Cache/BIU Control Reg*/

#ifndef BOARD_832D
        mov     0x3c, %l0
        mov     0x80, %l1
        sta     %l0, [%l1] 1
#endif

	/* SDTR init */
        sethi   %hi(CC_BASE), %l1
        or      %l1, %lo(CC_BASE), %l1

#define P_TCR3      %l2
#define P_RELOAD3   %l3
#define P_S0CMD     %l4
#define P_S0STS     %l4
#define P_S0DATA    %l5
                                        /* Timer 3 setting */
        add     %l1, TCR3, %l2
        add     %l1, RELOAD3, %l3
        add     %l1, SDTR0_CMD, %l4
        add     %l1, SDTR0_DATA, %l5
#ifndef BOARD_832D
        set     0x0990, %l0
        stha    %l0, [P_TCR3] CC_ASI
        set     RELOAD3_INIT, %l0
        stha    %l0, [P_RELOAD3] CC_ASI
#endif

#if 1
_baudrate:
# if 1
#  if 0
	/* BAUDRATE setting for 232C; 0xa2 is 162 for 19200 */
		sethi	%hi(0xffffb000), %l6
		or		%l6, %lo(0xffffb000), %l6
		or		%g0, 0xa2, %l7
		call	_delay4wr
		sta		%l7, [%l6] 0x4
#  else
	/* BAUDRATE setting for 232C; 0x28 is 40 for 76800 */
		sethi	%hi(0xffffb000), %l6
		or		%l6, %lo(0xffffb000), %l6
		or		%g0, 0x28, %l7
		call	_delay4wr
		sta		%l7, [%l6] 0x4
#  endif
# else
#  if 1
	/* BAUDRATE setting for 232C; 0x50 is 80 for 38400 */
		sethi	%hi(0xffffb000), %l6
		or		%l6, %lo(0xffffb000), %l6
		or		%g0, 0x50, %l7
		call	_delay4wr
		sta		%l7, [%l6] 0x4
#  else
	/* BAUDRATE setting for 232C; 0x13 is 19 for 153600 */
		sethi	%hi(0xffffb000), %l6
		or		%l6, %lo(0xffffb000), %l6
		or		%g0, 0x13, %l7
		call	_delay4wr
		sta		%l7, [%l6] 0x4
#  endif
# endif
#endif

	/* SDTR 0 */
        call    _delay4wr
        stha    %g0,[P_S0CMD] CC_ASI

        call    _delay4wr
        stha    %g0,[P_S0CMD] CC_ASI

        call    _delay4wr
        stha    %g0,[P_S0CMD] CC_ASI

        mov     0x40,%l0
        call    _delay4wr
        stha    %l0,[P_S0CMD] CC_ASI

        mov     0x4e,%l0        ! STB=0(STP1),EOP=0,PEN=0(NP),DTB=3(D8),ASY=2(1/16CLK)
        call    _delay4wr
        stha    %l0,[P_S0CMD] CC_ASI

        mov     0x37,%l0    ! EHN=0,IRST=0,RTS=1(L),EFR=1,BR=0,RCVEN=1,DTR=1,TRNEN=1
        call    _delay4wr
        stha    %l0,[P_S0CMD] CC_ASI

	/* SDTR 1 */
#define P_S1CMD		%l4
#define P_S1STS		%l4
#define P_S1DATA	%l5

		add		%l1, SDTR1_CMD, %l4
		add		%l1, SDTR1_DATA, %l5

        call    _delay4wr
        stha    %g0,[P_S1CMD] CC_ASI

        call    _delay4wr
        stha    %g0,[P_S1CMD] CC_ASI

        call    _delay4wr
        stha    %g0,[P_S1CMD] CC_ASI

        mov     0x40,%l0
        call    _delay4wr
        stha    %l0,[P_S1CMD] CC_ASI

        mov     0x4e,%l0        ! STB=0(STP1),EOP=0,PEN=0(NP),DTB=3(D8),ASY=2(1/16CLK)
        call    _delay4wr
        stha    %l0,[P_S1CMD] CC_ASI

        mov     0x37,%l0    ! EHN=0,IRST=0,RTS=1(L),EFR=1,BR=0,RCVEN=1,DTR=1,TRNEN=1
        call    _delay4wr
		stha	%l0,[P_S1CMD] CC_ASI

#ifdef _DEB_
init01:
        lduha   [P_S1STS] CC_ASI, %l0
        andcc   %l0, 1, %g0
        be      init01
        nop
        mov     0x48, %l0
        stha    %l0, [P_S1DATA] CC_ASI

init02:
        lduha   [P_S1STS] CC_ASI, %l0
        andcc   %l0, 1, %g0
        be      init02
        nop
        mov     0x65, %l0
        stha    %l0, [P_S1DATA] CC_ASI

init03:
        lduha   [P_S1STS] CC_ASI, %l0
        andcc   %l0, 1, %g0
        be      init03
        nop
        mov     0x6c, %l0
        stha    %l0, [P_S1DATA] CC_ASI

init04:
        lduha   [P_S1STS] CC_ASI, %l0
        andcc   %l0, 1, %g0
        be      init04
        nop
        mov     0x6c, %l0
        stha    %l0, [P_S1DATA] CC_ASI

init05:
        lduha   [P_S1STS] CC_ASI, %l0
        andcc   %l0, 1, %g0
        be      init05
        nop
        mov     0x6f, %l0
        stha    %l0, [P_S1DATA] CC_ASI

init06:
        lduha   [P_S1STS] CC_ASI, %l0
        andcc   %l0, 1, %g0
        be      init06
        nop
        mov     0x77, %l0
        stha    %l0, [P_S1DATA] CC_ASI
#endif /* _DEB_ */
        ba      init_end
        nop


_delay4wr:
        or  %g0, 20, %g1
_delay4wr_loop:
        subcc       %g1, 1, %g1
        bnz         _delay4wr_loop
        nop
            retl
        nop

/* debugging output excluding GDB protocol processings 
	are changed from STDR 0 to 1 */
        .global puthex
puthex:
        sethi   %hi(CC_BASE), %o1
        or      %o1, %lo(CC_BASE), %o1
        add     %o1, SDTR1_CMD, %o2
        add     %o1, SDTR1_DATA, %o3

        and     %o0, 0x0f, %o4
        srl     %o0, 4, %o0
        cmp     %o0, 10
        bcs,a   puthex01
        add     %o0, 0x30, %o0
        add     %o0, 0x41-10, %o0
puthex01:
        mov     0x2a, %o0
        set     0x1000, %o1
puthex02:
        subcc   %o1, 1, %o1
        bnz     puthex02
        nop
puthex03:
        lduha   [%o2] CC_ASI, %o1
        andcc   %o1, 1, %g0
        be      puthex03
        nop
        stha    %o0, [%o3] CC_ASI

        cmp     %o4, 10
        bcs,a   puthex11
        add     %o4, 0x30, %o0
        add     %o4, 0x41-10, %o0
puthex11:
        set     0x1000, %o1
puthex12:
        subcc   %o1, 1, %o1
        bnz     puthex12
        nop
puthex13:
        lduha   [%o2] CC_ASI, %o1
        andcc   %o1, 1, %g0
        be      puthex13
        nop
        stha    %o0, [%o3] CC_ASI

puthex21:
	mov	0x0d, %o0
        set     0x1000, %o1
puthex22:
        subcc   %o1, 1, %o1
        bnz     puthex22
        nop
puthex23:
        lduha   [%o2] CC_ASI, %o1
        andcc   %o1, 1, %g0
        be      puthex23
        nop
        stha    %o0, [%o3] CC_ASI

puthex31:
	mov	0x0a, %o0
        set     0x1000, %o1
puthex32:
        subcc   %o1, 1, %o1
        bnz     puthex32
        nop
puthex33:
        lduha   [%o2] CC_ASI, %o1
        andcc   %o1, 1, %g0
        be      puthex33
        nop
        stha    %o0, [%o3] CC_ASI

        retl
        nop


        .global putled
putled:
        sethi   %hi(CC_BASE), %o1
        or      %o1, %lo(CC_BASE), %o1
        add     %o1, SDTR1_CMD, %o2
        add     %o1, SDTR1_DATA, %o3

        xnor    %g0, %o0, %o0
        and     %o0, 0x0f, %o4
        srl     %o0, 4, %o0
        and     %o0, 0x0f, %o0
        cmp     %o0, 10
        bcs,a   putled01
        add     %o0, 0x30, %o0
        add     %o0, 0x41-10, %o0
putled01:
        set     0x1000, %o1
putled02:
        subcc   %o1, 1, %o1
        bnz     putled02
        nop
putled03:
        lduha   [%o2] CC_ASI, %o1
        andcc   %o1, 1, %g0
        be      putled03
        nop
        stha    %o0, [%o3] CC_ASI

        cmp     %o4, 10
        bcs,a   putled11
        add     %o4, 0x30, %o0
        add     %o4, 0x41-10, %o0
putled11:
        set     0x1000, %o1
putled12:
        subcc   %o1, 1, %o1
        bnz     putled12
        nop
putled13:
        lduha   [%o2] CC_ASI, %o1
        andcc   %o1, 1, %g0
        be      putled13
        nop
        stha    %o0, [%o3] CC_ASI

        ba  puthex21
        nop

        .global puthexw
puthexw:
        sethi   %hi(CC_BASE), %o1
        or      %o1, %lo(CC_BASE), %o1
        add     %o1, SDTR1_CMD, %o2
        add     %o1, SDTR1_DATA, %o3
	mov	%o0, %o4
	mov     8, %o5
puthexw00:
        srl     %o4, 32-4, %o0
	sll	%o4, 4, %o4
        cmp     %o0, 10
        bcs,a   puthexw01
        add     %o0, 0x30, %o0
        add     %o0, 0x41-10, %o0
puthexw01:
        set     0x1000, %o1
puthexw02:
        subcc   %o1, 1, %o1
        bnz     puthexw02
        nop
puthexw03:
        lduha   [%o2] CC_ASI, %o1
        andcc   %o1, 1, %g0
        be      puthexw03
        nop
        stha    %o0, [%o3] CC_ASI

	deccc	%o5
	bnz	puthexw00
	nop

        ba  puthex21
        nop


init_end:

