/*
 * FILE
 *      pci.c
 * 
 * 	kei
 * 
 */
//#include <stdio.h>
//#include <string.h>

#include "pci.h"


// ----------------------------------------------------------------------
void
pci_recv(char *buf, int size)
{
	int	i,j;
	unsigned long *p;
	unsigned long l,m;
	unsigned long ssize,rsize,bsize,tmp;
#if 0
	unsigned char checksum;
#endif

	/* check */
	RECV_MAIL( &m );
	if ( m!= C_P2S ) {
#ifdef DEBUG
		printf("wrong recv code\n");
#endif
	}
	SEND_MAIL( C_ACK );


	/* now transfering */
	UP_ID0;

	/* get BAR from MB_A */
	RECV_MAIL( &m );

	/* get BDCR from MB_A */
	RECV_MAIL( &ssize );

	/* sizes */
	rsize = NTOHL(ssize);		/* real size */
	if ((l = rsize % 4) != 0) {
		tmp = (rsize-l)+4;
	} else {
		tmp = rsize;
	}
	bsize = tmp/4;
 	ssize = NTOHL(tmp);

/*
	if ( rsize < (int)(size+4)/4+4 ) {
		printf("requested size too long\n");
		printf("recv:rsize = %x, size = %x\n",rsize,size);
	}
*/

	// if size<DMA buff_size, send data by mailbox
	if ( rsize < 0x10 ) {
		p = (unsigned long *) buf;
		for ( i = 0; i < bsize; i++ ) {
			RECV_MAIL( &m );
			*(volatile unsigned long *)(p + i) = m;
		}
		DOWN_ID0;

		return;
	}


	// PCI DMA/FIFO
	wrasi4b( ADDR+0x02,	0x20 );	// EIE <- 1h
	wrasi4b( ADDR+0x2d,	0x01 );	// DCR <- 00h
	wrasi4b( ADDR+0x3d,	0x01 );	// FCR <- 00h
	wrasi4b( ADDR+0x2f,	0x01 );	// DAMR <- 01h
	wrasi4b( ADDR+0x3f,	0x01 );	// FAMR <- 01h
	wrasi4b( ADDR+0x2b,	0x06 );	// DMR <- 0Xh
	wrasi4w( ADDR+0x20,	m );	// BAR <- XXXXXXXXh
	wrasi4w( ADDR+0x24,	ssize );	// BDCR <- XXXXXXXXh
					// RQPR <- XXXXh
	wrasi4h( ADDR+0x36,	0x0000 );		// WQPR
	wrasi4h( ADDR+0x34,	0x0800 );		// RQPR
	wrasi4b( ADDR+0x39,	0x00 );	// MRBER <- 0Xh

	// SPARC DMA
	if ( rsize >= 0x10 ) {
		wrasi4w( DADDR(0)+0x10,	0x00000000 );	/* TMR */
		wrasi4w( DADDR(0)+0x14,	0x00000000 );	/* SR */

		wrasi4w( DADDR(0)+0x04,	0xffff3014 );	/* PSA */
		wrasi4w( DADDR(0)+0x1c,	0x00000004 );	/* SASI */
		wrasi4w( DADDR(0)+0x08,	       buf );	/* MDA */
		wrasi4w( DADDR(0)+0x20,	0x00000008 );	/* DASI */
		wrasi4w( DADDR(0)+0x18,	0x00000010 );	/* LR */
	}

	// PCI DMA/FIFO start
	wrasi4b( ADDR+0x2f,	0x00 );	// DAMR <- 00h
	wrasi4b( ADDR+0x3f,	0x00 );	// FAMR <- 00h


	// read from PCI DMA/FIFO port
	p = (unsigned long *) buf;
	while ( rsize > 0 ) {
		if ( rsize >= 0x10 ) {
#define TIMER 10
#if 1
				for( j = 0; j < TIMER; j++ )
					;
#else
				DOWN_EMPTY;
#endif
			// SPARC DMA start
			wrasi4w( DADDR(0)+0x10,	0x00004481 );	/* TMR */
			WAIT_SDMA_ED(0);
			rsize -= 0x10;
			p = (unsigned long *) rdasi4w( DADDR(0)+0x08 );
								/* MDA */
		} else {
			if ((l = rsize % 4) != 0) {
				bsize = ( (rsize-l)+4 ) / 4;
			} else {
				bsize = rsize / 4;
			}
			for( i = 0; i < bsize; i++ ) {
#if 1
				for( j = 0; j < TIMER; j++ )
					;
#else
				DOWN_EMPTY;
#endif
				*(volatile unsigned long *)(p + i)
					= (unsigned long)rdasi4w( ADDR+0x14 );
			}
			rsize = 0;
		}
	}

	/* FSR EOP up? */
	WAIT_EOP;

	// PCI DMA/FIFO stop
	wrasi4b( ADDR+0x2f,	0x01 );	// DAMR <- 01h
	wrasi4b( ADDR+0x3f,	0x01 );	// FAMR <- 01h

	/* transfer finished */
	DOWN_ID0;

#if 0
	checksum = 0;
	for ( i = 0; i < NTOHL(ssize); i++ ) {
		checksum += *(char *)(buf+i);
	}
	printf("data %x: checksum %02x\n",NTOHL(ssize),checksum);
#endif
}
/*-----------------------------------------*/
void
pci_send(char *buf, int size)
{
	int	i;
	unsigned long *p;
	unsigned long l,m,tmp;
	unsigned long ssize,rsize,bsize;

	/* check */
	RECV_MAIL( &m );
	if ( m!= C_S2P ) {
#ifdef DEBUG
		printf("wrong send code\n");
#endif
	}
	SEND_MAIL( C_ACK );


	/* now transfering */
	UP_ID0;

	/* get BAR from MB_A */
	RECV_MAIL( &m );

	/* get BDCR from MB_A */
	RECV_MAIL( &ssize );

	/* sizes */
	rsize = NTOHL(ssize);		/* real size */
	if ((l = rsize % 4) != 0) {
		tmp = (rsize-l)+4;
	} else {
		tmp = rsize;
	}
	bsize = tmp/4;
 	ssize = NTOHL(tmp);

/*
	if ( rsize > (int)(size+4)/4+4 ) {
		printf("requested size too long\n");
		printf("send:rsize = %x, size = %x\n",rsize,size);
	}
*/
	// if size<DMA buff_size, send data by mailbox
	if ( rsize < 0x10 ) {
		p = (unsigned long *) buf;
		for ( i = 0; i < bsize; i++ ) {
			SEND_MAIL( *(p + i) );
		}
		DOWN_ID0;

		return;
	}


	// PCI DMA/FIFO
	wrasi4b( ADDR+0x02,	0x20 );	// EIE <- 1h
	wrasi4b( ADDR+0x2d,	0x01 );	// DCR <- 00h
	wrasi4b( ADDR+0x3d,	0x01 );	// FCR <- 00h
	wrasi4b( ADDR+0x2f,	0x01 );	// DAMR <- 01h
	wrasi4b( ADDR+0x3f,	0x01 );	// FAMR <- 01h
	wrasi4b( ADDR+0x2b,	0x07 );	// DMR <- 0Xh
	wrasi4w( ADDR+0x20,	   m );	// BAR <- XXXXXXXXh
	wrasi4w( ADDR+0x24,	ssize );	// BDCR <- XXXXXXXXh
					// RQPR <- XXXXh
	wrasi4h( ADDR+0x36,	0x0800 );		// WQPR
	wrasi4h( ADDR+0x34,	0x0000 );		// RQPR

	// PCI DMA/FIFO start
	wrasi4b( ADDR+0x2f,	0x00 );	// DAMR <- 00h
	wrasi4b( ADDR+0x3f,	0x00 );	// FAMR <- 00h



	// SPARC DMA/FIFO
	wrasi4w( DADDR(1)+0x10,	0x00000000 );	/* TMR */
	wrasi4w( DADDR(1)+0x14,	0x00000000 );	/* SR */

	wrasi4w( DADDR(1)+0x04,	0xffff3014 );	/* PSA */
	wrasi4w( DADDR(1)+0x1c,	0x00000008 );	/* SASI */
	wrasi4w( DADDR(1)+0x08,	       buf );	/* MDA */
	wrasi4w( DADDR(1)+0x20,	0x00000004 );	/* DASI */
	wrasi4w( DADDR(1)+0x18,	0x00000010 );	/* LR */

	// write on PCI DMA/FIFO port
	p = (unsigned long *) buf;
	while ( rsize > 0 ) {
		if ( rsize >= 0x10 ) {
			DOWN_FULL;
			// SPARC DMA start
//			wrasi4w( 0x00004581, DADDR(1)+0x10 );	/* TMR */
			// auto increment(dau bit) increments too much
			// so increments manually
			wrasi4w( DADDR(1)+0x10,	0x00000581 );	/* TMR */
			WAIT_SDMA_ED(1);
			rsize -= 0x10;
			p += 4;
			wrasi4w( DADDR(1)+0x08,	p );	/* MDA */
		} else {
			if ((l = rsize % 4) != 0) {
				bsize = ( (rsize-l)+4 ) / 4;
			} else {
				bsize = rsize / 4;
			}
			for( i = 0; i < bsize; i++ ) {
				DOWN_FULL;
				wrasi4w( ADDR+0x14,
					*(volatile unsigned long *)(p + i));
			}
			rsize = 0;
		}
	}

	/* FSR EOP up? */
	WAIT_EOP;

	// PCI DMA/FIFO stop
	wrasi4b( ADDR+0x2f,	0x01 );	// DAMR <- 01h
	wrasi4b( ADDR+0x3f,	0x01 );	// FAMR <- 01h

	/* transfer finished */
	DOWN_ID0;
}
/*-----------------------------------------*/


void
load_file(void)
{
	char buf[16];
	int	size;
	int	i;
	unsigned char	*to_addr;
	unsigned char	checksum;
	unsigned char	c;
	unsigned char	*pp;
	unsigned int	*p = (unsigned int *)buf;
	int	j;

	/* recv size, to_addr */
	pci_recv( buf, 8 );
	size    = (int)			*p++;
	to_addr = (unsigned char *)	*p;

	/* load file */
	pci_recv( to_addr, size );

	/* checksum */
	checksum = 0;
	for ( i = 0; i < size; i++ ) {
		checksum += *(char *)(to_addr+i);
	}

	buf[0] = (char)checksum;
	pci_send( buf, 1 );
}


_pci_main(memsize)
{
	char buf[16];
	void (*func)();

	while(1) {

		pci_recv( buf, 1 );

		if ( buf[0] == CMD_GET_STATUS ) {
			buf[0] = 0xaa;
			pci_send( buf, 1 );	/* send 0xaa */
			pci_recv( buf, 1 );	/* recv 0x55 */
			buf[0] = 0x55;
			pci_send( buf, 1 );	/* send 0x55 */
		} else 
		if ( buf[0] == CMD_LOAD ) {
			buf[0] = 0x5a;
			pci_send( buf, 1 );	/* send 0x5a */
			load_file();
		} else 
		if ( buf[0] == CMD_RUN_SR ) {
		} else 
		if ( buf[0] == CMD_EXEC ) {
			pci_recv( buf, 4 );
			(unsigned long)func = 0;
			(unsigned long)func |= (buf[0]&0xff) << 24
						| (buf[1]&0xff) << 16
						| (buf[2]&0xff) << 8
						| (buf[3]&0xff);
			(*func)();
			buf[0] = 0x55;
			pci_send( buf, 1 );	/* send 0x55 */
		} else 
		if ( buf[0] == CMD_MOVE_TRAP ) {
		} else 
		if ( buf[0] == CMD_REP_VER ) {
		} else  {
						/* default */
		}

	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------



