
/* FILE*/
/*      thndlrsl.s*/

/*      Copyright(c) 1993, 1995, FMI, Fujitsu Microelectronics, Inc.          */
/*      All rights reserved.                                                  */

/*      This software (including any documentation) is untested, has not been */
/*      fully tested for viruses and has been provided to you without charge. */
/*      ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR    */
/*      IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,  */
/*      FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all    */
/*      risk of nonperformance, loss of data and other problems and Fujitsu   */
/*      Microelectronics, Inc. and Fujitsu Limited will not be liable under   */
/*      any contract, negligence, strict liability or other theory for any    */
/*      damages including, without limitation, direct, consequential or       */
/*      incidental nor be required to provide substitute goods, services      */
/*      or technology.                                                        */

/* DESCRIPTION*/
/*       This file contains the trap handlers for all trap types listing in*/
/*      the trap table except the reset trap.  The trap table is in the file*/
/*      ttblsl.s and the reset trap handler is in the file resetsl.s*/
/*      Functions:*/
/*      - Common setup before specific trap handler.*/
/*      - Common trap return routine.*/
/*       - Window Overflow Trap Handler.*/
/*      - Window Underflow Trap Handler.*/
/*      - Interrupt 3 Trap Handler.*/

/* HISTORY*/
/*      August 1991     Roland*/
/*      April 1993      Clark Li*/
/* */


/* GLOBAL VARIABLE*/
/*      %g1 - used to store WIM*/
#include "utilsl.h"
        .text
        .global _reset_entry
        .global _chk4ovflo
        .global _chk4uflo
        .global _trap_return
        .global _instr_access
        .global _illegal_instr
        .global _privil_instr 
        .global _fp_disable
        .global _win_ovf
        .global _win_unf
        .global _mem_misalign
        .global _fp_exception
        .global _data_access
        .global _tag_ovf
        .global _trap_instr
        .global _emulation_bp
        .global _int_15         /* Not used.  Tied low through 10K.*/
        .global _int_14         /* Nice.  Tied high through 10K.*/
        .global _int_13         /* Timer2.  Tied low through 10K.*/
        .global _int_12         /* Off Board.  Tied high through 10K.*/
        .global _int_11         /* AT.  Tied high through 10K.*/
        .global _int_10         /* UART0 Rx.*/
        .global _int_9          /* UART0 Tx.*/
        .global _int_8          /* Timer1.  Tied low through 10K.*/
        .global _int_7          /* UART1 Rx.*/
        .global _int_6          /* UART1 Tx.*/
        .global _int_5          /* AT.  Tied high through 10K.*/
        .global _int_4          /* Nice.  Tied high through 10K.*/
        .global _int_3          /* Timer1.  Tied low through 10K.*/
        .global _int_2          /* Off Board.  Tied high through 10K.*/
        .global _int_1          /* Timer2.  Tied low through 10K.*/
        .global _cp_disable
        .global _cp_exception
        .global _Ticc_1
        .global _Ticc_2
        .global _Ticc_3
        .global _Ticc_4
        .global _Ticc_5
        .global _Ticc_6
        .global _Ticc_7
        .global _Ticc_8
        .global _Ticc_9
        .global _Ticc_10
        .global _Ticc_11
        .global _Ticc_12
        .global _Ticc_13
        .global _Ticc_14
        .global _Ticc_15
        .global _Ticc_16
        .global _Ticc_17
        .global _Ticc_18
        .global _Ticc_19
        .global _Ticc_20
        .global _Ticc_21
        .global _Ticc_22
        .global _Ticc_23
        .global _Ticc_24
        .global _Ticc_25
        .global _Ticc_26
        .global _Ticc_27
        .global _Ticc_28
        .global _Ticc_29
        .global _Ticc_30
        .global _Ticc_31
        .global _Ticc_32
        .global _Ticc_33
        .global _Ticc_34
        .global _Ticc_35
        .global _Ticc_36
        .global _Ticc_37
        .global _Ticc_38
        .global _Ticc_39
        .global _Ticc_40
        .global _Ticc_41
        .global _Ticc_42
        .global _Ticc_43
        .global _Ticc_44
        .global _Ticc_45
        .global _Ticc_46
        .global _Ticc_47
        .global _Ticc_48
        .global _Ticc_49
        .global _Ticc_50
        .global _Ticc_51
        .global _Ticc_52
        .global _Ticc_53
        .global _Ticc_54
        .global _Ticc_55
        .global _Ticc_56
        .global _Ticc_57
        .global _Ticc_58
        .global _Ticc_59
        .global _Ticc_60
        .global _Ticc_61
        .global _Ticc_62
        .global _Ticc_63
        .global _Ticc_64
        .global _Ticc_65
        .global _Ticc_66
        .global _Ticc_67
        .global _Ticc_68
        .global _Ticc_69
        .global _Ticc_70
        .global _Ticc_71
        .global _Ticc_72
        .global _Ticc_73
        .global _Ticc_74
        .global _Ticc_75
        .global _Ticc_76
        .global _Ticc_77
        .global _Ticc_78
        .global _Ticc_79
        .global _Ticc_80
        .global _Ticc_81
        .global _Ticc_82
        .global _Ticc_83
        .global _Ticc_84
        .global _Ticc_85
        .global _Ticc_86
        .global _Ticc_87
        .global _Ticc_88
        .global _Ticc_89
        .global _Ticc_90
        .global _Ticc_91
        .global _Ticc_92
        .global _Ticc_93
        .global _Ticc_94
        .global _Ticc_95
        .global _Ticc_96
        .global _Ticc_97
        .global _Ticc_98
        .global _Ticc_99
        .global _Ticc_100
        .global _Ticc_101
        .global _Ticc_102
        .global _Ticc_103
        .global _Ticc_104
        .global _Ticc_105
        .global _Ticc_106
        .global _Ticc_107
        .global _Ticc_108
        .global _Ticc_109
        .global _Ticc_110
        .global _Ticc_111
        .global _Ticc_112
        .global _Ticc_113
        .global _Ticc_114
        .global _Ticc_115
        .global _Ticc_116
        .global _Ticc_117
        .global _Ticc_118
        .global _Ticc_119
        .global _Ticc_120
        .global _Ticc_121
        .global _Ticc_122
        .global _Ticc_123
        .global _Ticc_124
        .global _Ticc_125
        .global _Ticc_126
        .global _Ticc_127
        .global _err_flash_leds

_reset_entry:
        set     _reset, %l0
        set     PROG_MEM_START, %g6
        sub     %l0, %g6, %l0                   /* minus PROG_MEM_START*/
        jmpl    %l0, %g0                        /* jump to _reset*/
        nop


/* FUNCTION*/
/*      _chk4ovflo*/

/* DESCRIPTION*/
/*      This code is branched to before each trap (except reset,*/
/*      _win_unf, and _win_ovf) handler.*/
/*       It checks to see if we have moved into the invalid window*/
/*       and performs fixup ala _win_ovf.*/

/* INPUTS*/
/*      - %l0 = psr at trap time.*/
/*      - %l1 = pc at trap time.*/
/*      - %l2 = npc at trap time.*/
/*      - %l3 = tbr at trap time.*/

/* INTERNAL DESCRIPTION*/

/* RETURNS*/
/*      - None.*/

_chk4ovflo:
        and     %l0, 0x1F, %l5          /* get the cwp*/
        set     1, %l4                  /* compare cwp with the wim*/
        rd      %wim,   %l6             /* read the wim*/
        nop
        nop
        nop
        sll     %l4, %l5, %l4           /* compare*/
        andcc   %l4, %l6, %g0
        bz      _ret2ttbl               /* not invalid window, just return*/
        nop

                                        /* in line version of _win_ovf*/
#ifndef INT_MODE1
        or      %l0, 0xf20, %l7         /* enable traps, disable interrupts.*/
        wr      %l7, %g0, %psr
#endif
        or      %g0, %g1, %l7           /* Save %g1.*/
        srl     %l6, 1, %g1             /* Next WIM = %g1 =*/
                                        /* rol(WIM, 1, NWINDOW).*/
        sll     %l6, NWINDOWS-1, %l5
        or      %l5, %g1, %g1
        save                            /* Get into window to be saved.*/
        wr      %g1,%g0, %wim           /* Install new wim.*/
        nop                             /* must delay three instructions*/
        nop                             /* before using these registers, so*/
        nop                             /* put nops in just to be safe*/
                                        /* save all local registers*/
        std     %l0, [%sp + 0x0 * 4]    
        std     %l2, [%sp + 0x2 * 4]
        std     %l4, [%sp + 0x4 * 4]
        std     %l6, [%sp + 0x6 * 4]
        std     %i0, [%sp + 0x8 * 4]
        std     %i2, [%sp + 0xa * 4]
        std     %i4, [%sp + 0xc * 4]
        std     %i6, [%sp + 0xe * 4]

        restore                         /* Go back to trap window.*/
        or      %g0, %l7, %g1           /* Restore %g1.*/

_ret2ttbl:
        /* It is safe now to allocate a stack frame for this window*/
        /* because all overflow handling will have been accomplished*/
        /* in the event we trapped into the invalid window.*/
        /* ie. all of this window %o regs (next window %i regs)*/
        /* will have been safely stored to the stack before we overwrite %sp.*/

        add     %fp, DEFAULT_STACK_FRAME, %sp
        or      %l3, 0xc, %l3   /* add 0xc to %tbr value to obtain*/
                                /* ttbl instruction addr we came from + 0x4*/
        jmpl    %l3, %g0        /* jump back into table at aforementioned addr.*/
        nop

/* FUNCTION*/
/*      _chk4uflo*/

/* DESCRIPTION*/
/*      This code is branched to before each return from trap (except reset,*/
/*      _win_unf, and _win_ovf) handlers.*/
/*       It checks to see if we are about to move to the invalid window*/
/*       on ensuing rett instrunction and performs fixup ala _win_unf.*/

/* INPUTS*/
/*      - %l0 = psr at trap time.*/
/*      - %l1 = pc at trap time.*/
/*      - %l2 = npc at trap time.*/
/*      - %l3 = tbr (ord w/ 0xc) at trap time.*/

/* INTERNAL DESCRIPTION*/

/* RETURNS*/
/*      - None.*/

_chk4uflo:
/*Test that the window we are moving into is valid*/
        and     %l0, 0x1F, %l4          /* get the cwp*/
        subcc   %l4, (NWINDOWS-1), %g0          /* test for being in high window*/
        be      win7
        nop
        add     %l4, 1, %l4             /* compare with the next highest window*/
        ba      not7
        nop
win7:   or      %g0, %g0, %l4
not7:   or      %g0, 0x1, %l5                   /* compare cwp with the wim*/
        sll     %l5, %l4, %l5           /* if they are the same then */
        rd      %wim,   %l6             /* read the wim*/
        nop
        nop
        nop
        andcc   %l5, %l6, %g0
        bz      _trap_return
        nop
        ba      _win_unf
        nop

        
/* FUNCTION*/
/*      _trap_return*/

/* DESCRIPTION*/
/*      This function is called by all traps except reset to perform some*/
/*       common setup tasks before returning from a specific handlers.  It*/
/*       is a leaf procedure.*/

/* INPUTS*/
/*      - %l7 = rerun instruction flag.*/
/*      - %l0 = psr upon return.*/
/*      - %l1 = pc at trap time.*/
/*      - %l2 = npc at trap time.*/

/* INTERNAL DESCRIPTION*/
/*      - Determine whether to start execution at pc or npc.*/
/*      - Disable traps.*/
/*      - Prepare cache autolock return sequence.*/
/*      - Return from trap to pc or npc.*/

/* RETURNS*/
/*      - None.*/

_trap_return:
        subcc   %l7, 1, %g0             /* If trap handler returns 1, then*/
        be      _rerun_trap_instr       /*  rerun the trapping instruction*/
        nop                             /*  else do not.*/
        ba      _skip_trap_instr
        nop

/* Return routine for reexecuting the trapped instruction like for page faults.*/

_rerun_trap_instr:
        andn    %l0, 0x20, %l0          /* Disable traps.*/
        wr      %l0, %g0, %psr
        or      %g0, 0x1, %l7           /* Set Restore Lock bit,*/
        or      %g0, 0x10, %l0          /*  in case an autolock sequence*/
        sta     %l7, [%l0] 1            /*  is in effect.*/
        jmpl    %l1, %g0                /* Return to instruction at pc.*/
        rett    %l2+%g0

/* Return routine for skipping the trapped instruction.*/

_skip_trap_instr:
        andn    %l0, 0x20, %l0          /* Disable traps.*/
        wr      %l0, %g0, %psr
        or      %g0, 0x1, %l7           /* Set Restore Lock bit,*/
        or      %g0, 0x10, %l0          /*  in case an autolock sequence*/
        sta     %l7, [%l0] 1            /*  is in effect.*/
        jmpl    %l2, %g0                /* Return to instruction at npc.*/
        rett    %l2+4

_instr_access:
        ba      error
        nop

_illegal_instr:
        ba      error
        nop

_privil_instr:
        ba      error
        nop

_fp_disable:
        ba      error
        nop


/* FUNCTION*/
/*      _win_ovf*/

/* DESCRIPTION*/
/*      This routine is the trap handler for register window overflow trap.*/
/*       Priority: 0x06*/
/*       Upon entry, the cwp points to the trap window, which is 1 less than*/
/*       the register window that must be saved to the stack.  the stack is*/
/*       organized with %i6 = %o6 - (0x40 + local stack used).  the ins and*/
/*       locals are saved, and the wim is adjusted for the new window.*/

/* INPUTS*/
/*      - %l0=psr at trap time.*/
/*      - %l1=pc at trap time.*/
/*      - %l2=npc at trap time.*/
/*      - %l3=tbr at trap time.*/

/* INTERNAL DESCRIPTION*/
/*      - Move the invalid window to the next window by rotating the %wim*/
/*         register left by one slot.*/
/*      - Get into the previously invalid window, the one that caused the trap,*/
/*         and save all of the registers in it.*/
/*      - Get back into the previously valid window and let the trapped routine*/
/*         execute the save again.*/

/* RETURNS*/
/*      - %l7 = 1 so execution starts at the trapped instruction.*/

_win_ovf:
        /* Turn on traps again so that we do not go into error state.*/
#ifndef INT_MODE1
        or      %l0, 0xf20, %l7         /* enable traps, disable interrupts.*/
        wr      %l7, %g0, %psr
#endif
        rd      %wim, %l4               /* Get wim at trap time.*/
        or      %g0, %g1, %l7           /* Save %g1.*/
        srl     %l4, 1, %g1             /* Next WIM = %g1 =*/
                                        /* rol(WIM, 1, NWINDOW).*/
        sll     %l4, NWINDOWS-1, %l5
        or      %l5, %g1, %g1
        save                            /* Get into window to be saved.*/
        wr      %g1,%g0, %wim           /* Install new wim.*/
        nop                             /* must delay three instructions*/
        nop                             /* before using these registers, so*/
        nop                             /* put nops in just to be safe*/
                                        /* save all local registers*/
        std     %l0, [%sp + 0x0 * 4]    
        std     %l2, [%sp + 0x2 * 4]
        std     %l4, [%sp + 0x4 * 4]
        std     %l6, [%sp + 0x6 * 4]
        std     %i0, [%sp + 0x8 * 4]
        std     %i2, [%sp + 0xa * 4]
        std     %i4, [%sp + 0xc * 4]
        std     %i6, [%sp + 0xe * 4]

        restore                         /* Go back to trap window.*/
        or      %g0, %l7, %g1           /* Restore %g1.*/
        or      %g0, 1, %l7             /* Tell _trap_return to rerun trapped*/
        ba      _trap_return            /*  instruction.*/
        nop


/* FUNCTION*/
/*      _win_unf*/

/* DESCRIPTION*/
/*      This routine is the trap handler for register window underflow trap.*/
/*       Priority: 0x07*/
/*       Upon entry, the cwp points to the trap window, which is 1 more than*/
/*       the register window that must be restored from the stack.  the stack*/
/*       is organized with %i6 = %o6 - (0x40 + local stack used).  the ins*/
/*       and locals are restored, and the wim is adjusted for the new window.*/

/* INPUTS*/
/*      - %l0=psr at trap time.*/
/*      - %l1=pc at trap time.*/
/*      - %l2=npc at trap time.*/
/*      - %l3=tbr at trap time.*/

/* INTERNAL DESCRIPTION*/

/* RETURNS*/
/*      - %l7 = 1 so execution starts at the trapped instruction.*/

_win_unf:
        /* Turn on traps again so that we do not go into error state.*/
#ifndef INT_MODE1
        or      %l0, 0xf20, %l7         /* enable traps, disable interrupts.*/
        wr      %l7, %g0, %psr
#endif
        rd      %wim, %l4               /* Get wim.*/
        nop
        nop
        nop
        sll     %l4, 1, %l5             /* Next WIM = rol(WIM, 1, NWINDOW).*/
        srl     %l4, NWINDOWS-1, %l6
        or      %l6, %l5, %l6
        mov     %l6, %wim               /* Install it.*/
        nop                             /* must delay three instructions*/
        nop                             /* before using these registers, so*/
        nop                             /* put nops in just to be safe*/
        restore                         /* Back to user window.*/
        restore                         /* Get into window to be restored.*/
                                        /*restore registers from stack*/
        ldd     [%sp + 0x0 * 4], %l0    
        ldd     [%sp + 0x2 * 4], %l2
        ldd     [%sp + 0x4 * 4], %l4
        ldd     [%sp + 0x6 * 4], %l6
        ldd     [%sp + 0x8 * 4], %i0
        ldd     [%sp + 0xa * 4], %i2
        ldd     [%sp + 0xc * 4], %i4
        ldd     [%sp + 0xe * 4], %i6
        save                            /* Get back to original window.*/
        save
        or      %g0, 1, %l7             /* Tell _trap_return to rerun trapped*/
        ba      _trap_return            /*  instruction.*/
        nop

_mem_misalign:
        ba      error
        nop
_fp_exception:
        ba      error
        nop
_data_access:
        ba      error
        nop
_tag_ovf:
        ba      error
        nop
_trap_instr:
        ba      error
        nop
_emulation_bp:
        set     0xff18, %l6     /* Debug control register*/
        lda     [%l6] 0, %l5
        or      %l5, 0x200, %l5
        sta     %l5, [%l6] 0
        add     %l0, 0x1, %l0
        jmpl    %l2, %g0                /* Return to instruction at npc.*/
        rett    %l2+4
_int_15:                        /* Not used normally.  Tied low through 10K.*/
#ifdef INT_MODE1
        sethi   %hi(CC1_BASE_ADDR), %l6
        or      %l6, %lo(CC1_BASE_ADDR), %l6
        or      %l6, 0x17<<2, %l4       /* %l4=CVR1 address.*/
        lda      [%l4] CC1_ASI, %l4              /* Reset Timer2 output.*/
        sethi   %hi(SRAM_START+0x3ff8), %l6    /* busy ourselves with incrementing*/
                                        /* the counter to allow interrupt*/
                                        /* to clear (we need minimum 5 cycles).*/
        or      %l6, 0xff8, %l6         /* %l6=&time.*/
        ld      [%l6], %l7              /* Get previous time.*/
        add     %l7, 1, %l7             /* Increment by 1.*/
        st      %l7, [%l6]              /* Updata time.*/
        sethi   %hi(CC1_BASE_ADDR), %l6
        or      %l6, %lo(CC1_BASE_ADDR), %l6
        or      %l6, 0x5<<2, %l5        /* %l5=ILCR address.*/
        or      %l6, 0x3<<2, %l6        /* %l6=RCR address.*/
        sethi   %hi(INT8_MASK), %l7    /* %l7 mask to clear int13.*/
        CC1_STA_HI (%l7, [%l6])
        sethi   %hi(IRL_CLEAR), %l7     /* %l7 mask to clear IRL latch.*/
        CC1_STA_HI (%l7, [%l5])

        set     0x0000fffe, %l5         /* 936 interrupt controller section */
        set     0x0000020c, %l4
        sta     %l5, [%l4] 1            /* Interrupt Request Clear register */

        set     0x00000010, %l5
        set     0x00000214, %l4
        sta     %l5, [%l4] 1            /* Interrupt IRL Latch/IRL Clear */

        or      %g0, 1, %l7             /* Tell _trap_return to rerun trapped*/
        ba      _chk4uflo            /*  instruction.*/
        nop
#else
# ifdef BOARD_832D
        ba      timer1_handler
# else
        ba      error
# endif
        nop
#endif
_int_14:                        /* Nice.  Tied high through 10K.*/
        ba      error
        nop
_int_13:                        /* Timer2.  Tied low through 10K.*/
#ifdef  I13
        sethi   %hi(CC1_BASE_ADDR), %l6
        or      %l6, %lo(CC1_BASE_ADDR), %l6
        or      %l6, 0x1b<<2, %l4       /* %l4=CVR1 address.*/
        lda      [%l4] CC1_ASI, %l4     /* Reset Timer2 output.*/
        sethi   %hi(SRAM_START+0x3ff8), %l6    /* busy ourselves with incrementing*/
                                        /* the counter to allow interrupt*/
                                        /* to clear (we need minimum 5 cycles).*/
        or      %l6, 0xff8, %l6         /* %l6=&time.*/
        ld      [%l6], %l7              /* Get previous time.*/
        add     %l7, 1, %l7             /* Increment by 1.*/
        st      %l7, [%l6]              /* Updata time.*/
        sethi   %hi(CC1_BASE_ADDR), %l6
        or      %l6, %lo(CC1_BASE_ADDR), %l6
        or      %l6, 0x5<<2, %l5        /* %l5=ILCR address.*/
        or      %l6, 0x3<<2, %l6        /* %l6=RCR address.*/
        sethi   %hi(INT13_MASK), %l7    /* %l7 mask to clear int13.*/
        CC1_STA_HI (%l7, [%l6])
        sethi   %hi(IRL_CLEAR), %l7     /* %l7 mask to clear IRL latch.*/
        CC1_STA_HI (%l7, [%l5])
        or      %g0, 1, %l7             /* Tell _trap_return to rerun trapped*/
        ba      _chk4uflo            /*  instruction.*/
        nop
#else
        ba      error
        nop
#endif
_int_12:                        /* Off Board.  Tied high through 10K.*/
        ba      error
        nop
_int_11:                        /* AT.  Tied high through 10K.*/
        ba      error
        nop
_int_10:                        /* UART0 Rx.*/
        ba      error
        nop
_int_9:                         /* UART0 Tx.*/
        ba      error
        nop
_int_8:                         /* Timer1.  Tied low through 10K.*/
#ifdef BOARD_832D
        ba      error
        nop
timer1_handler:
#endif
        sethi   %hi(CC1_BASE_ADDR), %l6
        or      %l6, %lo(CC1_BASE_ADDR), %l6
        or      %l6, 0x17<<2, %l4       /* %l4=CVR1 address.*/
        lda      [%l4] CC1_ASI, %l4              /* Reset Timer1 output.*/
        sethi   %hi(SRAM_START+0x3ff8), %l6    /* busy ourselves with incrementing*/
                                        /* the counter to allow interrupt*/
                                        /* to clear (we need minimum 5 cycles).*/
        or      %l6, %lo(SRAM_START+0x3ff8), %l6  /* %l6=&time.*/
        ld      [%l6], %l7              /* Get previous time.*/
        add     %l7, 1, %l7             /* Increment by 1.*/
        st      %l7, [%l6]              /* Updata time.*/
#ifdef CS3_IRC
        ldub    [%l6+5], %l6
        andcc   %l6, 0x80, %l6          /* If it is OFF, for internal IRC       */
        be      __int8_clrirc
        nop
#endif
        sethi   %hi(CC1_BASE_ADDR), %l6
        or      %l6, %lo(CC1_BASE_ADDR), %l6
        or      %l6, 0x5<<2, %l5        /* %l5=ILCR address.*/
        or      %l6, 0x3<<2, %l6        /* %l6=RCR address.*/
#ifdef CHIP_83X
        CC1_LDA_HI([%l6],%l7)           /* Dummy read for 830 clock x3,x4 */
        CC1_LDA_HI([%l6],%l7)
#endif
        sethi   %hi(INT8_MASK), %l7     /* %l7 mask to clear int13.*/
        CC1_STA_HI (%l7, [%l6])
        sethi   %hi(IRL_CLEAR), %l7     /* %l7 mask to clear IRL latch.*/
        CC1_STA_HI (%l7, [%l5])
#ifdef CHIP_83X
        CC1_LDA_HI ([%l5], %l7)         /* Dummy read for 830 clock x3,x4 */
#endif
#ifdef CS3_IRC
        ba      __int8_clrirc_end
        nop
__int8_clrirc:
        sethi   %hi(IRC_BASE), %l6
        or      %l6, %lo(IRC_BASE), %l6
        or      %l6, 0x5<<2, %l5        /* %l5=ILCR address.*/
        or      %l6, 0x3<<2, %l6        /* %l6=RCR address.*/
# ifdef CHIP_83X
        lda     [%l6] IRC_ASI, %l7              /* Dummy read for 830 clock x3,x4 */
        lda     [%l6] IRC_ASI, %l7
# endif
# ifdef BOARD_832D
        sethi   %hi(INT15_MASK>>16), %l7 /* %l7 mask to clear int15.*/
        or      %l7, %lo(INT15_MASK>>16), %l7
        sta     %l7, [%l6] IRC_ASI
# else
        sethi   %hi(INT8_MASK>>16), %l7 /* %l7 mask to clear int8.*/
        or      %l7, %lo(INT8_MASK>>16), %l7
        sta     %l7, [%l6] IRC_ASI
# endif
        sethi   %hi(IRL_CLEAR>>16), %l7 /* %l7 mask to clear IRL latch.*/
        or      %l7, %lo(IRL_CLEAR>>16), %l7
        sta     %l7, [%l5] IRC_ASI
# ifdef CHIP_83X
        lda     [%l5] IRC_ASI, %l7      /* Dummy read for 830 clock x3,x4 */
# endif
__int8_clrirc_end:
#endif /* CS3_IRC */
        or      %g0, 1, %l7             /* Tell _trap_return to rerun trapped*/
        ba      _chk4uflo               /*  instruction.*/
        nop
_int_7:                         /* UART1 Rx.*/
        ba      error
        nop
_int_6:                         /* UART1 Tx.*/
        ba      error
        nop
_int_5:                         /* AT.  Tied high through 10K.*/
        ba      error
        nop
_int_4:                         /* Nice.  Tied high through 10K.*/
        ba      error
        nop
_int_3:                         /* Timer1.  Tied low through 10K.*/
#ifdef  I3
        sethi   %hi(CC1_BASE_ADDR), %l6
        or      %l6, %lo(CC1_BASE_ADDR), %l6
        or      %l6, 0x17<<2, %l4       /* %l4=CVR1 address.*/
        lda      [%l4] CC1_ASI, %l4              /* Reset Timer2 output.*/
        sethi   %hi(SRAM_START+0x3ff8), %l6    /* busy ourselves with incrementing*/
                                        /* the counter to allow interrupt*/
                                        /* to clear (we need minimum 5 cycles).*/
        or      %l6, 0xff8, %l6         /* %l6=&time.*/
        ld      [%l6], %l7              /* Get previous time.*/
        add     %l7, 1, %l7             /* Increment by 1.*/
        st      %l7, [%l6]              /* Updata time.*/
        sethi   %hi(CC1_BASE_ADDR), %l6
        or      %l6, %lo(CC1_BASE_ADDR), %l6
        or      %l6, 0x5<<2, %l5        /* %l5=ILCR address.*/
        or      %l6, 0x3<<2, %l6        /* %l6=RCR address.*/
        sethi   %hi(INT3_MASK), %l7    /* %l7 mask to clear int13.*/
        CC1_STA_HI (%l7, [%l6])
        sethi   %hi(IRL_CLEAR), %l7     /* %l7 mask to clear IRL latch.*/
        CC1_STA_HI (%l7, [%l5]             /* Clear IRL latch.*/)
        or      %g0, 1, %l7             /* Tell _trap_return to rerun trapped*/
        ba      _chk4uflo            /*  instruction.*/
        nop
#else
        ba      error
        nop
#endif
_int_2:                         /* Off Board.  Tied high through 10K.*/
        ba      error
        nop
_int_1:                         /* Timer2.  Tied low through 10K.*/
#ifdef  I1
        sethi   %hi(CC1_BASE_ADDR), %l6
        or      %l6, %lo(CC1_BASE_ADDR), %l6
        or      %l6, 0x1b<<2, %l4       /* %l4=CVR1 address.*/
        lda      [%l4] CC1_ASI, %l4              /* Reset Timer2 output.*/
        sethi   %hi(SRAM_START+0x3ffc), %l6    /* busy ourselves with incrementing*/
                                        /* the counter to allow interrupt*/
                                        /* to clear (we need minimum 5 cycles).*/
        or      %l6, 0xffc, %l6         /* %l6=&time.*/
        ld      [%l6], %l7              /* Get previous time.*/
        add     %l7, 1, %l7             /* Increment by 1.*/
        st      %l7, [%l6]              /* Updata time.*/
        sethi   %hi(CC1_BASE_ADDR), %l6
        or      %l6, %lo(CC1_BASE_ADDR), %l6
        or      %l6, 0x5<<2, %l5        /* %l5=ILCR address.*/
        or      %l6, 0x3<<2, %l6        /* %l6=RCR address.*/
        sethi   %hi(INT1_MASK), %l7    /* %l7 mask to clear int13.*/
        CC1_STA_HI (%l7, [%l6]           /* Clear int13.*/)
        sethi   %hi(IRL_CLEAR), %l7     /* %l7 mask to clear IRL latch.*/
        CC1_STA_HI (%l7, [%l5]             /* Clear IRL latch.*/)
        or      %g0, 1, %l7             /* Tell _trap_return to rerun trapped*/
        ba      _chk4uflo            /*  instruction.*/
        nop
#else
        ba      error
        nop
#endif
_cp_disable:
        ba      error
        nop
_cp_exception:
        ba      error
        nop
_Ticc_1:
        ba      error
        nop
_Ticc_2:
        ba      error
        nop
_Ticc_3:
        ba      error
        nop
_Ticc_4:
        ba      error
        nop
_Ticc_5:
        ba      error
        nop
_Ticc_6:
        ba      error
        nop
_Ticc_7:
        ba      error
        nop
_Ticc_8:
        ba      error
        nop
_Ticc_9:
        ba      error
        nop
_Ticc_10:
        ba      error
        nop
_Ticc_11:
        ba      error
        nop
_Ticc_12:
        ba      error
        nop
_Ticc_13:
        ba      error
        nop
_Ticc_14:
        ba      error
        nop
_Ticc_15:
        ba      error
        nop
_Ticc_16:
        ba      error
        nop
_Ticc_17:
        ba      error
        nop
_Ticc_18:
        ba      error
        nop
_Ticc_19:
        ba      error
        nop
_Ticc_20:
        ba      error
        nop
_Ticc_21:
        ba      error
        nop
_Ticc_22:
        ba      error
        nop
_Ticc_23:
        ba      error
        nop
_Ticc_24:
        ba      error
        nop
_Ticc_25:
        ba      error
        nop
_Ticc_26:
        ba      error
        nop
_Ticc_27:
        ba      error
        nop
_Ticc_28:
        ba      error
        nop
_Ticc_29:
        ba      error
        nop
_Ticc_30:
        ba      error
        nop
_Ticc_31:
        ba      error
        nop
_Ticc_32:
        ba      error
        nop
_Ticc_33:
        ba      error
        nop
_Ticc_34:
        ba      error
        nop
_Ticc_35:
        ba      error
        nop
_Ticc_36:
        ba      error
        nop
_Ticc_37:
        ba      error
        nop
_Ticc_38:
        ba      error
        nop
_Ticc_39:
        ba      error
        nop
_Ticc_40:
        ba      error
        nop
_Ticc_41:
        ba      error
        nop
_Ticc_42:
        ba      error
        nop
_Ticc_43:
        ba      error
        nop
_Ticc_44:
        ba      error
        nop
_Ticc_45:
        ba      error
        nop
_Ticc_46:
        ba      error
        nop
_Ticc_47:
        ba      error
        nop
_Ticc_48:
        ba      error
        nop
_Ticc_49:
        ba      error
        nop
_Ticc_50:
        ba      error
        nop
_Ticc_51:
        ba      error
        nop
_Ticc_52:
        ba      error
        nop
_Ticc_53:
        ba      error
        nop
_Ticc_54:
        ba      error
        nop
_Ticc_55:
        ba      error
        nop
_Ticc_56:
        ba      error
        nop
_Ticc_57:
        ba      error
        nop
_Ticc_58:
        ba      error
        nop
_Ticc_59:
        ba      error
        nop
_Ticc_60:
        ba      error
        nop
_Ticc_61:
        ba      error
        nop
_Ticc_62:
        ba      error
        nop
_Ticc_63:
        ba      error
        nop
_Ticc_64:
        ba      error
        nop
_Ticc_65:
        ba      error
        nop
_Ticc_66:
        ba      error
        nop
_Ticc_67:
        ba      error
        nop
_Ticc_68:
        ba      error
        nop
_Ticc_69:
        ba      error
        nop
_Ticc_70:
        ba      error
        nop
_Ticc_71:
        ba      error
        nop
_Ticc_72:
        ba      error
        nop
_Ticc_73:
        ba      error
        nop
_Ticc_74:
        ba      error
        nop
_Ticc_75:
        ba      error
        nop
_Ticc_76:
        ba      error
        nop
_Ticc_77:
        ba      error
        nop
_Ticc_78:
        ba      error
        nop
_Ticc_79:
        ba      error
        nop
_Ticc_80:
        ba      error
        nop
_Ticc_81:
        ba      error
        nop
_Ticc_82:
        ba      error
        nop
_Ticc_83:
        ba      error
        nop
_Ticc_84:
        ba      error
        nop
_Ticc_85:
        ba      error
        nop
_Ticc_86:
        ba      error
        nop
_Ticc_87:
        ba      error
        nop
_Ticc_88:
        ba      error
        nop
_Ticc_89:
        ba      error
        nop
_Ticc_90:
        ba      error
        nop
_Ticc_91:
        ba      error
        nop
_Ticc_92:
        ba      error
        nop
_Ticc_93:
        ba      error
        nop
_Ticc_94:
        ba      error
        nop
_Ticc_95:
        ba      error
        nop
_Ticc_96:
        ba      error
        nop
_Ticc_97:
        ba      error
        nop
_Ticc_98:
        ba      error
        nop
_Ticc_99:
        ba      error
        nop
_Ticc_100:
        ba      error
        nop
_Ticc_101:
        ba      error
        nop
_Ticc_102:
        ba      error
        nop
_Ticc_103:
        ba      error
        nop
_Ticc_104:
        ba      error
        nop
_Ticc_105:
        ba      error
        nop
_Ticc_106:
        ba      error
        nop
_Ticc_107:
        ba      error
        nop
_Ticc_108:
        ba      error
        nop
_Ticc_109:
        ba      error
        nop
_Ticc_110:
        ba      error
        nop
_Ticc_111:
        ba      error
        nop
_Ticc_112:
        ba      error
        nop
_Ticc_113:
        ba      error
        nop
_Ticc_114:
        ba      error
        nop
_Ticc_115:
        ba      error
        nop
_Ticc_116:
        ba      error
        nop
_Ticc_117:
        ba      error
        nop
_Ticc_118:
        ba      error
        nop
_Ticc_119:
        ba      error
        nop
_Ticc_120:
        ba      error
        nop
_Ticc_121:
        ba      error
        nop
_Ticc_122:
        ba      error
        nop
_Ticc_123:
        ba      error
        nop
_Ticc_124:
        ba      error
        nop
_Ticc_125:
        ba      error
        nop
_Ticc_126:
        ba      error
        nop
_Ticc_127:
        ba      error
        nop

error:
        sethi   %hi(0x2000000), %l0
        or      %l0, 0x3, %l0
        stb     %g0, [%l0]              /* Light up all the LEDs.*/
        sethi   %hi(CC1_BASE_ADDR), %l0
        or      %l0, %lo(CC1_BASE_ADDR), %l0
        or      %l0, 0xd<<2, %l4        /* %l4=CSR address.*/
        or      %l0, 0xc<<2, %l0        /* %l0=DR address.*/
        sethi   %hi(TRDY_MASK), %l2     /* %l2=transmit ready mask to check.*/

/* Output tbr to serial port*/
a:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      a
        nop
        sethi   %hi(0xa0000), %l6       /* character: linefeed*/
        CC1_STA_HI (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
b:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      b
        nop
        sethi   %hi(0xd0000), %l6       /* character: return*/
        CC1_STA_HI (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
c:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      c
        nop
        sethi   %hi(0x540000), %l6      /* T*/
        CC1_STA_HI (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
d:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      d
        nop
        sethi   %hi(0x420000), %l6      /* B*/
        CC1_STA_HI (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
e:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      e
        nop
        sethi   %hi(0x520000), %l6      /* R*/
        CC1_STA_HI (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
f:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      f
        nop
        sethi   %hi(0x3d0000), %l6      /* =*/
        CC1_STA_HI (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 7*/
g:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      g
        nop
        srl     %l3, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 6*/
h:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      h
        nop
        sll     %l3, 4, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 5*/
i:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      i
        nop
        sll     %l3, 8, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 4*/
j:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      j
        nop
        sll     %l3, 12, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 3*/
k:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      k
        nop
        sll     %l3, 16, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 2*/
l:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      l
        nop
        sll     %l3, 20, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 1*/
m:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      m
        nop
        sll     %l3, 24, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 0*/
n:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      n
        nop
        sll     %l3, 28, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop

/* Output pc to serial port*/
o:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      o
        nop
        sethi   %hi(0x2c0000), %l6      /* ,*/
        CC1_STA_HI (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
p:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      p
        nop
        sethi   %hi(0x500000), %l6      /* P*/
        CC1_STA_HI (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
q:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      q
        nop
        sethi   %hi(0x430000), %l6      /* C*/
        CC1_STA_HI (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
r:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      r
        nop
        sethi   %hi(0x3d0000), %l6      /* =*/
        CC1_STA_HI (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 7*/
s:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      s
        nop
        srl     %l1, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 6*/
t:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      t
        nop
        sll     %l1, 4, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 5*/
u:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      u
        nop
        sll     %l1, 8, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 4*/
v:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      v
        nop
        sll     %l1, 12, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 3*/
w:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      w
        nop
        sll     %l1, 16, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 2*/
x:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      x
        nop
        sll     %l1, 20, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 1*/
y:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      y
        nop
        sll     %l1, 24, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        /* Write Nibble 0*/
z:
        CC1_LDA_HI      ([%l4], %l6              /* Get CSR*/)
        andcc   %l2, %l6, %g0           /* Are the buffer and shift reg empty.*/
        be      z
        nop
        sll     %l1, 28, %l6
        srl     %l6, 28, %l6
        call    _chk_hex_char   
        nop
        CC1_STA_LO (%l6, [%l0])
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        
/*------ If an error trap occurs, flash LEDs 20 times and reset the board.*/
/*      First, compute approariate flash counter by polling timer counter.*/
/*      The flash counter will be saved in %l4.*/
/*      We use race algorithm here.  The previous timer count is in %l1,*/
/*      while the current one is in %l2.  If %l2 < %l1, we are in the*/
/*      same timer cycle; if %l2 > %l1, the timer is reset once.*/
_err_flash_leds:

        set     CC1_BASE_ADDR, %l0
        or      %l0, 0x17<<2, %l0       /* %l0 = timer counter address*/
        clr     %l3
        CC1_LDA_HI      ([%l0], %l1     /* read timer counter*/)
    srl %l1, 16, %l1        /* Clear undefined bit */
LA1:
        CC1_LDA_HI      ([%l0], %l2     /* read timer counter*/)
    srl %l2, 16, %l2        /* Clear undefined bit */
        inc     %l4
        cmp     %l2, %l1
        bg      LA2
        mov     %l2, %l1
        ba      LA1
        nop
LA2:
        inc     %l3
        cmp     %l3, 3
        bne,a   LA1
        clr     %l4
 
/*------ Flash LEDs 20 times.*/
        srl     %l4, 1, %l4
        set     20, %l3                 /* flash 20 times*/
        set     0,  %l2                 /* byte written to the LEDs*/
err_flash_loop:
        mov     %l4, %l1
err_wait:
        subcc   %l1, 0x1, %l1
        bne     err_wait
        nop
        set     0x2000003, %l0          /* LED address*/
        orn     %g0, %l2, %l2
        stb     %l2, [%l0]              /* Toggle all the LEDs.*/
        subcc   %l3, 1, %l3
        bne     err_flash_loop
        nop

#ifdef BOARD_831
    set 0x00000020, %l0
    sta %g0, [%l0] 0x1
    nop
    nop
    nop
    nop
    sta %g0, [%g0] 0x1      /* cache off */
    nop
    nop
    nop
    nop
#endif

#ifdef NO_HW_RESET
        jmpl    %g0, %g0                /* No HW reset on double trap. Jump to*/
        nop                             /*  PROM location 0.*/
#endif

        ta      %g0                     /* reset board. ET bit = 0. Calling ta*/
        nop                             /*  makes the CPU enter error mode*/
                                        /*  and then enter reset stage*/

_chk_hex_char:
        add     %l6, 0x30, %l6
        subcc   %l6, 0x3a, %g0          /* is it "a..f"?*/
        bl      _done_hex_char          /* if not, we are done*/
        nop
        add     %l6, 0x7, %l6           /* get proper ascii code*/
_done_hex_char:
        jmpl    %o7+8, %g0              /* look in %o7 for ret from leaf*/
        nop

        .global _traphdl_end
_traphdl_end:   
