#include <stdio.h>
#include <string.h>
#include <mb86941.h>  

#define CACHE_ON 1
/*#define HV 1 */

extern void ASI4put(/* unsigned long data, unsigned long address */);
extern unsigned long ASI4get(/* unsigned long address */);
extern void ASI1put(/* unsigned long data, unsigned long address */);
extern unsigned long ASI1get(/* unsigned long address */);
extern void cache_on(/* void */);
extern void cache_off(/* void */);
extern void read_harvard( void );
extern void part_init();

#define RTBL_ADDR_BASE		0xfffe2000
#define RTBL_LINK_BASE		0xfffe3000
#define EVENT_DPM_IN_BASE	0x0c000000
#define EVENT_DPM_OUT_BASE	0x0c100000
#define DATA_DPM_IN_BASE	0x0c200000
#define DATA_DPM_OUT_BASE	0x0c300000
#define RL_SDRAM_MODE		0xfffe0000
#define RL_S_REG		0xfffe0004
#define RL_INIT_REG		0xfffe0008
#define RL_TBL_BREQ_REG		0xfffe0028
#define RL_TBL_BGRNT_REG	0xfffe002c
#define RL_SD_BREQ_REG		0xfffe0020
#define RL_SD_BGRNT_REG		0xfffe0024
#define	RL_SD_INIT_REG		0xffffe000
#define	SD_INIT_REG		0xfffff000
#define RL_SD_BASE		0x04000000
#define SD_BASE			0x08400000
#define ROM_BASE		0x00000000
#define MB86941_BASE		0xffff6000
#define PIO_BASE		( MB86941_BASE + 0x80 )

#define RL_BASE			0xfffe0000
#define RL_ELIC                 (RL_BASE + 0x000c)
#define RL_WIC                  (RL_BASE + 0x0010)
#define RL_CIC                  (RL_BASE + 0x0014)
#define RL_FIC                  (RL_BASE + 0x0018)
#define RL_RTIC                 (RL_BASE + 0x001c)
#define RL_EV_LRU               (RL_BASE + 0x0030)
#define RL_DA_LRU               (RL_BASE + 0x0034)
#define RL_IRC_ENABLE           (RL_BASE + 0x0038)
#define RL_EV_SD_CNT            (RL_BASE + 0x0040)
#define RL_DA_SD_CNT            (RL_BASE + 0x0044)


#define EVENT_IN_CNTL_REG		(EVENT_DPM_IN_BASE + 0x80)
#define EVENT_IN_PACKET_NUM		(EVENT_DPM_IN_BASE + 0x88)
#define EVENT_IN_PACKET_VALID	(EVENT_DPM_IN_BASE + 0x8c)
#define EVENT_OUT_CNTL_REG		(EVENT_DPM_OUT_BASE + 0x80)
#define EVENT_OUT_COUNT_REG		(EVENT_DPM_OUT_BASE + 0x84)
#define DATA_IN_CNTL_REG		(DATA_DPM_IN_BASE + 0x800)
#define DATA_IN_PACKET_NUM		(DATA_DPM_IN_BASE + 0x808)
#define DATA_IN_PACKET_VALID	(DATA_DPM_IN_BASE + 0x80c)
#define DATA_OUT_CNTL_REG		(DATA_DPM_OUT_BASE + 0x800)
#define DATA_OUT_COUNT_REG		(DATA_DPM_OUT_BASE + 0x804)

#define EVENT_HV_IN_BASE	0xf0001000
#define EVENT_HV_OUT_BASE	0xf0002000
#define HV_OUT_ENABLE		0x00030200

#define	DMA_BASE	0xffff2000
#define	DMA_PSA(x)	(DMA_BASE + 0x40*(x) + 0x04)
#define	DMA_MDA(x)	(DMA_BASE + 0x40*(x) + 0x08)
#define	DMA_IDR(x)	(DMA_BASE + 0x40*(x) + 0x0c)
#define	DMA_TMR(x)	(DMA_BASE + 0x40*(x) + 0x10)
#define	DMA_SR(x)	(DMA_BASE + 0x40*(x) + 0x14)
#define	DMA_LR(x)	(DMA_BASE + 0x40*(x) + 0x18)
#define	DMA_SASI(x)	(DMA_BASE + 0x40*(x) + 0x1c)
#define	DMA_DASI(x)	(DMA_BASE + 0x40*(x) + 0x20)
/*
DMAC0: Event In-DPM
DMAC1: Data In-DPM
DMAC2: Event Out-DPM
DMAC3: Data Out-DPM
*/

/*
 *  for IRC
 */
#define	LINK_IRC_BASE	0xfffe1000
#define LINK_IRC_TMR0   (LINK_IRC_BASE + 0x00)
#define LINK_IRC_TMR1   (LINK_IRC_BASE + 0x04)
#define LINK_IRC_RSR    (LINK_IRC_BASE + 0x08)
#define LINK_IRC_RCR    (LINK_IRC_BASE + 0x0c)
#define LINK_IRC_MR     (LINK_IRC_BASE + 0x10)
#define LINK_IRC_ICR    (LINK_IRC_BASE + 0x14)
#define LINK_IRC_MOD    (LINK_IRC_BASE + 0x18)

/*
#define       LINKINT_                15
#define       LINKINT_                14
#define       LINKINT_                13
#define       LINKINT_                12
#define       LINKINT_                11
*/
#define       LINKINT_FATAL           10
#define       LINKINT_TABLE            9
#define       LINKINT_WAIT             8
#define       LINKINT_CONT             7
#define       LINKINT_EV_IN_PAC        6
#define       LINKINT_DA_IN_PAC        5
#define       LINKINT_EV_IN_EOP        4
#define       LINKINT_DA_IN_EOP        3
#define       LINKINT_EV_OUT_EOP       2
#define       LINKINT_DA_OUT_EOP       1

#define IRL_CLEAR           0x00000010
#define REQ_ALL_CLEAR       0xfffffffe
#define INTR_DISABLE        0xffffffff
#define INTR_MASKALL        0xfffffffe

typedef unsigned long ulong;
typedef unsigned int u_int;

typedef unsigned long event_packet_t[4];

typedef enum {
        link_fatal      = 1 << LINKINT_FATAL,
        route_table     = 1 << LINKINT_TABLE,
        link_wait       = 1 << LINKINT_WAIT,
        link_cont       = 1 << LINKINT_CONT,
        ev_in_pac       = 1 << LINKINT_EV_IN_PAC,
        da_in_pac       = 1 << LINKINT_DA_IN_PAC,
        ev_in_eop       = 1 << LINKINT_EV_IN_EOP,
        da_in_eop       = 1 << LINKINT_DA_IN_EOP,
        ev_out_eop      = 1 << LINKINT_EV_OUT_EOP,
        da_out_eop      = 1 << LINKINT_DA_OUT_EOP,
} linkintr_t;

event_packet_t event_packet_demo[8] = { 
	{0x05a105a1, 0x00000000, 0x00000000, 0x410000e0},
	{0x05a105a1, 0x01234567, 0x89abcdef, 0x410000e0},
	{0x05a105a1, 0x01234567, 0x89abcdef, 0x410000e0},
	{0x05a105a1, 0x01234567, 0x89abcdef, 0x410000e0},
	{0x05a105a1, 0x01234567, 0x89abcdef, 0x410000e0},
	{0x05a105a1, 0x01234567, 0x89abcdef, 0x410000e0},
	{0x05a105a1, 0x01234567, 0x89abcdef, 0x410000e0},
	{0x05a105a1, 0x01234567, 0x89abcdef, 0x410000e0},
};

event_packet_t event_packet[8] = { 
	{0x05a105a1, 0x01234567, 0x89abcdef, 0x410000e0},
	{0x05a105a1, 0xfedcba98, 0x76543210, 0x410000e0},
	{0x05a105a1, 0x55555555, 0x55555555, 0x410000e0},
	{0x05a105a1, 0xaaaaaaaa, 0xaaaaaaaa, 0x410000e0},
	{0x05a105a1, 0x01234567, 0x89abcdef, 0x410000e0},
	{0x05a105a1, 0xfedcba98, 0x76543210, 0x410000e0},
	{0x05a105a1, 0x55555555, 0xaaaaaaaa, 0x410000e0},
	{0x05a105a1, 0x5a5a5a5a, 0x5a5a5a5a, 0x410000e0},
};

u_int ev_in_tail;

void wait( n )
int n;
{
	while ( n-- )
		;
}

void init_sdram( int num )
{
	if ( num == 0 ){
 		/* SDRAM0 Mode Setting , SDRAM0 used */	
		ASI4put( 0x2, RL_SDRAM_MODE );
		/* SDRAM0 Initialization */
		ASI4put( 0x02000000, RL_SD_INIT_REG );
	} else if ( num == 1 ){
		/* SDRAM1 Initialization */
		ASI4put( 0x02000000, SD_INIT_REG );
	}
}

void make_sender_routing_table( void )
{
	int i;
	ulong flag, d, *sp, *dp;
	
	/* Table Bus Request */
	ASI4put(0x00000000, RL_TBL_BREQ_REG);

	/* Polling Table Bus Arbitor */
	do {
		flag = ASI4get( RL_TBL_BGRNT_REG );
		flag >>= 31;
	} while ( flag != 0x0 );

	/* Put packet data align in order */
	sp = (ulong *) ( SD_BASE + 0x30000 );
	for ( i = 0; i < 4; i++ ) {
		*( sp + i ) = 0;
	}

	/* Null Clear Link Parts of Routing Table  */
	ASI4put( 0x00000000, DMA_TMR(0) );
	ASI4put( (ulong) sp, DMA_PSA(0) );
	ASI4put( RTBL_LINK_BASE, DMA_MDA(0) );
	ASI4put( 0x00000400, DMA_LR(0) );
	ASI4put( 0x00000008, DMA_SASI(0) );
	ASI4put( 0x00000004, DMA_DASI(0) );
	ASI4put( 0x00000081, DMA_TMR(0) );

	/* Null Clear Address Parts of Routing Table */
	ASI4put( 0x00000000, DMA_TMR(1) );
	ASI4put( (ulong) sp, DMA_PSA(1) );
	ASI4put( RTBL_ADDR_BASE, DMA_MDA(1) );
	ASI4put( 0x00000400, DMA_LR(1) );
	ASI4put( 0x00000008, DMA_SASI(1) );
	ASI4put( 0x00000004, DMA_DASI(1) );
	ASI4put( 0x00000081, DMA_TMR(1) );

	/* Setting Routing Table */
	ASI4put(0x05a105a1, RTBL_ADDR_BASE + 0x00);
	ASI4put(0x000003e2, RTBL_LINK_BASE + 0x00);

	ASI4put(0x85a185a1, RTBL_ADDR_BASE + 0x04);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x04);

	ASI4put(0x05a185a1, RTBL_ADDR_BASE + 0x08);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x08);

	ASI4put(0x85a105a1, RTBL_ADDR_BASE + 0x0c);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x0c);

	ASI4put(0x80008000, RTBL_ADDR_BASE + 0x10);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x10);

	ASI4put(0x80000000, RTBL_ADDR_BASE + 0x14);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x14);

	ASI4put(0x00008000, RTBL_ADDR_BASE + 0x18);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x18);

	/* Table Bus Release */
	ASI4put( 0x00000001, RL_TBL_BREQ_REG );
}

void send_datalink( ulong *dp ) {
	/* Set Data Out-DPM Control Register */
	*(ulong *) DATA_OUT_CNTL_REG = 0x4000000f;
	*(ulong *) DATA_OUT_COUNT_REG = 0;

	/* Data link output by DMAC */
	ASI4put( 0x00000000, DMA_TMR(3) );
	ASI4put( (ulong) dp, DMA_PSA(3) );
	ASI4put( DATA_DPM_OUT_BASE, DMA_MDA(3) );
	ASI4put( 0x00000040, DMA_LR(3) );
	ASI4put( 0x00000008, DMA_SASI(3) );
	ASI4put( 0x00000008, DMA_DASI(3) );
	ASI4put( 0x00002a01, DMA_TMR(3) );
	
	( * ( dp+1 ))++;
}

void send_eventlink_hv( void ) {
	int flag; 

	/* Harvard Bus */
        ASI1put( event_packet[0][0], EVENT_HV_OUT_BASE + 0x0 );
        ASI1put( event_packet[0][1], EVENT_HV_OUT_BASE + 0x4 );
        ASI1put( event_packet[0][2], EVENT_HV_OUT_BASE + 0x8 );
        ASI1put( event_packet[0][3], EVENT_HV_OUT_BASE + 0xc );

        printf("sending packets:\n");
        printf("%08x ",  ASI1get( EVENT_HV_OUT_BASE + 0x0 ) );
        printf("%08x ",  ASI1get( EVENT_HV_OUT_BASE + 0x4 ) );
        printf("%08x ",  ASI1get( EVENT_HV_OUT_BASE + 0x8 ) );
        printf("%08x\n", ASI1get( EVENT_HV_OUT_BASE + 0xc ) );

        /* wait for interrupt */
        do {
                flag = ASI4get(LINK_IRC_RSR);
        } while (flag == 0x0);
        ASI4put( 0xffffffff, 0xfffe000c );
        ASI4put( REQ_ALL_CLEAR,  LINK_IRC_RCR );
}

void send_eventlink_dpm( ulong *dp ) 
{
	/* Set Event Out-DPM Control Register */
        *(ulong *) EVENT_OUT_CNTL_REG = 0x40000003;
        *(ulong *) EVENT_OUT_COUNT_REG = 7;

        /* Event link output by DMAC */
        ASI4put( 0x00000000, DMA_TMR(2) );
        ASI4put( (ulong) dp, DMA_PSA(2) );
        ASI4put( EVENT_DPM_OUT_BASE, DMA_MDA(2) );
        ASI4put( 0x00000010, DMA_LR(2) );
        ASI4put( 0x00000008, DMA_SASI(2) );
        ASI4put( 0x00000008, DMA_DASI(2) );
        ASI4put( 0x00002a01, DMA_TMR(2) );
}

/*
 * Event Packet received.
 */
int ev_packet_in(void)
{
        register u_int ev_in_head;
        register u_int ret;

#if 1
        ret = ASI1get( EVENT_DPM_IN_BASE + ev_in_tail*0x10 + 0x4 );
#else
		ret = *(volatile u_int *)(EVENT_DPM_IN_BASE + ev_in_tail*0x10 + 0x8);
#endif
        ev_in_tail++;

        if (ev_in_tail == 8) {
                ev_in_tail = 0;
	}
        ev_in_head = ASI1get( EVENT_IN_PACKET_NUM );

        if (ev_in_tail == ev_in_head) {
                ASI4put( ev_in_pac, RL_ELIC );  /* Interrupt Clear */ 
	}
        return ret;
}

/*
void linkintr_clear(linkintr_t mask)
{
        ASI4put( ( u_int ) mask, LINK_IRC_RCR );
        ASI4put( IRL_CLEAR, LINK_IRC_ICR );
}
*/

u_int linkintr_init(void)
{
        ASI4put( 0xffffffff, RL_ELIC );
        ASI4put( 0x00000000, RL_WIC  );
        ASI4put( 0x00000000, RL_CIC  );
        ASI4put( 0x00000000, RL_FIC  );
        ASI4put( 0x00000000, RL_RTIC );
        ASI4put( INTR_DISABLE, LINK_IRC_MR  );
        ASI4put( 0x00000001, LINK_IRC_MOD   );
        ASI4put( 0x00000000, LINK_IRC_TMR0  );
        ASI4put( 0x00000000, LINK_IRC_TMR1  );
        ASI4put( INTR_MASKALL, LINK_IRC_MR  );
        ASI4put( REQ_ALL_CLEAR, LINK_IRC_RCR);
        ASI4put( IRL_CLEAR, LINK_IRC_ICR    );
        ASI4put( INTR_MASKALL, LINK_IRC_MR  );

	/* ENABLE */
	ASI4put( 0x00000000, LINK_IRC_MR );

        return 0;
}


void send_data_flow( void )
{
	int i, speed;
	u_int type, ret;
	ulong *sp, *dp;

	ev_in_tail = 0;

	speed = 100;	
	type = 0;

	linkintr_init();

	/* Set Packet Align */
	sp = (ulong *) event_packet_demo;
	dp = (ulong *) ( SD_BASE + 0x60000 );
	for ( i = 0; i < 4 * 8; i++ ) {
		*( dp + i ) = *( sp + i );
	}
	i = 40;
	while( i > 0 ){
		send_datalink( dp );
		wait( speed );
		type = ASI4get( LINK_IRC_ICR );
		printf( "LINK_IRC_ICR  %d\n", type );
		switch ( type ) {
	 	  case LINKINT_EV_IN_PAC:
			ret = ev_packet_in();
			//linkintr_clear( ev_in_pac );
			//sysintr_clear( link );
			printf( "event packet value = %x\n", ret );
			if ( ret == 0x0 ){
				speed == 1000000;
			} else if ( ret == 0x1 ) {
				speed == 1000;
			}
		       	speed = 100000;
			break;
		  default:
			break;
		}
		i--;
		if ( i == 38 ){
			send_eventlink_hv();
		}
	}
}	
	
void link2( void )
{
	int i, j;
	ulong flag, d, *sp, *dp;

#ifdef CACHE_ON 
	cache_on();
#else
	cache_off(); 
#endif

	ASI1put( 0x1, HV_OUT_ENABLE );

	init_sdram( 0 );
	init_sdram( 1 );

	/* DPLL Mode Setting */
#if 0 /* Set DPLL on other command instead of this */ 
	set_dpll(); /* defined on init.c */
#endif

	/* Link Initialization */
#if 1
	part_init();  /* 0x001e001e */
#else
	all_init();  /* 0x00010001 */
#endif

	make_sender_routing_table();

	/* Set Event In-DPM Control Register */
	*(ulong *) EVENT_IN_CNTL_REG = 0x40000010;

	/* Event link input by DMAC */
	ASI4put( 0x00000000, DMA_TMR(0) );
	ASI4put( EVENT_DPM_IN_BASE, DMA_PSA(0) );
	ASI4put( SD_BASE + 0x40000, DMA_MDA(0) );
	ASI4put( 0x00000040, DMA_LR(0) );
	ASI4put( 0x00000008, DMA_SASI(0) );
	ASI4put( 0x00000008, DMA_DASI(0) );
	ASI4put( 0x00006a00, DMA_TMR(0) );

	/* Set Data In-DPM Control Register */
#if 0
	*(ulong *) DATA_IN_CNTL_REG = 0x40000020;
#else
	*(ulong *) DATA_IN_CNTL_REG = 0x00000020;
#endif

	/* Data link input by DMAC */
	ASI4put( 0x00000000, DMA_TMR(1) );
	ASI4put( DATA_DPM_IN_BASE, DMA_PSA(1) );
	ASI4put( SD_BASE + 0x50000, DMA_MDA(1) );
	ASI4put( 0x00000040, DMA_LR(1) );
	ASI4put( 0x00000008, DMA_SASI(1) );
	ASI4put( 0x00000008, DMA_DASI(1) );
	ASI4put( 0x00006a00, DMA_TMR(1) );

#if OCL 
	/* PIO Direction (Write Mode) */
	ASI4put( 0xffffffff, PIO_BASE + 0x4 );
	/* PIO Data Reset */
	ASI4put( 0x00000000, PIO_BASE );
#endif

#ifndef HV
	/* Set Packet Align */
	sp = (ulong *) event_packet;
	dp = (ulong *) ( SD_BASE + 0x60000 );
	for ( i = 0; i < 4 * 8; i++ ) {
		*( dp + i ) = *( sp + i );
	}
#if 0 
	printf( "LINK_IRC_ICR   %d\n", ASI4get( LINK_IRC_ICR ) );
#endif
	printf( "send eventlink via dpm\n" );
	send_eventlink_dpm( dp );
	
#if 0 
	printf( "LINK_IRC_ICR   %d\n", ASI4get( LINK_IRC_ICR ) );
#endif

	printf( "send datalink\n" );
	send_datalink( dp );

#if OCL 
	ASI4put( 0xffffffff, PIO_BASE );
	ASI4put( 0x00000000, PIO_BASE );
#endif

/* above is not defined HV */

#else 

/* under is defined HV */
#if 0	
	/* Harvard Bus */
	ASI1put( event_packet[0][0], EVENT_HV_OUT_BASE + 0x0 );
	ASI1put( event_packet[0][1], EVENT_HV_OUT_BASE + 0x4 );
	ASI1put( event_packet[0][2], EVENT_HV_OUT_BASE + 0x8 );
	ASI1put( event_packet[0][3], EVENT_HV_OUT_BASE + 0xc );

#ifdef OCL	
	ASI4put( 0xffffffff, PIO_BASE );
	ASI4put( 0x00000000, PIO_BASE );
#endif

	printf("sending packets:\n");
	printf("%08x ",  ASI1get( EVENT_HV_OUT_BASE + 0x0 ) );
	printf("%08x ",  ASI1get( EVENT_HV_OUT_BASE + 0x4 ) );
	printf("%08x ",  ASI1get( EVENT_HV_OUT_BASE + 0x8 ) );
	printf("%08x\n", ASI1get( EVENT_HV_OUT_BASE + 0xc ) );

	/* wait for interrupt */
	do {
		flag = ASI4get(LINK_IRC_RSR);
	} while (flag == 0x0);
	ASI4put( 0xffffffff, 0xfffe000c );
	ASI4put( REQ_ALL_CLEAR,  LINK_IRC_RCR );
#endif

	printf("send eventlink via harvard bus\n" );
	send_eventlink_hv();

#endif 
#if 0 /* for checking input data on harvard bus */
	read_harvard();
#endif
}
