#include <stdio.h>
#include <string.h>
#include <mb86941.h>  

#define CACHE_ON 1

extern void ASI4put(/* unsigned long data, unsigned long address */);
extern unsigned long ASI4get(/* unsigned long address */);
extern void ASI1put(/* unsigned long data, unsigned long address */);
extern unsigned long ASI1get(/* unsigned long address */);
extern void cache_on(/* void */);
extern void cache_off(/* void */);
extern void part_init();

#define RTBL_ADDR_BASE		0xfffe2000
#define RTBL_LINK_BASE		0xfffe3000
#define EVENT_DPM_IN_BASE	0x0c000000
#define EVENT_DPM_OUT_BASE	0x0c100000
#define DATA_DPM_IN_BASE	0x0c200000
#define DATA_DPM_OUT_BASE	0x0c300000
#define RL_SDRAM_MODE		0xfffe0000
#define RL_S_REG			0xfffe0004
#define RL_INIT_REG			0xfffe0008
#define RL_TBL_BREQ_REG		0xfffe0028
#define RL_TBL_BGRNT_REG	0xfffe002c
#define RL_SD_BREQ_REG		0xfffe0020
#define RL_SD_BGRNT_REG		0xfffe0024
#define	RL_SD_INIT_REG		0xffffe000
#define	SD_INIT_REG			0xfffff000
#define RL_SD_BASE			0x04000000
#define SD_BASE				0x08400000
#define ROM_BASE		0x00000000
#define MB86941_BASE		0xffff6000
#define PIO_BASE		( MB86941_BASE + 0x80 )

#define EVENT_IN_CNTL_REG		(EVENT_DPM_IN_BASE + 0x80)
#define EVENT_IN_PACKET_NUM		(EVENT_DPM_IN_BASE + 0x88)
#define EVENT_IN_PACKET_VALID	(EVENT_DPM_IN_BASE + 0x8c)
#define EVENT_OUT_CNTL_REG		(EVENT_DPM_OUT_BASE + 0x80)
#define EVENT_OUT_COUNT_REG		(EVENT_DPM_OUT_BASE + 0x84)
#define DATA_IN_CNTL_REG		(DATA_DPM_IN_BASE + 0x800)
#define DATA_IN_PACKET_NUM		(DATA_DPM_IN_BASE + 0x808)
#define DATA_IN_PACKET_VALID	(DATA_DPM_IN_BASE + 0x80c)
#define DATA_OUT_CNTL_REG		(DATA_DPM_OUT_BASE + 0x800)
#define DATA_OUT_COUNT_REG		(DATA_DPM_OUT_BASE + 0x804)

#define EVENT_HV_IN_BASE	0xf0001000
#define EVENT_HV_OUT_BASE	0xf0002000
#define HV_OUT_ENABLE		0x00030200

#define	DMA_BASE	0xffff2000
#define	DMA_PSA(x)	(DMA_BASE + 0x40*(x) + 0x04)
#define	DMA_MDA(x)	(DMA_BASE + 0x40*(x) + 0x08)
#define	DMA_IDR(x)	(DMA_BASE + 0x40*(x) + 0x0c)
#define	DMA_TMR(x)	(DMA_BASE + 0x40*(x) + 0x10)
#define	DMA_SR(x)	(DMA_BASE + 0x40*(x) + 0x14)
#define	DMA_LR(x)	(DMA_BASE + 0x40*(x) + 0x18)
#define	DMA_SASI(x)	(DMA_BASE + 0x40*(x) + 0x1c)
#define	DMA_DASI(x)	(DMA_BASE + 0x40*(x) + 0x20)
/*
DMAC0: Event In-DPM
DMAC1: Data In-DPM
DMAC2: Event Out-DPM
DMAC3: Data Out-DPM
*/

/*
 *  for IRC
 */
#define	LINK_IRC_BASE	0xfffe1000
#define LINK_IRC_TMR0   (LINK_IRC_BASE + 0x00)
#define LINK_IRC_TMR1   (LINK_IRC_BASE + 0x04)
#define LINK_IRC_RSR    (LINK_IRC_BASE + 0x08)
#define LINK_IRC_RCR    (LINK_IRC_BASE + 0x0c)
#define LINK_IRC_MR     (LINK_IRC_BASE + 0x10)
#define LINK_IRC_ICR    (LINK_IRC_BASE + 0x14)
#define LINK_IRC_MOD    (LINK_IRC_BASE + 0x18)

#define IRL_CLEAR           0x00000010
#define REQ_ALL_CLEAR       0xfffffffe
#define INTR_DISABLE        0xffffffff
#define INTR_MASKALL        0xfffffffe


typedef unsigned long ulong;


typedef unsigned long event_packet_t[4];


static event_packet_t event_packet[8] = { 
	{0x05a105a1, 0x01234567, 0x89abcdef, 0x410000e0},
	{0x05a105a1, 0xfedcba98, 0x76543210, 0x410000e0},
	{0x05a105a1, 0x55555555, 0x55555555, 0x410000e0},
	{0x05a105a1, 0xaaaaaaaa, 0xaaaaaaaa, 0x410000e0},
	{0x05a105a1, 0x01234567, 0x89abcdef, 0x410000e0},
	{0x05a105a1, 0xfedcba98, 0x76543210, 0x410000e0},
	{0x05a105a1, 0x55555555, 0xaaaaaaaa, 0x410000e0},
	{0x05a105a1, 0x5a5a5a5a, 0x5a5a5a5a, 0x410000e0},
};


static void wait( n )
int n;
{
	while ( n-- )
		;
}


void receive_init()
{
	int i, j;
	ulong flag, d, *sp, *dp;

#ifdef CACHE_ON 
	cache_on();
#else
	cache_off(); 
#endif

	ASI1put( 0x1, HV_OUT_ENABLE );

 	/* SDRAM0 Mode Setting , SDRAM0 used */	
	ASI4put( 0x2, RL_SDRAM_MODE );

	/* SDRAM0 Initialization */
	/* ASI4put(0x03020000, RL_SD_INIT_REG); */
	ASI4put( 0x02000000, RL_SD_INIT_REG );

	/* SDRAM1 Initialization */
	/* ASI4put(0x03020000, SD_INIT_REG); */
	ASI4put( 0x02000000, SD_INIT_REG );

	/* DPLL Mode Setting */
#if 0
	set_dpll();
#endif 

	/* Link Initialization */
#if 1 
/*	part_init(); */ /* 0x001e001e */
#else
	all_init();     /* 0x00010001 */
#endif

        /* Set Event In-DPM Control Register */
        *(ulong *) EVENT_IN_CNTL_REG = 0x40000010;
        /* Event link input by DMAC */
        ASI4put( 0x00000000, DMA_TMR(0) );
        ASI4put( EVENT_DPM_IN_BASE, DMA_PSA(0) );
        ASI4put( SD_BASE + 0x40000, DMA_MDA(0) );
        ASI4put( 0x00000040, DMA_LR(0) );
        ASI4put( 0x00000008, DMA_SASI(0) );
        ASI4put( 0x00000008, DMA_DASI(0) );
        ASI4put( 0x00006a00, DMA_TMR(0) );

        /* Set Data In-DPM Control Register */
        *(ulong *) DATA_IN_CNTL_REG = 0x40000020;
        /* Data link input by DMAC */
        ASI4put( 0x00000000, DMA_TMR(1) );
        ASI4put( DATA_DPM_IN_BASE, DMA_PSA(1) );
        ASI4put( SD_BASE + 0x50000, DMA_MDA(1) );
        ASI4put( 0x00000040, DMA_LR(1) );
        ASI4put( 0x00000008, DMA_SASI(1) );
        ASI4put( 0x00000008, DMA_DASI(1) );
        ASI4put( 0x00006a00, DMA_TMR(1) );

/* follows are to set routing table for receiver */	
	/* Table Bus Request */
	ASI4put(0x00000000, RL_TBL_BREQ_REG);

	/* Polling Table Bus Arbitor */
	do {
		flag = ASI4get( RL_TBL_BGRNT_REG );
		flag >>= 31;
	} while ( flag != 0x0 );

	/* Make Routing Table */
	sp = (ulong *) ( SD_BASE + 0x30000 );
	for ( i = 0; i < 4; i++ ) {
		*( sp + i ) = 0;
	}

	/* Null Clear Link Parts of Routing Table  */
	ASI4put( 0x00000000, DMA_TMR(0) );
	ASI4put( (ulong) sp, DMA_PSA(0) );
	ASI4put( RTBL_LINK_BASE, DMA_MDA(0) );
	ASI4put( 0x00000400, DMA_LR(0) );
	ASI4put( 0x00000008, DMA_SASI(0) );
	ASI4put( 0x00000004, DMA_DASI(0) );
	ASI4put( 0x00000081, DMA_TMR(0) );

	/* Null Clear Address Parts of Routing Table */
	ASI4put( 0x00000000, DMA_TMR(1) );
	ASI4put( (ulong) sp, DMA_PSA(1) );
	ASI4put( RTBL_ADDR_BASE, DMA_MDA(1) );
	ASI4put( 0x00000400, DMA_LR(1) );
	ASI4put( 0x00000008, DMA_SASI(1) );
	ASI4put( 0x00000004, DMA_DASI(1) );
	ASI4put( 0x00000081, DMA_TMR(1) );

	/* Setting Routing Table */
	ASI4put(0x05a105a1, RTBL_ADDR_BASE + 0x00);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x00);

	ASI4put(0x85a185a1, RTBL_ADDR_BASE + 0x04);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x04);

	ASI4put(0x05a185a1, RTBL_ADDR_BASE + 0x08);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x08);

	ASI4put(0x85a105a1, RTBL_ADDR_BASE + 0x0c);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x0c);

	ASI4put(0x80000000, RTBL_ADDR_BASE + 0x10);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x10);

	ASI4put(0x00008000, RTBL_ADDR_BASE + 0x14);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x14);

	ASI4put(0x80008000, RTBL_ADDR_BASE + 0x18);
	ASI4put(0x00000301, RTBL_LINK_BASE + 0x18);

	/* Table Bus Release */
	ASI4put( 0x00000001, RL_TBL_BREQ_REG );

	printf( "Set Routing Table\n" );

/*	read_harvard(); */
}

void read_harvard( void ) 
{
	ulong d;

	/* Event ink input by HV Bus */
	d = ASI1get( EVENT_HV_IN_BASE + 0x0 );
	d = ASI1get( EVENT_HV_IN_BASE + 0x4 );
	d = ASI1get( EVENT_HV_IN_BASE + 0x8 );
	d = ASI1get( EVENT_HV_IN_BASE + 0xc );
	
	printf( "received packets:\n" );
	printf( "%08x ", ASI1get( EVENT_HV_IN_BASE + 0x0 ) );
	printf( "%08x ", ASI1get( EVENT_HV_IN_BASE + 0x4 ) );
	printf( "%08x ", ASI1get( EVENT_HV_IN_BASE + 0x8 ) );
	printf( "%08x\n", ASI1get( EVENT_HV_IN_BASE + 0xc ) );
}
	
