/*
 * FILE
 *	coff.h
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
 */

/*
 * COFF file definitions
 */

/*
 * COFF file header
 */
struct filehdr
{
	unsigned short	f_magic;	/* magic 			*/
	unsigned short	f_nscns;	/* section count		*/
	long		f_timdat;	/* time & date 			*/
	long		f_symptr;	/* symbol table pointer 	*/
	long		f_nsyms;	/* number of symbols		*/
	unsigned short	f_opthdr;	/* sizeof (optional hdr)	*/
	unsigned short	f_flags;	/* flags			*/
};


/*
 * COFF section header
 */
struct scnhdr
{
	char		s_name[8];	/* name of section		*/	
	long		s_paddr;	/* physical address		*/
	long		s_vaddr;	/* virtual address		*/
	long		s_size;		/* size of section		*/
	long		s_scnptr;	/* ptr to section		*/
	long		s_relptr;	/* ptr to relocation info	*/
	long		s_lnnoptr;	/* ptr to line numbers		*/
	unsigned short	s_nreloc;	/* number of relocation entries	*/
	unsigned short	s_nlnno;	/* number of line number entries*/
	long		s_flags;	/* flags			*/
};
