/*
 * FILE
 *	e_cksump.c
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 */
 *
#ifdef SUN_WORKSTATION
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <stdio.h>
#include <stab.h>
#include <fcntl.h>
#include <link.h>
#include <unistd.h>
#include <varargs.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/time.h>
#include "coff.h"
#else	/* PC */
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <fcntl.h>
#include "coff.h"
#endif


#define	usage()	{ \
	(void)fprintf(stderr, "usage: e_chksum -f coffile [-h hdrfile]\n"); \
	exit(1); }

#define Alloc( n, t )	( t * ) xalloc(( n ) * sizeof( t ))

#define BigToLit_L(x)	((((x) & 0xFF) << 24)    | (((x) & 0xFF00) << 8)     | \
			 (((x) & 0xFF0000) >> 8) | (((x) & 0xFF000000) >> 24))
#define BigToLit_S(x)	((((x) & 0xFF) << 8)     | (((x) & 0xFF00) >> 8));

struct opthdr {
	/* not defined in available coff.h so we'll make one up here */
	unsigned short 	magic;
	unsigned short  version;
	unsigned long   text_size;
	unsigned long   data_size;
	unsigned long   bss_size;
	unsigned long   entry_pt;
	unsigned long   text_start;
	unsigned long   data_start;
};

FILE			*hdr;	    	/* destintation .h file */
char 			*coffname = 0;
char 			*hdrname = 0;
char			*ap = NULL;	/* ptr to editable a.out in memory */
unsigned short		csum = 0;
struct stat		instat;		/* stat for input file */
struct filehdr		*fhdr;
struct opthdr		*ohdr;
struct scnhdr		*scn;

abort()
{
    exit(1);
}

/*
 * allocation routine.
 */
char *xalloc( n )
    long	n;
{
    char	*ptr;

    ptr = ( char * ) malloc( n );
    if ( ptr )
	return( ptr );
    printf( "malloc out of memory\n" );
    abort();
}

/*
 * readcoff( filename )
 *
 * Read the source a.out into memory.
 */
readcoff( filename )
    char	*filename;
{
    int				fd;
    long			i;
    long			len;
    long			n;
    unsigned short		*cur_ptr;
    unsigned long		tsize;
    unsigned long		dsize;
    unsigned long		d;
    unsigned short		secnum;
int ret;
long total;

    /*
    ** read in the whole file
    ** then set up some interesting
    ** pointers and stuff
    */
    fd = open( filename, O_RDONLY | O_BINARY);
    if ( fd < 0 ) {
	printf( "could not open %s\n", filename );
	abort();
    }
    if ( fstat( fd, &instat ) < 0 ) {
	printf( "could not fstat %s\n", filename );
	abort();
    }
    len = instat.st_size;
    /*
     * allocate enough space for two versions of the a.out,
     * the first is the editable one, the second is a read_only
     * version which can be referred to throughout the
     * editing process.
     */
    ap = Alloc( len + 8, char );
	total = 0;
	for (;;) {
    		ret = read( fd, ap+total, 10000 );
		total += ret;
		if (total >= len)
			break;
	}
    	if (total > len ) {
		printf( "could not read %s\n", filename );
		abort();
    	}
    close( fd );
    fhdr = (struct filehdr *)ap;
    ohdr = (struct opthdr *)(ap + sizeof(struct filehdr));
    scn = (struct scnhdr*)((char *)ohdr + sizeof(struct opthdr));

    /* change big endian (SPARC default) to little endian (DOS) */
    tsize  =  ohdr->text_size;
    dsize  =  ohdr->data_size;
    secnum =  fhdr->f_nscns;

    tsize  = BigToLit_L(tsize);
    d      = BigToLit_L(dsize);
    secnum = BigToLit_S(secnum);

    cur_ptr = (unsigned short *)((char *)scn + secnum*sizeof(struct scnhdr));

    for (i = 0;
	 i < (tsize + d);
	 i += sizeof(unsigned short)) {
	csum += BigToLit_S(*cur_ptr);
	cur_ptr++;
    }
    if (hdrname)
	/*
	 * just to make this utility more useful we will base csum 
	 * whether or not a header file has been specified which would
	 * imply a rebuild using the last value as the inclusive checksum.
	 */
        csum = (unsigned short) (0x10000 - (unsigned long)csum);
}

main(argc, argv)
int	argc;
char	**argv;
{
	argv++;
	argc--;
	while (argc) {
		if (argv[0][0] == '-') {
			switch (argv[0][1]) {


	    		case 'h':
				argc -= 2;
				argv++;
				hdrname = *argv++;
				break;

	    		case 'f':
				argc -= 2;
				argv++;
				coffname = *argv++;
				break;

			default:
				usage();
				break;
			}
		}
		else {
			usage();
		}
	}
    if (!coffname)
	usage();
    readcoff(coffname);
    printf("%s 2 byte checksum = 0x%x\n", coffname, csum);
    if (hdrname) {
        if (!(hdr = fopen( hdrname, "w+" ))) {
	    perror("fopen");
	    printf("couldn't open %s\n", hdrname);
	    abort();
        }
        if (fprintf(hdr, ".word\t0x%x\n", csum) == EOF) {
	    perror("fprintf");
	    printf("couldn't write to %s\n", hdrname);
	    abort();
        }
        fclose(hdr);
    }
    exit(0);
}
