/* FILE
 *  syscalls.c
 *
 *  Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *  All rights reserved.
 *
 *  This software (including any documentation) is untested, has not been
 *  fully tested for viruses and has been provided to you without charge.
 *  ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *  IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *  risk of nonperformance, loss of data and other problems and Fujitsu
 *  Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *  contract, negligence, strict liability or other theory for any damages
 *  including, without limitation, direct, consequential or incidental nor
 *  be required to provide substitute goods, services or technology.
 *
 */
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/times.h>

/* Operating system stubs */

int open(char *fname, int mode) {
  return(1);
}

int close(int file){
  return -1;
}


int execve(char *name, char **argv, char **env){
  errno=ENOMEM;
  return -1;
}


int fork() {
  errno=EAGAIN;
  return -1;
}


int fstat(int file, struct stat *st) {
  st->st_mode = S_IFCHR;
  return 0;
}


int getpid() {
  return 1;
}


int isatty(int file){
  return 1;
}


int kill(int pid, int sig){
  errno=EINVAL;
  return(-1);
}


int link(char *old, char *new){
  errno=EMLINK;
  return -1;
}


int lseek(int file, int ptr, int dir){
  return 0;
}


static char *heap_end = 0;

caddr_t sbrk(int incr){
  extern char end;            /* Defined by the linker */
  char *prev_heap_end;
  
  if (heap_end == 0) {        /* self-initialize */
    heap_end = &end;
  }
  prev_heap_end = heap_end;
  heap_end += incr;
  return (caddr_t) prev_heap_end;
}

/********************************************************************** 
   Added mark and release for the sake of Stanford benchmark Trees 
   which does not clean up after itself. 
*/

static char * mark_save;

void _mark() {
  mark_save = heap_end;
}

void _release() {
  heap_end = mark_save;
}

/**********************************************************************/

int stat(const char *file, struct stat *st) {
  st->st_mode = S_IFCHR;
  return 0;
}


clock_t times(struct tms *buf){

  buf->tms_utime = (clock_t)((double)CC1_time1()*(double)60/(double)65536);
  buf->tms_stime = (clock_t)0;
  buf->tms_cutime = (clock_t)0;
  buf->tms_cstime = (clock_t)0;
  return 0;
}

int unlink(char *name){
  errno=ENOENT;
  return -1;
}


int wait(int *status) {
  errno=ECHILD;
  return -1;
}


asm("
    .text
    .align 4
    .globl _get_uart1_status
_get_uart1_status:
    set 0x10000035, %o0
    retl
    lduba [%o0] 4, %o0

    .globl _xmt_char1
_xmt_char1:
    set 0x10000031, %o1
    retl
    stba %o0, [%o1] 4

    .globl _rcv_char1
_rcv_char1:
    set 0x10000031, %o0
    retl
    lduba [%o0] 4, %o0

");

 /* 1/5th of a second? */

#define LEDTIME (20000000 / 500)

int
getCharPort1()
{
  unsigned long countdown = LEDTIME;

  while (1)
    {
      if ((get_uart1_status(0) & 2) != 0) break;
      if (countdown-- == 0)
    {
      countdown = LEDTIME;
    }
    }
  return rcv_char1();
}

/* Output one character to the serial port */

void
putCharPort1(c)
     int c;
{

  while ((get_uart1_status() & 1) == 0) ;

  xmt_char1(c);
}

int
write(fd, data, length)
     int fd;
     unsigned char *data;
     int length;
{
  int olength = length;

  while (length--) {
    char ch;
    ch=*data++;
    if ((ch == '\n' || ch == '\r')) {
      putCharPort1('\n'); /* do both a line feed and return. */
      putCharPort1('\r');
    } else {
      putCharPort1(ch);
    }
  }

  return olength;
}

int
read(fd, data, length)
     int fd;
     unsigned char *data;
     int length;
{
  int olength = length;
  int c;

  while (length--)
    *data++ = getCharPort1();

  return olength;
}


