
# FILE
#	examplpc.mak
#
#	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
#	All rights reserved.
#
#	This software (including any documentation) is untested, has not been
#	fully tested for viruses and has been provided to you without charge.
#	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
#	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
#	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
#	risk of nonperformance, loss of data and other problems and Fujitsu
#	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
#	contract, negligence, strict liability or other theory for any damages
#	including, without limitation, direct, consequential or incidental nor
#	be required to provide substitute goods, services or technology.
#
# 
# Select chip version (930, 931, ...).  Every time CHIP definition is changed,
# all modules should be recompiled.
#
CHIP		= 933H
MHZ		= 20
TOOLPATH	= /cygnus
TOOLPATH1	= $(TOOLPATH)/bin
TOOLPATH2	= $(TOOLPATH)/lib
CC		= $(TOOLPATH1)/gcc
CPP		= $(TOOLPATH1)/cpp
AS		= $(TOOLPATH1)/as
LD		= $(TOOLPATH1)/ld
LIBRARY_PATH	= $(TOOLPATH2)
CCFLAGS		= -O -c -DCHIP_VER_$(CHIP) -DMASTER_CK_$(MHZ)
CPPFLAGS	= -DCHIP_VER_$(CHIP) -DMASTER_CK_$(MHZ)
ASFLAGS		= 
LIBS		= 
GNU_SP_LIB	= $(LIBRARY_PATH)

# LIBRARY_PATH is a shell environment variable set to Cygnus' library directory
LDFLAGS		= -Tldscript -Ttext 40010000 -Bstatic -N -L$(GNU_SP_LIB)

TARGET		= ex

OBJECTS		= crt0.o example.o cntlsps.o cntlsp.o salib.o syscalls.o

.s.o:	
	$(CPP) $(CPPFLAGS) $*.s $*.i
	$(AS) $(ASFLAGS) -o $*.o $*.i

.c.o:	
	$(CC) $(CCFLAGS) $*.c

$(TARGET):	$(OBJECTS) 
	$(LD) $(LDFLAGS) -o $(TARGET)$(CHIP).cof $(OBJECTS) -lc -lgcc
	objcopy --output-target=srec $(TARGET)$(CHIP).cof $(TARGET)$(CHIP).sr
	-del *.o
	-del *.i
