/* FILE
 *	salib.c
 *
 *
 *	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
 */

/* Stand-alone library for SPARClite */

extern unsigned long get_xmt_status();
extern void xmt_char();

asm("
	.text
	.align 4
	.globl _get_uart_status
_get_uart_status:
	set 0x10000025, %o0
	retl
	lduba [%o0] 4, %o0

	.globl _xmt_char
_xmt_char:
	set 0x10000021, %o1
	retl
	stba %o0, [%o1] 4

	.globl _rcv_char
_rcv_char:
	set 0x10000021, %o0
	retl
	lduba [%o0] 4, %o0

	.globl	_set_timer_3
_set_timer_3:
	set	0x10000078, %o1	! Address of TCR3 reload register
	retl
	stha	%o0, [%o1] 4	! Set the reg
");

void __main() { }

void
update_leds()
{
  static unsigned char *leds = (unsigned char *)0x02000003;
  static unsigned char curled = 0xfe;

  *leds = curled;
  curled = (curled >> 1) | (curled << 7);
}

 /* 1/5th of a second? */

#define LEDTIME (20000000 / 500)

int
getDebugChar()
{
  unsigned long countdown = LEDTIME;

  update_leds();

  while (1)
    {
      if ((get_uart_status(0) & 2) != 0) break;

      if (countdown-- == 0)
	{
	  countdown = LEDTIME;
	  update_leds();
	}
    }

  return rcv_char();
}

/* Output one character to the serial port */

void
putDebugChar(c)
     int c;
{
  update_leds();

  while ((get_uart_status() & 1) == 0) ;

  xmt_char(c);
}

/* Set the baud rate for the serial port, returns 0 for success,
   -1 otherwise */

int
set_baud_rate(baudrate)
     int baudrate;
{
  /* Convert baud rate to uart clock divider */
  switch (baudrate)
    {
    case 38400:
      baudrate = 24;
      break;
    case 19200:
      baudrate = 49;
      break;
    case 9600:
      baudrate = 98;
      break;
    default:
      return -1;
    }

  set_timer_3(baudrate);	/* Set it */
}
