/*
 *	FMI, Fujitsu Microelectronics, Inc.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
 */
/****************************************************************************/
/* THIS INFORMATION IS PROPRIETARY TO                                       */
/* MICROTEC RESEARCH, INC.                                                  */
/*--------------------------------------------------------------------------*/
/* Copyright (c) 1987, 1988, 1989, 1990  Microtec Research, Inc.	    */
/* All rights reserved                                                      */
/****************************************************************************/

/*      @(#)csyssparc.c	1.12 5/3/91	*/

/* This library assumes that the following UNIX style system routines exist:

char *sbrk (size) int size;
    This should increment the heap pointer by size bytes
    and return the old heap pointer.  If there is not enough space on the
    heap, it should return -1.

int open(filename,mode) char *filename; int mode;
    Opens the specified file, depending on the indicated mode,  the modes are
    0   => open for reading
    1   => open for writing
    2   => open for reading & writing (not used)
    1|_IO_EOF   => open for writing and seek to eof
    open should return a number between 0 and 19 that may be associated with
    an element in the iob array.  On failure it should return -1.

nt creat(filename,prot) char *filename; int prot;
    Creates and opens (for writing) a file named filename with protection
    as specified by prot.  For things like terminals that cannot be created
    it should just open the device.  It should return a number between 0-19
    that may be associated with an iob array element.  On failure it should
    return -1.

int read(fno,buf,nbyte) int fno, nbyte; char *buf;
    Reads at most nbyte bytes into buf from the file connected to fno (where
    fno is one of the file descriptors returned by open(). It should
    return the number of bytes read (a value of 0 is used to indicate EOF),
    or a -1 on error.

int write(fno,buf,nbyte) int fno, nbyte; char *buf;
    Writes at most nbyte bytes into the file connected to fno (where fno is
    one of the file descriptors returned by open() into buf.  It should
    return the number of bytes written, or a -1 to indicate an error.

int close(fno) int fno;
    Closes the file associated with the file descriptors fno (returned by
    open()).  Should return 0 if all goes well or -1 on error.

void exit (val) int val;
    Calls _atexit_functs which executes function calls indicated by 
    previous atexit function calls.  Closes all open files and then
    calls _exit using "val" as the argument.  Does not return.

void _exit(code) int code;
    Exits from the program, with a status code specified by code.
    Should not return.
    NOTE:  Code for _exit previously was located in this module.  _exit has
	   been relocated to "entry.s".

void abort(void);
    Causes an abnormal termination.  While "abort" normally executes a
    "raise (SIGABRT)" to accomplish this, this implementation simply calls
    "exit ()".  The "C" library routines never actually call "abort",
    however the "C++" class libraries do.

long lseek(fno, offset, whence);
    Positions a file associated with the file descriptor fno to an arbitrary
    byte position specified by offset and returns the new position as a long.
    If whence is 0, the new position is relative to the beginning of the
    file.  If whence is 1, the new positon is relative to the current
    position.  If whence is 2, the new position is relative to the end
    of the file.

long int ftell (FILE *stream);
    Obtains the current value of the file position indicator for the stream
    pointed to by stream.  If successful, the ftell function returns the
    current value of the file position indicator for the stream.  On 
    failure, the ftell function returns -1L and stores an appropriate
    positive value in errno.

These routines should use the variable errno to explain what went wrong when
problems occur (the various error codes are defined in errno.h).

The following is a very trivial version of these calls (except sbrk()) that
assumes the following: 

  1. there is one input device of interest, and characters can be read
        from it by calling _INCHRW() which returns an integer of value 0..255
        or -1 for error.
  2. there is one output device of interest, and characters can be written
        to it by calling _OUTCHR (ch).  Its return will be ignored.
  3. there is a way of entering the program, setting up the heap and stack
        pointers, and then it will call START() which in turn calls the
        user's main() function.

The user still has to provide 4 routines (written in assembly language):
(1) initialization routine, (2) sbrk(), (3) _INCHRW(), and (4) _OUTCHR().

*/

#include <stdio.h>
#include <mriext.h>
#include <errno.h>
#include <time.h>

#define	SPARClite_eval

#define eoln 2

			/*   eoln is used to indicate the end of line characters
                            for the host system.
                        eoln =  0   carriage return (13) as end of line, ex :
                                    Microtec 68000 simulator
                             =  1   carriage return (13) followed by line feed 
                                    (10) as end of line, ex : MSDOS, debugger
                             =  2   line feed (10) as end of line, ex : UNIX
                       */
                                   

/************************************************************************/
/*	Note:	The following variables, _simulated_input and		*/
/*		_simulated_output, are used by inchrw.c and outchr.c	*/
/*		to allow reading and writing of data through the	*/
/*		debugger.  They should be removed when inchrw.c and	*/
/*		outchr.c are rewritten for a particular application.	*/	
/*									*/
/*		The variables are initialized to place them in the	*/
/*		initialized data section.  The #pragma is then used to	*/
/*		place the variables in a unique section called		*/
/*		"ioports".						*/
/************************************************************************/
#pragma	options	-NIioports

volatile int _simulated_input = 0;	/* used by simulator */
volatile int _simulated_output= 0;	/* used by simulator */	

/************************************************************************/
/*	Note:	The routine build_argv () is used to build the argv	*/
/*		array and compute the value of argc.  If these are 	*/
/*		needed, simple define the macro BUILD_ARGV.  If they	*/
/*		not needed, do not define the macro BUILD_ARGV.  Memory	*/
/*		can be saved if the macro is not defined.		*/
/************************************************************************/

#ifdef	BUILD_ARGV

char _com_line [512];		/* the command line */
#define MAX_ARGC 32
static void build_argv (void);	/* computes argc and builds argv array */

#else	/* ! BUILD_ARGV */

#define MAX_ARGC 1

#endif	/* ! BUILD_ARGV */

#define	_ATEXIT_MAX	32
void	(*_atexit_stack[_ATEXIT_MAX]) (void);	/* atexit function stack */
short	_atexit_top;				/* index used by atexit */

char * * _environ;		/* the environment vector */
static unsigned argc;		/* the argument count */
static char * argv [MAX_ARGC];	/* the argument vector */


FILE _iob[FOPEN_MAX];	/* i/o control blocks */
int  errno;		/* errno is defined here */
int  _lastp;		/* variable to be used in 'strtok' */
long _randx;		/* variable to be used in 'rand' */
char _ctbuf[26];	/* array used by ctime to return time date string */
struct tm _xtm;		/* return structure used by time functions */

#define HEADER struct mem

HEADER {
	HEADER    *next;
	unsigned  size;
	};

HEADER  _membase;
HEADER *_avail;
char    _badlist;

/* This is a sample of the _START() rotuine which is called by the user's
   initialization routine to start a C program.  It opens stdin, stdout and
   stderr to the console.  Then it calls the user's main() function.

   Before entering _START(), the execution environment should already be
   set up, including the heap and the stack.
*/

void _START (void)
{

    _randx = 1;				/* initialize for 'rand' */

    _membase.next = &_membase;		/* initialize for malloc */
    _avail = &_membase;

            /* OPEN THE STANDARD FILES */
    stdin->_file = 0;
    stdin->_flag = _IOREAD | _IONBF;
    stdout->_file = 1;
    stdout->_flag = _IOWRT | _IONBF;
    stderr->_file = 2;
    stderr->_flag = _IOWRT | _IONBF;
    stdaux->_file = 3;
    stdaux->_flag = _IOWRT | _IOREAD |_IONBF;
    stdprn->_file = 4;
    stdprn->_flag = _IOWRT | _IONBF;

#ifdef BUILD_ARGV
    build_argv ();
#endif
#ifndef	SPARClite_eval
    exit (main (argc, argv, _environ));
#else
  main();
#endif

}

#ifdef BUILD_ARGV

static void build_argv (void)	/* Constructs the argv array from the */
{				/* command line (_com_line). */
    char * line = _com_line;

    for (argc = 0; argc < MAX_ARGC; ) {
	/* strip white space */
	while (*line == ' ' || (*line >= '\t' && *line <= '\r')) line++;
	if (*line == '\0') break ;

	/* point to next token */
	argv [argc++] = line ;

	/* skip over and terminate this token */
	while (    *line != '\0'
		&& *line != ' '
		&& !(*line >= '\t' && *line <= '\r')
	      ) line++ ;
	if (*line == '\0') break ;
	*line++ = '\0' ;
    }
}

#endif		/* BUILD_ARGV */

static find_free()      /* returns the number of a free _iob structure */
{
    register int i;

    for (i=0; i < FOPEN_MAX; i++) {
        if (!(_iob[i]._flag&(_IOREAD|_IOWRT)))
            return (i);
    }
    errno = EMFILE;
    return (-1);
}

open (ignore, mode)
char *ignore;
int mode;
{
    register int fno;

    if ((fno=find_free())== -1)
        return (-1);
    mode &= 3;
    _iob[fno]._file = fno;
    if (mode != 1)
        _iob[fno]._flag = _IOREAD;
    if (mode != 0)
        _iob[fno]._flag |= _IOWRT;
    return (fno);
}

creat (ignore, prot)
char *ignore;
int prot;
{
    return (open (ignore, 1));
}

close (fno)
int fno;
{
    if (!(_iob[fno]._flag&(_IOREAD|_IOWRT))) {
        errno = EBADF;
        return (-1);
    }
    _iob[fno]._flag = 0;
    return (0);
}

read (fno,buf,size)
int fno;
register char *buf;
register int size;
{
    register int cnt= 0, ch;

    if (!(_iob[fno]._flag&_IOREAD)) {
        errno = EBADF;
        return (-1);
    }
    while (--size >= 0) {
        if ((ch = _INCHRW()) == -1) {    /* read in one char */
            errno = EIO;
            return (-1);
        }
/* Add this for file I/O, skip '\r'
        if (eoln == 1 && ch == '\r') continue;  
*/
        if (eoln == 0 && ch == '\r') ch = '\n'; /* replace '\r' by '\n' */
        *(buf++) = ch;
        cnt++;
        if (ch == '\r' || ch == '\n')   /* CR or LF terminates the read */
            break;
    }
    return (cnt);
}

write (fno,buf,size)
int fno;
register char *buf;
register int size;
{
    register int cnt= 0;

    if (!(_iob[fno]._flag&_IOWRT)) {
        errno = EBADF;
        return (-1);
    }
    while (--size >= 0) {
        if (eoln == 0 && *buf == '\n') *buf = '\r';  /* replace by '\r' */
        if (eoln == 1 && *buf == '\n') _OUTCHR('\r');/* output a '\r' first */
        _OUTCHR (*(buf++));              /* output one char */
        cnt++;
    }
    return (cnt);
}

exit (val)
int val;
{
    register int i;

#ifndef	SPARClite_eval
    _atexit_functs ();		/* execute functions saved by atexit        */
				/* may be removed if atexit is never called */

    _cxxfini ();		/* execute static destructors for c++ */
				/* may be removed if c++ is not being used */

    for (i=0; i < FOPEN_MAX; i++) {		/* may be removed if no */
        if (_iob[i]._flag & (_IOREAD|_IOWRT)) {	/* files are openned    */
            if (_iob[i]._flag & _IOMYBUF)
                fclose (&_iob[i]);
            else
                close (i);
        }
    }    
#endif

    _exit(val);			/* cannot be removed */
}

void abort (void)
{
    exit (1);			/* cause unsuccessful termination */
}

long lseek (int d, long offset, int whence)
{
    return 0;			/* stub */
}

long int ftell (FILE *stream)
{
/************************************************************************/
/* On failure, the ftell function should return -1L and store an	*/
/* appropriate positive value in errno.					*/
/************************************************************************/

    return 0;			/* stub */
}
