
!
! FILE
!      cntlsps.s
!
!      Copyright(c) 1993, FMI, Fujitsu Microelectronics, Inc.
!      All rights reserved.
!      All usages must have written consent from FMI.
!      THIS SOFTWARE IS UNTESTED AND HAS BEEN GIVEN TO YOU GRATUITOUSLY.
!      ACCORDINGLY, IT IS PROVIDED "AS IS" WITH NO WARRANTIES EXPRESS OR
!      IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
!      FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  YOU BEAR 
!      ALL RISK OF NON-PERFORMANCE, LOSS OF DATA AND OTHER PROBLEMS AND 
!      FUJITSU WILL NOT BE LIABLE UNDER ANY CONTRACT, NEGLIGENCE, STRICT 
!      LIABILITY OR OTHER THEORY FOR ANY DAMAGES INCLUDING, WITHOUT 
!      LIMITATION, DIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES OR COST 
!      OF PROCUREMENT OF SUBSTITUTE GOODS, SERVICES OR TECHNOLOGY.
!
! DESCRIPTION
!       This file contains the functions used to manipulate the control
!       registers and the alternate memory spaces of the SPARClite chip on the
!	SPARClite Evaluation Board.
!
! HISTORY
!	October 16	Roland Chu
!       April 1993      Clark Li
! 


	.include	"utilsl.h"
! NOTE
!	This code has been updated to resolve the disparity in ASI and byte
!	alignment between the 930 and 931 SPARClite chips.
!	Macros from utilsl.h have been added to provide alignment compatibility
!	with applications using the functional interface provided by
!	cntlsp.c and direct calls to routines in this module.
!	If cntlsp.o is not being linked and 930-style byte alignment is 
!	not required, uncomment the following define:
!
!	.def	NO_ALIGN
!
	.ifdef	NO_ALIGN
	.macro	ALIGN_2LO_STA,reg
	.endm
	.macro	ALIGN_2HI_LDA,reg
	.endm
	.endif

        .macro  CC1_STA_HI_XX,op,src,dest
        ALIGN_2LO_STA src
        op     src, dest CC1_ASI
        .endm
        .macro  CC1_LDA_HI_XX,op,src,dest
        op     src CC1_ASI, dest
        ALIGN_2HI_LDA dest
        .endm

	.text
	.global	_tbrput
	.global	_psrput
	.global	_psrget
	.global	_tbrget
	.global	_ASI4get
	.global	_ASI4put
	.global	_ASI4bget
	.global	_ASI4bput
	.global	_ASI4hget
	.global	_ASI4hput
	.global	_CC1get
	.global	_CC1put
	.global	_CC1bget
	.global	_CC1bput
	.global	_CC1hget
	.global	_CC1hput

!
! FUNCTION
!	_tbrput
!
! DESCRIPTION
!
! INPUTS
!	- %o0=tbr value
!
! RETURNS
!	- None
!
_tbrput:
	wr	%g0, %o0, %tbr
	jmpl	%o7+8, %g0
	nop
!
! FUNCTION
!	_psrput
!
! DESCRIPTION
!
! INPUTS
!	- %o0=psr value
!
! RETURNS
!	- None
!
_psrput:
	wr	%g0, %o0, %psr
	jmpl	%o7+8, %g0
	nop
!
! FUNCTION
!	_psrget
!
! DESCRIPTION
!
! INPUTS
!	- None
!
! RETURNS
!	- %o0=psr value
!
_psrget:
	rd	%psr, %o0
	jmpl	%o7+8, %g0
	nop
!
! FUNCTION
!	_tbrget
!
! DESCRIPTION
!
! INPUTS
!	- None
!
! RETURNS
!	- %o0=psr value
!
_tbrget:
	rd	%tbr, %o0
	jmpl	%o7+8, %g0
	nop
!
! FUNCTION
!	_ASI4hput:
!
! DESCRIPTION
!	This function writes a half word into the location specified by the
!	caller in ASI 4.
!
! INPUTS
!	- %o0=data
!	- %o1=address
!
! RETURNS
!	- None
!
_ASI4hput:
	stuha	%o0, [%o1] 4
	jmpl	%o7+8, %g0
	nop
!
! FUNCTION
!	_ASI4hget
!
! DESCRIPTION
!	This function returns the half word in the location specified by the
!	caller in ASI 4.
!
! INPUTS
!	- %o0=address
!
! RETURNS
!	- Contents of [address] 4
!
_ASI4hget:
	lduha	[%o0] 4, %o0
	jmpl	%o7+8, %g0
	nop

!
! FUNCTION
!	_ASI4bput:
!
! DESCRIPTION
!	This function writes a byte into the location specified by the
!	caller in ASI 4.
!
! INPUTS
!	- %o0=data
!	- %o1=address
!
! RETURNS
!	- None
!
_ASI4bput:
	stuba	%o0, [%o1] 4
	jmpl	%o7+8, %g0
	nop
!
! FUNCTION
!	_ASI4bget
!
! DESCRIPTION
!	This function returns the byte in the location specified by the
!	caller in ASI 4.
!
! INPUTS
!	- %o0=address
!
! RETURNS
!	- Contents of [address] 4
!
_ASI4bget:
	lduba	[%o0] 4, %o0
	jmpl	%o7+8, %g0
	nop

!
! FUNCTION
!	_ASI4put:
!
! DESCRIPTION
!	This function writes a 32 bit word into the location specified by the
!	caller in ASI 4.
!
! INPUTS
!	- %o0=data
!	- %o1=address
!
! RETURNS
!	- None
!
_ASI4put:
	sta	%o0, [%o1] 4
	jmpl	%o7+8, %g0
	nop
!
! FUNCTION
!	_ASI4get
!
! DESCRIPTION
!	This function returns the 32 bit word in the location specified by the
!	caller in ASI 4.
!
! INPUTS
!	- %o0=address
!
! RETURNS
!	- Contents of [address] 4
!
_ASI4get:
	lda	[%o0] 4, %o0
	jmpl	%o7+8, %g0
	nop

!
! FUNCTION
!	_CC1hput:
!
! DESCRIPTION
!	This function writes a half word into the location specified by the
!	caller in CC1_ASI.
!
! INPUTS
!	- %o0=data
!	- %o1=address
!
! RETURNS
!	- None
!
_CC1hput:
        CC1_STA_HI_XX	stuha,%o0,[%o1]
	jmpl	%o7+8, %g0
	nop
!
! FUNCTION
!	_CC1hget
!
! DESCRIPTION
!	This function returns the half word in the location specified by the
!	caller in CC1_ASI.
!
! INPUTS
!	- %o0=address
!
! RETURNS
!	- Contents of [address] CC1_ASI
!
_CC1hget:
        CC1_LDA_HI_XX	lduha,[%o0],%o0
	jmpl	%o7+8, %g0
	nop

!
! FUNCTION
!	_CC1bput:
!
! DESCRIPTION
!	This function writes a byte into the location specified by the
!	caller in CC1_ASI
!
! INPUTS
!	- %o0=data
!	- %o1=address
!
! RETURNS
!	- None
!
_CC1bput:
        CC1_STA_HI_XX	stuba,%o0,[%o1]
	jmpl	%o7+8, %g0
	nop
!
! FUNCTION
!	_CC1bget
!
! DESCRIPTION
!	This function returns the byte in the location specified by the
!	caller in CC1_ASI.
!
! INPUTS
!	- %o0=address
!
! RETURNS
!	- Contents of [address] CC1_ASI
!
_CC1bget:
        CC1_LDA_HI_XX	lduba,[%o0],%o0
	jmpl	%o7+8, %g0
	nop

!
! FUNCTION
!	_CC1put:
!
! DESCRIPTION
!	This function writes a 32 bit word into the location specified by the
!	caller in CC1_ASI.
!
! INPUTS
!	- %o0=data
!	- %o1=address
!
! RETURNS
!	- None
!
_CC1put:
        CC1_STA_HI	%o0,[%o1]
	jmpl	%o7+8, %g0
	nop
!
! FUNCTION
!	_CC1get
!
! DESCRIPTION
!	This function returns the 32 bit word in the location specified by the
!	caller in CC1_ASI.
!
! INPUTS
!	- %o0=address
!
! RETURNS
!	- Contents of [address] CC1_ASI
!
_CC1get:
        CC1_LDA_HI	[%o0],%o0
	jmpl	%o7+8, %g0
	nop


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                       << 93X Cache Routines>>
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! Ver 1.0 on Jun/01/95  by Akira  Typos are fixed. Generic version.
! Ver 1.1 on Jun/05/95  by Akira  933H : 0x35 -> 0x31 at 0x00000000 (ASI=1)
! Ver 1.2 on Jun/14/95  by Akira  Cache gets on/off when Burst Mode is off.
! Ver 1.3 on Jul/11/95  by Akira  Work around for 934 Burst Mode off problem.
!
! 93X's Cache functions and configurations vary as follows;
!                                   
!               I cache  D cache  clear    prefetch/ burst
!        93X     size     size    flags    w buffer  mode
!     --------  -------  -------  -------  -------  -------
!        930       2K       2K       No      Yes       No
!        931       2K       2K       No      Yes       No
!        932       8K       2K      Yes      Yes      Yes
!        933       No       No       No       No       No
!        933H      1K       No       No      Yes       No
!        934       8K       2K      Yes      Yes      Yes
!        935       4K       2K      Yes      Yes      Yes
!        936       4K       2K      Yes      Yes      Yes
!
! There are four options.
!
! Option 1 : CACHE_ZERO    : 933       : No cache. (*1)
! Option 2 : CACHE_1K      : 933H      : 1K I cache with no clear, no burst.
! Option 3 : CACHE_2K_2K   : 930/1     : 2K I&D cache with no clear, no burst.
! Option 4 : CACHE_CLR_BST : 932/4/5/6 : I&D cache with clear, and burst.
!
!     (*1) Although 933 has no Cache, application program may call
!          cache_on/off routine. The best action to that call is
!          do nothing, instead of doing and ignored by 933.
!
!=========================================================================
!   << The 934 Burst Mode off problem >>   {934 A/A1/A2/B steps only.}
!=========================================================================
!  If the Burst mode is turned off during the Burst period, IU may get
!  garbage. Its work around is to force the address of "sta" instruction
!  to ...0 or ...8 by using ".align 8", so that the Burst mode is turned
!  off at ...C or ...4; not in the Burst period which address is ...0.
!=========================================================================
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!=========================================================================
! Grouping for Options
!=========================================================================

!-------------------------------------------------------------------------
.ifdef  CHIP_VER_930
.def    CACHE_2K_2K, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_931
.def    CACHE_2K_2K, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_932
.def    CACHE_CLR_BST, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_933
.def    CACHE_ZERO, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_933H
.def    CACHE_1K, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_934
.def    CACHE_CLR_BST, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_935
.def    CACHE_CLR_BST, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_936
.def    CACHE_CLR_BST, 1
.endif
!-------------------------------------------------------------------------

!=========================================================================
! cache_on() : flush cache, then turn cache on.         <<Leaf Function>>
!=========================================================================
	.global	_cache_on

!-------------------------------------------------------------------------
.ifdef CACHE_ZERO                       ! Do nothing.
_cache_on:
	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_1K
_cache_on:
	sta	%g0, [%g0] 0x1          ! Turn I Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	set	0x80000000, %o0         ! Flush I Cache.
	set	64, %o1                 !  > 64 lines in a bank.
?1:
	sta	%g0, [%o0] 0xc          !  > I Cache - Bank 2.
	subcc	%o1, 1, %o1
	bne	?1
	add	%o0, 16, %o0            !  > 16 bytes in each line.

	set 	0x31, %o0               ! Turn I Cache, P&W Buffer on.
	sta	%o0, [%g0] 0x1
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_2K_2K
_cache_on:
	sta	%g0, [%g0] 0x1          ! Turn I&D Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	set	0x00000000, %o0         ! Flush I&D Cache.
	set	0x80000000, %o1
	set	64, %o2                 !  > 64 lines in each bank.
?1:
	sta	%g0, [%o0]     0xc      !  > I Cache - Bank 1.
	sta	%g0, [%o0]     0xe      !  > D Cache - Bank 1.
	sta	%g0, [%o0+%o1] 0xc      !  > I Cache - Bank 2.
	sta	%g0, [%o0+%o1] 0xe      !  > D Cache - Bank 2.
	subcc	%o2, 1, %o2
	bne	?1
	add	%o0, 16, %o0            !  > 16 bytes in each line.

	set 	0x35, %o0               ! Turn I&D Cache, P&W Buffer on.
	sta	%o0, [%g0] 0x1
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_CLR_BST
.align	8    ! [ Work around for the 934 Burst Mode off problem. ]
_cache_on:
	nop  ! [ Work around: by .align 8, this ADDR = ...0 or ...8. ]
	set	0x00000020, %o0         ! Turn Burst Mode off.
	sta	%g0, [%o0] 0x1
	nop
	nop
	nop  ! [ Work around: Burst Mode is off at ADDR = ...4 or ...C. ]
	nop

	sta	%g0, [%g0] 0x1          ! Turn I&D Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	set	0x00001000, %o0         ! Flush I&D Cache.
	set	0x80000000, %o1
	set	0x3, %o2
	sta	%o2, [%o0]     0xc      !  > I Cache - Bank 1.
	sta	%o2, [%o0]     0xe      !  > D Cache - Bank 1.
	sta	%o2, [%o0+%o1] 0xc      !  > I Cache - Bank 2.
	sta	%o2, [%o0+%o1] 0xe      !  > D Cache - Bank 2.

	set 	0x35, %o0               ! Turn I&D Cache, P&W Buffer on.
	sta	%o0, [%g0] 0x1
	nop
	nop
	nop
	nop

	set	0x00000020, %o0         ! Turn Burst Mode on.
	set	0x3, %o1
	sta	%o1, [%o0] 0x1
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif


!=========================================================================
! cache_off() : turn cache off.                         <<Leaf Function>>
!=========================================================================
	.global	_cache_off

!-------------------------------------------------------------------------
.ifdef CACHE_ZERO                       ! Do nothing.
_cache_off:
	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_1K
_cache_off:
	sta	%g0, [%g0] 0x1          ! Turn I Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_2K_2K
_cache_off:
	sta	%g0, [%g0] 0x1          ! Turn I&D Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef CACHE_CLR_BST
.align	8    ! [ Work around for the 934 Burst Mode off problem. ]
_cache_off:
	nop  ! [ Work around: by .align 8, this ADDR = ...0 or ...8. ]
	set	0x00000020, %o0         ! Turn Burst Mode off.
	sta	%g0, [%o0] 0x1
	nop
	nop
	nop  ! [ Work around: Burst Mode is off at ADDR = ...4 or ...C. ]  
	nop

	sta	%g0, [%g0] 0x1          ! Turn I&D Cache, P&W Buffer off.
	nop
	nop
	nop   
	nop

	jmpl	%o7+8, %g0
	nop
.endif


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                        << 93X FPU Routines>>
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! Ver 1.0 on Jul/17/95  by Akira  First one.
!
! 93X's FPU functions are as follows;
!                                   
!        93X      FPU      FIFO
!      -------  -------  -------
!        930       No       No
!        931       No       No
!        932       No       No
!        933       No       No
!        933H      No       No
!        934      Yes      Yes
!        935       No       No
!        936      Yes       No
!
! There are three options.
!
! Option 1 : NO_FPU    : 930/1/2/3/3H/5 : No FPU. (*1)
! Option 2 : FPU_ONLY  : 936            : FPU; no FIFO.
! Option 3 : FPU_FIFO  : 934            : FPU and FIFO.
!
!   (*1) Although some 93x chips have no FPU, application program may call
!        FPUEN/FPUDIS routine. The best action to that call is
!        do nothing, instead of doing and ignored by the chips.
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!=========================================================================
! Grouping for Options
!=========================================================================

!-------------------------------------------------------------------------
.ifdef  CHIP_VER_930
.def    NO_FPU, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_931
.def    NO_FPU, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_932
.def    NO_FPU, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_933
.def    NO_FPU, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_933H
.def    NO_FPU, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_934
.def    FPU_FIFO, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_935
.def    NO_FPU, 1
.endif
!-------------------------------------------------------------------------
.ifdef  CHIP_VER_936
.def    FPU_ONLY, 1
.endif
!-------------------------------------------------------------------------

!=========================================================================
! FPUEN() : enable FPU.                                 <<Leaf Function>>
!=========================================================================
	.global _FPUEN

!-------------------------------------------------------------------------
.ifdef NO_FPU                           ! Do nothing.
_FPUEN:
	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef FPU_ONLY
_FPUEN:
	rd	%psr, %o0
	set	(1<<12), %o1            ! PSR[12] EF = 1
	or	%o0, %o1, %o0
	wr	%o0, %g0, %psr
	nop
	nop
	nop
	nop

	set	0x00400000,%o0
	set	?1,%o1
	st	%o0, [%o1]
	ld	[%o1], %fsr
	nop	
	nop	! FSR[31:30] RD  = 00    {Rounding Toward Nearest}
	nop	! FSR[27:23] TEM = 00000 {Disable all IEEE Traps}
	nop	! FSR[22]    NS  = 1     {Nonstandard FP Mode}

	jmpl	%o7+8, %g0
	nop

?1:	.word	0x00000000              ! Work Area

.endif

!-------------------------------------------------------------------------
.ifdef FPU_FIFO
_FPUEN:
	rd	%psr, %o0
	set	(1<<12), %o1            ! PSR[12] EF = 1
	or	%o0, %o1, %o0
	set	(1<<13), %o1            ! PSR[13] EC = 0
	andn	%o0, %o1, %o0
	wr	%o0, %g0, %psr
	nop
	nop
	nop
	nop

	set	0x00400000,%o0
	set	?1,%o1
	st	%o0, [%o1]
	ld	[%o1], %fsr
	nop	
	nop	! FSR[31:30] RD  = 00    {Rounding Toward Nearest}
	nop	! FSR[27:23] TEM = 00000 {Disable all IEEE Traps}
	nop	! FSR[22]    NS  = 1     {Nonstandard FP Mode}

	rd	%asr17, %o0
	set	(1<<3), %o1             ! ASR17[3] EFIFO = 1
	or	%o0, %o1, %o0
	wr	%o0, %g0, %asr17
	nop
	nop
	nop
	nop

	jmpl	%o7+8, %g0
	nop

?1:	.word	0x00000000              ! Work Area

.endif


!=========================================================================
! FPUDIS() : disable FPU.                               <<Leaf Function>>
!=========================================================================
	.global _FPUDIS

!-------------------------------------------------------------------------
.ifdef NO_FPU                           ! Do nothing.
_FPUDIS:
	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef FPU_ONLY
_FPUDIS:
	rd	%psr, %o0
	set	(1<<12), %o1            ! PSR[12] EF = 0
	andn	%o0, %o1, %o0
	wr	%o0, %g0, %psr
	nop
	nop
	nop
	nop

	jmpl	%o7+8, %g0
	nop
.endif

!-------------------------------------------------------------------------
.ifdef FPU_FIFO
_FPUDIS:
	rd	%psr, %o0
	set	(1<<12), %o1            ! PSR[12] EF = 0
	andn	%o0, %o1, %o0
	set	(1<<13), %o1            ! PSR[13] EC = 0
	andn	%o0, %o1, %o0
	wr	%o0, %g0, %psr
	nop
	nop
	nop
	nop

	rd	%asr17, %o0
	set	(1<<3), %o1             ! ASR17[3] EFIFO = 0
	andn	%o0, %o1, %o0
	wr	%o0, %g0, %asr17
	nop
	nop
	nop
	nop

	jmpl	%o7+8, %g0
	nop
.endif


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!




