!
!	FMI, Fujitsu Microelectronics, Inc.
!
!	This software (including any documentation) is untested, has not been
!	fully tested for viruses and has been provided to you without charge.
!	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
!	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
!	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
!	risk of nonperformance, loss of data and other problems and Fujitsu
!	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
!	contract, negligence, strict liability or other theory for any damages
!	including, without limitation, direct, consequential or incidental nor
!	be required to provide substitute goods, services or technology.
!
!*****************************************************************************
!* THIS INFORMATION IS PROPRIETARY TO                                       **
!* MICROTEC RESEARCH, INC.                                                  **
!*--------------------------------------------------------------------------**
!* Copyright (c) 1990 Microtec Research, Inc.				    **
!* All rights reserved                                                      **
!*****************************************************************************

!*	@(#)entry.s	1.12 1/30/91
!************************************************************************
!                                                                       *
!  ENTRY  : Main entry point routine, it does the following:		*
!                                                                       *
!	1.  Initializes stack and frame pointers.			*
!	2.  Initializes __heaptop as starting address of SECTION heap	*
!	    which will be after SECTION code				*
!	3.  Clears the 'zerovars' and '.bss' sections.			*
!	4.  Calls C initialization routine _START			*
!	5.  Defines a trap handler for window overflow and underflow    *
!	    but passive for other traps.				*
!									*
!************************************************************************
! 
	.def	SPARClite_eval, 0

	.sect	 code,text
	.seg 	"code"
!
	.global	__start			
	.global	__exit
	.global window_overflow
	.global window_underflow
	.extern	__START

	.ifndef	SPARClite_eval
	.extern	__stacktop
	.extern _TRAPS
	.endif

	.extern	_exit
!
	.align	8			
__start:				
!
!************************************************************************
!	Initialize the stack pointer and zeroes the frame pointer
!	Also initialize the trap table register if it is defined
!************************************************************************
!
	.ifndef	SPARClite_eval
	sethi	%hi(__stacktop),%o1
	or	%o1,%lo(__stacktop),%sp
	or	%g0,0x0,%fp
	sethi	%hi(_TRAPS),%o1
	or	%o1,%lo(_TRAPS),%o1	
	wr	%o1,%g0,%tbr
	.else
	save	%sp, -0x80, %sp
	.endif
!
!************************************************************************
!	As the EB "default" status, enable FPU; also turn Cache on here.
!	 [NOTE] If FPU (and/or Cache) doesn't exist, doing nothing on it.
!************************************************************************
!                                  {Added by Akira on Jul/17/95.}
	.extern	_FPUEN
	.extern	_cache_on

	call	_FPUEN
	nop
	call	_cache_on
	nop
!
!************************************************************************
!	Initialize __heaptop.
!	The heap will start immediately above the memory location
!	of __heaptop.
!************************************************************************
!
	sethi	%hi(__heaptop+4),%o2
	or 	%o2,%lo(__heaptop+4),%o2
	sethi	%hi(__heaptop),%o3
	or 	%o3,%lo(__heaptop),%o3
	st	%o2,[%o3]
!
!************************************************************************
!	Zero out the .bss section
!************************************************************************
!
	sethi	%hi(?sizeof(.bss)),%o4
	or	%o4,%lo(?sizeof(.bss)),%o4
	subcc	%o4,0,%g0
	be	cont1
	nop	
	sethi	%hi(?startof(.bss)),%o5
	or	%o5,%lo(?startof(.bss)),%o5
	
bssloop:					
	subcc	%o4,4,%o4
	bne	bssloop
	st	%g0,[%o5+%o4]
!
!************************************************************************
!	Zero out the zerovars section
!************************************************************************
!
cont1:					
	sethi	%hi(?sizeof(zerovars)),%o4
	or	%o4,%lo(?sizeof(zerovars)),%o4
	subcc	%o4,0,%g0
	be	cont2
	nop	
	sethi	%hi(?startof(zerovars)),%o5
	or	%o5,%lo(?startof(zerovars)),%o5
	
varsloop:					
	subcc	%o4,4,%o4
	bne	varsloop
	st	%g0,[%o5+%o4]
!
!************************************************************************
!	Branch to C startup routine
!************************************************************************
!
cont2:					
	call	__START
	nop
	call	_exit		! call exit() to clean up
	nop			! __START
!
!************************************************************************
!	Spin loop for _exit ()
!************************************************************************
!
__exit:
	.ifdef	SPARClite_eval
	jmpl	%i7+8, %g0
	restore	%g0, %g0, %g0
	.endif
	unimp	0x0		!this suppose to stop the execution
	ba	__exit		!loop if no exception caused by previous trap 
	nop

!************************************************************************
! windows - SPARC trap handlers for window overflow and underflow
!
!	Define the trap table which will halt for unimplemented inst-
!	ruction trap, automatically execute the handling routines for
!	window over/underflow traps, but jump back without warning or
!	messages for all the rest of traps.  User should provide their
!	own trap handling routines but it is recommended that handling 
!	for the window over/underflow traps should follow what are
!	defined or assumed here in order to work with Xray correctly.
!
! NOTE: These trap handlers assume that there is exactly one bit in the
! 	%wim (Window Invalid Mask) register set at any one time.  Unknown
!	results may occur if this is not true.  CWP (Current Window Pointer)
!	refers to the 5 lsb's of %psr.  It is recommended that when program
!	execution begins, CWP is set to zero and %wim is set to two.
! ****************************************************************************

NWINDOWS = 8
!	.text
!********************************************
!********************************************
!		MACROS
!********************************************
!********************************************
! pushwindow sets CWP to (CWP - n) % NWINDOWS
!********************************************
	.macro pushwindow,n,psr,cwp
!********************************************
!  n	   - number of pushes
!  psr,cwp - working regs for holding %psr and CWP
!********************************************
	rd	%psr,psr
	andcc	psr,31,cwp	!Get CWP

	.rep n
	.local lab
!	new CWP = (CWP - 1) % NWINDOWS
	bne,a	lab
	subcc	cwp,1,cwp	!get new CWP
	orcc	%g0,NWINDOWS-1,cwp
lab:
	.endr
	and	psr,-32,psr	!clear out old CWP
	or	psr,cwp,psr	!mask in new CWP
	wr	psr,%g0,%psr	!set new CWP
	nop
	nop			!wait 3 cycles for new %psr to take effect
	nop
	.endm

!********************************************
! popwindow sets CWP to (CWP + n) % NWINDOWS
!********************************************
	.macro popwindow,n,psr,cwp
!********************************************
!  n	   - number of pops
!  psr,cwp - working regs for holding %psr and CWP
!********************************************
	rd	%psr,psr
	and	psr,31,cwp	!Get CWP
	.rep n
	.local lab
	subcc	cwp,NWINDOWS-1,cwp !test for NWINDOWS-1
		! leave at zero if zero, otherwise
	bne,a	lab
	add	cwp,NWINDOWS,cwp ! effectively increment CWP
lab:
	.endr
	and	psr,-32,psr	!clear out old CWP
	or	psr,cwp,psr	!mask in new CWP
	wr	psr,%g0,%psr	!set new CWP
	nop
	nop			!wait 3 cycles for new %psr to take effect
	nop
	.endm
!
!********************************************
! xor_wim toggles window invalid mask bit for current window
!********************************************
	.macro	xor_wim,wim,cwp,tmp
!********************************************
!  wim,cwp,tmp - working regs for holding %wim, CWP and (1<<CWP)
!  NOTE: Use caution if executing RETT, SAVE or RESTORE within
!	 three words after this macro.
!********************************************
	rd	%psr,cwp
	and	cwp,31,cwp	! cwp = CWP
	rd	%wim,wim	! wim = WIM
	or	%g0,1,tmp
	sll	tmp,cwp,tmp	!get mask for current window
	wr	wim,tmp,%wim	!toggle window invalid bit
	.endm
!
!********************************************
!	TRAP HANDLERS
!********************************************
!
!*************************************************
window_overflow:	! trap handler
!*************************************************
!
!	Current windows are like this:
!
!	  -----------------------------------------
!	A | currently valid window to be next invalid window and saved
!	  -----------------------------------------
!	B | window for trap handler; currently invalid
!	  -----------------------------------------
!	C | window where trap occurred
!	  -----------------------------------------
!	  |
!	  ...
!
!	We are currently at window B.  This is also where we want to be after
!	the SAVE instruction that likely caused this trap is successfully
!	executed.  We need to save and invalidate window A.
! 	Make window B valid
	xor_wim	%g5,%g6,%g7
!	Go to window A; make it invalid and save its regs
	pushwindow	1,%g5,%g6
	xor_wim	%g5,%g6,%g7	! Make window A invalid
! Save window A to stack
	std	%l0,[%sp]	! save registers on stack
	std	%l2,[%sp+8]
	std	%l4,[%sp+16]
	std	%l6,[%sp+24]
	std	%i0,[%sp+32]
	std	%i2,[%sp+40]
	std	%i4,[%sp+48]
	std	%i6,[%sp+56]
!	Go back to window B and return.  rett will move us to window C.
!	Re-executing the SAVE will put us back at window B.
	popwindow	1,%g5,%g6
	jmpl	%l1,%g0	
	rett	%l2+0

!*************************************************
window_underflow:	! trap handler
!*************************************************
!
!	Current windows are like this:
!
!	  -----------------------------------------
!	A | window for trap handler
!	  -----------------------------------------
!	B | window where trap occurred
!	  -----------------------------------------
!	C | currently invalid window where we want to end up
!	  -----------------------------------------
!	D | currently valid window to be next invalid window
!	  -----------------------------------------
!	  |
!	  ...
!
!	We are currently at window A.  Go to window D.
	popwindow	3,%g5,%g6
! 	Make window D invalid
	xor_wim		%g5,%g6,%g7
!	Go to window C and make it valid
	pushwindow	1,%g5,%g6
	xor_wim		%g5,%g6,%g7
! 	Restore window C from stack
	
	ldd	[%sp],%l0	!restore registers from stack
	ldd	[%sp+8],%l2
	ldd	[%sp+16],%l4
	ldd	[%sp+24],%l6
	ldd	[%sp+32],%i0
	ldd	[%sp+40],%i2
	ldd	[%sp+48],%i4
	ldd	[%sp+56],%i6
!	Return to window A.  rett will move us to window B, and 
!	re-executing RESTORE will put us at window C.
	pushwindow	2,%g5,%g6
	jmpl	%l1,%g0
	rett	%l2+0
!
!************************************************************************
!	Define the heap section and __heaptop
!	1.  The heap section must be the last section in memory
!	2.  __heaptop does not actually have to be initialized to zero.
!	    It is set to its correct value at run-time.
!************************************************************************
!
	.sect	heap,data
	.seg	"heap"
	.align	8
	.global	__heaptop
__heaptop:
	.zero	4
	.end


