
CHIP		= 933H
MHZ             = 20

CC		= mccsp
AS		= asmsp
LD		= lnksp
CCFLAGS		= -Oghri -plite -DCHIP_VER_$(CHIP) -DMASTER_CK_$(MHZ) -c
ASFLAGS		= -DCHIP_VER_$(CHIP) -DMASTER_CK_$(MHZ) 
LDFLAGS  	= -c dram.cmd 

# You may need to change this path
MRI_LIB  	= \mri\mccsp\cslcs.lib

TARGET		= ex

OBJECTS		= entry.obj example.obj csyssp.obj cntlsps.obj cntlsp.obj utilsl.obj

.s.obj:	
	$(AS) $(ASFLAGS) -o $*.obj $*.s

.c.obj:	
	$(CC) $(CCFLAGS) $*.c

$(TARGET):	$(OBJECTS) 
	$(LD) $(LDFLAGS) -o $(TARGET)$(CHIP).cof $(OBJECTS) $(MRI_LIB)
	coffsp2s ex$(CHIP).cof ex$(CHIP).sr
	del *.obj

entry.obj:	entry.s
	$(AS) $(ASFLAGS) entry.s
example.obj:	example.c
	$(CC) $(CCFLAGS) example.c
csysp.obj:	csysp.c
	$(CC) $(CCFLAGS) csysp.c
cntlsps.obj:	cntlsps.s utilsl.h
	$(AS) $(ASFLAGS) cntlsps.s
cntlsp.obj:	cntlsp.c cntlsp.h
	$(CC) $(CCFLAGS) cntlsp.c
utilsl.obj:	utilsl.s utilsl.h
	$(AS) $(ASFLAGS) utilsl.s
