!
! FILE
!	utilsl.h	
!
!	Copyright(c) 1993, FMI, Fujitsu Microelectronics, Inc.
!	All rights reserved.
!
!	This software (including any documentation) is untested, has not been
!	fully tested for viruses and has been provided to you without charge.
!	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
!	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
!	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
!	risk of nonperformance, loss of data and other problems and Fujitsu
!	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
!	contract, negligence, strict liability or other theory for any damages
!	including, without limitation, direct, consequential or incidental nor
!	be required to provide substitute goods, services or technology.
!
! The ASI for the 940 companion chip registers
! varies between the 930/932/933/933H/936
!
! (separate companion chip) and 931 (940 functions folded in).
!
! Additionally, the byte alignment is different between the above-mentioned
! SPARClite chips.
!
! The following macros have been provided to abstract accesses to the 940
! address space as well as data alignment.
!
! The defines, CHIP_VER_93(0,1,2,3,3H or 6), provide compile-time switch, and ifdefs
! relevent to version-specific anomalies are confined to this header file.
!
! For backward compatibility to code written for the 930, these macros have
! been designed from the 930 point of view with respect to the need to
! re-align data for a given operation. In other words, before being aligned
! for a write or after being aligned following a read, the contents 
! of the register in question will duplicate the original 930 implementation.
!
! This allows all defines created originally for the 930 (hence pertinent
! bits residing in the high half-word) to be usable with the 931 without
! redefinition.
!
	.ifdef	CHIP_VER_931
	.def	CC1_ASI, 1
	.def	CC1_BASE_ADDR, 0x200
!
! Align data from high to low half-word prior to a write.
!
	.macro	ALIGN_2LO_STA,reg
	srl	reg, 0x10, reg
	.endm
!
! Align data from high to low half-word following a read.
! Data is already in low half-word following read on 931, hence null macro.
!
	.macro	ALIGN_2LO_LDA,reg
	.endm
!
! Align data from low to high half-word prior to a write.
! Data must be written from low half-word on 931, hence null macro.
!
	.macro	ALIGN_2HI_STA,reg
	.endm
!
! Align data from low to high half-word following a read.
!
	.macro	ALIGN_2HI_LDA,reg
	sll	reg, 0x10, reg
	.endm

	.else
! 
! chip version is 930, 932, 933, and 936 the following are common to both...
!
	.def	CC1_ASI, 4
	.def	CC1_BASE_ADDR, 0x10000000
!
! Align data from high to low half-word prior to a write.
! Data must be written from high half-word on 930, hence null macro.
!
	.macro	ALIGN_2LO_STA,reg
	.endm
!
! Align data from high to low half-word following a read.
!
	.macro	ALIGN_2LO_LDA,reg
	srl	reg, 0x10, reg
	.endm
!
! Align data from low to high half-word prior to a write.
!
	.macro	ALIGN_2HI_STA,reg
	sll	reg, 0x10, reg
	.endm
!
! Align data from low to high half-word following a read.
! Data is already in high half-word following read on 930, hence null macro.
!
	.macro	ALIGN_2HI_LDA,reg
	.endm
	.endif


	.def	SL_DCACHE_LINE, 64	! number of dcache lines
	.def	SL_DCACHE_BYTENUM,16	! number of bytes in a dcache line
!
! Different configuration parameters by chips
!
.ifdef CHIP_VER_930
	.def	PSR_RESET, 	0xfa7	! Set psr: trap enabled, S=1, PS=0,
					!  cwp=7, int mask=15
	.def	NWINDOWS, 	8	! number of register windows
        .def    WS_SRAM,	0x4	! SRAM wait 2 cycles without override
        .def    WS_CC1,		0x0	! 0 wait state for companion chip
	.def	SL_CACHE, 	0x1	! has cache
	.def	SL_ICACHE_LINE, 64	! number of icache lines
	.def	SL_ICACHE_BYTENUM,16	! number of bytes in an icache line
        .def    DRAM_START, 0x40000000
        .def    DRAM_HI_START, 0x40400000 ! hi dram starts with 4MB
        .def    DRAM_END, 0x41000000      ! maximum 16MB
.endif
.ifdef CHIP_VER_931
	.def	PSR_RESET, 	0xfa7	! Set psr: trap enabled, S=1, PS=0,
					!  cwp=7, int mask=15
	.def	NWINDOWS, 	8	! number of register windows
        .def    WS_SRAM,	0x4	! SRAM wait 2 cycles without override
        .def    WS_CC1,		0x0	! 0 wait state for companion chip
	.def	SL_CACHE, 	0x1	! has cache
	.def	SL_ICACHE_LINE, 64	! number of icache lines
	.def	SL_ICACHE_BYTENUM,16	! number of bytes in an icache line
        .def    DRAM_START, 0x40000000
        .def    DRAM_HI_START, 0x40400000 ! hi dram starts with 4MB
        .def    DRAM_END, 0x41000000      ! maximum 16MB
.endif
.ifdef CHIP_VER_932
	.def	CHIP_VER_932_OR_936,	1
	.def	PSR_RESET, 	0xfa7	! Set psr: trap enabled, S=1, PS=0,
					!  cwp=7, int mask=15
	.def	NWINDOWS, 	8	! number register windows
        .def    WS_SRAM,	0x10D	! SRAM wait 2 cycles with override
        .def    WS_CC1,		0x214	! 3 wait state for companion chip
	.def	SL_CACHE, 	0x1	! has cache 
	.def	SL_ICACHE_LINE, 128	! number of icache lines
	.def	SL_ICACHE_BYTENUM,32	! number of bytes in an icache line
        .def    DRAM_START, 0x40000000
        .def    DRAM_HI_START, 0x40800000 ! only 8MB dram
        .def    DRAM_END, 0x40800000	  ! only 8MB dram
.endif
.ifdef CHIP_VER_933
	.def	CHIP_VER_933_OR_936,	1
	.def	PSR_RESET, 	0xfa5	! Set psr: trap enabled, S=1, PS=0,
					!  cwp=5, int mask=15
	.def	NWINDOWS, 	6	! number of register windows
        .def    WS_SRAM,	0x5	! SRAM wait 2 cycles with override
        .def    WS_CC1,		0x0	! 0 wait state for companion chip
	.def	SL_CACHE, 	0x0	! has no cache
        .def    DRAM_START, 0x40000000
        .def    DRAM_HI_START, 0x40400000 ! hi dram starts with 4MB
        .def    DRAM_END, 0x41000000      ! maximum 16MB
.endif
.ifdef CHIP_VER_933H
	.def	CHIP_VER_933_OR_936,	1
	.def	PSR_RESET, 	0xfa5	! Set psr: trap enabled, S=1, PS=0,
					!  cwp=5, int mask=15
	.def	NWINDOWS, 	6	! number of register windows
        .def    WS_SRAM,	0x5	! SRAM wait 2 cycles with override
        .def    WS_CC1,		0x0	! 0 wait state for companion chip
	.def	SL_CACHE, 	0x1	! has cache 
	.def	SL_ICACHE_LINE, 64	! number of icache lines
	.def	SL_ICACHE_BYTENUM,16	! number of bytes in an icache line
        .def    DRAM_START, 0x40000000
        .def    DRAM_HI_START, 0x40100000 ! hi dram starts with 1MB
        .def    DRAM_END, 0x40800000      ! maximum 8MB
	.def	ALT_CLOCK,	 1	! alternate serial clock
.endif
.ifdef CHIP_VER_934
	.def	CHIP_VER_932_OR_936,	1
	.def	CHIP_VER_933_OR_936,	1
	.def	CHIP_VER_934_OR_936,	1
	.def	ALT_CLOCK,		1 !alternate serial clock
	.def	PSR_RESET, 	0xfa7	! Set psr: trap enabled, S=1, PS=0,
					!  cwp=7, int mask=15
	.def	NWINDOWS, 	8	! number register windows
        .def    WS_SRAM,	0x10D	! SRAM wait 2 cycles with override
        .def    WS_FLASHRAM,	0x634	! 8 cycle flashram wait state
        .def    WS_CC1,		0x214	! 3 wait state for companion chip
	.def	SL_CACHE, 	0x1	! has cache 
	.def	SL_ICACHE_LINE, 128	! number of icache lines
	.def	SL_ICACHE_BYTENUM,32	! number of bytes in an icache line
        .def    DRAM_START, 0x40000000
        .def    DRAM_HI_START, 0x40400000 ! 4MB dram
        .def    DRAM_END, 0x40800000	  ! 8MB dram
        .def    SDRAM_START, 0x50000000
        .def    SDRAM_HI_START, 0x50400000 ! 4MB sdram
        .def    SDRAM_END, 0x50800000	  ! 8MB  dram
        .def    FLASHRAM_START, 0x3000000
.endif
.ifdef CHIP_VER_936
	.def	CHIP_VER_932_OR_936,	1
	.def	CHIP_VER_933_OR_936,	1
	.def	CHIP_VER_934_OR_936,	1
	.def	ALT_CLOCK,		1 !alternate serial clock
	.def	PSR_RESET, 	0xfa7	! Set psr: trap enabled, S=1, PS=0,
					!  cwp=7, int mask=15
	.def	NWINDOWS, 	8	! number register windows
        .def    WS_SRAM,	0x10D	! SRAM wait 2 cycles with override
        .def    WS_FLASHRAM,	0x634	! 8 cycle flashram wait state
        .def    WS_CC1,		0x214	! 3 wait state for companion chip
	.def	SL_CACHE, 	0x1	! has cache 
	.def	SL_ICACHE_LINE, 64	! number of icache lines
	.def	SL_ICACHE_BYTENUM,32	! number of bytes in an icache line
        .def    DRAM_START, 0x40000000
        .def    DRAM_HI_START, 0x40400000 ! 4MB dram
        .def    DRAM_END, 0x41000000	  ! 16MB dram
        .def    FLASHRAM_START, 0x3000000
.endif

!
! Different time parameters 
!
.ifdef	MASTER_CK_60			! 936 only
	.def CLK_DOUBLED,	1	! 60MHz same as 30MHz except for memory
	.def MASTER_CK_30,	1
.endif
.ifdef	MASTER_CK_50			! 936 only
	.def CLK_DOUBLED,	1	! 50MHz same as 25MHz except for memory
	.def MASTER_CK_25,	1
.endif
.ifdef  MASTER_CK_14
        .def	ERRLOOP_CNT, 0x1c000	! loopcount between flashing led's
        .def	REFRESH_PRELOAD, 210	! DRAM refresh timer cycles
        .def	TMR1_PRESCALE, 0x1af0000 
        .def	TMR3_RELOAD, 0x2d0000 
        .def    WS_EPROM, 0x214		! 4 cycle eprom access (3 wait states) 
.endif
.ifdef  MASTER_CK_20
        .def	ERRLOOP_CNT, 0x28000	! loopcount between flashing led's
        .def	REFRESH_PRELOAD, 300	! DRAM refresh timer cycles
        .def	TMR1_PRESCALE, 0x1fa0000
        .def	TMR3_RELOAD, 0x400000
        .def    WS_EPROM, 0x31c		! 5 cycle eprom access (4 wait states)
					! pre V1.5 was 8
.endif
.ifdef  MASTER_CK_25
        .def	ERRLOOP_CNT, 0x28000	! loopcount between flashing led's
        .def	REFRESH_PRELOAD, 375	! DRAM refresh timer cycles
        .def	TMR1_PRESCALE, 0x29c0000	
	.def	TMR3_RELOAD, 0x500000
        .def    WS_EPROM, 0x424		! 6 cycle eprom access (5 wait states)
.endif
.ifdef  MASTER_CK_30
        .def	ERRLOOP_CNT, 0x50000	! loopcount between flashing led's
        .def	REFRESH_PRELOAD, 450	! DRAM refresh timer cycles
        .def	TMR1_PRESCALE, 0x2bc0000
        .def	TMR3_RELOAD, 0x610000
        .def    WS_EPROM, 0x52c		! 7 cycle eprom access (6 wait states)
.endif
.ifdef  MASTER_CK_40
        .def	ERRLOOP_CNT, 0x50000	! loopcount between flashing led's
        .def	REFRESH_PRELOAD, 600	! DRAM refresh timer cycles
        .def	TMR1_PRESCALE, 0x2fa0000
        .def	TMR3_RELOAD, 0x810000 
        .def    WS_EPROM, 0x634		! 8 cycle eprom access (7 wait states) 
.endif

!
! The following macros are provided as a generalized programmatic interface
! to the SPARClite CC1 registers.
!
! USER BEWARE:
!
! ALIGN_{2LO/2HI}_STA will sometimes leave the contents of src reg shifted
! up or down by 16 bits depending on the processor being compiled for.
!

!
! Store value in high half word of src reg to dest CC1 reg.
!
	.macro	CC1_STA_HI,src,dest
	ALIGN_2LO_STA src
	sta	src, dest CC1_ASI
	.endm
	
!
! Store value in low half word of src reg to dest CC1 reg.
!
	.macro	CC1_STA_LO,src,dest
	ALIGN_2HI_STA src
	sta	src, dest CC1_ASI
	.endm
	
!
! Store value loaded from CC1 src reg to high half word of dest reg.
!
	.macro	CC1_LDA_HI,src,dest
	lda	src CC1_ASI, dest
	ALIGN_2HI_LDA dest
	.endm
	
!
! Store value loaded from CC1 src reg to low half word of dest reg.
!
	.macro	CC1_LDA_LO,src,dest
	lda	src CC1_ASI, dest
	ALIGN_2LO_LDA dest
	.endm
	
        .def	TMR1_POLL, 0x2000	! # of polls Timer1 interrupt test
        .def	TMR1_RELOAD, 0x4e1f0000	! Timer1 reload value
	.def	TMR3_RELOAD_SER, 0x70000 ! Timer3 reload for serial clock
	.def	_EMULATION_BP, 0x300001d0
	.def    TOP_OF_STACK, 0x40400000
        .def    TRDY_MASK, 0x00040000
        .def    DEFAULT_STACK_FRAME, -0x80
        .def    SRAM_START, 0x30000000
	.def    SRAM_HI_START, 0x30020000
	.def    SRAM_END, 0x30080000
        .def    INT1_MASK, 0x00020000	! 0x00020000 - IRQ1  Timer2
        .def    INT2_MASK, 0x00040000	! 0x00040000 - IRQ2  OBInt*
        .def    INT3_MASK, 0x00080000	! 0x00080000 - IRQ3  Timer1
        .def    INT4_MASK, 0x00100000	! 0x00100000 - IRQ4  NICE*
        .def    INT5_MASK, 0x00200000	! 0x00200000 - IRQ5  AT*
        .def    INT6_MASK, 0x00400000	! 0x00400000 - IRQ6  SDTR1 Tx
        .def    INT7_MASK, 0x00800000	! 0x00800000 - IRQ7  SDTR1 Rx
        .def    INT8_MASK, 0x01000000	! 0x01000000 - IRQ8  Timer1
        .def    INT9_MASK, 0x02000000	! 0x02000000 - IRQ9  SDTR0 Tx
        .def    INT10_MASK, 0x04000000	! 0x04000000 - IRQ10 SDTR0 Rx
        .def    INT11_MASK, 0x08000000	! 0x08000000 - IRQ11 AT*
        .def    INT12_MASK, 0x10000000	! 0x10000000 - IRQ12 OBInt*
        .def    INT13_MASK, 0x20000000	! 0x20000000 - IRQ13 Timer2
        .def    INT14_MASK, 0x40000000	! 0x40000000 - IRQ14 NICE*
        .def    TRIGGER_MODE0, 0x11400000
        .def    TRIGGER_MODE1, 0x05100000
        .def    IRL_CLEAR, 0x00100000
        .def    IRQ_MASK, 0xfefe0000

!------ The monitor in EPROM is copied to DRAM at location PROG_MEM_START.
!       If PROG_MEM_START is changed, the start address in command file
!	'ram.cmd' used by lnksp has to be changed to the same address.
	.def	PROG_MEM_START, 0x40008000	! start at 32K in DRAM

	.def     NICEADDR,	0x20000000	! NICE regs base addr

	.def     DLCR0,	0x2			! NICE DLRC regs offsets
	.def     DLCR1,	0x3
	.def     DLCR2,	0x6
	.def     DLCR3,	0x7
	.def     DLCR4,	0xa
	.def     DLCR5,	0xb
	.def     DLCR6,	0xe
	.def     DLCR7,	0xf

	.def     IDR8,	0x12			! NICE IDR regs offsets
	.def     IDR9,	0x13
	.def     IDR10,	0x16
	.def     IDR11,	0x17
	.def     IDR12,	0x1a
	.def     IDR13,	0x1b
	.def     IDR14,	0x1e
	.def     IDR15,	0x1f

	.def     HT8,	0x12			! NICE HT regs offsets
	.def     HT9,	0x13
	.def     HT10,	0x16
	.def     HT11,	0x17
	.def     HT12,	0x1a
	.def     HT13,	0x1b
	.def     HT14,	0x1e
	.def     HT15,	0x1f

	.def     BMR8,	0x12			! NICE BMR regs offsets
	.def     BMR9,	0x13
	.def     BMR10,	0x16
	.def     BMR11,	0x17
	.def     BMR12,	0x1a
	.def     BMR13,	0x1b
	.def     BMR14,	0x1e
	.def     BMR15,	0x1f
