#
# FILE
#	example.mak
#
#	Copyright(c) 1995, FMI, Fujitsu Microelectronics, Inc.
#	All rights reserved.
#
#	This software (including any documentation) is untested, has not been
#	fully tested for viruses and has been provided to you without charge.
#	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
#	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
#	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
#	risk of nonperformance, loss of data and other problems and Fujitsu
#	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
#	contract, negligence, strict liability or other theory for any damages
#	including, without limitation, direct, consequential or incidental nor
#	be required to provide substitute goods, services or technology.
#
# 
# Select chip version (930, 931, ...).  Every time CHIP definition is changed,
# all modules should be recompiled.
#
CHIP		= 831
MHZ		= 10

CC		= sparc-gcc
AS		= sparc-as
LD		= sparc-ld

PROGSTART930	= 40010000
PROGSTART931	= 40010000
PROGSTART932	= 40010000
PROGSTART933	= 40010000
PROGSTART933H	= 40010000
PROGSTART934	= 40010000
PROGSTART935	= 40010000
PROGSTART936	= 40010000
PROGSTART831	= 04010000
PROGSTART831C	= 40010000

PROGSTART	= 08010000
#PROGSTART	= $(PROGSTART$(CHIP))

CPPFLAGS	= -P -DCHIP_VER_$(CHIP) -DMASTER_CK_$(MHZ)
CCFLAGS		= -O -c -DCHIP_VER_$(CHIP) -DMASTER_CK_$(MHZ)
ASFLAGS		= -DCHIP_VER_$(CHIP) -DMASTER_CK_$(MHZ)
LDFLAGS		= -Ttext $(PROGSTART) -Bstatic -N
LIBS		= /usr/lib/libc.a 

TARGET		= ex

OBJECTS		= crt0.o example.o cntlsps.o cntlsp.o

.s.o:	
	$(CC) $(CPPFLAGS) $*.s 
	$(AS) $(ASFLAGS) -o $*.o $*.i

.c.o:	
	$(CC) $(CCFLAGS) $*.c

$(TARGET):	$(OBJECTS) example.mak
	$(LD) $(LDFLAGS) -o $(TARGET)$(CHIP).out $(OBJECTS) $(LIBS)
	-rm *.o
	-rm *.i
