# 1 "cntlsps.s"
!
! FILE
!       regsp.s
!
!       Copyright(c) 1991, FMI, Fujitsu Microelectronics, Inc.
!       All rights reserved.
!
!       This software (including any documentation) is untested, has not been
!       fully tested for viruses and has been provided to you without charge.
!       ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
!       IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
!       FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
!       risk of nonperformance, loss of data and other problems and Fujitsu
!       Microelectronics, Inc. and Fujitsu Limited will not be liable under any
!       contract, negligence, strict liability or other theory for any damages
!       including, without limitation, direct, consequential or incidental nor
!       be required to provide substitute goods, services or technology.
!
!
! DESCRIPTION
!       This file contains the functions used to manipulate the control
!       registers and the alternate memory spaces of the SPARClite chip on the
!       SPARClite Evaluation Board.
!
! HISTORY
!       Author - Roland Chu
!       Date   - October 16, 1991
!
# 1 "cntlsp.h" 1
 






































































 






















# 105 "cntlsp.h"













 



















































































# 29 "cntlsps.s" 2

        

        .text
        .global _tbrput
        .global _psrput
        .global _psrget
        .global _tbrget
        .global _ASI4get
        .global _ASI4put
        .global _ASI4bget
        .global _ASI4bput
        .global _ASI4hget
        .global _ASI4hput
        .global _CC1get
        .global _CC1put
        .global _CC1bget
        .global _CC1bput
        .global _CC1hget
        .global _CC1hput
        .global _cache_on
        .global _cache_off
!
! FUNCTION
!       _tbrput
!
! DESCRIPTION
!
! INPUTS
!       - %o0=tbr value
!
! RETURNS
!       - None
!
_tbrput:
        wr      %g0, %o0, %tbr
        jmpl    %o7+8, %g0
        nop
!
! FUNCTION
!       _psrput
!
! DESCRIPTION
!
! INPUTS
!       - %o0=psr value
!
! RETURNS
!       - None
!
_psrput:
        wr      %g0, %o0, %psr
        jmpl    %o7+8, %g0
        nop
!
! FUNCTION
!       _psrget
!
! DESCRIPTION
!
! INPUTS
!       - None
!
! RETURNS
!       - %o0=psr value
!
_psrget:
        rd      %psr, %o0
        jmpl    %o7+8, %g0
        nop
!
! FUNCTION
!       _tbrget
!
! DESCRIPTION
!
! INPUTS
!       - None
!
! RETURNS
!       - %o0=psr value
!
_tbrget:
        rd      %tbr, %o0
        jmpl    %o7+8, %g0
        nop
!
! FUNCTION
!       _ASI4hput:
!
! DESCRIPTION
!       This function writes a half word into the location specified by the
!       caller in ASI 4.
!
! INPUTS
!       - %o0=data
!       - %o1=address
!
! RETURNS
!       - None
!
_ASI4hput:
        stha    %o0, [%o1] 4
        jmpl    %o7+8, %g0
        nop
!
! FUNCTION
!       _ASI4hget
!
! DESCRIPTION
!       This function returns the half word in the location specified by the
!       caller in ASI 4.
!
! INPUTS
!       - %o0=address
!
! RETURNS
!       - Contents of [address] 4
!
_ASI4hget:
        lduha   [%o0] 4, %o0
        jmpl    %o7+8, %g0
        nop

!
! FUNCTION
!       _ASI4bput:
!
! DESCRIPTION
!       This function writes a byte into the location specified by the
!       caller in ASI 4.
!
! INPUTS
!       - %o0=data
!       - %o1=address
!
! RETURNS
!       - None
!
_ASI4bput:
        stba    %o0, [%o1] 4
        jmpl    %o7+8, %g0
        nop
!
! FUNCTION
!       _ASI4bget
!
! DESCRIPTION
!       This function returns the byte in the location specified by the
!       caller in ASI 4.
!
! INPUTS
!       - %o0=address
!
! RETURNS
!       - Contents of [address] 4
!
_ASI4bget:
        lduba   [%o0] 4, %o0
        jmpl    %o7+8, %g0
        nop

!
! FUNCTION
!       _ASI4put:
!
! DESCRIPTION
!       This function writes a 32 bit word into the location specified by the
!       caller in ASI 4.
!
! INPUTS
!       - %o0=data
!       - %o1=address
!
! RETURNS
!       - None
!
_ASI4put:
        sta     %o0, [%o1] 4
        jmpl    %o7+8, %g0
        nop
!
! FUNCTION
!       _ASI4get
!
! DESCRIPTION
!       This function returns the 32 bit word in the location specified by the
!       caller in ASI 4.
!
! INPUTS
!       - %o0=address
!
! RETURNS
!       - Contents of [address] 4
!
_ASI4get:
        lda     [%o0] 4, %o0
        jmpl    %o7+8, %g0
        nop

!
! FUNCTION
!       _CC1hput:
!
! DESCRIPTION
!       This function writes a half word into the location specified by the
!       caller in 4 .
!
! INPUTS
!       - %o0=data
!       - %o1=address
!
! RETURNS
!       - None
!
_CC1hput:
         
        stha    %o0, [%o1] 4 
        jmpl    %o7+8, %g0
        nop
!
! FUNCTION
!       _CC1hget
!
! DESCRIPTION
!       This function returns the half word in the location specified by the
!       caller in 4 .
!
! INPUTS
!       - %o0=address
!
! RETURNS
!       - Contents of [address] 4 
!
_CC1hget:
        lduha   [%o0] 4 , %o0
         
        jmpl    %o7+8, %g0
        nop

!
! FUNCTION
!       _CC1bput:
!
! DESCRIPTION
!       This function writes a byte into the location specified by the
!       caller in 4 
!
! INPUTS
!       - %o0=data
!       - %o1=address
!
! RETURNS
!       - None
!
_CC1bput:
         
        stba    %o0, [%o1] 4 
        jmpl    %o7+8, %g0
        nop
!
! FUNCTION
!       _CC1bget
!
! DESCRIPTION
!       This function returns the byte in the location specified by the
!       caller in 4 .
!
! INPUTS
!       - %o0=address
!
! RETURNS
!       - Contents of [address] 4 
!
_CC1bget:
        lduba   [%o0] 4 , %o0
         
        jmpl    %o7+8, %g0
        nop

!
! FUNCTION
!       _CC1put:
!
! DESCRIPTION
!       This function writes a 32 bit word into the location specified by the
!       caller in 4 .
!
! INPUTS
!       - %o0=data
!       - %o1=address
!
! RETURNS
!       - None
!
_CC1put:
         
        sta     %o0, [%o1] 4 
        jmpl    %o7+8, %g0
        nop
!
! FUNCTION
!       _CC1get
!
! DESCRIPTION
!       This function returns the 32 bit word in the location specified by the
!       caller in 4 .
!
! INPUTS
!       - %o0=address
!
! RETURNS
!       - Contents of [address] 4 
!
_CC1get:
        lda     [%o0] 4 , %o0
         
        jmpl    %o7+8, %g0
        nop


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                       << 93X Cache Routines>>
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! Ver 1.0 on Jun/01/95  by Akira  Typos are fixed. Generic version.
! Ver 1.1 on Jun/05/95  by Akira  933H : 0x35 -> 0x31 at 0x00000000 (ASI=1)
! Ver 1.2 on Jun/14/95  by Akira  Cache gets on/off when Burst Mode is off.
! Ver 1.3 on Jul/11/95  by Akira  Work around for 934 Burst Mode off problem.
!
! 93X's Cache functions and configurations vary as follows;
!                                   
!               I cache  D cache  clear    prefetch/ burst
!        93X     size     size    flags    w buffer  mode
!     --------  -------  -------  -------  -------  -------
!        930       2K       2K       No      Yes       No
!        931       2K       2K       No      Yes       No
!        932       8K       2K      Yes      Yes      Yes
!        933       No       No       No       No       No
!        933H      1K       No       No      Yes       No
!        934       8K       2K      Yes      Yes      Yes
!        935       4K       2K      Yes      Yes      Yes
!        936       4K       2K      Yes      Yes      Yes
!        831       4K       2K      Yes      Yes      Yes
!
! There are four options.
!
! Option 1 : CACHE_ZERO    : 933       : No cache. (*1)
! Option 2 : CACHE_1K      : 933H      : 1K I cache with no clear, no burst.
! Option 3 : CACHE_2K_2K   : 930/1     : 2K I&D cache with no clear, no burst.
! Option 4 : CACHE_CLR_BST : 932/4/5/6 : I&D cache with clear, and burst.
!
!     (*1) Although 933 has no Cache, application program may call
!          cache_on/off routine. The best action to that call is
!          do nothing, instead of doing and ignored by 933.
!
!=========================================================================
!   << The 934 Burst Mode off problem >>   {934 A/A1/A2/B steps only.}
!=========================================================================
!  If the Burst mode is turned off during the Burst period, IU may get
!  garbage. Its work around is to force the address of "sta" instruction
!  to ...0 or ...8 by using ".align 8", so that the Burst mode is turned
!  off at ...C or ...4; not in the Burst period which address is ...0.
!=========================================================================
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!=========================================================================
! Grouping for Options
!=========================================================================

!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------

!=========================================================================
! cache_on() : flush cache, then turn cache on.         <<Leaf Function>>
!=========================================================================
        .global _cache_on

!-------------------------------------------------------------------------






!-------------------------------------------------------------------------
# 478 "cntlsps.s"


!-------------------------------------------------------------------------
# 510 "cntlsps.s"


!-------------------------------------------------------------------------

.align  8    ! [ Work around for the 934 Burst Mode off problem. ]
_cache_on:
        nop  ! [ Work around: by .align 8, this ADDR = ...0 or ...8. ]
        set     0x00000020, %o0         ! Turn Burst Mode off.
        sta     %g0, [%o0] 0x1
        nop
        nop
        nop  ! [ Work around: Burst Mode is off at ADDR = ...4 or ...C. ]
        nop

        sta     %g0, [%g0] 0x1          ! Turn I&D Cache, P&W Buffer off.
        nop
        nop
        nop   
        nop

        set     0x00001000, %o0         ! Flush I&D Cache.
        set     0x80000000, %o1
        set     0x3, %o2
        sta     %o2, [%o0]     0xc      !  > I Cache - Bank 1.
        sta     %o2, [%o0]     0xe      !  > D Cache - Bank 1.
        sta     %o2, [%o0+%o1] 0xc      !  > I Cache - Bank 2.
        sta     %o2, [%o0+%o1] 0xe      !  > D Cache - Bank 2.

        set     0x35, %o0               ! Turn I&D Cache, P&W Buffer on.
        sta     %o0, [%g0] 0x1
        nop
        nop
        nop
        nop

        set     0x00000020, %o0         ! Turn Burst Mode on.
        set     0x3, %o1
        sta     %o1, [%o0] 0x1
        nop
        nop
        nop   
        nop

        jmpl    %o7+8, %g0
        nop



!=========================================================================
! cache_off() : turn cache off.                         <<Leaf Function>>
!=========================================================================
        .global _cache_off

!-------------------------------------------------------------------------






!-------------------------------------------------------------------------
# 581 "cntlsps.s"


!-------------------------------------------------------------------------
# 594 "cntlsps.s"


!-------------------------------------------------------------------------

.align  8    ! [ Work around for the 934 Burst Mode off problem. ]
_cache_off:
        nop  ! [ Work around: by .align 8, this ADDR = ...0 or ...8. ]
        set     0x00000020, %o0         ! Turn Burst Mode off.
        sta     %g0, [%o0] 0x1
        nop
        nop
        nop  ! [ Work around: Burst Mode is off at ADDR = ...4 or ...C. ]  
        nop

        sta     %g0, [%g0] 0x1          ! Turn I&D Cache, P&W Buffer off.
        nop
        nop
        nop   
        nop

        jmpl    %o7+8, %g0
        nop


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                        << 93X FPU Routines>>
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! Ver 1.0 on Jul/17/95  by Akira  First one.
!
! 93X's FPU functions are as follows;
!                                   
!        93X      FPU      FIFO
!      -------  -------  -------
!        930       No       No
!        931       No       No
!        932       No       No
!        933       No       No
!        933H      No       No
!        934      Yes      Yes
!        935       No       No
!        936      Yes       No
!        831       No       No
!
! There are three options.
!
! Option 1 : NO_FPU    : 930/1/2/3/3H/5 : No FPU. (*1)
! Option 2 : FPU_ONLY  : 936            : FPU; no FIFO.
! Option 3 : FPU_FIFO  : 934            : FPU and FIFO.
!
!   (*1) Although some 93x chips have no FPU, application program may call
!        FPUEN/FPUDIS routine. The best action to that call is
!        do nothing, instead of doing and ignored by the chips.
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!=========================================================================
! Grouping for Options
!=========================================================================

!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------



!-------------------------------------------------------------------------

!=========================================================================
! FPUEN() : enable FPU.                                 <<Leaf Function>>
!=========================================================================
        .global _FPUEN

!-------------------------------------------------------------------------

_FPUEN:
        jmpl    %o7+8, %g0
        nop


!-------------------------------------------------------------------------
# 736 "cntlsps.s"


!-------------------------------------------------------------------------
# 775 "cntlsps.s"



!=========================================================================
! FPUDIS() : disable FPU.                               <<Leaf Function>>
!=========================================================================
        .global _FPUDIS

!-------------------------------------------------------------------------

_FPUDIS:
        jmpl    %o7+8, %g0
        nop


!-------------------------------------------------------------------------
# 804 "cntlsps.s"


!-------------------------------------------------------------------------
# 831 "cntlsps.s"



!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



        .global _wait4RRDY
        .global _wait4TRDY

        ! FUNCTION
        !       _wait4RRDY
        ! DESCRIPTION
        !       This function examines the status register and returns
        !        when the receive buffer is not empty.
        !       Internal status register format:
        !        Bit 7: -DSR pin level
        !            6: Break code detect
        !            5: Framing error
        !            4: Overrun error
        !            3: Parity error
        !            2: Transmit data buffer/transmission shift register present        !            1: Receive data buffer not empty
        !            0: Transmit data buffer empty
        ! INPUT
        !       - %i0=CSR
        ! INTERNAL DESCRIPTION
        !       -
        ! RETURN
        !       - None
_wait4RRDY:
        save    %sp, -0x80 , %sp   ! Reserve stack, switch window.
        ! %l1=RRDY mask
        sethi   %hi(0x20000), %l1
wait4rrdy:
        lda     [%i0] 4 , %l0
         
        andcc   %l1, %l0, %g0
        be      wait4rrdy
        nop
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0


        ! FUNCTION
        !       _wait4TRDY
        ! DESCRIPTION
        !       This function examines the status register and returns
        !        when the transmit buffer is empty.
        ! INPUT
        !       - %i0=CSR
        ! INTERNAL DESCRIPTION
        !       - Set up some registers
        ! RETURN
        !       - None
_wait4TRDY:
        save    %sp, -0x80 , %sp   ! Reserve stack, switch window.
        ! %l1=TRDY mask
        sethi   %hi(0x40000), %l1
        set     20, %l2
wait4trdyloop:
        ! We need to make sure that at least 20 clock ticks
        !  occur after the previous write to a CC register
        !  (previous character going out in most cases)
        !  for the status register to be updated.  In clock
        !  double mode, this means 40 instructions if in cache.
        subcc   %l2, 0x1, %l2
        bnz     wait4trdyloop
        nop
wait4trdy:
        lda     [%i0] 4 , %l0
         
        andcc   %l1, %l0, %g0
        be      wait4trdy
        nop
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0




        .global __exit
__exit:
        jmpl    %i7+8, %g0
        restore %g0, %g0, %g0
