/*
 * FILE
 *	example.c
 *
 *
 *	Copyright(c) 1993, FMI, Fujitsu Microelectronics, Inc.
 *	All rights reserved.
 *
 *	This software (including any documentation) is untested, has not been
 *	fully tested for viruses and has been provided to you without charge.
 *	ACCORDINGLY, IT IS DELIVERED "AS IS" WITH NO WARRANTIES EXPRESS OR
 *	IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY,
 *	FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.  You bear all 
 *	risk of nonperformance, loss of data and other problems and Fujitsu
 *	Microelectronics, Inc. and Fujitsu Limited will not be liable under any
 *	contract, negligence, strict liability or other theory for any damages
 *	including, without limitation, direct, consequential or incidental nor
 *	be required to provide substitute goods, services or technology.
 *
 * DESCRIPTION
 *	This example program shows how to test benchmark and 
 *	print the results on SPARClite Eval Board.
 *
 * HISTORY
 *	Sep. 1991	Roland Chu
 *	Apr. 1993	Clark Li
 */

#include "cntlsp.h"

char	copyright[80]="Copyright (c) 1993, Fujitsu Microelectronics, Inc.  All rights reserved.";

main()
{
	unsigned long	i, arr[0x1000], starttime, endtime;


	printf("\r\n-----------------------------------\r\n");
	printf("Start Test,  Cache On ...\r\n");
	cache_on();				/* Turn on cache */
	RESET_TIMER();				/* Clear timer counter */
	starttime = GET_TIME();			/* Get start time */
	for (i = 0; i < 0x50000; i++)		/* Benchmark loop */
		arr[i % 0x1000] = i * 3;
	endtime = GET_TIME();			/* Get end time */
	printf("Benchmark time = %d (micro sec)\r\n", endtime - starttime);


	printf("\r\nStart Test,  Cache Off ...\r\n");
	RESET_TIMER();				/* Clear timer counter */
	cache_off();				/* Turn off cache */
	starttime = GET_TIME();			/* Get start time */
	for (i = 0; i < 0x50000; i++)		/* Benchmark loop */
		arr[i % 0x1000] = i * 3;
	endtime = GET_TIME();			/* Get end time */
	printf("Benchmark time = %d (micro sec)\r\n", endtime - starttime);
	printf("-----------------------------------\r\n");
}


